/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.AbstractFormControlBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormButtonBuilder
extends AbstractFormControlBuilder<Button> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String text;
    private String toolTipText;
    private Image image;
    private Boolean selection;

    public FormButtonBuilder(FormToolkit toolkit) {
        super(toolkit);
    }

    public FormButtonBuilder text(String text) {
        this.text = text;
        return this;
    }

    public FormButtonBuilder toolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        return this;
    }

    public FormButtonBuilder image(Image image) {
        this.image = image;
        return this;
    }

    public FormButtonBuilder selection(Boolean selection) {
        this.selection = selection;
        return this;
    }

    @Override
    public Button build(Composite parent) {
        Button control = this.getToolkit().createButton(parent, this.text == null ? "" : this.text, this.getStyle().intValue());
        GridData gridData = this.getGridDataBuilder().build();
        control.setLayoutData((Object)gridData);
        if (this.toolTipText != null) {
            control.setToolTipText(this.toolTipText);
        }
        if (this.image != null) {
            control.setImage(this.image);
        }
        if (this.selection != null) {
            control.setSelection(this.selection.booleanValue());
        }
        control.setBackground(null);
        this.setCommonAttrs((Control)control, this);
        XSwt.addTabTraverseListener((Control)control);
        return control;
    }
}

