/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swt;

import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class AbstractControlBuilder<T> {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GridLayoutBuilder gridLayoutBuilder = new GridLayoutBuilder();
    private GridDataBuilder gridDataBuilder = new GridDataBuilder();
    private Integer style = 0;
    private Boolean enabled;
    private Boolean visible;
    private Color background;
    private Image backgroundImage;
    private Color foreground;
    private List<DisposeListener> disposeListeners = new ArrayList<DisposeListener>();
    private List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private List<IHyperlinkListener> iHyperlinkListeners = new ArrayList<IHyperlinkListener>();
    private List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private List<MouseMoveListener> mouseMoveListeners = new ArrayList<MouseMoveListener>();
    private List<MouseTrackAdapter> mouseTrackAdapters = new ArrayList<MouseTrackAdapter>();
    private List<PaintListener> paintListeners = new ArrayList<PaintListener>();
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private List<VerifyListener> verifyListeners = new ArrayList<VerifyListener>();

    public AbstractControlBuilder<T> style(Integer style) {
        this.style = style;
        return this;
    }

    public AbstractControlBuilder<T> enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AbstractControlBuilder<T> visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    public AbstractControlBuilder<T> background(Color background) {
        this.background = background;
        return this;
    }

    public AbstractControlBuilder<T> backgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public AbstractControlBuilder<T> foreground(Color foreground) {
        this.foreground = foreground;
        return this;
    }

    public AbstractControlBuilder<T> numColumns(int numColumns) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.numColumns(numColumns);
        return this;
    }

    public AbstractControlBuilder<T> marginHeight(int marginHeight) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.marginHeight(marginHeight);
        return this;
    }

    public AbstractControlBuilder<T> marginWidth(int marginWidth) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.marginWidth(marginWidth);
        return this;
    }

    public AbstractControlBuilder<T> marginTop(int marginTop) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.marginTop(marginTop);
        return this;
    }

    public AbstractControlBuilder<T> marginLeft(int marginLeft) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.marginLeft(marginLeft);
        return this;
    }

    public AbstractControlBuilder<T> marginRight(int marginRight) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.marginRight(marginRight);
        return this;
    }

    public AbstractControlBuilder<T> marginBottom(int marginBottom) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.marginBottom(marginBottom);
        return this;
    }

    public AbstractControlBuilder<T> horizontalSpacing(int horizontalSpacing) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.horizontalSpacing(horizontalSpacing);
        return this;
    }

    public AbstractControlBuilder<T> verticalSpacing(int verticalSpacing) {
        this.gridLayoutBuilder = this.gridLayoutBuilder.verticalSpacing(verticalSpacing);
        return this;
    }

    public AbstractControlBuilder<T> horizontalAlignment(int horizontalAlignment) {
        this.gridDataBuilder = this.gridDataBuilder.horizontalAlignment(horizontalAlignment);
        return this;
    }

    public AbstractControlBuilder<T> verticalAlignment(int verticalAlignment) {
        this.gridDataBuilder = this.gridDataBuilder.verticalAlignment(verticalAlignment);
        return this;
    }

    public AbstractControlBuilder<T> grabExcessHorizontalSpace(boolean grabExcessHorizontalSpace) {
        this.gridDataBuilder = this.gridDataBuilder.grabExcessHorizontalSpace(grabExcessHorizontalSpace);
        return this;
    }

    public AbstractControlBuilder<T> grabExcessVerticalSpace(boolean grabExcessVerticalSpace) {
        this.gridDataBuilder = this.gridDataBuilder.grabExcessVerticalSpace(grabExcessVerticalSpace);
        return this;
    }

    public AbstractControlBuilder<T> horizontalSpan(int horizontalSpan) {
        this.gridDataBuilder = this.gridDataBuilder.horizontalSpan(horizontalSpan);
        return this;
    }

    public AbstractControlBuilder<T> verticalSpan(int verticalSpan) {
        this.gridDataBuilder = this.gridDataBuilder.verticalSpan(verticalSpan);
        return this;
    }

    public AbstractControlBuilder<T> horizontalIndent(int horizontalIndent) {
        this.gridDataBuilder = this.gridDataBuilder.horizontalIndent(horizontalIndent);
        return this;
    }

    public AbstractControlBuilder<T> verticalIndent(int verticalIndent) {
        this.gridDataBuilder = this.gridDataBuilder.verticalIndent(verticalIndent);
        return this;
    }

    public AbstractControlBuilder<T> heightHint(int heightHint) {
        this.gridDataBuilder = this.gridDataBuilder.heightHint(heightHint);
        return this;
    }

    public AbstractControlBuilder<T> widthHint(int widthHint) {
        this.gridDataBuilder = this.gridDataBuilder.widthHint(widthHint);
        return this;
    }

    public AbstractControlBuilder<T> minimumHeight(int minimumHeight) {
        this.gridDataBuilder = this.gridDataBuilder.minimumHeight(minimumHeight);
        return this;
    }

    public AbstractControlBuilder<T> minimumWidth(int minimumWidth) {
        this.gridDataBuilder = this.gridDataBuilder.minimumWidth(minimumWidth);
        return this;
    }

    public AbstractControlBuilder<T> listener(IHyperlinkListener listener) {
        if (!this.iHyperlinkListeners.contains(listener)) {
            this.iHyperlinkListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(ModifyListener listener) {
        if (!this.modifyListeners.contains(listener)) {
            this.modifyListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(MouseListener listener) {
        if (!this.mouseListeners.contains(listener)) {
            this.mouseListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(MouseMoveListener listener) {
        if (!this.mouseMoveListeners.contains(listener)) {
            this.mouseMoveListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(SelectionListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(PaintListener listener) {
        if (!this.paintListeners.contains(listener)) {
            this.paintListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(VerifyListener listener) {
        if (!this.verifyListeners.contains(listener)) {
            this.verifyListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(FocusListener listener) {
        if (!this.focusListeners.contains(listener)) {
            this.focusListeners.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(MouseTrackAdapter listener) {
        if (!this.mouseTrackAdapters.contains(listener)) {
            this.mouseTrackAdapters.add(listener);
        }
        return this;
    }

    public AbstractControlBuilder<T> listener(DisposeListener listener) {
        if (!this.disposeListeners.contains(listener)) {
            this.disposeListeners.add(listener);
        }
        return this;
    }

    public Integer getStyle() {
        return this.style;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public Color getBackground() {
        return this.background;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public GridLayoutBuilder getGridLayoutBuilder() {
        return this.gridLayoutBuilder;
    }

    public GridDataBuilder getGridDataBuilder() {
        return this.gridDataBuilder;
    }

    private void addListeners(Control control) {
        for (DisposeListener disposeListener : this.disposeListeners) {
            control.addDisposeListener(disposeListener);
        }
        for (FocusListener focusListener : this.focusListeners) {
            control.addFocusListener(focusListener);
        }
        for (IHyperlinkListener iHyperlinkListener : this.iHyperlinkListeners) {
            if (!(control instanceof Hyperlink)) continue;
            ((Hyperlink)control).addHyperlinkListener(iHyperlinkListener);
        }
        for (ModifyListener modifyListener : this.modifyListeners) {
            if (control instanceof Text) {
                ((Text)control).addModifyListener(modifyListener);
                continue;
            }
            if (control instanceof Combo) {
                ((Combo)control).addModifyListener(modifyListener);
                continue;
            }
            if (!(control instanceof StyledText)) continue;
            ((StyledText)control).addModifyListener(modifyListener);
        }
        for (MouseListener mouseListener : this.mouseListeners) {
            control.addMouseListener(mouseListener);
        }
        for (MouseMoveListener mouseMoveListener : this.mouseMoveListeners) {
            control.addMouseMoveListener(mouseMoveListener);
        }
        for (MouseTrackListener mouseTrackListener : this.mouseTrackAdapters) {
            control.addMouseTrackListener(mouseTrackListener);
        }
        for (PaintListener paintListener : this.paintListeners) {
            control.addPaintListener(paintListener);
        }
        for (SelectionListener selectionListener : this.selectionListeners) {
            if (control instanceof Button) {
                ((Button)control).addSelectionListener(selectionListener);
                continue;
            }
            if (control instanceof Combo) {
                ((Combo)control).addSelectionListener(selectionListener);
                continue;
            }
            if (!(control instanceof TableCombo)) continue;
            ((TableCombo)control).addSelectionListener(selectionListener);
        }
        for (VerifyListener verifyListener : this.verifyListeners) {
            if (control instanceof Text) {
                ((Text)control).addVerifyListener(verifyListener);
                continue;
            }
            if (control instanceof StyledText) {
                ((StyledText)control).addVerifyListener(verifyListener);
                continue;
            }
            if (!(control instanceof Combo)) continue;
            ((Combo)control).addVerifyListener(verifyListener);
        }
    }

    public void setCommonAttrs(Control control, AbstractControlBuilder<?> builder) {
        if (builder.getBackground() != null) {
            control.setBackground(builder.getBackground());
        }
        if (builder.getBackgroundImage() != null) {
            control.setBackgroundImage(builder.getBackgroundImage());
        }
        if (builder.getEnabled() != null) {
            control.setEnabled(builder.getEnabled().booleanValue());
        }
        if (builder.getForeground() != null) {
            control.setForeground(builder.getForeground());
        }
        if (builder.getVisible() != null) {
            control.setVisible(builder.getVisible().booleanValue());
        }
        this.addListeners(control);
    }

    public abstract T build(Composite var1);
}

