/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.swagger;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.annotations.HttpIn;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveTypeFormat;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.MapUtilz;
import com.ibm.zosconnect.ui.common.util.xsd.IZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdSimpleTypes;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgi.framework.Version;

public class OpenApi2xUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IZosConnectXsdSimpleTypes xsdSimpleTypes = ZosConnectXsdSimpleTypes.getInstance();
    private static final DateTimeFormatter openApiDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final Pattern openApiDatePattern = Pattern.compile("[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}");

    public static String stripQueryParameters(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        int firstQPNdx = path.lastIndexOf("?");
        if (firstQPNdx != -1) {
            path = path.substring(0, firstQPNdx);
        }
        return path;
    }

    public static Set<PathParameter> getPathParametersFromPath(String path) {
        HashSet<PathParameter> parameters = new HashSet<PathParameter>();
        if (StringUtils.isBlank((CharSequence)path)) {
            return parameters;
        }
        HashSet<String> parameterNames = new HashSet<String>();
        int leftBraceIx = path.indexOf("{");
        String remainingStr = path;
        while (leftBraceIx != -1) {
            int rightBraceIx = (remainingStr = remainingStr.substring(leftBraceIx)).indexOf("}");
            if (rightBraceIx == -1) break;
            PathParameter pp = new PathParameter();
            pp.setName(remainingStr.substring(1, rightBraceIx));
            pp.setType("string");
            pp.setRequired(true);
            pp.setIn(HttpIn.PATH.value());
            if (!parameterNames.contains(pp.getName())) {
                parameterNames.add(pp.getName());
                parameters.add(pp);
            }
            remainingStr = remainingStr.substring(rightBraceIx);
            leftBraceIx = remainingStr.indexOf("{");
        }
        return parameters;
    }

    public static Set<QueryParameter> getQueryParametersFromPath(String path) {
        HashSet<QueryParameter> parameters = new HashSet<QueryParameter>();
        if (StringUtils.isBlank((CharSequence)path)) {
            return parameters;
        }
        HashSet<String> parameterNames = new HashSet<String>();
        int firstQPNdx = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"?");
        if (firstQPNdx != -1) {
            path = StringUtils.substring((String)path, (int)(firstQPNdx + 1));
            String[] tokens = StringUtils.split((String)path, (String)"&");
            int i = 0;
            while (i < tokens.length) {
                QueryParameter qp = new QueryParameter();
                qp.setName(tokens[i]);
                qp.setType("string");
                qp.setRequired(true);
                qp.setIn(HttpIn.QUERY.value());
                if (!parameterNames.contains(qp.getName())) {
                    parameters.add(qp);
                    parameterNames.add(qp.getName());
                }
                ++i;
            }
        }
        return parameters;
    }

    public static Parameter getParameter(List<Parameter> parameters, String name) {
        if (ListUtilz.isEmpty(parameters)) {
            return null;
        }
        Parameter retVal = null;
        Iterator<Parameter> parameterIt = parameters.iterator();
        while (retVal == null && parameterIt.hasNext()) {
            Parameter nextParameter = parameterIt.next();
            if (!(nextParameter instanceof Parameter) || !StringUtils.equals((CharSequence)name, (CharSequence)nextParameter.getName())) continue;
            retVal = nextParameter;
        }
        return retVal;
    }

    public static HeaderParameter getHeaderParameter(List<Parameter> parameters, String name) {
        if (ListUtilz.isEmpty(parameters)) {
            return null;
        }
        HeaderParameter retVal = null;
        Iterator<Parameter> parameterIt = parameters.iterator();
        while (retVal == null && parameterIt.hasNext()) {
            Parameter nextParameter = parameterIt.next();
            if (!(nextParameter instanceof HeaderParameter) || !StringUtils.equals((CharSequence)name, (CharSequence)nextParameter.getName())) continue;
            retVal = (HeaderParameter)nextParameter;
        }
        return retVal;
    }

    public static PathParameter getPathParameter(List<Parameter> parameters, String name) {
        if (ListUtilz.isEmpty(parameters)) {
            return null;
        }
        PathParameter retVal = null;
        Iterator<Parameter> parameterIt = parameters.iterator();
        while (retVal == null && parameterIt.hasNext()) {
            Parameter nextParameter = parameterIt.next();
            if (!(nextParameter instanceof PathParameter) || !StringUtils.equals((CharSequence)name, (CharSequence)nextParameter.getName())) continue;
            retVal = (PathParameter)nextParameter;
        }
        return retVal;
    }

    public static QueryParameter getQueryParameter(List<Parameter> parameters, String name) {
        if (ListUtilz.isEmpty(parameters)) {
            return null;
        }
        QueryParameter retVal = null;
        Iterator<Parameter> parameterIt = parameters.iterator();
        while (retVal == null && parameterIt.hasNext()) {
            Parameter nextParameter = parameterIt.next();
            if (!(nextParameter instanceof QueryParameter) || !StringUtils.equals((CharSequence)name, (CharSequence)nextParameter.getName())) continue;
            retVal = (QueryParameter)nextParameter;
        }
        return retVal;
    }

    public static BodyParameter getBodyParameter(List<Parameter> parameters, String name) {
        if (ListUtilz.isEmpty(parameters)) {
            return null;
        }
        BodyParameter retVal = null;
        Iterator<Parameter> parameterIt = parameters.iterator();
        while (retVal == null && parameterIt.hasNext()) {
            Parameter nextParameter = parameterIt.next();
            if (!(nextParameter instanceof BodyParameter) || !StringUtils.equals((CharSequence)name, (CharSequence)nextParameter.getName())) continue;
            retVal = (BodyParameter)nextParameter;
        }
        return retVal;
    }

    public static void setSimpleTypeFacets(AbstractSerializableParameter<?> parameter, XSDElementDeclaration element, XSDSimpleTypeDefinition simpleType) {
        OpenApi2xUtil.clearSimpleTypeFacets(parameter);
        if (JsonSchemaPrimitiveType.ARRAY.value().equals(parameter.getType())) {
            Property itemsProperty = parameter.getItems();
            if (itemsProperty != null) {
                OpenApi2xUtil.setSimpleTypeFacets(itemsProperty, element, simpleType);
            }
        } else if (JsonSchemaPrimitiveType.STRING.value().equals(parameter.getType()) && xsdSimpleTypes.isStringType(simpleType)) {
            OpenApi2xUtil.setSimpleTypeFacets_string(parameter, element, simpleType);
        } else if (JsonSchemaPrimitiveType.INTEGER.value().equals(parameter.getType()) && xsdSimpleTypes.isDecimalType(simpleType)) {
            OpenApi2xUtil.setSimpleTypeFacets_decimal(parameter, element, simpleType);
        } else if (JsonSchemaPrimitiveType.NUMBER.value().equals(parameter.getType()) && xsdSimpleTypes.isDecimalType(simpleType)) {
            OpenApi2xUtil.setSimpleTypeFacets_decimal(parameter, element, simpleType);
        } else if (JsonSchemaPrimitiveType.NUMBER.value().equals(parameter.getType()) && xsdSimpleTypes.isFloatType(simpleType)) {
            OpenApi2xUtil.setSimpleTypeFacets_decimal(parameter, element, simpleType);
        }
    }

    private static void setSimpleTypeFacets_string(AbstractSerializableParameter<?> parameter, XSDElementDeclaration element, XSDSimpleTypeDefinition simpleType) {
        JsonSchemaPrimitiveTypeFormat jsonTypeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo(element);
        if (jsonTypeFormat != null) {
            parameter.setFormat(jsonTypeFormat.value());
        }
        for (XSDConstrainingFacet facet : simpleType.getFacets()) {
            if (facet instanceof XSDMinLengthFacet) {
                parameter.setMinLength(Integer.valueOf(((XSDMinLengthFacet)facet).getValue()));
            }
            if (!(facet instanceof XSDMaxLengthFacet)) continue;
            parameter.setMaxLength(Integer.valueOf(((XSDMaxLengthFacet)facet).getValue()));
        }
        if (XSDConstraint.DEFAULT_LITERAL == element.getConstraint() && (parameter instanceof HeaderParameter || parameter instanceof QueryParameter)) {
            parameter.setDefaultValue(element.getLexicalValue());
        }
    }

    private static void setSimpleTypeFacets_decimal(AbstractSerializableParameter<?> parameter, XSDElementDeclaration element, XSDSimpleTypeDefinition simpleType) {
        for (XSDConstrainingFacet facet : simpleType.getFacets()) {
            if (facet instanceof XSDMinFacet) {
                parameter.setMinimum(new BigDecimal(((XSDMinFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMinInclusiveFacet) {
                parameter.setMinimum(new BigDecimal(((XSDMinInclusiveFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMinExclusiveFacet) {
                parameter.setExclusiveMinimum(Boolean.valueOf(true));
                parameter.setMinimum(new BigDecimal(((XSDMinExclusiveFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMaxFacet) {
                parameter.setMaximum(new BigDecimal(((XSDMaxFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMaxInclusiveFacet) {
                parameter.setMaximum(new BigDecimal(((XSDMaxInclusiveFacet)facet).getLexicalValue()));
                continue;
            }
            if (!(facet instanceof XSDMaxExclusiveFacet)) continue;
            parameter.setExclusiveMinimum(Boolean.valueOf(true));
            parameter.setMaximum(new BigDecimal(((XSDMaxExclusiveFacet)facet).getLexicalValue()));
        }
        if (XSDConstraint.DEFAULT_LITERAL == element.getConstraint() && (parameter instanceof HeaderParameter || parameter instanceof QueryParameter)) {
            parameter.setDefaultValue(element.getLexicalValue());
        }
    }

    public static void clearSimpleTypeFacets(AbstractSerializableParameter<?> parameter) {
        Property itemsProperty;
        if (JsonSchemaPrimitiveType.ARRAY.value().equals(parameter.getType()) && (itemsProperty = parameter.getItems()) != null) {
            OpenApi2xUtil.clearSimpleTypeFacets(itemsProperty);
        }
        parameter.setMinimum(null);
        parameter.setMaximum(null);
        parameter.setMinLength(null);
        parameter.setMaxLength(null);
        parameter.setExclusiveMinimum(null);
        parameter.setExclusiveMaximum(null);
        parameter.setMultipleOf(null);
        parameter.setFormat(null);
        parameter.setDefaultValue(null);
    }

    public static void setSimpleTypeFacets(Property property, XSDElementDeclaration element, XSDSimpleTypeDefinition simpleType) {
        OpenApi2xUtil.clearSimpleTypeFacets(property);
        if (property instanceof ArrayProperty) {
            property = ((ArrayProperty)property).getItems();
        }
        if (property instanceof StringProperty && xsdSimpleTypes.isStringType(simpleType)) {
            OpenApi2xUtil.setSimpleTypeFacets((StringProperty)property, element, simpleType);
        } else if (property instanceof AbstractNumericProperty && xsdSimpleTypes.isDecimalType(simpleType)) {
            OpenApi2xUtil.setSimpleTypeFacets((AbstractNumericProperty)property, simpleType);
        }
    }

    private static void setSimpleTypeFacets(StringProperty property, XSDElementDeclaration element, XSDSimpleTypeDefinition simpleType) {
        JsonSchemaPrimitiveTypeFormat jsonTypeFormat = ZosConnectXsdUtil.getJsonSchemaPrimitiveTypeFormatAppInfo(element);
        if (jsonTypeFormat != null) {
            property.setFormat(jsonTypeFormat.value());
        }
        for (XSDConstrainingFacet facet : simpleType.getFacets()) {
            if (facet instanceof XSDMinLengthFacet) {
                property.setMinLength(Integer.valueOf(((XSDMinLengthFacet)facet).getValue()));
            }
            if (!(facet instanceof XSDMaxLengthFacet)) continue;
            property.setMaxLength(Integer.valueOf(((XSDMaxLengthFacet)facet).getValue()));
        }
    }

    private static void setSimpleTypeFacets(AbstractNumericProperty property, XSDSimpleTypeDefinition simpleType) {
        for (XSDConstrainingFacet facet : simpleType.getFacets()) {
            if (facet instanceof XSDMinFacet) {
                property.setMinimum(new BigDecimal(((XSDMinFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMinInclusiveFacet) {
                property.setMinimum(new BigDecimal(((XSDMinInclusiveFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMinExclusiveFacet) {
                property.setExclusiveMinimum(Boolean.valueOf(true));
                property.setMinimum(new BigDecimal(((XSDMinExclusiveFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMaxFacet) {
                property.setMaximum(new BigDecimal(((XSDMaxFacet)facet).getLexicalValue()));
                continue;
            }
            if (facet instanceof XSDMaxInclusiveFacet) {
                property.setMaximum(new BigDecimal(((XSDMaxInclusiveFacet)facet).getLexicalValue()));
                continue;
            }
            if (!(facet instanceof XSDMaxExclusiveFacet)) continue;
            property.setExclusiveMinimum(Boolean.valueOf(true));
            property.setMaximum(new BigDecimal(((XSDMaxExclusiveFacet)facet).getLexicalValue()));
        }
    }

    public static void clearSimpleTypeFacets(Property property) {
        if (property instanceof StringProperty) {
            OpenApi2xUtil.clearSimpleTypeFacets((StringProperty)property);
        } else if (property instanceof AbstractNumericProperty) {
            OpenApi2xUtil.clearSimpleTypeFacets((AbstractNumericProperty)property);
        }
    }

    private static void clearSimpleTypeFacets(StringProperty property) {
        property.setMinLength(null);
        property.setMaxLength(null);
        property.setFormat(null);
    }

    private static void clearSimpleTypeFacets(AbstractNumericProperty property) {
        property.setMinimum(null);
        property.setMaximum(null);
        property.setExclusiveMinimum(null);
        property.setExclusiveMaximum(null);
    }

    public static void setParameterAppInfo(AbstractSerializableParameter<?> parameter, XSDElementDeclaration element) {
        OpenApi2xUtil.clearParameterAppInfo(parameter);
        ArrayFormat arrayFormat = ZosConnectXsdUtil.getArrayFormatAppInfo(element);
        if (arrayFormat != null) {
            parameter.setCollectionFormat(arrayFormat.value());
        }
    }

    public static void clearParameterAppInfo(AbstractSerializableParameter<?> parameter) {
        parameter.setCollectionFormat(null);
    }

    public static void setPropertyAppInfo(Property property, XSDElementDeclaration element) {
        OpenApi2xUtil.clearPropertyAppInfo(property);
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            ArrayFormat arrayFormat = ZosConnectXsdUtil.getArrayFormatAppInfo(element);
            if (arrayFormat != null) {
                arrayProperty.setCollectionFormat(arrayFormat.value());
            }
        }
    }

    public static void clearPropertyAppInfo(Property property) {
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            arrayProperty.setCollectionFormat(null);
        }
    }

    public static List<String> getOperationIDs(Swagger swagger) {
        ArrayList<String> operationIDs = new ArrayList<String>();
        if (MapUtilz.notEmpty(swagger.getPaths())) {
            for (Path path : swagger.getPaths().values()) {
                if (!ListUtilz.notEmpty(path.getOperations())) continue;
                for (Operation operation : path.getOperations()) {
                    if (!StringUtils.isNotBlank((CharSequence)operation.getOperationId())) continue;
                    operationIDs.add(StringUtils.trim((String)operation.getOperationId()));
                }
            }
        }
        return operationIDs;
    }

    public static Swagger unmarshallSwagger(String fromString) throws JsonParseException, JsonMappingException, IOException {
        return (Swagger)Json.mapper().readValue(fromString, Swagger.class);
    }

    public static Version getVersion(Swagger swagger) {
        Version version = new Version(0, 0, 0);
        if (swagger != null && swagger.getInfo() != null && StringUtils.isNotBlank((CharSequence)swagger.getInfo().getVersion())) {
            version = new Version(StringUtils.trim((String)swagger.getInfo().getVersion()));
        }
        return version;
    }

    public static Property getSwaggerPropertyFromXsdSimpleType(XSDElementDeclaration element) {
        Property swaggerProperty = null;
        if ((element = element.getResolvedElementDeclaration()).getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition elementType = (XSDSimpleTypeDefinition)element.getTypeDefinition();
            swaggerProperty = OpenApi2xUtil.getSwaggerPropertyFromXsdSimpleType(elementType);
        }
        return swaggerProperty;
    }

    public static Property getSwaggerPropertyFromXsdSimpleType(XSDSimpleTypeDefinition elementType) {
        StringProperty swaggerProperty = new StringProperty();
        int simpleTypeID = xsdSimpleTypes.getBuiltInOrDerivedTypeID(elementType);
        switch (simpleTypeID) {
            case 1: {
                swaggerProperty = new StringProperty();
                break;
            }
            case 32: {
                swaggerProperty = new IntegerProperty();
                break;
            }
            case 12: {
                swaggerProperty = new BooleanProperty();
                break;
            }
            case 2: {
                swaggerProperty = new DecimalProperty();
                break;
            }
            case 16: {
                swaggerProperty = new DoubleProperty();
                break;
            }
            case 15: {
                swaggerProperty = new FloatProperty();
            }
        }
        return swaggerProperty;
    }

    public static JsonSchemaPrimitiveType getJsonPrimitiveTypeFromXsdSimpleType(XSDElementDeclaration element) {
        JsonSchemaPrimitiveType primitiveType = JsonSchemaPrimitiveType.STRING;
        if ((element = element.getResolvedElementDeclaration()).getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition elementType = (XSDSimpleTypeDefinition)element.getTypeDefinition();
            primitiveType = OpenApi2xUtil.getJsonPrimitiveTypeFromXsdSimpleType(elementType);
        }
        return primitiveType;
    }

    public static JsonSchemaPrimitiveType getJsonPrimitiveTypeFromXsdSimpleType(XSDSimpleTypeDefinition elementType) {
        JsonSchemaPrimitiveType primitiveType = JsonSchemaPrimitiveType.STRING;
        int simpleTypeID = xsdSimpleTypes.getBuiltInOrDerivedTypeID(elementType);
        switch (simpleTypeID) {
            case 1: {
                primitiveType = JsonSchemaPrimitiveType.STRING;
                break;
            }
            case 32: {
                primitiveType = JsonSchemaPrimitiveType.INTEGER;
                break;
            }
            case 12: {
                primitiveType = JsonSchemaPrimitiveType.BOOLEAN;
                break;
            }
            case 2: 
            case 15: 
            case 16: {
                primitiveType = JsonSchemaPrimitiveType.NUMBER;
            }
        }
        return primitiveType;
    }

    public static boolean isValueInRange(Property property, String value) {
        boolean inRange = true;
        if (property instanceof StringProperty) {
            inRange = OpenApi2xUtil.isValueInRange((StringProperty)property, value);
        } else if (property instanceof AbstractNumericProperty) {
            inRange = OpenApi2xUtil.isValueInRange((AbstractNumericProperty)property, value);
        }
        return inRange;
    }

    public static boolean isValueInRange(StringProperty property, String value) {
        boolean inRange = true;
        if (OpenApi2xUtil.isValueTooShort(property, value)) {
            inRange = false;
        } else if (OpenApi2xUtil.isValueTooLong(property, value)) {
            inRange = false;
        }
        return inRange;
    }

    public static boolean isValueTooShort(StringProperty property, String value) {
        boolean tooShort = false;
        Integer minLength = property.getMinLength();
        if (minLength != null && StringUtils.length((CharSequence)value) < minLength) {
            tooShort = true;
        }
        return tooShort;
    }

    public static boolean isValueTooLong(StringProperty property, String value) {
        boolean tooLong = false;
        Integer maxLength = property.getMaxLength();
        if (maxLength != null && StringUtils.length((CharSequence)value) > maxLength) {
            tooLong = true;
        }
        return tooLong;
    }

    public static Integer getMinLength(StringProperty property) {
        Integer minLength = 0;
        if (property.getMinLength() != null) {
            minLength = property.getMinLength();
        }
        return minLength;
    }

    public static Integer getMaxLength(StringProperty property) {
        Integer maxLength = null;
        if (property.getMaxLength() != null) {
            maxLength = property.getMaxLength();
        }
        return maxLength;
    }

    public static boolean isValueInRange(AbstractNumericProperty property, String value) {
        boolean inRange = true;
        if (value == null) {
            inRange = false;
        } else if (OpenApi2xUtil.isValueTooSmall(property, value)) {
            inRange = false;
        } else if (OpenApi2xUtil.isValueTooBig(property, value)) {
            inRange = false;
        }
        return inRange;
    }

    public static BigDecimal getMinimum(AbstractNumericProperty property) {
        BigDecimal minimum = null;
        if (property.getMinimum() != null) {
            minimum = property.getMinimum();
        } else if (property instanceof IntegerProperty) {
            minimum = new BigDecimal(Integer.MIN_VALUE);
        } else if (property instanceof LongProperty) {
            minimum = new BigDecimal(Long.MIN_VALUE);
        }
        return minimum;
    }

    public static BigDecimal getMaximum(AbstractNumericProperty property) {
        BigDecimal maximum = null;
        if (property.getMaximum() != null) {
            maximum = property.getMaximum();
        } else if (property instanceof IntegerProperty) {
            maximum = new BigDecimal(Integer.MAX_VALUE);
        } else if (property instanceof LongProperty) {
            maximum = new BigDecimal(Long.MAX_VALUE);
        }
        return maximum;
    }

    public static boolean isValueTooSmall(AbstractNumericProperty property, String value) {
        boolean tooSmall = false;
        BigDecimal minimum = OpenApi2xUtil.getMinimum(property);
        BigDecimal bdValue = null;
        try {
            bdValue = new BigDecimal(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (minimum != null && bdValue != null && bdValue.compareTo(minimum) < 0) {
            tooSmall = true;
        }
        return tooSmall;
    }

    public static boolean isValueTooBig(AbstractNumericProperty property, String value) {
        boolean tooBig = false;
        BigDecimal maximum = OpenApi2xUtil.getMaximum(property);
        BigDecimal bdValue = null;
        try {
            bdValue = new BigDecimal(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maximum != null && bdValue != null && bdValue.compareTo(maximum) > 0) {
            tooBig = true;
        }
        return tooBig;
    }

    public static boolean isValidDateFormatValue(String value) {
        boolean isValid = false;
        try {
            openApiDateFormatter.parseDateTime(value);
            if (!openApiDatePattern.matcher(value).matches()) {
                throw new Exception();
            }
            isValid = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isValid;
    }
}

