/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util.http;

import com.ibm.zosconnect.ui.common.util.NumberUtilz;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum HttpStatusCodes {
    Continue(100),
    SwitchingProtocols(101),
    Processing(102),
    EarlyHints(103),
    OK(200),
    Created(201),
    Accepted(202),
    NonAuthoritativeInformation(203),
    NoContent(204),
    ResetContent(205),
    PartialContent(206),
    MultiStatus(207),
    AlreadyReported(208),
    IMUsed(226),
    MultipleChoices(300),
    MovedPermanently(301),
    Found(302),
    SeeOther(303),
    NotModified(304),
    UseProxy(305),
    TemporaryRedirect(307),
    PermanentRedirect(308),
    BadRequest(400),
    Unauthorized(401),
    PaymentRequired(402),
    Forbidden(403),
    NotFound(404),
    MethodNotAllowed(405),
    NotAcceptable(406),
    ProxyAuthenticationRequired(407),
    RequestTimeout(408),
    Conflict(409),
    Gone(410),
    LengthRequired(411),
    PreconditionFailed(412),
    PayloadTooLarge(413),
    URITooLong(414),
    UnsupportedMediaType(415),
    RangeNotSatisfiable(416),
    ExpectationFailed(417),
    MisdirectedRequest(421),
    UnprocessableEntity(422),
    Locked(423),
    FailedDependency(424),
    TooEarly(425),
    UpgradeRequired(426),
    PreconditionRequired(428),
    TooManyRequests(429),
    RequestHeaderFieldsTooLarge(431),
    UnavailableForLegalReasons(451),
    InternalServerError(500),
    NotImplemented(501),
    BadGateway(502),
    ServiceUnavailable(503),
    GatewayTimeout(504),
    HTTPVersionNotSupported(505),
    VariantAlsoNegotiates(506),
    InsufficientStorage(507),
    LoopDetected(508),
    NotExtended(510),
    NetworkAuthenticationRequired(511);

    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2016. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DETAIL_SEPARATOR = " - ";
    private int code;
    private static final Map<Integer, String> code2Desc;
    private static final Map<String, HttpStatusCodes> desc2Enum;
    private static final Map<Integer, HttpStatusCodes> code2Enum;
    public static final List<HttpStatusCodes> all;

    static {
        code2Desc = new HashMap<Integer, String>();
        code2Desc.put(100, "Continue");
        code2Desc.put(101, "Switching Protocols");
        code2Desc.put(102, "Processing");
        code2Desc.put(103, "Early Hints");
        code2Desc.put(200, "OK");
        code2Desc.put(201, "Created");
        code2Desc.put(202, "Accepted");
        code2Desc.put(203, "Non-Authoritative Information");
        code2Desc.put(204, "No Content");
        code2Desc.put(205, "Reset Content");
        code2Desc.put(206, "Partial Content");
        code2Desc.put(207, "Multi-Status");
        code2Desc.put(208, "Already Reported");
        code2Desc.put(226, "IM Used");
        code2Desc.put(300, "Multiple Choices");
        code2Desc.put(301, "Moved Permanently");
        code2Desc.put(302, "Found");
        code2Desc.put(303, "See Other");
        code2Desc.put(304, "Not Modified");
        code2Desc.put(305, "Use Proxy");
        code2Desc.put(307, "Temporary Redirect");
        code2Desc.put(308, "Permanent Redirect");
        code2Desc.put(400, "Bad Request");
        code2Desc.put(401, "Unauthorized");
        code2Desc.put(402, "Payment Required");
        code2Desc.put(403, "Forbidden");
        code2Desc.put(404, "Not Found");
        code2Desc.put(405, "Method Not Allowed");
        code2Desc.put(406, "Not Acceptable");
        code2Desc.put(407, "Proxy Authentication Required");
        code2Desc.put(408, "Request Timeout");
        code2Desc.put(409, "Conflict");
        code2Desc.put(410, "Gone");
        code2Desc.put(411, "Length Required");
        code2Desc.put(412, "Precondition Failed");
        code2Desc.put(413, "Payload Too Large");
        code2Desc.put(414, "URI Too Long");
        code2Desc.put(415, "Unsupported Media Type");
        code2Desc.put(416, "Range Not Satisfiable");
        code2Desc.put(417, "Expectation Failed");
        code2Desc.put(421, "Misdirected Request");
        code2Desc.put(422, "Unprocessable Entity");
        code2Desc.put(423, "Locked");
        code2Desc.put(424, "Failed Dependency");
        code2Desc.put(425, "Too Early");
        code2Desc.put(426, "Upgrade Required");
        code2Desc.put(428, "Precondition Required");
        code2Desc.put(429, "Too Many Requests");
        code2Desc.put(431, "Request Header Fields Too Large");
        code2Desc.put(451, "Unavailable For Legal Reasons");
        code2Desc.put(500, "Internal Server Error");
        code2Desc.put(501, "Not Implemented");
        code2Desc.put(502, "Bad Gateway");
        code2Desc.put(503, "Service Unavailable");
        code2Desc.put(504, "Gateway Timeout");
        code2Desc.put(505, "HTTP Version Not Supported");
        code2Desc.put(506, "Variant Also Negotiates");
        code2Desc.put(507, "Insufficient Storage");
        code2Desc.put(508, "Loop Detected");
        code2Desc.put(510, "Not Extended");
        code2Desc.put(511, "Network Authentication Required");
        desc2Enum = new HashMap<String, HttpStatusCodes>();
        desc2Enum.put("Continue", Continue);
        desc2Enum.put("Switching Protocols", SwitchingProtocols);
        desc2Enum.put("Processing", Processing);
        desc2Enum.put("Early Hints", EarlyHints);
        desc2Enum.put("OK", OK);
        desc2Enum.put("Created", Created);
        desc2Enum.put("Accepted", Accepted);
        desc2Enum.put("Non-Authoritative Information", NonAuthoritativeInformation);
        desc2Enum.put("No Content", NoContent);
        desc2Enum.put("Reset Content", ResetContent);
        desc2Enum.put("Partial Content", PartialContent);
        desc2Enum.put("Multi-Status", MultiStatus);
        desc2Enum.put("Already Reported", AlreadyReported);
        desc2Enum.put("IM Used", IMUsed);
        desc2Enum.put("Multiple Choices", MultipleChoices);
        desc2Enum.put("Moved Permanently", MovedPermanently);
        desc2Enum.put("Found", Found);
        desc2Enum.put("See Other", SeeOther);
        desc2Enum.put("Not Modified", NotModified);
        desc2Enum.put("Use Proxy", UseProxy);
        desc2Enum.put("Temporary Redirect", TemporaryRedirect);
        desc2Enum.put("Permanent Redirect", PermanentRedirect);
        desc2Enum.put("Bad Request", BadRequest);
        desc2Enum.put("Unauthorized", Unauthorized);
        desc2Enum.put("Payment Required", PaymentRequired);
        desc2Enum.put("Forbidden", Forbidden);
        desc2Enum.put("Not Found", NotFound);
        desc2Enum.put("Method Not Allowed", MethodNotAllowed);
        desc2Enum.put("Not Acceptable", NotAcceptable);
        desc2Enum.put("Proxy Authentication Required", ProxyAuthenticationRequired);
        desc2Enum.put("Request Timeout", RequestTimeout);
        desc2Enum.put("Conflict", Conflict);
        desc2Enum.put("Gone", Gone);
        desc2Enum.put("Length Required", LengthRequired);
        desc2Enum.put("Precondition Failed", PreconditionFailed);
        desc2Enum.put("Payload Too Large", PayloadTooLarge);
        desc2Enum.put("URI Too Long", URITooLong);
        desc2Enum.put("Unsupported Media Type", UnsupportedMediaType);
        desc2Enum.put("Range Not Satisfiable", RangeNotSatisfiable);
        desc2Enum.put("Expectation Failed", ExpectationFailed);
        desc2Enum.put("Misdirected Request", MisdirectedRequest);
        desc2Enum.put("Unprocessable Entity", UnprocessableEntity);
        desc2Enum.put("Locked", Locked);
        desc2Enum.put("Failed Dependency", FailedDependency);
        desc2Enum.put("Too Early", TooEarly);
        desc2Enum.put("Upgrade Required", UpgradeRequired);
        desc2Enum.put("Precondition Required", PreconditionRequired);
        desc2Enum.put("Too Many Requests", TooManyRequests);
        desc2Enum.put("Request Header Fields Too Large", RequestHeaderFieldsTooLarge);
        desc2Enum.put("Unavailable For Legal Reasons", UnavailableForLegalReasons);
        desc2Enum.put("Internal Server Error", InternalServerError);
        desc2Enum.put("Not Implemented", NotImplemented);
        desc2Enum.put("Bad Gateway", BadGateway);
        desc2Enum.put("Service Unavailable", ServiceUnavailable);
        desc2Enum.put("Gateway Timeout", GatewayTimeout);
        desc2Enum.put("HTTP Version Not Supported", HTTPVersionNotSupported);
        desc2Enum.put("Variant Also Negotiates", VariantAlsoNegotiates);
        desc2Enum.put("Insufficient Storage", InsufficientStorage);
        desc2Enum.put("Loop Detected", LoopDetected);
        desc2Enum.put("Not Extended", NotExtended);
        desc2Enum.put("Network Authentication Required", NetworkAuthenticationRequired);
        code2Enum = new HashMap<Integer, HttpStatusCodes>();
        code2Enum.put(100, Continue);
        code2Enum.put(101, SwitchingProtocols);
        code2Enum.put(102, Processing);
        code2Enum.put(103, EarlyHints);
        code2Enum.put(200, OK);
        code2Enum.put(201, Created);
        code2Enum.put(202, Accepted);
        code2Enum.put(203, NonAuthoritativeInformation);
        code2Enum.put(204, NoContent);
        code2Enum.put(205, ResetContent);
        code2Enum.put(206, PartialContent);
        code2Enum.put(207, MultiStatus);
        code2Enum.put(208, AlreadyReported);
        code2Enum.put(226, IMUsed);
        code2Enum.put(300, MultipleChoices);
        code2Enum.put(301, MovedPermanently);
        code2Enum.put(302, Found);
        code2Enum.put(303, SeeOther);
        code2Enum.put(304, NotModified);
        code2Enum.put(305, UseProxy);
        code2Enum.put(307, TemporaryRedirect);
        code2Enum.put(308, PermanentRedirect);
        code2Enum.put(400, BadRequest);
        code2Enum.put(401, Unauthorized);
        code2Enum.put(402, PaymentRequired);
        code2Enum.put(403, Forbidden);
        code2Enum.put(404, NotFound);
        code2Enum.put(405, MethodNotAllowed);
        code2Enum.put(406, NotAcceptable);
        code2Enum.put(407, ProxyAuthenticationRequired);
        code2Enum.put(408, RequestTimeout);
        code2Enum.put(409, Conflict);
        code2Enum.put(410, Gone);
        code2Enum.put(411, LengthRequired);
        code2Enum.put(412, PreconditionFailed);
        code2Enum.put(413, PayloadTooLarge);
        code2Enum.put(414, URITooLong);
        code2Enum.put(415, UnsupportedMediaType);
        code2Enum.put(416, RangeNotSatisfiable);
        code2Enum.put(417, ExpectationFailed);
        code2Enum.put(421, MisdirectedRequest);
        code2Enum.put(422, UnprocessableEntity);
        code2Enum.put(423, Locked);
        code2Enum.put(424, FailedDependency);
        code2Enum.put(425, TooEarly);
        code2Enum.put(426, UpgradeRequired);
        code2Enum.put(428, PreconditionRequired);
        code2Enum.put(429, TooManyRequests);
        code2Enum.put(431, RequestHeaderFieldsTooLarge);
        code2Enum.put(451, UnavailableForLegalReasons);
        code2Enum.put(500, InternalServerError);
        code2Enum.put(501, NotImplemented);
        code2Enum.put(502, BadGateway);
        code2Enum.put(503, ServiceUnavailable);
        code2Enum.put(504, GatewayTimeout);
        code2Enum.put(505, HTTPVersionNotSupported);
        code2Enum.put(506, VariantAlsoNegotiates);
        code2Enum.put(507, InsufficientStorage);
        code2Enum.put(508, LoopDetected);
        code2Enum.put(510, NotExtended);
        code2Enum.put(511, NetworkAuthenticationRequired);
        all = new ArrayList<HttpStatusCodes>();
        all.add(Continue);
        all.add(SwitchingProtocols);
        all.add(Processing);
        all.add(EarlyHints);
        all.add(OK);
        all.add(Created);
        all.add(Accepted);
        all.add(NonAuthoritativeInformation);
        all.add(NoContent);
        all.add(ResetContent);
        all.add(PartialContent);
        all.add(MultiStatus);
        all.add(AlreadyReported);
        all.add(IMUsed);
        all.add(MultipleChoices);
        all.add(MovedPermanently);
        all.add(Found);
        all.add(SeeOther);
        all.add(NotModified);
        all.add(UseProxy);
        all.add(TemporaryRedirect);
        all.add(PermanentRedirect);
        all.add(BadRequest);
        all.add(Unauthorized);
        all.add(PaymentRequired);
        all.add(Forbidden);
        all.add(NotFound);
        all.add(MethodNotAllowed);
        all.add(NotAcceptable);
        all.add(ProxyAuthenticationRequired);
        all.add(RequestTimeout);
        all.add(Conflict);
        all.add(Gone);
        all.add(LengthRequired);
        all.add(PreconditionFailed);
        all.add(PayloadTooLarge);
        all.add(URITooLong);
        all.add(UnsupportedMediaType);
        all.add(RangeNotSatisfiable);
        all.add(ExpectationFailed);
        all.add(MisdirectedRequest);
        all.add(UnprocessableEntity);
        all.add(Locked);
        all.add(FailedDependency);
        all.add(TooEarly);
        all.add(UpgradeRequired);
        all.add(PreconditionRequired);
        all.add(TooManyRequests);
        all.add(RequestHeaderFieldsTooLarge);
        all.add(UnavailableForLegalReasons);
        all.add(InternalServerError);
        all.add(NotImplemented);
        all.add(BadGateway);
        all.add(ServiceUnavailable);
        all.add(GatewayTimeout);
        all.add(HTTPVersionNotSupported);
        all.add(VariantAlsoNegotiates);
        all.add(InsufficientStorage);
        all.add(LoopDetected);
        all.add(NotExtended);
        all.add(NetworkAuthenticationRequired);
    }

    private HttpStatusCodes(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static HttpStatusCodes fromCode(Integer code) {
        if (code != null) {
            return code2Enum.get(code);
        }
        return null;
    }

    public static HttpStatusCodes fromDetail(String detail) {
        HttpStatusCodes statusCode = null;
        try {
            String codeStr = StringUtils.trimToEmpty((String)detail);
            int sepIdx = codeStr.indexOf(DETAIL_SEPARATOR);
            if (sepIdx != -1) {
                codeStr = codeStr.substring(0, sepIdx);
            }
            statusCode = code2Enum.get(Integer.valueOf(codeStr));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return statusCode;
    }

    public static HttpStatusCodes fromDescription(String description) {
        return desc2Enum.get(description);
    }

    public String getDescription() {
        return code2Desc.get(this.code);
    }

    public String getRangeDescription() {
        return HttpStatusCodes.getRangeDescription(this.code);
    }

    public boolean equals(HttpStatusCodes other) {
        boolean retVal = false;
        if (other != null) {
            retVal = this.code == other.getCode();
        }
        return retVal;
    }

    public boolean equals(int code) {
        return this.code == code;
    }

    public String toString() {
        return String.valueOf(this.code);
    }

    public String toDetail() {
        return this.code + DETAIL_SEPARATOR + code2Desc.get(this.code);
    }

    public static List<HttpStatusCodes> getAll() {
        return all;
    }

    public static List<HttpStatusCodes> getByClass(boolean informational, boolean success, boolean redirection, boolean clientError, boolean serverError) {
        ArrayList<HttpStatusCodes> result = new ArrayList<HttpStatusCodes>();
        for (HttpStatusCodes code : all) {
            if (NumberUtilz.isInRange(code.getCode(), 100, 199)) {
                if (!informational) continue;
                result.add(code);
                continue;
            }
            if (NumberUtilz.isInRange(code.getCode(), 200, 299)) {
                if (!success) continue;
                result.add(code);
                continue;
            }
            if (NumberUtilz.isInRange(code.getCode(), 300, 399)) {
                if (!redirection) continue;
                result.add(code);
                continue;
            }
            if (NumberUtilz.isInRange(code.getCode(), 400, 499)) {
                if (!clientError) continue;
                result.add(code);
                continue;
            }
            if (!NumberUtilz.isInRange(code.getCode(), 500, 599) || !serverError) continue;
            result.add(code);
        }
        return result;
    }

    public static String getRangeDescription(int code) {
        if (NumberUtilz.isInRange(code, 100, 199)) {
            return "Informational";
        }
        if (NumberUtilz.isInRange(code, 200, 299)) {
            return "Success";
        }
        if (NumberUtilz.isInRange(code, 300, 399)) {
            return "Redirection";
        }
        if (NumberUtilz.isInRange(code, 400, 499)) {
            return "Client Error";
        }
        if (NumberUtilz.isInRange(code, 500, 599)) {
            return "Server Error";
        }
        return "";
    }
}

