/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.ProgressMonitorDialog2;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class WorkspaceUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Pattern FILENAME_VALID_CHAR = Pattern.compile("[^/\\?<>\\\\:\\*\\|\"]+");

    public static void run(WorkspaceModifyOperation operation, boolean fork, boolean cancel) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(XSwt.getActiveShell());
        dialog.run(false, false, (IRunnableWithProgress)operation);
    }

    public static void run(WorkspaceModifyOperation operation, String name, boolean fork, boolean cancel) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog2 dialog = new ProgressMonitorDialog2(XSwt.getActiveShell(), name);
        dialog.run(false, false, (IRunnableWithProgress)operation);
    }

    public static String getValidFileName(String candidateName) {
        StringBuffer newName = new StringBuffer();
        int charIndex = 0;
        while (charIndex < candidateName.length()) {
            Character c = Character.valueOf(candidateName.charAt(charIndex));
            Matcher m = FILENAME_VALID_CHAR.matcher(c.toString());
            if (m.matches()) {
                newName.append(c);
            } else {
                newName.append('_');
            }
            ++charIndex;
        }
        return newName.toString();
    }

    public static void createProject(String projectName) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final IProject project = workspaceRoot.getProject(projectName);
        WorkspaceUtil.run(new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor execMon) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    if (!project.exists()) {
                        project.create(execMon);
                        project.open(execMon);
                    }
                    execMon.done();
                }
                catch (Exception e) {
                    ZCeeUILogger.error(e);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.zosconnect.ui.common", e.getMessage(), (Throwable)e));
                }
            }
        }, false, false);
    }

    public static void deleteProject(String projectName) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final IProject project = workspaceRoot.getProject(projectName);
        WorkspaceUtil.run(new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor execMon) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    if (project.exists()) {
                        project.delete(true, execMon);
                    }
                    execMon.done();
                }
                catch (Exception e) {
                    ZCeeUILogger.error(e);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.zosconnect.ui.common", e.getMessage(), (Throwable)e));
                }
            }
        }, false, false);
    }

    public static void addAPIDeployProblemMarker(IResource resource, ZosConnectUIException exception) throws CoreException {
        IMarker m = resource.createMarker("com.ibm.zosconnect.ui.deployproblem");
        m.setAttribute("message", (Object)StringUtils.trimToEmpty((String)exception.getExternalMessage()));
        m.setAttribute("location", (Object)resource.getLocation().toOSString());
        m.setAttribute("priority", 2);
        m.setAttribute("severity", 2);
    }

    public static void clearAPIDeployProblemMarkers(IResource resource) throws CoreException {
        resource.deleteMarkers("com.ibm.zosconnect.ui.deployproblem", true, 2);
    }

    public static void addServiceDeployProblemMarker(IResource resource, ZosConnectUIException exception) throws CoreException {
        IMarker m = resource.createMarker("com.ibm.zosconnect.service.ui.deployproblem");
        m.setAttribute("message", (Object)StringUtils.trimToEmpty((String)exception.getExternalMessage()));
        m.setAttribute("location", (Object)resource.getLocation().toOSString());
        m.setAttribute("priority", 2);
        m.setAttribute("severity", 2);
    }

    public static void clearServiceDeployProblemMarkers(IResource resource) throws CoreException {
        resource.deleteMarkers("com.ibm.zosconnect.service.ui.deployproblem", true, 2);
    }

    public static boolean equals(IResource left, IResource right) {
        boolean equals = false;
        if (left == null && right == null) {
            equals = true;
        } else if (left != null && right != null) {
            equals = left.equals((Object)right);
        }
        return equals;
    }

    public static IEditorReference[] getEditorReferences() {
        IEditorReference[] retVal = new IEditorReference[]{};
        IWorkbenchPage activePage = XSwt.getActivePage();
        if (activePage != null) {
            retVal = activePage.getEditorReferences();
        }
        return retVal;
    }

    public static IEditorPart[] getDirtyEditors() {
        IEditorPart[] retVal = new IEditorPart[]{};
        IWorkbenchPage activePage = XSwt.getActivePage();
        if (activePage != null) {
            retVal = activePage.getDirtyEditors();
        }
        return retVal;
    }

    public static List<IEditorReference> getEditorReferences(String editorId) {
        ArrayList<IEditorReference> retVal = new ArrayList<IEditorReference>();
        try {
            IEditorReference[] iEditorReferenceArray = WorkspaceUtil.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                if (StringUtils.equals((CharSequence)ref.getId(), (CharSequence)editorId)) {
                    retVal.add(ref);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static List<IProject> getDirtyProjects(List<IProject> projects) throws CoreException {
        ArrayList<IProject> dirtyProjects = new ArrayList<IProject>();
        ArrayList<IFile> projectFiles = new ArrayList<IFile>();
        for (IProject project : projects) {
            projectFiles.addAll(WorkspaceUtil.getAllFiles((IContainer)project));
        }
        IEditorPart[] iEditorPartArray = WorkspaceUtil.getDirtyEditors();
        int n = iEditorPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject dirtyProject;
            IFileEditorInput fileEditorInput;
            IFile editorInputFile;
            IEditorPart editor = iEditorPartArray[n2];
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput && (editorInputFile = (fileEditorInput = (IFileEditorInput)editorInput).getFile()) != null && editor.isDirty() && projects.contains(dirtyProject = editorInputFile.getProject()) && !dirtyProjects.contains(dirtyProject)) {
                dirtyProjects.add(dirtyProject);
            }
            ++n2;
        }
        return dirtyProjects;
    }

    public static boolean isProjectDirty(IProject project) throws CoreException {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(project);
        List<IProject> dirtyProjects = WorkspaceUtil.getDirtyProjects(projects);
        return dirtyProjects.contains(project);
    }

    public static void closeEditorIfOpen(final List<IFile> files, final String editorId) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                List<IEditorReference> editorRefs = WorkspaceUtil.getEditorReferences(editorId);
                for (IEditorReference editorRef : editorRefs) {
                    IFile editorInputFile;
                    IEditorInput editorInput;
                    IWorkbenchPage workbenchPage;
                    IEditorSite editorSite;
                    IEditorPart editorPart = editorRef.getEditor(false);
                    if (editorPart == null || (editorSite = editorPart.getEditorSite()) == null || (workbenchPage = editorSite.getPage()) == null || !((editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput) || !files.contains(editorInputFile = ((IFileEditorInput)editorInput).getFile())) continue;
                    workbenchPage.closeEditor(editorPart, true);
                }
            }
        });
    }

    public static List<IFile> getAllFiles(IContainer container) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        WorkspaceUtil.getAllFiles(container, files);
        return files;
    }

    private static void getAllFiles(IContainer container, List<IFile> files) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                WorkspaceUtil.getAllFiles((IContainer)member, files);
            } else if (member instanceof IFile) {
                files.add((IFile)member);
            }
            ++n2;
        }
    }
}

