/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class URIUtilz {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Pattern ESCAPED_URI_CHAR_REGEX = Pattern.compile("(%[0-9A-Fa-f]{2})");
    public static String ALPHANUMERIC_URI_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public static String updateURI(String uri, String host, int port) throws URISyntaxException {
        URI oldUri = new URI(uri);
        URI newUri = new URI(oldUri.getScheme(), oldUri.getUserInfo(), host, port, oldUri.getPath(), oldUri.getQuery(), oldUri.getFragment());
        return newUri.toString();
    }

    public static String getEObjectURI(EObject eObject) {
        String retVal = null;
        if (eObject != null) {
            retVal = EcoreUtil.getURI((EObject)eObject).toString();
        }
        return retVal;
    }

    public static String encodeResourceName(String resourceName) {
        StringBuffer retVal = new StringBuffer();
        int charIndex = 0;
        while (charIndex < resourceName.length()) {
            char character;
            char codepoint = character = resourceName.charAt(charIndex);
            if (ALPHANUMERIC_URI_CHARS.indexOf(character) == -1) {
                retVal.append("%" + String.format("%02X", codepoint));
            } else {
                retVal.append(character);
            }
            ++charIndex;
        }
        return retVal.toString();
    }

    public static String decodeResourceName(String resourceName) {
        StringBuffer retVal = new StringBuffer();
        Matcher matcher = ESCAPED_URI_CHAR_REGEX.matcher(resourceName);
        while (matcher.find()) {
            String encoded = matcher.group();
            int codepoint = Integer.parseInt(encoded.substring(1), 16);
            String decoded = String.valueOf((char)codepoint);
            matcher.appendReplacement(retVal, decoded);
        }
        matcher.appendTail(retVal);
        return retVal.toString();
    }

    public static Set<String> getPathParamNamesFromPath(String path) {
        HashSet<String> parameterNames = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)path)) {
            return parameterNames;
        }
        int leftBraceIx = path.indexOf("{");
        String remainingStr = path;
        while (leftBraceIx != -1) {
            int rightBraceIx = (remainingStr = remainingStr.substring(leftBraceIx)).indexOf("}");
            if (rightBraceIx == -1) break;
            String parameterName = remainingStr.substring(1, rightBraceIx);
            if (!parameterNames.contains(parameterName)) {
                parameterNames.add(parameterName);
            }
            remainingStr = remainingStr.substring(rightBraceIx);
            leftBraceIx = remainingStr.indexOf("{");
        }
        return parameterNames;
    }

    public static Set<String> getQueryParamNamesFromPath(String path) {
        HashSet<String> parameterNames = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)path)) {
            return parameterNames;
        }
        int firstQPNdx = StringUtils.lastIndexOf((CharSequence)path, (CharSequence)"?");
        if (firstQPNdx != -1) {
            path = StringUtils.substring((String)path, (int)(firstQPNdx + 1));
            String[] tokens = StringUtils.split((String)path, (String)"&");
            int i = 0;
            while (i < tokens.length) {
                String parameterName = tokens[i];
                if (!parameterNames.contains(parameterName)) {
                    parameterNames.add(parameterName);
                }
                ++i;
            }
        }
        return parameterNames;
    }
}

