/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;

public class SimpleLock {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String ClassName = SimpleLock.class.getName();
    private boolean lockHeld = false;
    private String lockName = ClassName;

    public SimpleLock() {
    }

    public SimpleLock(String lockName) {
        this();
        this.lockName = lockName;
    }

    public synchronized void acquireLock() {
        ZCeeUILogger.entering(ClassName, "acquireLock()", new Object[0]);
        ZCeeUILogger.info("acquiring lock \"{0}\"...", this.lockName);
        while (this.lockHeld) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.lockHeld = true;
        ZCeeUILogger.info("lock \"{0}\" acquired", this.lockName);
        ZCeeUILogger.exiting(ClassName, "acquireLock()", new Object[0]);
    }

    public synchronized void releaseLock(boolean notifyAll) {
        ZCeeUILogger.entering(ClassName, "releaseLock(notifyAll=" + notifyAll + ")", new Object[0]);
        ZCeeUILogger.info("releasing lock \"{0}\"...", this.lockName);
        this.lockHeld = false;
        if (notifyAll) {
            this.notifyAll();
        } else {
            this.notify();
        }
        ZCeeUILogger.info("lock \"{0}\" released", this.lockName);
        ZCeeUILogger.exiting(ClassName, "releaseLock(notifyAll=" + notifyAll + ")", new Object[0]);
    }

    public boolean isLockHeld() {
        return this.lockHeld;
    }
}

