/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.SWTBrowserFormEditorInput;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.FormCompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SWTBrowserFormEditor
extends FormEditor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = SWTBrowserFormEditor.class.getName();
    public static final String EDITOR_ID = "com.ibm.zosconnect.ui.swtbrowser";
    public static final String PROP_BROWSER_DEFAULTTYPE = "org.eclipse.swt.browser.DefaultType";
    private BrowserPage page;
    private SWTBrowserFormEditorInput editorInput;

    protected void addPages() {
        this.page = new BrowserPage(this, this.editorInput.getName(), this.editorInput.getUrl());
        try {
            this.addPage((IFormPage)this.page);
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(0);
            }
        }
        catch (PartInitException e) {
            ZCeeUILogger.error(e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.editorInput = (SWTBrowserFormEditorInput)input;
        this.setPartName(this.editorInput.getName());
        this.setTitleToolTip(this.editorInput.getTooltip());
    }

    public void dispose() {
        super.dispose();
        XSwt.dispose(this.page);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private class BrowserPage
    extends FormPage {
        private Browser browser;

        public BrowserPage(FormEditor editor, String id, String title) {
            super(editor, id, title);
        }

        protected void createFormContent(IManagedForm managedForm) {
            Composite body = managedForm.getForm().getBody();
            body.setLayout((Layout)new GridLayoutBuilder().marginHeight(0).marginWidth(0).build());
            body.setLayoutData((Object)new GridDataBuilder().grabExcessHorizontalSpace(true).grabExcessVerticalSpace(true).build());
            FormToolkit toolkit = SWTBrowserFormEditor.this.getToolkit();
            Composite browserComposite = (Composite)new FormCompositeBuilder(toolkit).grabExcessHorizontalSpace(true).grabExcessVerticalSpace(true).marginHeight(0).marginWidth(0).build(body);
            String browserDefaultType = System.getProperty(SWTBrowserFormEditor.PROP_BROWSER_DEFAULTTYPE);
            this.browser = StringUtils.equalsIgnoreCase((CharSequence)browserDefaultType, (CharSequence)"edge") ? new Browser(browserComposite, 262144) : new Browser(browserComposite, 0);
            this.browser.setLayoutData((Object)new GridDataBuilder().grabExcessHorizontalSpace(true).grabExcessVerticalSpace(true).build());
            this.browser.setJavascriptEnabled(true);
            this.browser.setUrl(SWTBrowserFormEditor.this.editorInput.getUrl());
        }

        public void setFocus() {
            this.browser.setFocus();
        }
    }
}

