/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;

public class MessageManagerWrapper
implements IMessageManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IMessageManager manager;
    private Map<Object, String> messages = new HashMap<Object, String>();

    public MessageManagerWrapper(IMessageManager manager) {
        this.manager = manager;
    }

    public IMessageManager getManager() {
        return this.manager;
    }

    public void addMessage(Object key, String messageText, Object data, int type, Control control) {
        this.manager.addMessage(key, messageText, data, type, control);
        this.messages.put(key, messageText);
    }

    public void addMessage(Object key, String messageText, Object data, int type) {
        this.manager.addMessage(key, messageText, data, type);
        this.messages.put(key, messageText);
    }

    public String createSummary(IMessage[] messages) {
        return this.manager.createSummary(messages);
    }

    public int getDecorationPosition() {
        return this.manager.getDecorationPosition();
    }

    public IMessagePrefixProvider getMessagePrefixProvider() {
        return this.manager.getMessagePrefixProvider();
    }

    public boolean isAutoUpdate() {
        return this.manager.isAutoUpdate();
    }

    public void removeAllMessages() {
        this.manager.removeAllMessages();
        this.messages.clear();
    }

    public void removeMessage(Object key, Control control) {
        this.manager.removeMessage(key, control);
        this.messages.remove(key);
    }

    public void removeMessage(Object key) {
        this.manager.removeMessage(key);
        this.messages.remove(key);
    }

    public void removeMessages() {
        this.manager.removeMessages();
        this.messages.clear();
    }

    public void removeMessages(Control control) {
        this.manager.removeMessages(control);
        this.messages.clear();
    }

    public void setAutoUpdate(boolean enabled) {
        this.manager.setAutoUpdate(enabled);
    }

    public void setDecorationPosition(int position) {
        this.manager.setDecorationPosition(position);
    }

    public void setMessagePrefixProvider(IMessagePrefixProvider provider) {
        this.manager.setMessagePrefixProvider(provider);
    }

    public void update() {
        this.manager.update();
    }

    public Map<Object, String> getMessages() {
        return this.messages;
    }

    public String getMessage(Object key) {
        return this.messages.get(key);
    }

    public boolean hasMessage(Object key) {
        return this.messages.containsKey(key);
    }
}

