/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public class IResourceUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean pathStartsWith(IPath path, IPath prefix) {
        boolean startsWith = false;
        if (prefix.matchingFirstSegments(path) == prefix.segmentCount()) {
            startsWith = true;
        }
        return startsWith;
    }

    public static List<IFile> getAffectedFiles(IResourceDelta delta) {
        ArrayList<IFile> affected = new ArrayList<IFile>();
        if (delta != null) {
            IResourceUtil.getAffectedFiles(delta, affected);
        }
        return affected;
    }

    private static void getAffectedFiles(IResourceDelta delta, List<IFile> affected) {
        IResource resource = delta.getResource();
        if (resource instanceof IFile) {
            affected.add((IFile)resource);
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta2 = iResourceDeltaArray[n2];
            IResourceUtil.getAffectedFiles(delta2, affected);
            ++n2;
        }
    }
}

