/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.util;

import com.ibm.zosconnect.ui.common.ZCeeUICommonPlugin;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;

public class FileUtilz {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static File getUniqueDirectory(File parentDirectory, String directoryName) {
        File retVal = null;
        int ordinal = 0;
        File directory = new File(String.valueOf(parentDirectory) + File.separator + directoryName);
        while (retVal == null) {
            if (!directory.exists()) {
                directory.mkdirs();
                retVal = directory;
                continue;
            }
            directory = new File(String.valueOf(parentDirectory) + File.separator + directoryName + ordinal);
            ++ordinal;
        }
        return directory;
    }

    public static File getUniqueFile(File parentDirectory, String extension) throws IOException {
        File retVal = null;
        SecureRandom random = new SecureRandom();
        String path = parentDirectory.getAbsolutePath() + File.separator;
        while (retVal == null) {
            String nextFileName = path + "tmp_" + Math.abs(random.nextLong()) + extension;
            File nextFile = new File(nextFileName);
            if (nextFile.exists()) continue;
            nextFile.createNewFile();
            retVal = nextFile;
        }
        return retVal;
    }

    public static String getRelativePath(String sourcePath, File file) {
        String path = file.getAbsolutePath().substring(sourcePath.length());
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    public static File getTempFile(String extension) throws IOException {
        File retVal = null;
        SecureRandom random = new SecureRandom();
        ZCeeUICommonPlugin plugin = ZCeeUICommonPlugin.getDefault();
        String path = plugin.getStateLocation().toOSString() + File.separator;
        if (!StringUtils.startsWith((CharSequence)extension, (CharSequence)".")) {
            extension = StringUtils.join((Object[])new String[]{".", extension});
        }
        while (retVal == null) {
            String nextFileName = path + "tmp_" + Math.abs(random.nextLong()) + extension;
            File nextFile = new File(nextFileName);
            if (nextFile.exists()) continue;
            nextFile.createNewFile();
            retVal = nextFile;
        }
        return retVal;
    }

    public static File getTempDir() {
        File retVal = null;
        SecureRandom random = new SecureRandom();
        ZCeeUICommonPlugin plugin = ZCeeUICommonPlugin.getDefault();
        String path = plugin.getStateLocation().toOSString() + File.separator;
        while (retVal == null) {
            String nextFileName = path + "tmp_" + Math.abs(random.nextLong());
            File nextFile = new File(nextFileName);
            if (nextFile.exists()) continue;
            nextFile.mkdirs();
            retVal = nextFile;
        }
        return retVal;
    }

    public static boolean exists(IFile file) {
        boolean retVal = false;
        if (file != null && file.exists()) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean exists(File file) {
        boolean retVal = false;
        if (file != null && file.exists()) {
            retVal = true;
        }
        return retVal;
    }
}

