/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.projects;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class ServiceProjectNature
implements IProjectNature {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.zosconnect.ui.projects.ServiceProjectNature";
    public static final String BUILDER_ID = "com.ibm.zosconnect.service.ui.projectbuilder";
    private IProject project;

    public void configure() throws CoreException {
        ServiceProjectNature.addServiceBuilderToProject(this.project);
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static boolean hasNature(IProject project) throws Exception {
        boolean hasNature = false;
        if (project != null && project.isAccessible() && project.getDescription() != null) {
            hasNature = project.getDescription().hasNature(ID);
        }
        return hasNature;
    }

    public static void appendNature(IProject project) throws Exception {
        IProjectDescription description = project.getDescription();
        if (description.hasNature(ID)) {
            return;
        }
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = ID;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static void addServiceBuilderToProject(IProject project) throws CoreException {
        if (!ServiceProjectNature.hasServiceBuilder(project)) {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand command = desc.newCommand();
            command.setBuilderName(BUILDER_ID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
        }
    }

    public static boolean hasServiceBuilder(IProject project) {
        if (project == null || !project.exists() || !project.isOpen()) {
            return false;
        }
        try {
            project.getNature(ID);
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    found = true;
                    break;
                }
                ++i;
            }
            return found;
        }
        catch (CoreException e) {
            ZCeeUILogger.error(Xlat.error("SERVICEPROJECT_BUILDER_CHECK_ERROR", project.getName()), e, new Object[0]);
            return false;
        }
    }
}

