/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.preferences;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ZosConnectPreferencesUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Text createText(Composite parent, String leadingLabel, String tooltip, String trailingLabel, String initialValue, ModifyListener modifyListener, int horizontalIndent, int widthHint) {
        Label label1 = new Label(parent, 0);
        label1.setText(leadingLabel);
        Text text = new Text(parent, 2052);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = widthHint;
        gridData.horizontalIndent = horizontalIndent;
        text.setToolTipText(tooltip);
        if (trailingLabel != null && !trailingLabel.isEmpty()) {
            Label label2 = new Label(parent, 0);
            label2.setText(trailingLabel);
        }
        text.setLayoutData((Object)gridData);
        if (modifyListener != null) {
            text.addModifyListener(modifyListener);
        }
        return text;
    }

    public static Button createCheckbox(Composite parent, String label, String tooltip, Boolean initialValue, SelectionListener selectionListener) {
        Button button = new Button(parent, 32);
        button.setText(label);
        if (initialValue != null) {
            button.setSelection(initialValue.booleanValue());
        }
        button.setLayoutData((Object)new GridData());
        button.setToolTipText(tooltip);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static void setGridLayout(Composite composite, Integer numColumns, Integer marginHeight, Integer marginWidth, Boolean grabExcessVerticalSpace, Boolean expandHorizontal) {
        GridLayout layout = new GridLayout();
        if (numColumns != null) {
            layout.numColumns = numColumns;
        }
        if (marginHeight != null) {
            layout.marginHeight = marginHeight;
        }
        if (marginWidth != null) {
            layout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        if (expandHorizontal.booleanValue()) {
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        if (grabExcessVerticalSpace != null) {
            data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        }
        composite.setLayoutData((Object)data);
    }
}

