/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.preferences;

import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferenceConstants;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesUtil;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.util.Xlat;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ZosConnectPreferences
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener,
ZosConnectPreferenceConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZosConnectPreferencesWrapper prefWrapper = null;
    private Text connectTimeout = null;
    private Text readTimeout = null;
    private Button infoTryItOutTLS = null;
    private Button deployAPIStarted = null;
    private Button stopAPIOnRemove = null;
    private Button stopAPIOnUpdate = null;
    private Button deployServiceStarted = null;
    private Button stopServiceOnRemove = null;
    private Button stopServiceOnUpdate = null;
    private Button verboseLogging = null;
    private FieldDecorationRegistry decorationRegistry;
    private FieldDecoration errorFieldDecoration;
    private ControlDecoration connectTimeoutDecoration;
    private ControlDecoration readTimeoutDecoration;
    private String psbNameValue;
    private Integer connectionTimeoutValue = 0;
    private Integer readTimeoutValue = 0;
    private Boolean infoTryItOutTLSValue = Boolean.TRUE;
    private Boolean deployAPIStartedValue = Boolean.TRUE;
    private Boolean stopAPIOnRemoveValue = Boolean.FALSE;
    private Boolean stopAPIOnUpdateValue = Boolean.TRUE;
    private Boolean deployServiceStartedValue = Boolean.TRUE;
    private Boolean stopServiceOnRemoveValue = Boolean.FALSE;
    private Boolean stopServiceOnUpdateValue = Boolean.TRUE;
    private Boolean verboseLoggingValue = Boolean.FALSE;

    public ZosConnectPreferences() {
        this.prefWrapper = new ZosConnectPreferencesWrapper();
        this.setPreferenceStore(this.prefWrapper.getStore());
        this.decorationRegistry = FieldDecorationRegistry.getDefault();
        this.errorFieldDecoration = this.decorationRegistry.getFieldDecoration("DEC_ERROR");
    }

    protected Control createContents(Composite page) {
        Composite body = new Composite(page, 0);
        ZosConnectPreferencesUtil.setGridLayout(body, 1, 5, 5, true, true);
        Group deployApis = new Group(body, 0);
        deployApis.setText(Xlat.label("DEPLOY_API_PREFERENCES"));
        ZosConnectPreferencesUtil.setGridLayout((Composite)deployApis, 1, 10, 10, false, true);
        this.deployAPIStartedValue = this.prefWrapper.getDeployAPIStarted();
        this.deployAPIStarted = ZosConnectPreferencesUtil.createCheckbox((Composite)deployApis, Xlat.label("DEPLOY_API_STARTED"), Xlat.description("DEPLOY_API_STARTED"), this.deployAPIStartedValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.deployAPIStartedValue = ZosConnectPreferences.this.deployAPIStarted.getSelection();
            }
        });
        this.stopAPIOnRemoveValue = this.prefWrapper.getStopAPIOnRemove();
        this.stopAPIOnRemove = ZosConnectPreferencesUtil.createCheckbox((Composite)deployApis, Xlat.label("STOP_API_ON_REMOVE"), Xlat.description("STOP_API_ON_REMOVE"), this.stopAPIOnRemoveValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.stopAPIOnRemoveValue = ZosConnectPreferences.this.stopAPIOnRemove.getSelection();
            }
        });
        this.stopAPIOnUpdateValue = this.prefWrapper.getStopAPIOnUpdate();
        this.stopAPIOnUpdate = ZosConnectPreferencesUtil.createCheckbox((Composite)deployApis, Xlat.label("STOP_API_ON_UPDATE"), Xlat.description("STOP_API_ON_UPDATE"), this.stopAPIOnUpdateValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.stopAPIOnUpdateValue = ZosConnectPreferences.this.stopAPIOnUpdate.getSelection();
            }
        });
        Group deployServices = new Group(body, 0);
        deployServices.setText(Xlat.label("DEPLOY_SERVICE_PREFERENCES"));
        ZosConnectPreferencesUtil.setGridLayout((Composite)deployServices, 1, 10, 10, false, true);
        this.deployServiceStartedValue = this.prefWrapper.getDeployServiceStarted();
        this.deployServiceStarted = ZosConnectPreferencesUtil.createCheckbox((Composite)deployServices, Xlat.label("DEPLOY_SERVICE_STARTED"), Xlat.description("DEPLOY_SERVICE_STARTED"), this.deployServiceStartedValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.deployServiceStartedValue = ZosConnectPreferences.this.deployServiceStarted.getSelection();
            }
        });
        this.stopServiceOnRemoveValue = this.prefWrapper.getStopServiceOnRemove();
        this.stopServiceOnRemove = ZosConnectPreferencesUtil.createCheckbox((Composite)deployServices, Xlat.label("STOP_SERVICE_ON_REMOVE"), Xlat.description("STOP_SERVICE_ON_REMOVE"), this.stopServiceOnRemoveValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.stopServiceOnRemoveValue = ZosConnectPreferences.this.stopServiceOnRemove.getSelection();
            }
        });
        this.stopServiceOnUpdateValue = this.prefWrapper.getStopServiceOnUpdate();
        this.stopServiceOnUpdate = ZosConnectPreferencesUtil.createCheckbox((Composite)deployServices, Xlat.label("STOP_SERVICE_ON_UPDATE"), Xlat.description("STOP_SERVICE_ON_UPDATE"), this.stopServiceOnUpdateValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.stopServiceOnUpdateValue = ZosConnectPreferences.this.stopServiceOnUpdate.getSelection();
            }
        });
        Group connection = new Group(body, 0);
        connection.setText(Xlat.label("CONNECTION_PREFERENCES"));
        ZosConnectPreferencesUtil.setGridLayout((Composite)connection, 3, 10, 10, false, true);
        this.connectionTimeoutValue = this.prefWrapper.getConnectTimeout();
        this.connectTimeout = ZosConnectPreferencesUtil.createText((Composite)connection, Xlat.label("CONNECT_TIMEOUT"), Xlat.description("CONNECT_TIMEOUT"), Xlat.label("UNIT_MILLISECONDS"), this.connectionTimeoutValue.toString(), this, this.decorationRegistry.getMaximumDecorationWidth(), -1);
        this.connectTimeoutDecoration = new ControlDecoration((Control)this.connectTimeout, 16512);
        this.connectTimeoutDecoration.setImage(this.errorFieldDecoration.getImage());
        this.connectTimeoutDecoration.hide();
        this.readTimeoutValue = this.prefWrapper.getReadTimeout();
        this.readTimeout = ZosConnectPreferencesUtil.createText((Composite)connection, Xlat.label("READ_TIMEOUT"), Xlat.description("READ_TIMEOUT"), Xlat.label("UNIT_MILLISECONDS"), this.readTimeoutValue.toString(), this, this.decorationRegistry.getMaximumDecorationWidth(), -1);
        this.readTimeoutDecoration = new ControlDecoration((Control)this.readTimeout, 16512);
        this.readTimeoutDecoration.setImage(this.errorFieldDecoration.getImage());
        this.readTimeoutDecoration.hide();
        Group messages = new Group(body, 0);
        messages.setText(Xlat.label("MESSAGE_PREFERENCES"));
        ZosConnectPreferencesUtil.setGridLayout((Composite)messages, 2, 10, 10, false, true);
        this.infoTryItOutTLSValue = this.prefWrapper.getInfoTryItOutTLS();
        this.infoTryItOutTLS = ZosConnectPreferencesUtil.createCheckbox((Composite)messages, Xlat.label("INFO_TRYITOUT_TLS"), Xlat.description("INFO_TRYITOUT_TLS"), this.infoTryItOutTLSValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.infoTryItOutTLSValue = ZosConnectPreferences.this.infoTryItOutTLS.getSelection();
            }
        });
        this.verboseLoggingValue = this.prefWrapper.getVerboseLogging();
        this.verboseLogging = ZosConnectPreferencesUtil.createCheckbox(body, Xlat.label("VERBOSE_LOGGING"), Xlat.description("VERBOSE_LOGGING"), this.verboseLoggingValue, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosConnectPreferences.this.verboseLoggingValue = ZosConnectPreferences.this.verboseLogging.getSelection();
            }
        });
        return body;
    }

    public void init(IWorkbench workbench) {
    }

    public void modifyText(ModifyEvent event) {
        Object source = event.getSource();
        this.doValidation(source);
    }

    protected boolean doValidation(Object source) {
        block8: {
            this.setErrorMessage(null);
            this.connectTimeoutDecoration.hide();
            this.readTimeoutDecoration.hide();
            if (source == this.connectTimeout) {
                try {
                    this.connectionTimeoutValue = Integer.valueOf(this.connectTimeout.getText());
                    if (this.connectionTimeoutValue < 0) {
                        this.setErrorMessage(Xlat.error("INVALID_CONNECT_TIMEOUT_VALUE"));
                        this.connectTimeoutDecoration.show();
                        return false;
                    }
                    break block8;
                }
                catch (NumberFormatException e) {
                    this.setErrorMessage(Xlat.error("INVALID_CONNECT_TIMEOUT_VALUE"));
                    this.connectTimeoutDecoration.show();
                    return false;
                }
            }
            if (source == this.readTimeout) {
                try {
                    this.readTimeoutValue = Integer.valueOf(this.readTimeout.getText());
                    if (this.readTimeoutValue < 0) {
                        this.setErrorMessage(Xlat.error("INVALID_READ_TIMEOUT_VALUE"));
                        this.readTimeoutDecoration.show();
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    this.setErrorMessage(Xlat.error("INVALID_READ_TIMEOUT_VALUE"));
                    this.readTimeoutDecoration.show();
                    return false;
                }
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.connectTimeout.setText(String.valueOf(this.prefWrapper.getDefaultConnectTimeout()));
        this.readTimeout.setText(String.valueOf(this.prefWrapper.getDefaultReadTimeout()));
        this.infoTryItOutTLSValue = this.prefWrapper.getDefaultInfoTryItOutTLS();
        this.infoTryItOutTLS.setSelection(this.infoTryItOutTLSValue.booleanValue());
        this.deployAPIStartedValue = this.prefWrapper.getDefaultDeployAPIStarted();
        this.deployAPIStarted.setSelection(this.deployAPIStartedValue.booleanValue());
        this.stopAPIOnRemoveValue = this.prefWrapper.getDefaultStopAPIOnRemove();
        this.stopAPIOnRemove.setSelection(this.stopAPIOnRemoveValue.booleanValue());
        this.stopAPIOnUpdateValue = this.prefWrapper.getDefaultStopAPIOnUpdate();
        this.stopAPIOnUpdate.setSelection(this.stopAPIOnUpdateValue.booleanValue());
        this.deployServiceStartedValue = this.prefWrapper.getDefaultDeployServiceStarted();
        this.deployServiceStarted.setSelection(this.deployServiceStartedValue.booleanValue());
        this.stopServiceOnRemoveValue = this.prefWrapper.getDefaultStopServiceOnRemove();
        this.stopServiceOnRemove.setSelection(this.stopServiceOnRemoveValue.booleanValue());
        this.stopServiceOnUpdateValue = this.prefWrapper.getDefaultStopServiceOnUpdate();
        this.stopServiceOnUpdate.setSelection(this.stopServiceOnUpdateValue.booleanValue());
        this.verboseLoggingValue = this.prefWrapper.getDefaultVerboseLogging();
        this.verboseLogging.setSelection(this.verboseLoggingValue.booleanValue());
        super.performDefaults();
    }

    protected void performApply() {
        this.prefWrapper.setConnectTimeout(this.connectionTimeoutValue);
        this.prefWrapper.setReadTimeout(this.readTimeoutValue);
        this.prefWrapper.setInfoTryItOutTLS(this.infoTryItOutTLSValue);
        this.prefWrapper.setDeployAPIStarted(this.deployAPIStartedValue);
        this.prefWrapper.setStopAPIOnRemove(this.stopAPIOnRemoveValue);
        this.prefWrapper.setStopAPIOnUpdate(this.stopAPIOnUpdateValue);
        this.prefWrapper.setDeployServiceStarted(this.deployServiceStartedValue);
        this.prefWrapper.setStopServiceOnRemove(this.stopServiceOnRemoveValue);
        this.prefWrapper.setStopServiceOnUpdate(this.stopServiceOnUpdateValue);
        this.prefWrapper.setVerboseLogging(this.verboseLoggingValue);
        super.performApply();
    }

    public boolean performOk() {
        this.prefWrapper.setConnectTimeout(this.connectionTimeoutValue);
        this.prefWrapper.setReadTimeout(this.readTimeoutValue);
        this.prefWrapper.setInfoTryItOutTLS(this.infoTryItOutTLSValue);
        this.prefWrapper.setDeployAPIStarted(this.deployAPIStartedValue);
        this.prefWrapper.setStopAPIOnRemove(this.stopAPIOnRemoveValue);
        this.prefWrapper.setStopAPIOnUpdate(this.stopAPIOnUpdateValue);
        this.prefWrapper.setDeployServiceStarted(this.deployServiceStartedValue);
        this.prefWrapper.setStopServiceOnRemove(this.stopServiceOnRemoveValue);
        this.prefWrapper.setStopServiceOnUpdate(this.stopServiceOnUpdateValue);
        this.prefWrapper.setVerboseLogging(this.verboseLoggingValue);
        return super.performOk();
    }
}

