/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.logger;

import com.ibm.zosconnect.ui.common.ZCeeUICommonPlugin;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ZCeeUILogger {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ZosConnectPreferencesWrapper prefWrapper = new ZosConnectPreferencesWrapper();
    private static Level LogLevel = Level.WARNING;

    public static IStatus entering(String className, String method, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.FINEST)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Long threadId = Thread.currentThread().getId();
        Object message = "Thread " + String.valueOf(threadId) + " entering " + className + "#" + method + " at " + String.valueOf(currTime) + "...";
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(1, "com.ibm.zosconnect.ui.common", (String)message);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus info(String msg, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.INFO)) {
            return Status.OK_STATUS;
        }
        String message = msg;
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders(message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(1, "com.ibm.zosconnect.ui.common", message);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus info(String msg, Throwable throwable, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.INFO)) {
            return Status.OK_STATUS;
        }
        String message = msg;
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders(message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(1, "com.ibm.zosconnect.ui.common", message, throwable);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus warn(String msg, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.WARNING)) {
            return Status.OK_STATUS;
        }
        String message = msg;
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders(message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(2, "com.ibm.zosconnect.ui.common", message);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus warn(String msg, Throwable throwable, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.WARNING)) {
            return Status.OK_STATUS;
        }
        String message = msg;
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders(message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(2, "com.ibm.zosconnect.ui.common", message, throwable);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus error(String msg, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.SEVERE)) {
            return Status.OK_STATUS;
        }
        String message = msg;
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders(message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(4, "com.ibm.zosconnect.ui.common", message);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus error(String msg, Throwable throwable, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.SEVERE)) {
            return Status.OK_STATUS;
        }
        String message = msg;
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders(message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(4, "com.ibm.zosconnect.ui.common", message, throwable);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus error(Throwable t) {
        if (!ZCeeUILogger.isLoggable(Level.SEVERE)) {
            return Status.OK_STATUS;
        }
        String message = ZosConnectUIException.getMessage(t);
        Status status = new Status(4, "com.ibm.zosconnect.ui.common", message, t);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static IStatus error(IStatus s) {
        if (!ZCeeUILogger.isLoggable(Level.SEVERE)) {
            return Status.OK_STATUS;
        }
        ZCeeUILogger.getLog().log(s);
        return s;
    }

    public static IStatus exiting(String className, String method, Object ... args) {
        if (!ZCeeUILogger.isLoggable(Level.FINEST)) {
            return Status.OK_STATUS;
        }
        Long currTime = System.currentTimeMillis();
        Long threadId = Thread.currentThread().getId();
        Object message = "Thread " + String.valueOf(threadId) + " exiting " + className + "#" + method + " at " + String.valueOf(currTime) + "...";
        if (args != null && args.length > 0) {
            String patternMsg = ZCeeUILogger.insertArgumentPlaceholders((String)message, args.length);
            message = MessageFormat.format(patternMsg, args);
        }
        Status status = new Status(1, "com.ibm.zosconnect.ui.common", (String)message);
        ZCeeUILogger.getLog().log((IStatus)status);
        return status;
    }

    public static boolean isLoggable(Level level) {
        boolean loggable = false;
        if (prefWrapper.getVerboseLogging() || level.intValue() >= LogLevel.intValue()) {
            loggable = true;
        }
        return loggable;
    }

    private static ILog getLog() {
        return ZCeeUICommonPlugin.getDefault().getLog();
    }

    public static void setLogLevel(Level logLevel) {
        LogLevel = logLevel;
    }

    public static String insertArgumentPlaceholders(String msg, int numOfInserts) {
        if (numOfInserts == 0) {
            return msg;
        }
        if (msg.contains("{0}")) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg);
        sb.append(" [");
        int i = 0;
        while (i < numOfInserts) {
            sb.append(" {" + i + "} ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

