/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.logger;

import com.ibm.zosconnect.ui.common.exceptions.IZosConnectUIException;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.resources.utils.ZosConnectUIMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ZCeeErrorDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void openError(Exception e, boolean blocking) {
        ZCeeErrorDialog.openError(XSwt.getActiveShell(), e, blocking);
    }

    public static void openError(Exception e) {
        ZCeeErrorDialog.openError(XSwt.getActiveShell(), e, false);
    }

    private static void openError(final Shell shell, Exception e, boolean blocking) {
        Throwable userException = e;
        if (e instanceof IZosConnectUIException) {
            userException = ((ZosConnectUIException)e).getExternalException();
        }
        if (e instanceof InvocationTargetException) {
            userException = ((InvocationTargetException)e).getTargetException();
        }
        ArrayList<Status> childStatus = new ArrayList<Status>();
        if (userException == null) {
            userException = new Exception();
        }
        StackTraceElement[] stackTraceElementArray = userException.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ele = stackTraceElementArray[n2];
            childStatus.add(new Status(4, "com.ibm.zosconnect.ui.common", ZosConnectUIException.getExternalMessage(ele)));
            ++n2;
        }
        MultiStatus status = new MultiStatus("com.ibm.zosconnect.ui.common", 4, childStatus.toArray(new IStatus[0]), userException.getMessage(), userException);
        String message = "";
        message = e instanceof IZosConnectUIException ? ((IZosConnectUIException)((Object)e)).getExternalMessage() : ZosConnectUIMessages.getError().getString("UNEXPECTED_ERROR");
        final String fMessage = message;
        final MultiStatus fStatus = status;
        if (!blocking) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)Xlat.error("ERRDLG_TITLE"), (String)fMessage, (IStatus)fStatus);
                }
            });
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)Xlat.error("ERRDLG_TITLE"), (String)fMessage, (IStatus)fStatus);
                }
            });
        }
    }
}

