/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.exceptions;

import com.ibm.zosconnect.ui.common.exceptions.IZosConnectUIException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.bind.JAXBException;

public class ZosConnectUIException
extends Exception
implements IZosConnectUIException {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;

    public ZosConnectUIException() {
    }

    public ZosConnectUIException(String message, Throwable cause) {
        super(message, cause);
    }

    public ZosConnectUIException(String message) {
        super(message);
    }

    public ZosConnectUIException(Throwable cause) {
        super(cause);
    }

    @Override
    public Exception getExternalException() {
        return this;
    }

    @Override
    public String getExternalMessage() {
        return this.getMessage();
    }

    public static String getMessage(Throwable t) {
        String msg;
        String retVal = t.getMessage();
        if (t instanceof JAXBException && (msg = ZosConnectUIException.getMessage((JAXBException)t)) != null) {
            retVal = msg;
        }
        return retVal;
    }

    private static String getMessage(JAXBException e) {
        String retVal = e.getMessage();
        Throwable linked = e.getLinkedException();
        if (linked != null && linked.getMessage() != null && !linked.getMessage().isEmpty()) {
            retVal = linked.getMessage();
        }
        return retVal;
    }

    @Override
    public boolean isCausedByConnectivityException() {
        return false;
    }

    @Override
    public boolean isCausedBySecurityException() {
        return false;
    }

    @Override
    public boolean isCausedByUnexpectedResponse() {
        return false;
    }

    @Override
    public String getHttpReasonPhrase() {
        return "";
    }

    @Override
    public String getHttpResponseBody() {
        return "";
    }

    @Override
    public int getHttpStatusCode() {
        return 0;
    }

    @Override
    public boolean isCausedByCertificateException() {
        Throwable cause = this.getCause();
        return cause instanceof SSLHandshakeException && cause.getCause() instanceof CertificateException;
    }

    public static String getExternalMessage(StackTraceElement ele) {
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append(ele.getClassName());
        msgBuf.append(".");
        msgBuf.append(ele.getMethodName());
        msgBuf.append("(");
        if (ele.isNativeMethod()) {
            msgBuf.append("Native Method");
        } else if (ele.getFileName() != null) {
            msgBuf.append(ele.getFileName());
            if (ele.getLineNumber() >= 0) {
                msgBuf.append(":");
                msgBuf.append(ele.getLineNumber());
            }
        } else {
            msgBuf.append("Unknown Source");
        }
        msgBuf.append(")");
        return msgBuf.toString();
    }
}

