/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.common.connections;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Display;

public class AdminApiConnectionUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CATEGORY_ID = "com.ibm.zosconnect.ui.connections.category.adminapi";
    public static final String CONNECTION_ID = "com.ibm.zosconnect.ui.connections.type.adminapi";
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private static IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();

    public static void doConnect(ConnectionProfile profile, boolean async) {
        if (profile != null) {
            if (async) {
                connectionService.connectAsync(profile.getId());
            } else {
                connectionService.connect(profile.getId());
            }
        }
    }

    public static void disconnectAllWithSameCredential(final ConnectionProfile profile) {
        if (profile != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AdminApiConnectionUtil.disconnectAllWithSameCred(profile);
                }
            });
        }
    }

    private static void disconnectAllWithSameCred(ConnectionProfile profile) {
        AdminApiConnectionUtil.doDisconnect(profile);
        CredentialsConfiguration credsConfig = profile.getCredentials();
        if (credsConfig == null) {
            return;
        }
        for (ConnectionProfile nextProfile : connectionManager.getConnectionProfiles(CONNECTION_ID)) {
            CredentialsConfiguration nextCredsConfig;
            if (StringUtils.equals((CharSequence)nextProfile.getId(), (CharSequence)profile.getId()) || (nextCredsConfig = nextProfile.getCredentials()) == null || !StringUtils.equals((CharSequence)nextCredsConfig.getID(), (CharSequence)credsConfig.getID())) continue;
            AdminApiConnectionUtil.doDisconnect(nextProfile);
        }
    }

    public static void doDisconnect(ConnectionProfile profile) {
        if (profile != null) {
            try {
                if (ConnectionUtils.supportsMultipleConnections((IConnectionDescriptor)profile.getConnectionDescriptor())) {
                    AdminApiConnectionUtil.multiConnectionPreDisconnect(profile);
                }
                connectionService.disconnect(profile.getConnectionDescriptor().getCategory().getId());
            }
            catch (ConnectionException e) {
                ZCeeUILogger.error(e);
            }
        }
    }

    private static void multiConnectionPreDisconnect(ConnectionProfile connectionProfile) {
        IConnectionState desirableState;
        String connectionCategoryId = connectionProfile.getConnectionDescriptor().getCategory().getId();
        IConnectionState state = connectionService.getConnectionState(connectionCategoryId);
        String ID = state.getID();
        if ((ID == null || !ID.equals(connectionProfile.getId())) && (desirableState = connectionService.getConnectionState(connectionProfile)) instanceof ConnectedState) {
            IConnection connection = ((ConnectedState)desirableState).getConnection();
            ((ConnectionService)connectionService).switchToAlreadyConnected(connection, connectionProfile);
        }
    }

    public static String getServerNameWithHostAndPort(ConnectionProfile profile) {
        if (profile == null || profile.getConnectionConfiguration() == null) {
            return "";
        }
        ConnectionConfiguration config = profile.getConnectionConfiguration();
        return AdminApiConnectionUtil.getServerNameWithHostAndPort(config);
    }

    public static String getServerNameWithHostAndPort(ConnectionConfiguration config) {
        if (config == null) {
            return "";
        }
        StringBuilder serverName = new StringBuilder();
        serverName.append("\"");
        serverName.append(config.getName());
        serverName.append("\" (");
        serverName.append(config.getHost());
        serverName.append(Xlat.colon());
        serverName.append(config.getPort());
        serverName.append(")");
        return serverName.toString();
    }
}

