/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.mq.impl;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.service.mq.impl.MQXlat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class MQUtils {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NLS_KEY_MQ_SERVICE_TWO_WAY = "MQ_SERVICE_TWO_WAY";
    private static final String NLS_KEY_MQ_SERVICE_ONE_WAY_MQPUT = "MQ_SERVICE_ONE_WAY_MQPUT";
    private static final String NLS_KEY_MQ_SERVICE_ONE_WAY_MQGET = "MQ_SERVICE_ONE_WAY_MQGET";
    private static final String NLS_KEY_MQ_UNEXPECTED_ERROR = "MQ_UNEXPECTED_ERROR";
    private static final String TWO_WAY_NATURE = "com.ibm.zosconnect.ui.projects.MQServiceProjectNatureTwoWay";
    private static final String ONE_WAY_PUT_NATURE = "com.ibm.zosconnect.ui.projects.MQServiceProjectNatureOneWayPut";
    private static final String ONE_WAY_GET_NATURE = "com.ibm.zosconnect.ui.projects.MQServiceProjectNatureOneWayGet";

    public static boolean hasMQProjectNature(IProject project) {
        return MQUtils.hasMQTwoWayProjectNature(project) || MQUtils.hasMQOneWayGetProjectNature(project) || MQUtils.hasMQOneWayPutProjectNature(project);
    }

    public static boolean hasMQTwoWayProjectNature(IProject project) {
        return MQUtils.hasNature(project, TWO_WAY_NATURE);
    }

    public static boolean hasMQOneWayPutProjectNature(IProject project) {
        return MQUtils.hasNature(project, ONE_WAY_PUT_NATURE);
    }

    public static boolean hasMQOneWayGetProjectNature(IProject project) {
        return MQUtils.hasNature(project, ONE_WAY_GET_NATURE);
    }

    public static String getTranslatedProjectServiceType(IProject project) {
        String translatedProjectServiceType = null;
        if (MQUtils.hasMQTwoWayProjectNature(project)) {
            translatedProjectServiceType = MQXlat.getMessage(NLS_KEY_MQ_SERVICE_TWO_WAY);
        } else if (MQUtils.hasMQOneWayGetProjectNature(project)) {
            translatedProjectServiceType = MQXlat.getMessage(NLS_KEY_MQ_SERVICE_ONE_WAY_MQGET);
        } else if (MQUtils.hasMQOneWayPutProjectNature(project)) {
            translatedProjectServiceType = MQXlat.getMessage(NLS_KEY_MQ_SERVICE_ONE_WAY_MQPUT);
        }
        return translatedProjectServiceType;
    }

    private static boolean hasNature(IProject project, String nature) {
        boolean hasNature = false;
        if (project != null && project.isAccessible()) {
            try {
                IProjectDescription description = project.getDescription();
                hasNature = description == null ? false : description.hasNature(nature);
            }
            catch (CoreException e) {
                String message = MQXlat.getMessage(NLS_KEY_MQ_UNEXPECTED_ERROR, e.getMessage());
                ZCeeUILogger.error((String)message, (Object[])new Object[0]);
                ZCeeErrorDialog.openError((Exception)new Exception(message), (boolean)true);
            }
        }
        return hasNature;
    }
}

