/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.mq.impl;

import com.ibm.zosconnect.service.mq.common.MQServiceCcsidUtils;
import com.ibm.zosconnect.service.mq.common.MQServiceTracing;
import com.ibm.zosconnect.ui.common.exceptions.ResponseInterfaceDefaultValueException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerAttributes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.TranDataStructureController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckArrayCountersVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckDatatypeOverridesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckFieldDefaultValuesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import com.ibm.zosconnect.ui.service.mq.impl.MQUtils;
import com.ibm.zosconnect.ui.service.mq.impl.MQXlat;
import com.ibm.zosconnect.ui.service.mq.impl.TracerForMQServiceCcsidUtils;
import com.ibm.zosconnect.ui.service.validation.AdvancedOptionsValidator;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public class MQPropertiesValidator
implements IServicePropertiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private static final String CONNECTIONFACTORY_KEY = "connectionFactory";
    private static final String DESTINATION_KEY = "destination";
    private static final String EXPIRY_KEY = "expiry";
    private static final String WAITINTERVAL_KEY = "waitInterval";
    private static final String REPLYDESTINATION_KEY = "replyDestination";
    private static final String REPLYSELECTION_KEY = "replySelection";
    private static final String REPLYSELECTION_VALUE_CORREL_ID_TO_CORREL_ID = "correlIDToCorrelID";
    private static final String REPLYSELECTION_VALUE_MSG_ID_TO_CORREL_ID = "msgIDToCorrelID";
    private static final String REPLYSELECTION_VALUE_NONE = "none";
    private static final String SELECTOR_KEY = "selector";
    private static final String MQMDFORMAT_KEY = "mqmdFormat";
    private static final String CCSID_KEY = "ccsid";
    private static final String PERSISTENCE_KEY = "persistence";
    private static final String MESSAGING_ACTION_KEY = "messagingAction";
    private static final String MESSAGING_ACTION_VALUE_MQPUT = "mqput";
    private static final String MESSAGING_ACTION_VALUE_MQGET = "mqget";
    private static final String REQUEST_SI_NAME_KEY = "requestSIName";
    private static final String RESPONSE_SI_NAME_KEY = "responseSIName";
    private static final String ESCAPE_OUTPUT_CONTROL_CHARACTERS_KEY = "escapeOutputControlCharacters";
    private static final String TRIM_OUTPUT_TRAILING_WHITESPACE_KEY = "trimOutputTrailingWhitespace";
    private static final String TRIM_OUTPUT_LEADING_WHITESPACE_KEY = "trimOutputLeadingWhitespace";
    private static final String OMIT_OUTPUT_FIELDS_BY_VALUE_KEY = "omitOutputFieldsByValue";
    private static final String OMIT_OUTPUT_FIELDS_BY_VALUE_BYTE_KEY = "omitOutputFieldsByValueByte";
    private static final String OMIT_OUTPUT_EMPTY_TAGS_KEY = "omitOutputEmptyTags";
    private static final String INITIALIZE_INPUT_FIELDS_KEY = "initializeInputFields";
    private static final String ENFORCE_MIN_ARRAY_OCCURENCE_KEY = "enforceMinArrayOccurrence";
    private static final String ENFORCE_MIN_ARRAY_OCCURENCE_RESPONSE_KEY = "enforceMinArrayOccurrenceResponse";
    private static final String NLS_KEY_MQ_EXPIRY_NON_NUMERIC = "MQ_EXPIRY_NON_NUMERIC";
    private static final String NLS_KEY_MQ_WAIT_INTERVAL_NON_NUMERIC = "MQ_WAIT_INTERVAL_NON_NUMERIC";
    private static final String NLS_MQ_WAIT_INTERVAL_ZERO = "MQ_WAIT_INTERVAL_ZERO";
    private static final String NLS_KEY_MQ_INCORRECT_REPLY_SELECTION = "MQ_INCORRECT_REPLY_SELECTION";
    private static final String NLS_KEY_MQ_SELECTOR_BLANK = "MQ_SELECTOR_BLANK";
    private static final String NLS_KEY_MQ_MD_FORMAT_TOO_LONG = "MQ_MD_FORMAT_TOO_LONG";
    private static final String NLS_KEY_MQ_CCSID_NON_NUMERIC = "MQ_CCSID_NON_NUMERIC";
    private static final String NLS_KEY_MQ_UNEXPECTED_ERROR = "MQ_UNEXPECTED_ERROR";
    private static final String NLS_KEY_MQ_PERSISTENCE_NON_BOOLEAN = "MQ_PERSISTENCE_NON_BOOLEAN";
    private static final String NLS_KEY_MQ_MESSAGING_ACTION_INCORRECT = "MQ_MESSAGING_ACTION_INCORRECT";
    private static final String NLS_KEY_MQ_MESSAGING_ACTION_MISMATCH = "MQ_MESSAGING_ACTION_MISMATCH";
    private static final String NLS_KEY_UNKNOWN_PROPERTY = "UNKNOWN_PROPERTY";
    private static final String NLS_KEY_REQUIRED_SERVICE_PROPERTY_MISSING = "REQUIRED_SERVICE_PROPERTY_MISSING";
    private static final String NLS_KEY_SERVICEEDIT_LABEL_REQUESTSI = "SERVICEEDIT_LABEL_REQUESTSI";
    private static final String NLS_KEY_SERVICEEDIT_LABEL_RESPONSESI = "SERVICEEDIT_LABEL_RESPONSESI";
    private static final String NLS_KEY_MISSING_REQUIRED_PROPERTY = "MISSING_REQUIRED_PROPERTY";
    private static final String NLS_KEY_REQUEST_OR_RESPONSE_REQUIRED = "REQUEST_OR_RESPONSE_REQUIRED";
    private static final String NLS_KEY_PROJECT_FILE_MISSING_ERROR = "PROJECT_FILE_MISSING_ERROR";
    private static final String NLS_KEY_PROPERTY_ERROR = "PROPERTY_ERROR";
    private static final String NLS_KEY_RESPONSE_SI_DEFAULTVALUES = "RESPONSE_SI_DEFAULTVALUES";
    private static final String NLS_KEY_SE_INCOMPATIBLE_SI_FILE = "SE_INCOMPATIBLE_SI_FILE";
    private static final String NLS_KEY_CICS_CCSID_INVALID = "CICS_CCSID_INVALID";
    private final AdvancedOptionsValidator advancedOptionsValidator = new AdvancedOptionsValidator();

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IResource resource, String key, String value, boolean isRequired, String propertyType) {
        String methodName = "validateConfigurationProperty";
        ZCeeUILogger.entering((String)this.className, (String)"validateConfigurationProperty", (Object[])new Object[]{resource, key, value, isRequired, propertyType});
        ServiceProjectValidationError result = null;
        if (isRequired && (value == null || value.trim().isEmpty())) {
            return this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_MISSING_REQUIRED_PROPERTY, key);
        }
        IProject project = resource.getProject();
        switch (key) {
            case "replyDestination": {
                if (MQUtils.hasMQTwoWayProjectNature(project)) break;
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            case "expiry": {
                if (MQUtils.hasMQTwoWayProjectNature(project) || MQUtils.hasMQOneWayPutProjectNature(project)) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_EXPIRY_NON_NUMERIC, new String[0]);
                    }
                    break;
                }
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            case "waitInterval": {
                if (MQUtils.hasMQTwoWayProjectNature(project)) {
                    try {
                        int waitInterval = Integer.parseInt(value);
                        if (waitInterval != 0) break;
                        result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_MQ_WAIT_INTERVAL_ZERO, new String[0]);
                    }
                    catch (NumberFormatException nfe) {
                        result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_WAIT_INTERVAL_NON_NUMERIC, new String[0]);
                    }
                    break;
                }
                if (MQUtils.hasMQOneWayGetProjectNature(project)) {
                    if (value.isEmpty()) break;
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_WAIT_INTERVAL_NON_NUMERIC, new String[0]);
                    }
                    break;
                }
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            case "replySelection": {
                if (MQUtils.hasMQTwoWayProjectNature(project)) {
                    if (value.equals(REPLYSELECTION_VALUE_CORREL_ID_TO_CORREL_ID) || value.equals(REPLYSELECTION_VALUE_MSG_ID_TO_CORREL_ID) || value.equals(REPLYSELECTION_VALUE_NONE)) break;
                    result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_INCORRECT_REPLY_SELECTION, key);
                    break;
                }
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            case "selector": {
                if (MQUtils.hasMQOneWayGetProjectNature(project)) {
                    if (value.isEmpty() || !value.trim().isEmpty()) break;
                    result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_SELECTOR_BLANK, key);
                    break;
                }
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            case "mqmdFormat": {
                if (MQUtils.hasMQTwoWayProjectNature(project) || MQUtils.hasMQOneWayPutProjectNature(project)) {
                    if (value.length() <= 8) break;
                    result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_MD_FORMAT_TOO_LONG, key);
                    break;
                }
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            case "ccsid": {
                try {
                    int ccsidInt = Integer.parseInt(value);
                    try {
                        if (MQServiceCcsidUtils.getCodepage((int)ccsidInt, (MQServiceTracing)new TracerForMQServiceCcsidUtils()) != null) break;
                        result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_CICS_CCSID_INVALID, key);
                    }
                    catch (IOException e) {
                        result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_UNEXPECTED_ERROR, e.getMessage());
                    }
                }
                catch (NumberFormatException nfe) {
                    result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_CCSID_NON_NUMERIC, new String[0]);
                }
                break;
            }
            case "persistence": {
                if (MQUtils.hasMQTwoWayProjectNature(project) || MQUtils.hasMQOneWayPutProjectNature(project)) {
                    if (value.equals(Boolean.TRUE.toString()) || value.equals(Boolean.FALSE.toString())) break;
                    result = this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_PERSISTENCE_NON_BOOLEAN, new String[0]);
                    break;
                }
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
                break;
            }
            default: {
                result = this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key);
            }
            case "destination": 
            case "connectionFactory": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateConfigurationProperty", (Object[])new Object[]{result});
        return result;
    }

    private ServiceProjectValidationError createNewPropertiesValidationErrorForMQ(IResource resource, String nlsKey, String ... nlsInserts) {
        return new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, MQXlat.getMessage(nlsKey, nlsInserts));
    }

    private ServiceProjectValidationError createNewPropertiesValidationErrorForZCEE(IResource resource, String nlsKey, String ... nlsInserts) {
        return new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)nlsKey, (String[])nlsInserts));
    }

    public List<ServiceProjectValidationError> validateDefinitionProperty(IResource resource, String key, String value) {
        String methodName = "validateDefinitionProperty";
        ZCeeUILogger.entering((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{resource, key, value});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (value == null) {
            String msg = Xlat.error((String)NLS_KEY_REQUIRED_SERVICE_PROPERTY_MISSING, (String[])new String[]{key});
            result.add(this.createNewPropertiesValidationErrorForZCEE(resource, msg, new String[0]));
            ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
            return result;
        }
        IProject project = resource.getProject();
        ServiceProjectValidationError error = null;
        switch (key) {
            case "messagingAction": {
                if (MQUtils.hasMQOneWayPutProjectNature(project) || MQUtils.hasMQOneWayGetProjectNature(project)) {
                    if (!value.equals(MESSAGING_ACTION_VALUE_MQGET) && !value.equals(MESSAGING_ACTION_VALUE_MQPUT)) {
                        result.add(this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_MESSAGING_ACTION_INCORRECT, new String[0]));
                        break;
                    }
                    if ((!MQUtils.hasMQOneWayGetProjectNature(project) || value.equals(MESSAGING_ACTION_VALUE_MQGET)) && (!MQUtils.hasMQOneWayPutProjectNature(project) || value.equals(MESSAGING_ACTION_VALUE_MQPUT))) break;
                    result.add(this.createNewPropertiesValidationErrorForMQ(resource, NLS_KEY_MQ_MESSAGING_ACTION_MISMATCH, new String[0]));
                    break;
                }
                result.add(this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key));
                break;
            }
            case "requestSIName": {
                if (MQUtils.hasMQTwoWayProjectNature(project) || MQUtils.hasMQOneWayPutProjectNature(project)) {
                    result = this.validateRequestOrResponseFile(resource, value, NLS_KEY_SERVICEEDIT_LABEL_REQUESTSI, false);
                    break;
                }
                result.add(this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key));
                break;
            }
            case "responseSIName": {
                if (MQUtils.hasMQTwoWayProjectNature(project) || MQUtils.hasMQOneWayGetProjectNature(project)) {
                    result = this.validateRequestOrResponseFile(resource, value, NLS_KEY_SERVICEEDIT_LABEL_RESPONSESI, true);
                    break;
                }
                result.add(this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key));
                break;
            }
            case "trimOutputLeadingWhitespace": {
                error = this.advancedOptionsValidator.validateTrimOutputLeadingWhitespace(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "trimOutputTrailingWhitespace": {
                error = this.advancedOptionsValidator.validateTrimOutputTrailingWhitespace(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "escapeOutputControlCharacters": {
                error = this.advancedOptionsValidator.validateEscapeOutputControlCharacters(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "initializeInputFields": {
                error = this.advancedOptionsValidator.validateInitializeInputFields(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "omitOutputFieldsByValue": {
                error = this.advancedOptionsValidator.validateOmitOutputFieldsByValue(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "omitOutputEmptyTags": {
                error = this.advancedOptionsValidator.validateOmitOutputEmptyTags(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "enforceMinArrayOccurrence": {
                error = this.advancedOptionsValidator.validateEnforceMinArrayOccurrence(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "enforceMinArrayOccurrenceResponse": {
                error = this.advancedOptionsValidator.validateEnforceMinArrayOccurrenceResponse(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            default: {
                result.add(this.createNewPropertiesValidationErrorForZCEE(resource, NLS_KEY_UNKNOWN_PROPERTY, key));
            }
            case "omitOutputFieldsByValueByte": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
        return result;
    }

    public List<ServiceProjectValidationError> validateRequest(IResource resource, String value) {
        return this.validateRequestOrResponseFile(resource, value, NLS_KEY_SERVICEEDIT_LABEL_REQUESTSI, false);
    }

    public List<ServiceProjectValidationError> validateResponse(IResource resource, String value) {
        return this.validateRequestOrResponseFile(resource, value, NLS_KEY_SERVICEEDIT_LABEL_RESPONSESI, true);
    }

    private List<ServiceProjectValidationError> validateRequestOrResponseFile(IResource resource, String fileName, String label, boolean isResponse) {
        ArrayList<ServiceProjectValidationError> result;
        block16: {
            String methodName = "validateRequestOrResponseFile";
            ZCeeUILogger.entering((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{resource, fileName, label, isResponse});
            result = new ArrayList<ServiceProjectValidationError>();
            if (fileName.isEmpty()) {
                String msg = Xlat.error((String)NLS_KEY_REQUEST_OR_RESPONSE_REQUIRED, (String[])new String[]{Xlat.label((String)label)});
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, msg));
            } else {
                String filePath = "service-interfaces" + File.separator + fileName;
                IProject project = resource.getProject();
                if (!project.getFile(filePath).exists()) {
                    String errMsgInsert = Xlat.error((String)NLS_KEY_PROJECT_FILE_MISSING_ERROR, (String[])new String[]{fileName, project.getName()});
                    String errorMsg = Xlat.error((String)NLS_KEY_PROPERTY_ERROR, (String[])new String[]{Xlat.label((String)label), errMsgInsert});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMsg));
                } else {
                    try {
                        ServiceProjectValidationError error;
                        FieldType errorField;
                        CheckArrayCountersVisitor visitor;
                        IFile file = project.getFolder("service-interfaces").getFile(fileName);
                        Message msg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)file);
                        ServiceArchiveConstants.SP_Type project_spType = ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
                        String siServiceType = msg.getServiceType();
                        if (siServiceType != null && !siServiceType.equals(project_spType.toString())) {
                            String errMsgInsert = Xlat.error((String)NLS_KEY_SE_INCOMPATIBLE_SI_FILE, (String[])new String[]{ServiceExtension.getLabelUsingServiceInterfaceServiceType((String)siServiceType), MQUtils.getTranslatedProjectServiceType(project)});
                            String errorMsg = Xlat.error((String)NLS_KEY_PROPERTY_ERROR, (String[])new String[]{Xlat.label((String)label), errMsgInsert});
                            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMsg));
                            break block16;
                        }
                        if (isResponse) {
                            try {
                                new MessageWalker().accept((IMessageVisitor)new CheckFieldDefaultValuesVisitor(), msg.getMessage());
                            }
                            catch (ResponseInterfaceDefaultValueException e2) {
                                String error2 = Xlat.error((String)NLS_KEY_RESPONSE_SI_DEFAULTVALUES, (String[])new String[]{fileName});
                                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM.toString(), error2, null, null, Integer.valueOf(1)));
                            }
                        }
                        List dataStructures = TranDataStructureController.getAllDataStructures((Message)msg);
                        for (FieldType dataStructure : dataStructures) {
                            visitor = new CheckArrayCountersVisitor();
                            new MessageWalker().accept((IMessageVisitor)visitor, dataStructure);
                            for (Map.Entry errorEntry : visitor.getFieldErrorMessages().entrySet()) {
                                errorField = (FieldType)errorEntry.getKey();
                                for (String errorMessage : (List)errorEntry.getValue()) {
                                    error = new ServiceProjectValidationError((IResource)file, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMessage);
                                    error.setAttribute(ServiceProjectMarkerAttributes.FIELD_PATH, errorField.getPath());
                                    result.add(error);
                                }
                            }
                        }
                        for (FieldType dataStructure : dataStructures) {
                            visitor = new CheckDatatypeOverridesVisitor(!isResponse);
                            new MessageWalker().accept((IMessageVisitor)visitor, dataStructure);
                            for (Map.Entry errorEntry : visitor.getFieldErrorMessages().entrySet()) {
                                errorField = (FieldType)errorEntry.getKey();
                                for (String errorMessage : (List)errorEntry.getValue()) {
                                    error = new ServiceProjectValidationError((IResource)file, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMessage);
                                    error.setAttribute(ServiceProjectMarkerAttributes.FIELD_PATH, errorField.getPath());
                                    result.add(error);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
        return result;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IMessageManager messageMgr, HashMap<String, Control> configurationControls, IResource resource, ServiceExtensionProperty extensionProperty, String value) {
        ServiceProjectValidationError result = null;
        boolean isRequired = extensionProperty.isRequired();
        String propertyType = extensionProperty.getPropertyType();
        String key = extensionProperty.getPropertyName();
        result = this.validateConfigurationProperty(serviceController, resource, key, value, isRequired, propertyType);
        return result;
    }
}

