/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.mq.impl;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import com.ibm.zosconnect.ui.service.mq.impl.MQCompositeBaseImpl;
import com.ibm.zosconnect.ui.service.mq.impl.MQXlat;
import com.ibm.zosconnect.ui.service.mq.impl.ServiceInterfaceHelper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MQCompositeTwoWayImpl
extends MQCompositeBaseImpl {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NLS_KEY_MQ_TWO_WAY_CUSTOM_ACTION = "MQ_TWO_WAY_CUSTOM_ACTION";
    private static final String NLS_KEY_MQ_TWO_WAY_SERVICEEDIT_TITLE = "MQ_TWO_WAY_SERVICEEDIT_TITLE";
    private static final String NLS_KEY_MQ_TWO_WAY_SERVICEEDIT_DESCRIPTION = "MQ_TWO_WAY_SERVICEEDIT_DESCRIPTION";
    private static final String NLS_KEY_MQ_SERVICEEDIT_LABEL_REQUESTSI = "MQ_SERVICEEDIT_LABEL_REQUESTSI";
    private static final String NLS_KEY_MQ_SERVICEEDIT_LABEL_RESPONSESI = "MQ_SERVICEEDIT_LABEL_RESPONSESI";
    private static final String REQUEST_SI_NAME_KEY = "requestSIName";
    private static final String RESPONSE_SI_NAME_KEY = "responseSIName";
    private static final String CLASS_NAME = MQCompositeTwoWayImpl.class.getName();
    private Button editRequestServiceInterfaceButton;
    private Button editResponseServiceInterfaceButton;
    private Combo requestServiceInterfaceCombo;
    private Combo responseServiceInterfaceCombo;
    private final ServiceInterfaceHelper requestServiceInterfaceHelper = new ServiceInterfaceHelper(){

        @Override
        public List<ServiceProjectValidationError> validateServiceInterface(IResource resource, String value) {
            return MQCompositeTwoWayImpl.this.validateRequest(resource, value);
        }

        @Override
        public void setServiceInterfaceName(String name) {
            MQCompositeTwoWayImpl.this.setRequestServiceInterfaceName(name);
        }

        @Override
        public String getServiceInterfaceName() {
            return MQCompositeTwoWayImpl.this.getRequestServiceInterfaceName();
        }

        @Override
        public String getServiceInterfacePropertyKey() {
            return MQCompositeTwoWayImpl.REQUEST_SI_NAME_KEY;
        }
    };
    private final ServiceInterfaceHelper responseServiceInterfaceHelper = new ServiceInterfaceHelper(){

        @Override
        public List<ServiceProjectValidationError> validateServiceInterface(IResource resource, String value) {
            return MQCompositeTwoWayImpl.this.validateResponse(resource, value);
        }

        @Override
        public void setServiceInterfaceName(String name) {
            MQCompositeTwoWayImpl.this.setResponseServiceInterfaceName(name);
        }

        @Override
        public String getServiceInterfaceName() {
            return MQCompositeTwoWayImpl.this.getResponseServiceInterfaceName();
        }

        @Override
        public String getServiceInterfacePropertyKey() {
            return MQCompositeTwoWayImpl.RESPONSE_SI_NAME_KEY;
        }
    };

    public MQCompositeTwoWayImpl() {
        super(NLS_KEY_MQ_TWO_WAY_CUSTOM_ACTION);
        String methodName = "MQCompositeTwoWayImpl<init>";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"MQCompositeTwoWayImpl<init>", (Object[])new Object[0]);
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"MQCompositeTwoWayImpl<init>", (Object[])new Object[0]);
    }

    public LinkedHashMap<Composite, String> getComposites(FormToolkit formToolkit, Composite parentComposite, IServiceProjectEditor serviceProjectEditor) {
        String methodName = "getComposites";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"getComposites", (Object[])new Object[]{formToolkit, parentComposite, serviceProjectEditor});
        this.storeCompositeInformation(formToolkit, parentComposite, serviceProjectEditor);
        LinkedHashMap<Composite, String> listOfComposites = new LinkedHashMap<Composite, String>();
        listOfComposites.put(this.getDefineReqRespServiceInterfaceComposite(), MQXlat.getMessage(NLS_KEY_MQ_TWO_WAY_SERVICEEDIT_TITLE));
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"getComposites", (Object[])new Object[]{listOfComposites});
        return listOfComposites;
    }

    private Composite getDefineReqRespServiceInterfaceComposite() {
        String methodName = "getDefineReqRespServiceInterfaceComposite";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[0]);
        this.generateServiceInterfaceComposite(NLS_KEY_MQ_TWO_WAY_SERVICEEDIT_DESCRIPTION);
        this.generateCreateAndImportSIButtons();
        this.generateServiceInterfacesForTwoWayService();
        this.generateAdvancedOptionsButton();
        this.setTabListOnComposite();
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[0]);
        return this.getServiceInterfaceComposite();
    }

    private void generateServiceInterfacesForTwoWayService() {
        String methodName = "generateServiceInterfacesForTwoWayService";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"generateServiceInterfacesForTwoWayService", (Object[])new Object[0]);
        this.positionFirstServiceInterfaceLabel(this.createLabelForServiceInterfaceButtonAndAddToComposite(NLS_KEY_MQ_SERVICEEDIT_LABEL_REQUESTSI));
        this.requestServiceInterfaceCombo = this.createServiceInterfaceCombo(this.requestServiceInterfaceHelper, true);
        this.editRequestServiceInterfaceButton = this.createEditServiceInterfaceButton(this.requestServiceInterfaceCombo);
        this.createLabelForServiceInterfaceButtonAndAddToComposite(NLS_KEY_MQ_SERVICEEDIT_LABEL_RESPONSESI);
        this.responseServiceInterfaceCombo = this.createServiceInterfaceCombo(this.responseServiceInterfaceHelper, false);
        this.editResponseServiceInterfaceButton = this.createEditServiceInterfaceButton(this.responseServiceInterfaceCombo);
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"generateServiceInterfacesForTwoWayService", (Object[])new Object[0]);
    }

    public void refreshPage(Properties properties) {
        String methodName = "refreshPage";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"refreshPage", (Object[])new Object[]{properties});
        for (Object keyObj : properties.keySet()) {
            String key;
            switch (key = (String)keyObj) {
                case "responseSIName": {
                    this.updateComboOptions(this.responseServiceInterfaceCombo, this.editResponseServiceInterfaceButton, this.responseServiceInterfaceHelper);
                    this.validateCombo(this.responseServiceInterfaceCombo, this.responseServiceInterfaceHelper);
                    break;
                }
                case "requestSIName": {
                    this.updateComboOptions(this.requestServiceInterfaceCombo, this.editRequestServiceInterfaceButton, this.requestServiceInterfaceHelper);
                    this.validateCombo(this.requestServiceInterfaceCombo, this.requestServiceInterfaceHelper);
                }
            }
        }
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"refreshPage", (Object[])new Object[0]);
    }
}

