/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.mq.impl;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.controllers.AdvancedDataConversionOptionsController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.dialogs.AdvancedDataConversionOptionsDialog;
import com.ibm.zosconnect.ui.service.dialogs.ServiceInterfaceSelectionDialog;
import com.ibm.zosconnect.ui.service.dialogs.ServiceProjectSIDialog;
import com.ibm.zosconnect.ui.service.interfaces.IServiceOverviewComposite;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import com.ibm.zosconnect.ui.service.mq.impl.MQPropertiesValidator;
import com.ibm.zosconnect.ui.service.mq.impl.MQUtils;
import com.ibm.zosconnect.ui.service.mq.impl.MQXlat;
import com.ibm.zosconnect.ui.service.mq.impl.ServiceInterfaceHelper;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class MQCompositeBaseImpl
implements IServiceOverviewComposite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CLASS_NAME = MQCompositeBaseImpl.class.getName();
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_COMPOSEDATASET = "SERVICEEDIT_BUTTON_COMPOSEDATASET";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_COMPOSEDATASET_TOOLTIP = "SERVICEEDIT_BUTTON_COMPOSEDATASET_TOOLTIP";
    private static final String NLS_KEY_CREATE_SI_ERROR_TITLE = "CREATE_SI_ERROR_TITLE";
    private static final String NLS_KEY_NULL_NAME_SI_ERROR = "NULL_NAME_SI_ERROR";
    private static final String NLS_KEY_DUPLICATE_SI_ERROR = "DUPLICATE_SI_ERROR";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_IMPORTDATASET = "SERVICEEDIT_BUTTON_IMPORTDATASET";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_IMPORTDATASET_TOOLTIP = "SERVICEEDIT_BUTTON_IMPORTDATASET_TOOLTIP";
    private static final String NLS_KEY_SERVICEEDIT_LABEL_ADVANCED_OPTIONS = "SERVICEEDIT_LABEL_ADVANCED_OPTIONS";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_ADVANCED_OPTIONS = "SERVICEEDIT_BUTTON_ADVANCED_OPTIONS";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_ADVANCED_OPTIONS_TOOLTIP = "SERVICEEDIT_BUTTON_ADVANCED_OPTIONS_TOOLTIP";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_EDIT = "SERVICEEDIT_BUTTON_EDIT";
    private static final String NLS_KEY_SERVICEEDIT_BUTTON_EDIT_TOOLTIP = "SERVICEEDIT_BUTTON_EDIT_TOOLTIP";
    private static final String DOT_SI_SUFFIX = ".si";
    private static final String SI_SUFFIX = "si";
    private final List<String> customActions = new ArrayList<String>();
    private final List<Control> controlsForTabList = new ArrayList<Control>();
    private final MQPropertiesValidator propertiesValidator = new MQPropertiesValidator();
    private Button createServiceInterfaceButton;
    private Button importServiceInterfaceButton;
    private IServiceProjectEditor serviceProjectEditor;
    private Composite parentComposite;
    private FormToolkit formToolkit;
    private Composite serviceInterfaceComposite;
    private IServiceModelController serviceModel;

    public MQCompositeBaseImpl(String customActionsLabel) {
        String methodName = "MQCompositeBaseImpl<init>";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"MQCompositeBaseImpl<init>", (Object[])new Object[]{customActionsLabel});
        this.customActions.add(MQXlat.getMessage(customActionsLabel));
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"MQCompositeBaseImpl<init>", (Object[])new Object[0]);
    }

    public List<String> getCustomActions() {
        return this.customActions;
    }

    protected void storeCompositeInformation(FormToolkit formToolkit, Composite parentComposite, IServiceProjectEditor serviceProjectEditor) {
        this.formToolkit = formToolkit;
        this.parentComposite = parentComposite;
        this.serviceProjectEditor = serviceProjectEditor;
        this.serviceModel = serviceProjectEditor.getServiceProjectController().getServiceModel();
    }

    protected Composite generateServiceInterfaceComposite(String compositeLabelNLSKey) {
        String methodName = "generateServiceInterfaceComposite";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"generateServiceInterfaceComposite", (Object[])new Object[]{compositeLabelNLSKey});
        this.serviceInterfaceComposite = this.formToolkit.createComposite(this.parentComposite, 0);
        this.formToolkit.paintBordersFor(this.serviceInterfaceComposite);
        this.serviceInterfaceComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblDescription = this.formToolkit.createLabel(this.serviceInterfaceComposite, MQXlat.getMessage(compositeLabelNLSKey), 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"generateServiceInterfaceComposite", (Object[])new Object[0]);
        return this.serviceInterfaceComposite;
    }

    protected void generateCreateAndImportSIButtons() {
        String methodName = "generateCreateAndImportSIButtons";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"generateCreateAndImportSIButtons", (Object[])new Object[0]);
        this.createServiceInterfaceButton = new Button(this.serviceInterfaceComposite, 0);
        this.formToolkit.adapt((Control)this.createServiceInterfaceButton, true, true);
        this.createServiceInterfaceButton.setText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_COMPOSEDATASET));
        this.createServiceInterfaceButton.setToolTipText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_COMPOSEDATASET_TOOLTIP));
        this.createServiceInterfaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ServiceProjectSIDialog dialog = new ServiceProjectSIDialog(null);
                    if (dialog.open() == 0) {
                        String siName = dialog.getSiName();
                        if (siName == null || siName.isEmpty()) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)MQCompositeBaseImpl.NLS_KEY_CREATE_SI_ERROR_TITLE), (String)Xlat.error((String)MQCompositeBaseImpl.NLS_KEY_NULL_NAME_SI_ERROR));
                        } else if (MQCompositeBaseImpl.this.getServiceInterfaceFileNameList().contains(siName + MQCompositeBaseImpl.DOT_SI_SUFFIX)) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)MQCompositeBaseImpl.NLS_KEY_CREATE_SI_ERROR_TITLE), (String)Xlat.error((String)MQCompositeBaseImpl.NLS_KEY_DUPLICATE_SI_ERROR, (String[])new String[]{siName + MQCompositeBaseImpl.SI_SUFFIX}));
                        } else {
                            Message initialMsg = null;
                            if (MQUtils.hasMQProjectNature(MQCompositeBaseImpl.this.serviceProjectEditor.getProject())) {
                                initialMsg = ProjectTreeFileHelper.createNewMQProgramInterface((String)siName);
                            }
                            IFile newPgmInterfaceFile = ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsg((String)MQCompositeBaseImpl.this.serviceProjectEditor.getProjectName(), (Message)initialMsg, (String)siName);
                            MQCompositeBaseImpl.this.serviceProjectEditor.launchPgmInterfaceEditor(newPgmInterfaceFile);
                        }
                    }
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.addControlToTabList((Control)this.createServiceInterfaceButton);
        this.importServiceInterfaceButton = new Button(this.serviceInterfaceComposite, 0);
        this.importServiceInterfaceButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formToolkit.adapt((Control)this.importServiceInterfaceButton, true, true);
        this.importServiceInterfaceButton.setText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_IMPORTDATASET));
        this.importServiceInterfaceButton.setToolTipText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_IMPORTDATASET_TOOLTIP));
        this.importServiceInterfaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ServiceInterfaceSelectionDialog dialog = new ServiceInterfaceSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MQCompositeBaseImpl.this.serviceProjectEditor.getServiceProjectController(), true);
                    dialog.open();
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.addControlToTabList((Control)this.importServiceInterfaceButton);
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"generateCreateAndImportSIButtons", (Object[])new Object[0]);
    }

    protected void generateAdvancedOptionsButton() {
        String methodName = "generateAdvancedOptionsButton";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"generateAdvancedOptionsButton", (Object[])new Object[0]);
        Label setAdvancedOptionsLabel = new Label(this.serviceInterfaceComposite, 0);
        this.formToolkit.adapt((Control)setAdvancedOptionsLabel, true, true);
        setAdvancedOptionsLabel.setText(Xlat.label((String)NLS_KEY_SERVICEEDIT_LABEL_ADVANCED_OPTIONS));
        Button setAdvancedOptionsButton = new Button(this.serviceInterfaceComposite, 0);
        setAdvancedOptionsButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formToolkit.adapt((Control)setAdvancedOptionsButton, true, true);
        setAdvancedOptionsButton.setText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_ADVANCED_OPTIONS));
        setAdvancedOptionsButton.setToolTipText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_ADVANCED_OPTIONS_TOOLTIP));
        setAdvancedOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AdvancedDataConversionOptionsController selectAdvMobDataConvOpController = new AdvancedDataConversionOptionsController(MQCompositeBaseImpl.this.serviceProjectEditor.getServiceProjectController().getServiceModel());
                    selectAdvMobDataConvOpController.saveAdvancedOptions();
                    Shell activeShell = Display.getDefault().getActiveShell();
                    AdvancedDataConversionOptionsDialog selAdvDialog = new AdvancedDataConversionOptionsDialog(activeShell, selectAdvMobDataConvOpController);
                    int result = selAdvDialog.open();
                    if (result == 0) {
                        MQCompositeBaseImpl.this.serviceProjectEditor.setDirty(true);
                    } else if (result == 1) {
                        selectAdvMobDataConvOpController.restoreAdvancedOptions();
                    }
                }
                catch (Exception e1) {
                    ZCeeUILogger.error((Throwable)e1);
                    ZCeeErrorDialog.openError((Exception)e1);
                }
            }
        });
        this.addControlToTabList((Control)setAdvancedOptionsButton);
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"generateAdvancedOptionsButton", (Object[])new Object[0]);
    }

    private List<String> getServiceInterfaceFileNameList() {
        String methodName = "getServiceInterfaceFileNameList";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"getServiceInterfaceFileNameList", (Object[])new Object[0]);
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            IResource[] iResourceArray = this.serviceProjectEditor.getServiceProjectController().getFolder("service-interfaces").members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getFileExtension().equalsIgnoreCase(SI_SUFFIX)) {
                    fileNames.add(resource.getName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"getServiceInterfaceFileNameList", (Object[])new Object[]{fileNames});
        return fileNames;
    }

    protected void setTabListOnComposite() {
        this.serviceInterfaceComposite.setTabList(this.controlsForTabList.toArray(new Control[0]));
    }

    protected void addControlToTabList(Control control) {
        this.controlsForTabList.add(control);
    }

    protected SelectionListener getEditButtonSelectionListener(final Combo comboForButton) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String siName = comboForButton.getText();
                if (siName != null && !siName.isEmpty() && MQCompositeBaseImpl.this.getServiceInterfaceFileNameList().contains(siName)) {
                    try {
                        IFile newPgmInterfaceFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)MQCompositeBaseImpl.this.serviceProjectEditor.getProjectName(), (String)siName);
                        MQCompositeBaseImpl.this.serviceProjectEditor.launchPgmInterfaceEditor(newPgmInterfaceFile);
                    }
                    catch (Exception e1) {
                        ZCeeUILogger.error((Throwable)e1);
                        ZCeeErrorDialog.openError((Exception)e1);
                    }
                }
            }
        };
    }

    protected void updateComboOptions(Combo serviceInterfaceCombo, Button serviceInterfaceButton, ServiceInterfaceHelper serviceInterfaceHelper) {
        String methodName = "updateComboOptions";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"updateComboOptions", (Object[])new Object[]{serviceInterfaceCombo, serviceInterfaceButton, serviceInterfaceHelper});
        serviceInterfaceCombo.removeAll();
        for (String fileName : this.getServiceInterfaceFileNameList()) {
            serviceInterfaceCombo.add(fileName);
        }
        if (serviceInterfaceHelper.getServiceInterfaceName().isEmpty() || !Arrays.asList(serviceInterfaceCombo.getItems()).contains(serviceInterfaceHelper.getServiceInterfaceName())) {
            serviceInterfaceCombo.select(0);
        } else {
            serviceInterfaceCombo.setText(serviceInterfaceHelper.getServiceInterfaceName());
        }
        if (serviceInterfaceButton != null) {
            if (serviceInterfaceCombo.getItemCount() == 0) {
                serviceInterfaceButton.setEnabled(false);
                if (!serviceInterfaceHelper.getServiceInterfaceName().isEmpty()) {
                    this.setEditorDirty();
                    serviceInterfaceHelper.setServiceInterfaceName("");
                }
            } else {
                serviceInterfaceButton.setEnabled(true);
            }
        }
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"updateComboOptions", (Object[])new Object[0]);
    }

    private void setEditorDirty() {
        boolean tempLoading = this.serviceProjectEditor.isLoading();
        this.serviceProjectEditor.setLoading(false);
        this.serviceProjectEditor.setDirty(true);
        this.serviceProjectEditor.setLoading(tempLoading);
    }

    protected void validateCombo(Combo serviceInterfaceCombo, ServiceInterfaceHelper serviceInterfaceHelper) {
        List<ServiceProjectValidationError> validationErrors;
        String methodName = "validateCombo";
        ZCeeUILogger.entering((String)CLASS_NAME, (String)"validateCombo", (Object[])new Object[]{serviceInterfaceCombo, serviceInterfaceHelper});
        if (serviceInterfaceCombo.getSelectionIndex() != -1 && !serviceInterfaceHelper.getServiceInterfaceName().equals(serviceInterfaceCombo.getItem(serviceInterfaceCombo.getSelectionIndex()))) {
            serviceInterfaceHelper.setServiceInterfaceName(serviceInterfaceCombo.getItem(serviceInterfaceCombo.getSelectionIndex()));
            this.setEditorDirty();
        }
        if ((validationErrors = serviceInterfaceHelper.validateServiceInterface(this.serviceModel.getResource(), serviceInterfaceCombo.getText())) != null && !validationErrors.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrors.get(0);
            if (firstError.getSeverity().equals(1)) {
                this.serviceProjectEditor.getServiceProjectValidator().setControlToWarning(this.serviceProjectEditor.getMessageManager(), serviceInterfaceHelper.getServiceInterfacePropertyKey(), firstError, (Control)serviceInterfaceCombo);
            } else {
                this.serviceProjectEditor.getServiceProjectValidator().setControlToError(this.serviceProjectEditor.getMessageManager(), serviceInterfaceHelper.getServiceInterfacePropertyKey(), firstError, (Control)serviceInterfaceCombo);
            }
        } else {
            this.serviceProjectEditor.getServiceProjectValidator().resetControlToError(this.serviceProjectEditor.getMessageManager(), serviceInterfaceHelper.getServiceInterfacePropertyKey(), (Control)serviceInterfaceCombo);
        }
        ZCeeUILogger.exiting((String)CLASS_NAME, (String)"validateCombo", (Object[])new Object[0]);
    }

    protected List<ServiceProjectValidationError> validateResponse(IResource resource, String value) {
        return this.propertiesValidator.validateResponse(resource, value);
    }

    protected List<ServiceProjectValidationError> validateRequest(IResource resource, String value) {
        return this.propertiesValidator.validateRequest(resource, value);
    }

    protected Button createEditServiceInterfaceButton(Combo serviceInterfaceCombo) {
        Button button = new Button(this.serviceInterfaceComposite, 0);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)button, true, true);
        button.setText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_EDIT));
        button.setToolTipText(Xlat.label((String)NLS_KEY_SERVICEEDIT_BUTTON_EDIT_TOOLTIP));
        button.addSelectionListener(this.getEditButtonSelectionListener(serviceInterfaceCombo));
        this.addControlToTabList((Control)button);
        return button;
    }

    protected Combo createServiceInterfaceCombo(final ServiceInterfaceHelper serviceInterfaceHelper, boolean isFirstCombo) {
        final Combo serviceInterfaceCombo = new Combo(this.serviceInterfaceComposite, 8);
        this.updateComboOptions(serviceInterfaceCombo, null, serviceInterfaceHelper);
        int horizontalButtonAlignment = isFirstCombo ? 16384 : 0;
        GridData griddataForServiceInterfaceButton = new GridData(horizontalButtonAlignment, 0x1000000, false, false, 1, 1);
        griddataForServiceInterfaceButton.widthHint = 400;
        serviceInterfaceCombo.setLayoutData((Object)griddataForServiceInterfaceButton);
        this.formToolkit.adapt((Composite)serviceInterfaceCombo);
        this.formToolkit.paintBordersFor((Composite)serviceInterfaceCombo);
        List<ServiceProjectValidationError> validationErrorsForServiceInterface = serviceInterfaceHelper.validateServiceInterface(this.serviceModel.getResource(), serviceInterfaceCombo.getText());
        if (validationErrorsForServiceInterface != null && !validationErrorsForServiceInterface.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrorsForServiceInterface.get(0);
            this.serviceProjectEditor.getServiceProjectValidator().setControlToError(this.serviceProjectEditor.getMessageManager(), serviceInterfaceHelper.getServiceInterfacePropertyKey(), firstError, (Control)serviceInterfaceCombo);
        } else {
            this.serviceProjectEditor.getServiceProjectValidator().resetControlToError(this.serviceProjectEditor.getMessageManager(), serviceInterfaceHelper.getServiceInterfacePropertyKey(), (Control)serviceInterfaceCombo);
        }
        serviceInterfaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MQCompositeBaseImpl.this.serviceProjectEditor.isLoading()) {
                    MQCompositeBaseImpl.this.validateCombo(serviceInterfaceCombo, serviceInterfaceHelper);
                }
            }
        });
        this.addControlToTabList((Control)serviceInterfaceCombo);
        return serviceInterfaceCombo;
    }

    protected Label createLabelForServiceInterfaceButtonAndAddToComposite(String labelNLSKey) {
        return this.formToolkit.createLabel(this.serviceInterfaceComposite, MQXlat.getMessage(labelNLSKey) + Xlat.colon(), 0);
    }

    protected Composite getServiceInterfaceComposite() {
        return this.serviceInterfaceComposite;
    }

    protected void setRequestServiceInterfaceName(String name) {
        this.serviceModel.setServiceRequestSIName(name);
    }

    protected void setResponseServiceInterfaceName(String name) {
        this.serviceModel.setServiceResponseSIName(name);
    }

    protected String getRequestServiceInterfaceName() {
        return this.serviceModel.getServiceRequestSIName();
    }

    protected String getResponseServiceInterfaceName() {
        return this.serviceModel.getServiceResponseSIName();
    }

    protected void positionFirstServiceInterfaceLabel(Label serviceInterfaceLabel) {
        GridData griddataForServiceInterfaceLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        griddataForServiceInterfaceLabel.widthHint = 200;
        serviceInterfaceLabel.setLayoutData((Object)griddataForServiceInterfaceLabel);
    }
}

