/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.FieldTypeToolTip;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.SegmentTypeToolTip;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeNodeToolTipTreeListener
extends MouseTrackAdapter
implements MouseMoveListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Tree tree;
    private FieldTypeToolTip fieldTooltip;
    private SegmentTypeToolTip segTooltip;
    private boolean fieldToolTipActivated;
    private boolean segmentToolTipActivated;

    public TreeNodeToolTipTreeListener(Tree tree, TranEditorController tranEditCtrl) {
        this.tree = tree;
        this.fieldTooltip = new FieldTypeToolTip((Control)tree, tranEditCtrl);
        this.fieldTooltip.deactivate();
        this.segTooltip = new SegmentTypeToolTip((Control)tree);
        this.segTooltip.deactivate();
    }

    public void mouseMove(MouseEvent me) {
        TreeItem item = this.tree.getItem(new Point(me.x, me.y));
        FieldModel field = null;
        TranSegmentModel segment = null;
        if (item != null && item.getData() instanceof FieldModel) {
            field = (FieldModel)item.getData();
        } else if (item != null && item.getData() instanceof TranSegmentModel) {
            segment = (TranSegmentModel)item.getData();
        }
        if (field != null) {
            this.fieldTooltip.setData(FieldType.class.getCanonicalName(), field);
            this.fieldTooltip.activate();
            this.fieldToolTipActivated = true;
        } else if (segment != null) {
            this.segTooltip.setData(SegmentType.class.getCanonicalName(), segment);
            this.segTooltip.activate();
            this.segmentToolTipActivated = true;
        } else {
            if (this.fieldToolTipActivated) {
                this.fieldTooltip.deactivate();
                this.fieldToolTipActivated = false;
            }
            if (this.segmentToolTipActivated) {
                this.segTooltip.deactivate();
                this.segmentToolTipActivated = false;
            }
        }
    }
}

