/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class SegmentTypeToolTip
extends ToolTip {
    private Color backgroundColor = XSwt.getColor((int)29);
    private Color foregroundColor = XSwt.getColor((int)28);

    public SegmentTypeToolTip(Control control) {
        super(control);
        this.setShift(new Point(15, 0));
        this.backgroundColor = control.getBackground();
        this.foregroundColor = control.getForeground();
    }

    protected Composite createToolTipContentArea(Event event, Composite content) {
        Composite composite = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        composite.setBackground(this.backgroundColor);
        TranSegmentModel segNode = (TranSegmentModel)this.getData(SegmentType.class.getCanonicalName());
        if (segNode == null) {
            return null;
        }
        SegmentType segType = segNode.getSegment();
        if (segType == null) {
            return null;
        }
        String importPrompt = "";
        if (segNode.getSpType() == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            importPrompt = PgmIntXlat.getLabel().getString("SIE_IMPORT_PROMPT_HOVER_CONTAINER");
        } else if (segNode.getSpType() == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA) {
            importPrompt = PgmIntXlat.getLabel().getString("SIE_IMPORT_PROMPT_HOVER_COMMAREA");
        } else if (segNode.getSpType() == ServiceArchiveConstants.SP_Type.IMS) {
            importPrompt = PgmIntXlat.getLabel().getString("SIE_IMPORT_PROMPT_HOVER_SEGMENT");
        } else if (segNode.getSpType() == ServiceArchiveConstants.SP_Type.IMS_LDS) {
            importPrompt = PgmIntXlat.getLabel().getString("SIE_IMPORT_PROMPT_HOVER_LDS");
        } else if (segNode.getSpType() == ServiceArchiveConstants.SP_Type.IMSDB) {
            importPrompt = PgmIntXlat.getLabel().getString("SIE_IMPORT_PROMPT_HOVER_IMSDB");
        } else if (segNode.getSpType() == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            importPrompt = PgmIntXlat.getLabel().getString("SIE_IMPORT_PROMPT_HOVER_MQ_MESSAGE");
        }
        StyledText styledText = new StyledText(composite, 0);
        styledText.setText(importPrompt);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = importPrompt.length();
        styleRange.fontStyle = 0;
        styleRange.background = this.backgroundColor;
        styleRange.foreground = this.foregroundColor;
        styledText.setStyleRange(styleRange);
        return composite;
    }
}

