/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.api.ZosConnectJAXBEscapeHandler;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.gateway.rest.models.GatewayService;
import com.ibm.zosconnect.wv.metadata.message.overlay.InterfaceFieldType;
import com.ibm.zosconnect.wv.metadata.message.overlay.MessageInterfaceType;
import com.ibm.zosconnect.wv.metadata.message.overlay.ServiceInterface;
import com.ibm.zosconnect.wv.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.CicsContainerType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.ObjectFactory;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.Transaction;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ProjectTreeFileHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger("com.ibm.im.ims.workbench.transaction.utilities.ProjectTreeFileHelper");
    public static final String CATALOG_PROJECT_NAME = "IMS_Explorer_Catalog_ReadOnly";
    public static final String TRANSACTION_META_EXTENTION = ".trn";
    public static final String TEST_CASE_EXTENTION = ".ttc";
    public static final String XML_EXTENTION = ".xml";
    public static final String DS_EXTENTION = ".si";
    public static final String JSON_TEST_CASE_EXTENTION = ".stc";
    public static final String SEGMENT_PAYLOAD_EXTENTION = ".segbin";
    public static final String TOP_TRANSACTION_FOLDER = "Transactions";
    public static final String ZCEE_SCHEMAS_FOLDER = "schemas";
    public static final String ZCEE_SERVICES_FOLDER = "services";
    public static final String ZCEE_SERVICE_ARTIFACTS_FOLDER = "bin";
    public static final String ZCEE_SCHEMAS_REQUEST_SUFFIX = "Request.json";
    public static final String ZCEE_SCHEMAS_RESPONSE_SUFFIX = "Response.json";
    public static final String SERVER_TRANSACTION_FOLDER = "Server Transactions";
    public static final String INPUT_MSG_FOLDER = "Input Messages";
    public static final String OUTPUT_MSG_FOLDER = "Output Messages";
    public static final String TOP_TESTCASE_FOLDER = "Test Cases";
    public static final String MESSAGE_FOLDER = "Messages";
    public static final String SEGMENT_FOLDER = "Segments";
    public static final String TRANTOC_FILENAME = ".toc";
    public static final String TRAN_PROJ_NATURE = "com.ibm.im.ims.workbench.transaction.nature";
    public static final String ZCEE_IMS_PGM_INTERFACE_PROJ_NATURE = "com.ibm.ims.zcee.transaction.nature";
    public static final String ZCEE_CICS_PGM_INTERFACE_PROJ_NATURE = "com.ibm.zcee.cics.program.nature";
    public static final String ZCEE_DB2_SERVICE_PROJ_NATURE = "com.ibm.zcee.db2.service.nature";
    public static final String ZCEE_IMS_SERVICE_PROJ_NATURE = "com.ibm.ims.zcee.service.nature";
    public static final String ZCEE_CICS_SERVICE_PROJ_NATURE = "com.ibm.zcee.cics.service.nature";
    public static final String SERVICE_TEST_PROJ_NATURE = "com.ibm.ims.gw.ui.nature";
    private static JAXBContext tranContext = null;
    private static Marshaller tranMarshaller = null;
    private static JAXBContext serviceInterfaceContext = null;
    private static Marshaller serviceInterfaceMarshaller = null;
    private static Unmarshaller serviceInterfaceUnmarshaller = null;
    private static Unmarshaller tranUnmarshaller = null;

    public static void createNewzCEEProgramProject(String projectName, ProgramType pgmType) throws CoreException, JAXBException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            String[] nature = new String[1];
            if (pgmType == ProgramType.CICS) {
                nature[0] = ZCEE_CICS_PGM_INTERFACE_PROJ_NATURE;
            } else if (pgmType == ProgramType.IMS) {
                nature[0] = ZCEE_IMS_PGM_INTERFACE_PROJ_NATURE;
            }
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(nature);
            project.setDescription(desc, (IProgressMonitor)monitor);
        }
    }

    public static void createNewzCEEServiceProject(String containerName) throws CoreException, JAXBException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            String[] natures = new String[]{ZCEE_IMS_SERVICE_PROJ_NATURE};
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(natures);
            project.setDescription(desc, (IProgressMonitor)monitor);
        }
    }

    public static Transaction createNewTran(String projectName, String tranCode) {
        tranCode = tranCode.trim();
        Transaction newTran = new Transaction();
        newTran.setTranCode(tranCode);
        MessageType newMsg = new MessageType();
        newMsg.setName(tranCode + " - INPUT");
        newMsg.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setId(BigInteger.valueOf(1L));
        newMsg.getSegment().add(newSeg);
        newTran.getInputMessage().add(newMsg);
        MessageType newOutMsg = new MessageType();
        newOutMsg.setName(tranCode + " - OUTPUT");
        newOutMsg.setId(BigInteger.valueOf(2L));
        SegmentType newOutSeg = new SegmentType();
        newOutSeg.setId(BigInteger.valueOf(1L));
        newOutMsg.getSegment().add(newOutSeg);
        newTran.getOutputMessage().add(newOutMsg);
        return newTran;
    }

    public static Message createNewImsProgramInterface(String name, String programName) throws CoreException {
        MessageType newInMsgType = new MessageType();
        newInMsgType.setName(name);
        newInMsgType.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " 1");
        newSeg.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " 1");
        newSeg.setId(BigInteger.valueOf(1L));
        newInMsgType.getSegment().add(newSeg);
        Message msg = new Message();
        msg.setMessageName(newInMsgType.getName());
        msg.setMessage(newInMsgType);
        msg.setDirection(BigInteger.valueOf(0L));
        msg.setTransactionCode(programName);
        msg.setServiceType(ServiceArchiveConstants.SP_Type.IMS.toString());
        return msg;
    }

    public static Message createNewImsLdsProgramInterface(String name, String programName) throws CoreException {
        MessageType newInMsgType = new MessageType();
        newInMsgType.setName(name);
        newInMsgType.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setOriginalName(PgmIntXlat.getLabel().getString("TMME_IMS_LDS"));
        newSeg.setName(PgmIntXlat.getLabel().getString("TMME_IMS_LDS"));
        newSeg.setId(BigInteger.valueOf(1L));
        newInMsgType.getSegment().add(newSeg);
        Message msg = new Message();
        msg.setMessageName(newInMsgType.getName());
        msg.setMessage(newInMsgType);
        msg.setDirection(BigInteger.valueOf(0L));
        msg.setTransactionCode(programName);
        msg.setServiceType(ServiceArchiveConstants.SP_Type.IMS_LDS.toString());
        return msg;
    }

    public static Message createNewChannelProgramInterface(String name, String programName) throws CoreException {
        MessageType newInMsgType = new MessageType();
        newInMsgType.setName(name);
        newInMsgType.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setContainerType(CicsContainerType.BIT);
        newSeg.setOriginalName(PgmIntXlat.getLabel().getString("TMME_CONTAINER") + "1");
        newSeg.setName("");
        newSeg.setRequired(YesnoType.Y);
        newSeg.setId(BigInteger.valueOf(1L));
        newInMsgType.getSegment().add(newSeg);
        Message msg = new Message();
        msg.setMessageName(PgmIntXlat.getLabel().getString("ZSIE_CHANNEL_NAME"));
        newInMsgType.setName(PgmIntXlat.getLabel().getString("ZSIE_CHANNEL_NAME"));
        msg.setMessage(newInMsgType);
        msg.setDirection(BigInteger.valueOf(0L));
        msg.setTransactionCode(programName);
        msg.setServiceType(ServiceArchiveConstants.SP_Type.CICS_CHANNEL.toString());
        return msg;
    }

    public static Message createNewCommareaProgramInterface(String name, String programName) throws CoreException {
        MessageType newInMsgType = new MessageType();
        newInMsgType.setName(name);
        newInMsgType.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setOriginalName("COMMAREA");
        newSeg.setName("COMMAREA");
        newSeg.setId(BigInteger.valueOf(1L));
        newInMsgType.getSegment().add(newSeg);
        Message msg = new Message();
        msg.setMessageName(newInMsgType.getName());
        msg.setMessage(newInMsgType);
        msg.setDirection(BigInteger.valueOf(0L));
        msg.setTransactionCode(programName);
        msg.setServiceType(ServiceArchiveConstants.SP_Type.CICS_COMM_AREA.toString());
        return msg;
    }

    public static Message createNewMQProgramInterface(String name) throws CoreException {
        MessageType newInMsgType = new MessageType();
        newInMsgType.setName(name);
        newInMsgType.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        String segmentName = PgmIntXlat.getLabel().getString("MQ_SEGMENT_NAME");
        newSeg.setOriginalName(segmentName);
        newSeg.setName(segmentName);
        newSeg.setId(BigInteger.valueOf(1L));
        newInMsgType.getSegment().add(newSeg);
        Message msg = new Message();
        msg.setMessageName(newInMsgType.getName());
        msg.setMessage(newInMsgType);
        msg.setDirection(BigInteger.valueOf(0L));
        msg.setServiceType(ServiceArchiveConstants.SP_Type.MQ_MESSAGE.toString());
        return msg;
    }

    public static boolean projectExists(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        boolean retVal = false;
        try {
            IProject project = root.getProject(projectName);
            retVal = project.exists();
        }
        catch (Throwable e) {
            logger.finest(e.getMessage());
        }
        return retVal;
    }

    public static IProject getProject(String projectName) throws CoreException {
        IProject retVal = null;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        retVal = wsRoot.getProject(projectName);
        return retVal;
    }

    public static IFolder getTransactionFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(TOP_TRANSACTION_FOLDER);
        return transFolder;
    }

    public static IFolder getTestCaseFolder(String projectName) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(TOP_TESTCASE_FOLDER);
        return transFolder;
    }

    public static String[] getTestCaseFileNames(String projectName) throws CoreException {
        return ProjectTreeFileHelper.getTestCaseFileNames(projectName, true);
    }

    public static String[] getTestCaseFileNames(String projectName, boolean removeExtension) throws CoreException {
        IFolder tcFolder = ProjectTreeFileHelper.getTestCaseFolder(projectName);
        IResource[] members = tcFolder.members();
        String[] retVal = new String[members.length];
        int i = 0;
        while (i < members.length) {
            String ext = "." + members[i].getFileExtension();
            if (ext != null && ext.equals(TEST_CASE_EXTENTION)) {
                String fileName = members[i].getName();
                retVal[i] = removeExtension ? fileName.substring(0, fileName.length() - 4) : fileName;
            }
            ++i;
        }
        return retVal;
    }

    public static String[] getServiceTestCaseFileNames(String projectName, boolean removeExtension) throws CoreException {
        String[] retVal = new String[]{};
        if (ProjectTreeFileHelper.projectExists(projectName)) {
            IFolder tcFolder = ProjectTreeFileHelper.getTestCaseFolder(projectName);
            IResource[] members = tcFolder.members();
            retVal = new String[members.length];
            int i = 0;
            while (i < members.length) {
                String ext = "." + members[i].getFileExtension();
                if (ext != null && ext.equals(JSON_TEST_CASE_EXTENTION)) {
                    String fileName = members[i].getName();
                    retVal[i] = removeExtension ? fileName.substring(0, fileName.length() - 4) : fileName;
                }
                ++i;
            }
        }
        return retVal;
    }

    public static String[] getTransactionFileNames(String projectName) throws CoreException {
        IFolder tranFolder = ProjectTreeFileHelper.getTransactionFolder(projectName);
        IResource[] members = tranFolder.members();
        String[] retVal = new String[members.length];
        int i = 0;
        while (i < members.length) {
            String ext = members[i].getFileExtension();
            if (ext != null && ext.equals("trn")) {
                String fileName = members[i].getName();
                retVal[i] = fileName.substring(0, fileName.length() - 4);
            }
            ++i;
        }
        return retVal;
    }

    public static IFile getTransactionMetadataFile(String projectName, String tranName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(TOP_TRANSACTION_FOLDER);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        IFile retVal = transFolder.getFile((IPath)new Path(tranName + TRANSACTION_META_EXTENTION));
        return retVal;
    }

    public static IProject getCatalogReadOnlyProject() throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(CATALOG_PROJECT_NAME);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.create((IProgressMonitor)monitor);
        }
        project.open((IProgressMonitor)monitor);
        return project;
    }

    public static IFile getTransactionMetadataFile(String tranName) throws CoreException {
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder transFolder = project.getFolder(SERVER_TRANSACTION_FOLDER);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        IFile retVal = transFolder.getFile((IPath)new Path(tranName + TRANSACTION_META_EXTENTION));
        return retVal;
    }

    public static void deleteTransactionMetadataFile(String tranName) throws CoreException {
        IFile tranFile;
        IProject project = ProjectTreeFileHelper.getCatalogReadOnlyProject();
        IFolder transFolder = project.getFolder(SERVER_TRANSACTION_FOLDER);
        if (transFolder.exists() && (tranFile = transFolder.getFile((IPath)new Path(tranName + TRANSACTION_META_EXTENTION))).exists()) {
            tranFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IFile getTrantocMetadataFile(String projectName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile retVal = project.getFile((IPath)new Path(TRANTOC_FILENAME));
        return retVal;
    }

    public static IFile getTestCaseMetadataFile(String projectName, String tcId) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder tcFolder = project.getFolder(TOP_TESTCASE_FOLDER);
        if (!tcFolder.exists()) {
            tcFolder.create(true, true, null);
        }
        IFile retVal = tcFolder.getFile((IPath)new Path(tcId + TEST_CASE_EXTENTION));
        return retVal;
    }

    public static IFile getJsonTestCaseMetadataFile(String projectName, String tcId) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder tcFolder = project.getFolder(TOP_TESTCASE_FOLDER);
        if (!tcFolder.exists()) {
            tcFolder.create(true, true, null);
        }
        IFile retVal = tcFolder.getFile((IPath)new Path(tcId + JSON_TEST_CASE_EXTENTION));
        return retVal;
    }

    public static IFile getSegmentBytesFile(String projectName, String fileName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFile retVal = project.getFile((IPath)new Path(fileName + SEGMENT_PAYLOAD_EXTENTION));
        return retVal;
    }

    public static HashMap<String, String> getAllProjectFromOS() {
        HashMap<String, String> projHash = new HashMap<String, String>();
        File root = Platform.getLocation().toFile();
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    projHash.put(f.getName().toUpperCase(), f.getName());
                }
                ++n2;
            }
        }
        return projHash;
    }

    public static IProject getTransactionProject(String projectName) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (ProjectTreeFileHelper.hasTransNature(project) && project.getName().equals(projectName)) {
                return project;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasTransNature(IProject iProject) {
        try {
            if (iProject != null && iProject.getNature(TRAN_PROJ_NATURE) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing("com.ibm.im.ims.workbench.transaction.utilities.ProjectTreeFileHelper", "hasTransNature(IProject)", e);
            EclipseLogger.logError(e);
        }
        return false;
    }

    public static boolean hasIMSzCEEServiceNature(IProject iProject) {
        try {
            if (iProject != null && iProject.getNature(ZCEE_IMS_SERVICE_PROJ_NATURE) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing("com.ibm.im.ims.workbench.transaction.utilities.ProjectTreeFileHelper", "hasIMSzCEEServiceNature(IProject)", e);
            EclipseLogger.logError(e);
        }
        return false;
    }

    public static boolean hasIMSzCEEProgramInterfaceNature(IProject iProject) {
        try {
            if (iProject != null && iProject.getNature(ZCEE_IMS_PGM_INTERFACE_PROJ_NATURE) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing("com.ibm.im.ims.workbench.transaction.utilities.ProjectTreeFileHelper", "hasIMSzCEEServiceNature(IProject)", e);
            EclipseLogger.logError(e);
        }
        return false;
    }

    public static boolean hasCICSzCEEProgramInterfaceNature(IProject iProject) {
        try {
            if (iProject != null && iProject.getNature(ZCEE_CICS_PGM_INTERFACE_PROJ_NATURE) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            logger.throwing("com.ibm.im.ims.workbench.transaction.utilities.ProjectTreeFileHelper", "hasIMSzCEEServiceNature(IProject)", e);
            EclipseLogger.logError(e);
        }
        return false;
    }

    public static ArrayList<String> getProjectList(String[] projectNature) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> projectNames = new ArrayList<String>();
        IResource[] resources = root.members();
        if (resources.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            try {
                IProject temp = (IProject)resources[i];
                boolean strCompare = Arrays.equals(temp.getDescription().getNatureIds(), projectNature);
                if (resources[i] instanceof IProject && strCompare) {
                    projectNames.add(temp.getName());
                }
            }
            catch (Throwable e) {
                logger.throwing("ProjectTreeFileHelper", "getProjectList(String[] projectNature)", e);
            }
            ++i;
        }
        return projectNames;
    }

    public static IFile marshallNewTran(String projectName, Transaction newTran, String newTranName) throws CoreException, IOException, JAXBException {
        IFile tranFile = null;
        if (newTran != null) {
            tranFile = ProjectTreeFileHelper.getTransactionMetadataFile(projectName, newTranName);
            ProjectTreeFileHelper.marshallTran(projectName, newTran, tranFile);
        }
        return tranFile;
    }

    public static void revealTranInProjectTree(IFile tranFile) {
        IViewPart part;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (part = page.findView("org.eclipse.ui.navigator.ProjectExplorer")) != null && part instanceof ISetSelectionTarget) {
            if (!page.isPartVisible((IWorkbenchPart)part)) {
                try {
                    page.showView("org.eclipse.ui.navigator.ProjectExplorer");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            StructuredSelection selection = new StructuredSelection((Object)tranFile);
            ((ISetSelectionTarget)part).selectReveal((ISelection)selection);
        }
    }

    public static void launchTranEditor(IFile tranFile) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            IDE.openEditor((IWorkbenchPage)page, (IFile)tranFile);
        }
    }

    public static MessageType getInputMessage(Transaction transaction, String messageName) {
        List messages = transaction.getInputMessage();
        int i = 0;
        while (i < messages.size()) {
            MessageType currentMessage = (MessageType)messages.get(i);
            if (messageName.equals(currentMessage.getName())) {
                return currentMessage;
            }
            ++i;
        }
        return null;
    }

    public static MessageType getOutputMessage(Transaction transaction, String messageName) {
        List messages = transaction.getOutputMessage();
        int i = 0;
        while (i < messages.size()) {
            MessageType currentMessage = (MessageType)messages.get(i);
            if (messageName.equals(currentMessage.getName())) {
                return currentMessage;
            }
            ++i;
        }
        return null;
    }

    public static Properties getProjectCapabilities(IProject project) throws CoreException, IOException {
        IFile capabilitiesFile = project.getFile(".capabilities");
        Properties properties = null;
        if (capabilitiesFile.exists()) {
            capabilitiesFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            InputStream is = capabilitiesFile.getContents();
            ZCeeUILogger.info((String)"Loading properties from file {0}", (Object[])new Object[]{capabilitiesFile.getName()});
            properties = new Properties();
            properties.load(is);
            is.close();
        }
        return properties;
    }

    public static Transaction unmarshallTran(String projectName, String tranName) throws JAXBException, CoreException {
        InputStream is;
        tranName = tranName.trim();
        if (tranUnmarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranUnmarshaller = tranContext.createUnmarshaller();
        }
        if (projectName.equals(CATALOG_PROJECT_NAME)) {
            is = ProjectTreeFileHelper.getTransactionMetadataFile(tranName).getContents();
        } else {
            IFile theFile = ProjectTreeFileHelper.getTransactionMetadataFile(projectName, tranName);
            is = theFile.getContents();
        }
        Transaction tran = (Transaction)tranUnmarshaller.unmarshal(is);
        return tran;
    }

    public static Transaction unmarshallTran(InputStream is) throws JAXBException, CoreException {
        if (tranUnmarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranUnmarshaller = tranContext.createUnmarshaller();
        }
        Transaction tran = (Transaction)tranUnmarshaller.unmarshal(is);
        return tran;
    }

    public static void marshallTran(String projectName, Transaction tran, IFile tranMetaFile) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)tran, (OutputStream)tranOutputStream);
        ByteArrayInputStream tranInputStream = new ByteArrayInputStream(tranOutputStream.toByteArray());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranInputStream, true, true, null);
        }
    }

    public static void marshallProgramMessages(String projectName, Transaction tran) throws JAXBException, CoreException {
        Message msg;
        List inMsgs = tran.getInputMessage();
        List outMsgs = tran.getOutputMessage();
        for (MessageType msgType : inMsgs) {
            msg = new Message();
            msg.setMessageName(msgType.getName().trim());
            msg.setMessage(msgType);
            msg.setDirection(new BigInteger("0"));
            ProjectTreeFileHelper.marshallzCEESharedProgramMsg(projectName, tran.getTranCode().trim(), msg);
        }
        for (MessageType msgType : outMsgs) {
            msg = new Message();
            msg.setMessageName(msgType.getName().trim());
            msg.setMessage(msgType);
            msg.setDirection(new BigInteger("1"));
            ProjectTreeFileHelper.marshallzCEESharedProgramMsg(projectName, tran.getTranCode().trim(), msg);
        }
    }

    public static IFile getzCEEProgramMsgFile(String projectName, String msgName) throws CoreException {
        int extIx;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dataStructuresFolder = project.getFolder("service-interfaces");
        if (!dataStructuresFolder.exists()) {
            dataStructuresFolder.create(true, true, null);
        }
        if ((extIx = ((String)msgName).indexOf(DS_EXTENTION)) < 0) {
            msgName = (String)msgName + DS_EXTENTION;
        }
        IFile tranMetaFile = dataStructuresFolder.getFile((IPath)new Path((String)msgName));
        return tranMetaFile;
    }

    public static String[] getzCEEProgramMsgNames(String projectName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder dataStructuresFolder = project.getFolder("service-interfaces");
        if (!dataStructuresFolder.exists()) {
            dataStructuresFolder.create(true, true, null);
        }
        IResource[] members = dataStructuresFolder.members();
        String[] retVal = new String[members.length];
        int i = 0;
        while (i < members.length) {
            IResource currRes = members[i];
            String msgName = currRes.getName();
            int extIx = msgName.indexOf(DS_EXTENTION);
            if (extIx > 0) {
                msgName = msgName.substring(0, extIx);
            }
            retVal[i] = msgName;
            ++i;
        }
        return retVal;
    }

    private static IFile getzCEESharedProgramMsgFile(String projectName, String tranCode, String msgName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(tranCode);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        IFile tranMetaFile = transFolder.getFile((IPath)new Path(msgName + XML_EXTENTION));
        return tranMetaFile;
    }

    public static List<String> getzCEEProgramInterfaceNames(String projectName) throws CoreException {
        ArrayList<String> retVal = new ArrayList<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IResource[] pgmIntNames = project.members();
        int i = 0;
        while (i < pgmIntNames.length) {
            IResource currResource = pgmIntNames[i];
            if (currResource instanceof IFolder) {
                retVal.add(currResource.getName());
            }
            ++i;
        }
        return retVal;
    }

    public static IFile marshallzCEEProgramMsg(String projectName, Message msgToMarshal) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranMsgOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)msgToMarshal, (OutputStream)tranMsgOutputStream);
        ByteArrayInputStream tranMsgInputStream = new ByteArrayInputStream(tranMsgOutputStream.toByteArray());
        IFile tranMetaFile = ProjectTreeFileHelper.getzCEEProgramMsgFile(projectName, msgToMarshal.getMessageName());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranMsgInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranMsgInputStream, true, true, null);
        }
        return tranMetaFile;
    }

    public static IFile marshallzCEEServiceInterfaceMsg(String projectName, Message msgToMarshal, String fileName) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranMsgOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)msgToMarshal, (OutputStream)tranMsgOutputStream);
        ByteArrayInputStream tranMsgInputStream = new ByteArrayInputStream(tranMsgOutputStream.toByteArray());
        IFile tranMetaFile = ProjectTreeFileHelper.getzCEEProgramMsgFile(projectName, fileName);
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranMsgInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranMsgInputStream, true, true, null);
        }
        tranMetaFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        return tranMetaFile;
    }

    public static IFile marshallzCEEServiceInterfaceMsgUnknownProjectType(String projectName, Message msgToMarshal, String fileName, IFile inputFile) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranMsgOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)msgToMarshal, (OutputStream)tranMsgOutputStream);
        ByteArrayInputStream tranMsgInputStream = new ByteArrayInputStream(tranMsgOutputStream.toByteArray());
        if (!inputFile.exists()) {
            inputFile.create((InputStream)tranMsgInputStream, true, null);
        } else {
            inputFile.setContents((InputStream)tranMsgInputStream, true, true, null);
        }
        inputFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        return inputFile;
    }

    public static void marshallzCEESharedProgramMsg(String projectName, String tranCode, Message msgToMarshal) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranMsgOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)msgToMarshal, (OutputStream)tranMsgOutputStream);
        ByteArrayInputStream tranMsgInputStream = new ByteArrayInputStream(tranMsgOutputStream.toByteArray());
        IFile tranMetaFile = ProjectTreeFileHelper.getzCEESharedProgramMsgFile(projectName, tranCode, msgToMarshal.getMessageName());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranMsgInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranMsgInputStream, true, true, null);
        }
        tranMetaFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
    }

    private static IFile getzCEETranMsgFile(String projectName, String tranCode, String msgName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(tranCode);
        if (!transFolder.exists()) {
            transFolder.create(true, true, null);
        }
        IFile tranMetaFile = transFolder.getFile((IPath)new Path(msgName + XML_EXTENTION));
        return tranMetaFile;
    }

    public static List<String> getzCEEDataStructureNames(String projectName, String pgmInterfaceName, int msgDirection) throws CoreException, JAXBException {
        ArrayList<String> retVal = new ArrayList<String>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder interfaceFolder = project.getFolder(pgmInterfaceName);
        if (!interfaceFolder.exists()) {
            interfaceFolder.create(true, true, null);
        }
        IResource[] dataStructureNames = interfaceFolder.members();
        int i = 0;
        while (i < dataStructureNames.length) {
            Message currMsg;
            IResource currResource = dataStructureNames[i];
            if (currResource instanceof IFile && (currMsg = ProjectTreeFileHelper.unmarshallzCEETranMsg((IFile)currResource)).getDirection().intValue() == msgDirection) {
                String dsName = currResource.getName();
                int ix = dsName.indexOf(XML_EXTENTION);
                if (ix >= 0) {
                    dsName = dsName.substring(0, ix);
                }
                retVal.add(dsName);
            }
            ++i;
        }
        return retVal;
    }

    public static void marshallzCEETranMsg(String projectName, String tranCode, Message msgToMarshal) throws JAXBException, CoreException {
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranMsgOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)msgToMarshal, (OutputStream)tranMsgOutputStream);
        ByteArrayInputStream tranMsgInputStream = new ByteArrayInputStream(tranMsgOutputStream.toByteArray());
        IFile tranMetaFile = ProjectTreeFileHelper.getzCEETranMsgFile(projectName, tranCode, msgToMarshal.getMessageName());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranMsgInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranMsgInputStream, true, true, null);
        }
    }

    public static Message unmarshallzCEEPgmMsg(IFile file) throws JAXBException, CoreException {
        Message tranMsg = null;
        if (file != null && file.exists()) {
            tranMsg = ProjectTreeFileHelper.unmarshallzCEETranMsg(file);
        }
        return tranMsg;
    }

    public static Message unmarshallzCEEPgmMsg(String projectName, String msgName) throws JAXBException, CoreException {
        Message tranMsg = null;
        IFile tranMsgFile = ProjectTreeFileHelper.getzCEEProgramMsgFile(projectName, msgName);
        if (tranMsgFile.exists()) {
            tranMsg = ProjectTreeFileHelper.unmarshallzCEETranMsg(tranMsgFile);
        }
        return tranMsg;
    }

    public static Message unmarshallzCEESharedPgmMsg(String projectNature, String pgmName, String msgName) throws JAXBException, CoreException {
        Message tranMsg = null;
        ArrayList<String> projectNames = ProjectTreeFileHelper.getProjectList(new String[]{projectNature});
        int i = 0;
        while (i < projectNames.size()) {
            if (tranMsg != null) break;
            String currProjectName = (String)projectNames.get(i);
            List<String> allPgmInterfaces = ProjectTreeFileHelper.getzCEEProgramInterfaceNames(currProjectName);
            int j = 0;
            while (j < allPgmInterfaces.size()) {
                String currPgmInterface = allPgmInterfaces.get(j);
                if (currPgmInterface.equals(pgmName)) {
                    IFile tranMsgFile = ProjectTreeFileHelper.getzCEETranMsgFile(currProjectName, pgmName, msgName);
                    if (!tranMsgFile.exists()) break;
                    tranMsg = ProjectTreeFileHelper.unmarshallzCEETranMsg(tranMsgFile);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return tranMsg;
    }

    private static Message unmarshallzCEETranMsg(IFile msgFile) throws JAXBException, CoreException {
        Message retVal = null;
        Unmarshaller unmarshaller = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader()).createUnmarshaller();
        if (msgFile.exists()) {
            InputStream is = msgFile.getContents();
            retVal = (Message)unmarshaller.unmarshal(is);
        }
        return retVal;
    }

    public static GatewayService unmarshallzCEEService(String serviceName) throws JAXBException, CoreException {
        GatewayService service = null;
        Unmarshaller unmarshaller = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.gateway.rest.models", (ClassLoader)com.ibm.zosconnect.wv.gateway.rest.models.ObjectFactory.class.getClassLoader()).createUnmarshaller();
        IFile tranMsgFile = ProjectTreeFileHelper.getzCEEServiceMetadataFile(serviceName);
        if (tranMsgFile.exists()) {
            InputStream is = tranMsgFile.getContents();
            service = (GatewayService)unmarshaller.unmarshal(is);
        }
        return service;
    }

    public static IFile getzCEEServiceMetadataFile(String serviceName) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(serviceName);
        IFolder serviceArtifactsFolder = project.getFolder(ZCEE_SERVICE_ARTIFACTS_FOLDER);
        if (!serviceArtifactsFolder.exists()) {
            serviceArtifactsFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile serviceFile = serviceArtifactsFolder.getFile((IPath)new Path(serviceName + XML_EXTENTION));
        return serviceFile;
    }

    public static List<Message> unmarshallRemainingzCEETranMsgs(String projectName, String tranCode, String msgName) throws CoreException, JAXBException {
        ArrayList<Message> retVal = new ArrayList<Message>();
        Unmarshaller unmarshaller = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader()).createUnmarshaller();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(projectName);
        IFolder transFolder = project.getFolder(tranCode);
        IResource[] msgFiles = transFolder.members();
        int i = 0;
        while (i < msgFiles.length) {
            InputStream is;
            Message msg;
            if (msgFiles[i].exists() && msgFiles[i] instanceof IFile && !(msg = (Message)unmarshaller.unmarshal(is = ((IFile)msgFiles[i]).getContents())).getMessageName().equals(msgName)) {
                retVal.add(msg);
            }
            ++i;
        }
        return retVal;
    }

    public static void marshallzCEESchemas(String serviceName, String requestSchema, String responseSchema) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(serviceName);
        IFolder binFolder = project.getFolder(ZCEE_SERVICE_ARTIFACTS_FOLDER);
        IFolder schemasFolder = binFolder.getFolder(ZCEE_SCHEMAS_FOLDER);
        if (!schemasFolder.exists()) {
            schemasFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile requestFile = schemasFolder.getFile((IPath)new Path(serviceName + ZCEE_SCHEMAS_REQUEST_SUFFIX));
        ByteArrayInputStream requestSchemaInputStream = new ByteArrayInputStream(requestSchema.getBytes());
        if (!requestFile.exists()) {
            requestFile.create((InputStream)requestSchemaInputStream, true, null);
        } else {
            requestFile.setContents((InputStream)requestSchemaInputStream, true, true, null);
        }
        IFile responseFile = schemasFolder.getFile((IPath)new Path(serviceName + ZCEE_SCHEMAS_RESPONSE_SUFFIX));
        ByteArrayInputStream responseSchemaInputStream = new ByteArrayInputStream(responseSchema.getBytes());
        if (!responseFile.exists()) {
            responseFile.create((InputStream)responseSchemaInputStream, true, null);
        } else {
            responseFile.setContents((InputStream)responseSchemaInputStream, true, true, null);
        }
    }

    public static void marshallzCEEService(GatewayService gwService) throws JAXBException, CoreException {
        Marshaller marshaller = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.gateway.rest.models", (ClassLoader)com.ibm.zosconnect.wv.gateway.rest.models.ObjectFactory.class.getClassLoader()).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)gwService, (OutputStream)outputStream);
        ByteArrayInputStream serviceInputStream = new ByteArrayInputStream(outputStream.toByteArray());
        String serviceName = gwService.getServiceName();
        IFile serviceFile = ProjectTreeFileHelper.getzCEEServiceMetadataFile(serviceName);
        if (!serviceFile.exists()) {
            serviceFile.create((InputStream)serviceInputStream, true, null);
        } else {
            serviceFile.setContents((InputStream)serviceInputStream, true, true, null);
        }
    }

    public static void marshallzCEEManifest(String serviceName, byte[] bytes) throws JAXBException, CoreException {
        ByteArrayInputStream yamlInputStream = new ByteArrayInputStream(bytes);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wsRoot.getProject(serviceName);
        IFile yamlFile = project.getFile((IPath)new Path("manifest.yml"));
        if (!yamlFile.exists()) {
            yamlFile.create((InputStream)yamlInputStream, true, null);
        } else {
            yamlFile.setContents((InputStream)yamlInputStream, true, true, null);
        }
    }

    public static String marshallInterfaceToString(InterfaceFieldType interfaceRootField) throws JAXBException {
        if (serviceInterfaceMarshaller == null) {
            if (serviceInterfaceContext == null) {
                serviceInterfaceContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.message.overlay", (ClassLoader)com.ibm.zosconnect.wv.metadata.message.overlay.ObjectFactory.class.getClassLoader());
            }
            serviceInterfaceMarshaller = serviceInterfaceContext.createMarshaller();
            serviceInterfaceMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            serviceInterfaceMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            serviceInterfaceMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        MessageInterfaceType msgInterface = new MessageInterfaceType();
        ServiceInterfaceSegmentType segment = new ServiceInterfaceSegmentType();
        msgInterface.getSegment().add(segment);
        segment.getInterfaceField().add(interfaceRootField);
        ServiceInterface serviceInterface = new ServiceInterface();
        serviceInterface.setInterface(msgInterface);
        ByteArrayOutputStream interfaceOutputStream = new ByteArrayOutputStream();
        serviceInterfaceMarshaller.marshal((Object)serviceInterface, (OutputStream)interfaceOutputStream);
        return interfaceOutputStream.toString();
    }

    public static ServiceInterface unmarshallStringToInterface(String interfaceStr) throws JAXBException {
        if (serviceInterfaceUnmarshaller == null) {
            if (serviceInterfaceContext == null) {
                serviceInterfaceContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.message.overlay", (ClassLoader)com.ibm.zosconnect.wv.metadata.message.overlay.ObjectFactory.class.getClassLoader());
            }
            serviceInterfaceUnmarshaller = serviceInterfaceContext.createUnmarshaller();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(interfaceStr.getBytes());
        ServiceInterface interfaceType = (ServiceInterface)serviceInterfaceUnmarshaller.unmarshal((InputStream)is);
        return interfaceType;
    }

    public static ServiceInterface unmarshallFileToInterface(File interfaceFile) throws JAXBException, FileNotFoundException {
        if (serviceInterfaceUnmarshaller == null) {
            if (serviceInterfaceContext == null) {
                serviceInterfaceContext = JAXBContext.newInstance((String)"com.ibm.im.ims.metadata.message.overlay", (ClassLoader)com.ibm.zosconnect.wv.metadata.message.overlay.ObjectFactory.class.getClassLoader());
            }
            serviceInterfaceUnmarshaller = serviceInterfaceContext.createUnmarshaller();
        }
        FileInputStream is = new FileInputStream(interfaceFile);
        ServiceInterface interfaceType = (ServiceInterface)serviceInterfaceUnmarshaller.unmarshal((InputStream)is);
        return interfaceType;
    }

    public static IFile marshallTranToReadOnlyProject(String serverName, Transaction tran) throws CoreException, JAXBException {
        IFile tranMetaFile = null;
        if (tran != null) {
            tranMetaFile = ProjectTreeFileHelper.getTransactionMetadataFile(tran.getTranCode());
        }
        if (tranMarshaller == null) {
            if (tranContext == null) {
                tranContext = JAXBContext.newInstance((String)"com.ibm.zosconnect.wv.metadata.transaction", (ClassLoader)ObjectFactory.class.getClassLoader());
            }
            tranMarshaller = tranContext.createMarshaller();
            tranMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            tranMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            tranMarshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new ZosConnectJAXBEscapeHandler());
        }
        ByteArrayOutputStream tranOutputStream = new ByteArrayOutputStream();
        tranMarshaller.marshal((Object)tran, (OutputStream)tranOutputStream);
        ByteArrayInputStream tranInputStream = new ByteArrayInputStream(tranOutputStream.toByteArray());
        if (!tranMetaFile.exists()) {
            tranMetaFile.create((InputStream)tranInputStream, true, null);
        } else {
            tranMetaFile.setContents((InputStream)tranInputStream, true, true, null);
        }
        return tranMetaFile;
    }

    public static IFile marshallSegmentPayload(String projectName, byte[] payload, String fileName) throws JAXBException, CoreException {
        IFile payloadFile = ProjectTreeFileHelper.getSegmentBytesFile(projectName, fileName);
        ByteArrayInputStream payloadInputStream = new ByteArrayInputStream(payload);
        if (!payloadFile.exists()) {
            payloadFile.create((InputStream)payloadInputStream, true, null);
        } else {
            payloadFile.setContents((InputStream)payloadInputStream, true, true, null);
        }
        return payloadFile;
    }

    public static void deleteProject(String containerName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(containerName);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.delete(true, (IProgressMonitor)monitor);
        }
    }

    public static byte[] importFileToByteArray(File file) throws IOException {
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            byte[] buffer = new byte[4096];
            baos = new ByteArrayOutputStream();
            fis = new FileInputStream(file);
            int read = 0;
            while ((read = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return baos.toByteArray();
    }

    public static String getCurrentDir() {
        String currentDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        return currentDir;
    }

    public static void createServiceTestProject(String containerName) throws CoreException, JAXBException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        logger.finest("root location: " + root.getRawLocation().toString());
        IProject project = root.getProject(containerName);
        if (!project.exists()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            project.create((IProgressMonitor)monitor);
            project.open((IProgressMonitor)monitor);
            String[] natures = new String[]{SERVICE_TEST_PROJ_NATURE};
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(natures);
            project.setDescription(desc, (IProgressMonitor)monitor);
            IFolder testCaseFolder = ProjectTreeFileHelper.getTestCaseFolder(containerName);
            if (!testCaseFolder.exists()) {
                testCaseFolder.create(false, true, (IProgressMonitor)monitor);
            }
        }
    }

    public static enum ProgramType {
        CICS,
        IMS,
        DB2;

    }
}

