/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.wv.metadata.transaction.BooleanOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DateOverrideType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OverrideTypeUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_DATETIME = "DateTime";
    private static final Map<Class<? extends DatatypeOverride>, String> ovrTypeToUIStr = new HashMap<Class<? extends DatatypeOverride>, String>();
    private static final Map<String, Class<? extends DatatypeOverride>> uiStrToOvrType;

    static {
        ovrTypeToUIStr.put(BooleanOverrideType.class, TYPE_BOOLEAN);
        ovrTypeToUIStr.put(DateOverrideType.class, TYPE_DATE);
        uiStrToOvrType = new HashMap<String, Class<? extends DatatypeOverride>>();
        uiStrToOvrType.put(TYPE_BOOLEAN, BooleanOverrideType.class);
        uiStrToOvrType.put(TYPE_DATE, DateOverrideType.class);
    }

    public static Class<? extends DatatypeOverride> getTypeFromUIString(String ovrTypeUIStr) {
        Class<? extends DatatypeOverride> retVal = null;
        if (StringUtils.isNotBlank((CharSequence)ovrTypeUIStr)) {
            retVal = uiStrToOvrType.get(ovrTypeUIStr);
        }
        return retVal;
    }

    public static String getUIStringFromType(Class<? extends DatatypeOverride> ovrType) {
        String retVal = "";
        if (ovrType != null) {
            retVal = ovrTypeToUIStr.get(ovrType);
        }
        return retVal;
    }

    public static String getUIStringFromType(DatatypeOverride ovrType) {
        String retVal = "";
        if (ovrType instanceof BooleanOverrideType) {
            retVal = ovrTypeToUIStr.get(BooleanOverrideType.class);
        } else if (ovrType instanceof DateOverrideType) {
            retVal = ovrTypeToUIStr.get(DateOverrideType.class);
        }
        return retVal;
    }
}

