/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FindCountedArrayVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.FoundCountedArrayException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.ApplicationDatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class FieldTypeToolTip
extends ToolTip {
    private Color backgroundColor = XSwt.getColor((int)29);
    private Color foregroundColor = XSwt.getColor((int)28);
    private Color datatypeColor = XSwt.getColor((int)36);
    private Color overrideDatatypeColor = XSwt.getColor((int)36);
    private Color errorForegroundColor = XSwt.getColor((int)4);
    private static final String Indent = "    ";
    private static final String Space = " ";
    private TranEditorController tranEditCtrl;

    public FieldTypeToolTip(Control control, TranEditorController tranEditCtrl) {
        super(control);
        this.setShift(new Point(15, 0));
        this.tranEditCtrl = tranEditCtrl;
        this.backgroundColor = control.getBackground();
        this.foregroundColor = control.getForeground();
    }

    protected Composite createToolTipContentArea(Event event, Composite content) {
        Composite composite = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        composite.setBackground(this.backgroundColor);
        FieldModel fieldNode = (FieldModel)this.getData(FieldType.class.getCanonicalName());
        if (fieldNode == null) {
            return null;
        }
        FieldType fieldType = fieldNode.getField();
        if (fieldType == null) {
            return null;
        }
        this.addFieldPathAndDatatypeTip(fieldNode, fieldType, composite);
        this.checkAddArrayMinMaxTip(fieldNode, fieldType, composite);
        this.checkAddArrayDependsOnTip(fieldNode, fieldType, composite);
        this.checkAddDependedOnTip(fieldNode, fieldType, composite);
        this.checkAddRedefinesTip(fieldNode, fieldType, composite);
        this.checkAddRedefinedByTip(fieldNode, fieldType, composite);
        this.checkAddCounterForTip(fieldNode, fieldType, composite);
        this.checkAddArrayCountedByTip(fieldNode, fieldType, composite);
        this.checkAddFieldHasErrorTip(fieldNode, fieldType, composite);
        return composite;
    }

    private void checkAddFieldHasErrorTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        List<IMarker> errorMarkers = this.tranEditCtrl.getErrorMarkers(fieldType);
        if (errorMarkers == null || errorMarkers.isEmpty()) {
            return;
        }
        for (IMarker errorMarker : errorMarkers) {
            String errorMessage = errorMarker.getAttribute("message", "");
            if (errorMessage == null || errorMessage.isEmpty()) continue;
            StyledText styledText = new StyledText(composite, 0);
            StringBuilder text = new StringBuilder();
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            StyleRange styleRange = new StyleRange();
            styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = errorMessage.length();
            styleRange.fontStyle = 0;
            styleRange.background = this.backgroundColor;
            styleRange.foreground = this.errorForegroundColor;
            styleRanges.add(styleRange);
            text.append(errorMessage);
            styledText.setText(text.toString());
            styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
        }
    }

    private void addFieldPathAndDatatypeTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        DatatypeOverride overrideType;
        String overrideTypeName;
        String fieldPath = fieldType.getPath();
        if (fieldPath == null || fieldPath.isEmpty()) {
            fieldPath = fieldType.getName();
        }
        if (fieldPath == null || fieldPath.isEmpty()) {
            fieldPath = "";
        }
        StyledText styledText = new StyledText(composite, 0);
        StringBuilder text = new StringBuilder();
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        String token1 = fieldPath;
        StyleRange styleRange1 = new StyleRange();
        styleRange1 = new StyleRange();
        styleRange1.start = 0;
        styleRange1.length = token1.length();
        styleRange1.fontStyle = 0;
        styleRange1.background = this.backgroundColor;
        styleRange1.foreground = this.foregroundColor;
        styleRanges.add(styleRange1);
        text.append(token1);
        ApplicationDatatypeType datatype = fieldType.getApplicationDatatype();
        if (datatype != null && datatype.getDatatype() != null) {
            String token2 = Space + datatype.getDatatype().toString();
            StyleRange styleRange2 = new StyleRange();
            styleRange2 = new StyleRange();
            styleRange2.start = text.length();
            styleRange2.length = token2.length();
            styleRange2.fontStyle = 0;
            styleRange2.background = this.backgroundColor;
            styleRange2.foreground = this.datatypeColor;
            styleRanges.add(styleRange2);
            text.append(token2);
        }
        if (StringUtils.isNotBlank((CharSequence)(overrideTypeName = OverrideTypeUtil.getUIStringFromType(overrideType = fieldType.getDatatypeOverride())))) {
            String token3 = " (" + overrideTypeName + ")";
            StyleRange styleRange3 = new StyleRange();
            styleRange3 = new StyleRange();
            styleRange3.start = text.length();
            styleRange3.length = token3.length();
            styleRange3.fontStyle = 0;
            styleRange3.background = this.backgroundColor;
            styleRange3.foreground = this.overrideDatatypeColor;
            styleRanges.add(styleRange3);
            text.append(token3);
        }
        styledText.setText(text.toString());
        styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private void checkAddArrayMinMaxTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        String minOccursStr;
        if (fieldType.getApplicationDatatype() != null && !DatatypeType.ARRAY.equals((Object)fieldType.getApplicationDatatype().getDatatype())) {
            return;
        }
        Integer minOccurs = fieldType.getMinOccurs();
        Integer maxOccurs = fieldType.getMaxOccurs();
        String string = minOccursStr = minOccurs == null ? "1" : minOccurs.toString();
        String maxOccursStr = maxOccurs == null ? "1" : (maxOccurs == 0 ? "*" : maxOccurs.toString());
        StringBuilder text = new StringBuilder(Indent);
        if (!minOccursStr.equals(maxOccursStr)) {
            text.append(PgmIntXlat.label((String)"TIP_OCCURS_MINMAX", (String[])new String[]{minOccursStr, maxOccursStr}));
        } else {
            text.append(PgmIntXlat.label((String)"TIP_OCCURS_MAX", (String[])new String[]{maxOccursStr}));
        }
        StyledText styledText = new StyledText(composite, 0);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = text.length();
        styleRange.fontStyle = 0;
        styleRange.background = this.backgroundColor;
        styleRange.foreground = this.foregroundColor;
        styleRanges.add(styleRange);
        styledText.setText(text.toString());
        styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private void checkAddArrayDependsOnTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        if (fieldType.getApplicationDatatype() != null && !DatatypeType.ARRAY.equals((Object)fieldType.getApplicationDatatype().getDatatype())) {
            return;
        }
        String dependsOnPath = fieldType.getDependsOnPath();
        if (dependsOnPath == null || dependsOnPath.isEmpty()) {
            return;
        }
        StringBuilder text = new StringBuilder(Indent);
        text.append(PgmIntXlat.label((String)"TIP_DEPENDS_ON", (String[])new String[]{dependsOnPath}));
        StyledText styledText = new StyledText(composite, 0);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = text.length();
        styleRange.fontStyle = 0;
        styleRange.background = this.backgroundColor;
        styleRange.foreground = this.foregroundColor;
        styleRanges.add(styleRange);
        styledText.setText(text.toString());
        styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private void checkAddArrayCountedByTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        if (fieldType.getApplicationDatatype() != null && !DatatypeType.ARRAY.equals((Object)fieldType.getApplicationDatatype().getDatatype())) {
            return;
        }
        String counterPath = fieldType.getCounterPath();
        if (counterPath == null || counterPath.isEmpty()) {
            return;
        }
        String text = Indent + PgmIntXlat.label((String)"TIP_COUNTED_BY", (String[])new String[]{counterPath});
        StyledText styledText = new StyledText(composite, 0);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = text.length();
        styleRange.fontStyle = 0;
        styleRange.background = this.backgroundColor;
        styleRange.foreground = this.foregroundColor;
        styleRanges.add(styleRange);
        styledText.setText(text.toString());
        styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private void checkAddDependedOnTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        ArrayList<FieldModel> dependingFieldNodes = fieldNode.getOccursDependedUponByFields();
        if (dependingFieldNodes == null || dependingFieldNodes.isEmpty()) {
            return;
        }
        for (FieldModel dependingFieldNode : dependingFieldNodes) {
            String dependingFieldPath = dependingFieldNode.getField().getPath();
            String text = Indent + PgmIntXlat.label((String)"TIP_DEPENDED_ON_BY", (String[])new String[]{dependingFieldPath});
            StyledText styledText = new StyledText(composite, 0);
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = text.length();
            styleRange.fontStyle = 0;
            styleRange.background = this.backgroundColor;
            styleRange.foreground = this.foregroundColor;
            styleRanges.add(styleRange);
            styledText.setText(text.toString());
            styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
        }
    }

    private void checkAddRedefinesTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        String redefinesFieldPath = fieldType.getRedefines();
        if (redefinesFieldPath == null || redefinesFieldPath.isEmpty()) {
            return;
        }
        String text = Indent + PgmIntXlat.label((String)"TIP_REDEFINES", (String[])new String[]{redefinesFieldPath});
        StyledText styledText = new StyledText(composite, 0);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = text.length();
        styleRange.fontStyle = 0;
        styleRange.background = this.backgroundColor;
        styleRange.foreground = this.foregroundColor;
        styleRanges.add(styleRange);
        styledText.setText(text.toString());
        styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private void checkAddRedefinedByTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        ArrayList<FieldModel> redefiningFields = fieldNode.getRedefiningFields();
        if (redefiningFields == null || redefiningFields.isEmpty()) {
            return;
        }
        for (FieldModel redefiningFieldNode : redefiningFields) {
            String redefiningFieldPath = redefiningFieldNode.getField().getPath();
            String text = Indent + PgmIntXlat.label((String)"TIP_REDEFINED_BY", (String[])new String[]{redefiningFieldPath});
            StyledText styledText = new StyledText(composite, 0);
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = text.length();
            styleRange.fontStyle = 0;
            styleRange.background = this.backgroundColor;
            styleRange.foreground = this.foregroundColor;
            styleRanges.add(styleRange);
            styledText.setText(text.toString());
            styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
        }
    }

    private void checkAddCounterForTip(FieldModel fieldNode, FieldType fieldType, Composite composite) {
        if (!fieldNode.isCounterField()) {
            return;
        }
        TranDataStructureModel dataStructureNode = fieldNode.getDataStructureNode();
        if (dataStructureNode == null) {
            return;
        }
        FindCountedArrayVisitor visitor = new FindCountedArrayVisitor(fieldNode.getField());
        MessageWalker walker = new MessageWalker();
        try {
            walker.accept((IMessageVisitor)visitor, dataStructureNode.getField());
        }
        catch (FoundCountedArrayException foundCountedArrayException) {
            FieldType countedField = visitor.getCountedArrayField();
            String text = Indent + PgmIntXlat.label((String)"TIP_COUNTED_FOR", (String[])new String[]{countedField.getPath()});
            StyledText styledText = new StyledText(composite, 0);
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = text.length();
            styleRange.fontStyle = 0;
            styleRange.background = this.backgroundColor;
            styleRange.foreground = this.foregroundColor;
            styleRanges.add(styleRange);
            styledText.setText(text.toString());
            styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
        }
        catch (MessageWalkerException unexpected) {
            ZCeeUILogger.error((Throwable)unexpected);
        }
    }
}

