/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DateComponentType;
import com.ibm.zosconnect.wv.metadata.transaction.DateComponentTypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DateOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.PatternDateType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.transaction.messages.NumericFieldType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DateOverrideTypeValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<String> errorMessages = new ArrayList<String>();
    private List<String> warningMessages = new ArrayList<String>();
    private List<String> infoMessages = new ArrayList<String>();

    public static boolean canOverrideAsDate(FieldType fieldType) {
        MarshallerType marshaller = fieldType.getMarshaller();
        if (marshaller != null && marshaller.getIsNativeInteger() == YesnoType.Y) {
            return false;
        }
        DatatypeType dataType = fieldType.getApplicationDatatype().getDatatype();
        return dataType == DatatypeType.CHAR || JSONConversionUtil.isInteger((FieldType)fieldType);
    }

    public void validate(FieldType field) {
        if (!(field.getDatatypeOverride() instanceof DateOverrideType)) {
            throw new IllegalArgumentException("Expected DateOverrideType");
        }
        DateOverrideType overrideType = (DateOverrideType)field.getDatatypeOverride();
        this.clearMessages();
        if (!DateOverrideTypeValidator.canOverrideAsDate(field)) {
            this.errorMessages.add(PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_AS_TYPE", (String[])new String[]{DateOverrideTypeValidator.getDatatypeName(field), DateOverrideTypeValidator.getFieldPath(field), OverrideTypeUtil.getUIStringFromType((DatatypeOverride)overrideType)}));
            return;
        }
        PatternDateType dateType = (PatternDateType)overrideType.getDate();
        List dateComponentList = dateType.getDateComponent();
        Iterator it = dateComponentList.iterator();
        int length = 0;
        boolean literalError = false;
        while (!literalError && it.hasNext()) {
            DateComponentType currComponentType = (DateComponentType)it.next();
            if (currComponentType.getType() == DateComponentTypeType.Literal && JSONConversionUtil.isInteger((FieldType)field)) {
                try {
                    new BigInteger(currComponentType.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    literalError = true;
                    this.errorMessages.add(PgmIntXlat.error((String)"EF_ERROR_LITERAL_NOT_INT", (String[])new String[]{currComponentType.getValue()}));
                }
            }
            length += currComponentType.getNumChars().intValue();
        }
        DatatypeType dataType = field.getApplicationDatatype().getDatatype();
        if (dataType != null) {
            if (dataType == DatatypeType.CHAR) {
                BigInteger maxChars = JSONConversionUtil.getMaxValueLengthInCodeUnits((FieldType)field);
                if (length > maxChars.intValue()) {
                    this.errorMessages.add(PgmIntXlat.error((String)"DT_EXCEEDS_CHARS", (Object[])new Object[]{maxChars}));
                }
            } else {
                NumericFieldType numericField = new NumericFieldType(field);
                int maxDigits = numericField.getPrecision();
                if (length > numericField.getPrecision()) {
                    if (maxDigits == 1) {
                        this.errorMessages.add(PgmIntXlat.error((String)"DT_EXCEEDS_ONE_DIGIT"));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"DT_EXCEEDS_DIGITS", (Object[])new Object[]{maxDigits}));
                    }
                }
            }
        }
    }

    private void clearMessages() {
        this.errorMessages.clear();
        this.warningMessages.clear();
        this.infoMessages.clear();
    }

    private static String getFieldPath(FieldType field) {
        String fieldPath = "";
        if (field != null && field.getPath() != null) {
            fieldPath = field.getPath();
        }
        return fieldPath;
    }

    private static String getDatatypeName(FieldType field) {
        String datatypeName = "";
        if (field != null && field.getApplicationDatatype() != null) {
            datatypeName = field.getApplicationDatatype().getDatatype().toString();
        }
        return datatypeName;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<String> getInfoMessages() {
        return this.infoMessages;
    }
}

