/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.wv.metadata.testcase.InteractionType;
import com.ibm.zosconnect.wv.mpm.FieldValue;
import java.util.HashMap;
import java.util.List;

public class ClipBoard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ClipBoard clipBoard = null;
    private HashMap<String, String> fieldValues = new HashMap();
    private InteractionType interaction;
    private boolean canPasteFieldValues = false;
    private boolean canPasteInteraction = false;

    public void setFieldValues(List<FieldValue> fieldValueList) {
        this.fieldValues.clear();
        int i = 0;
        while (i < fieldValueList.size()) {
            FieldValue currFieldValue = fieldValueList.get(i);
            this.fieldValues.put(currFieldValue.getFieldName(), currFieldValue.getFieldValue());
            ++i;
        }
        this.canPasteFieldValues = true;
    }

    public void setInteraction(InteractionType interaction) {
        this.interaction = interaction;
        this.canPasteInteraction = true;
    }

    public boolean canPasteFieldValues() {
        return this.canPasteFieldValues;
    }

    public boolean canPasteInteraction() {
        return this.canPasteInteraction;
    }

    public HashMap<String, String> getCopiedFieldValues() {
        return this.fieldValues;
    }

    public InteractionType getInteraction() {
        return this.interaction;
    }

    public static synchronized ClipBoard getSingletonInstance() {
        if (clipBoard == null) {
            clipBoard = new ClipBoard();
        }
        return clipBoard;
    }
}

