/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanRequest;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanResponse;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.OverrideValueType;
import com.ibm.zosconnect.wv.transaction.messages.exceptions.InvalidHexValueException;
import com.ibm.zosconnect.wv.transaction.messages.exceptions.UnbalancedHexValueException;
import com.ibm.zosconnect.wv.transaction.messages.exceptions.ValueScaleTooLargeException;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BooleanOverrideTypeValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<String> errorMessages;
    private List<String> warningMessages;
    private List<String> infoMessages;
    private boolean isRequestSI;

    public BooleanOverrideTypeValidator(boolean isRequestSI) {
        this.isRequestSI = isRequestSI;
        this.errorMessages = new ArrayList<String>();
        this.warningMessages = new ArrayList<String>();
        this.infoMessages = new ArrayList<String>();
    }

    public static boolean canOverrideAsBoolean(FieldType fieldType) {
        boolean canOverrideAsType = false;
        DatatypeType dataType = fieldType.getApplicationDatatype().getDatatype();
        if (dataType == DatatypeType.CHAR || JSONConversionUtil.isInteger((FieldType)fieldType)) {
            canOverrideAsType = true;
        }
        return canOverrideAsType;
    }

    public void validate(FieldType field) {
        if (!(field.getDatatypeOverride() instanceof BooleanOverrideType)) {
            throw new IllegalArgumentException("Expected BooleanOverrideType");
        }
        BooleanOverrideType overrideType = (BooleanOverrideType)field.getDatatypeOverride();
        this.clearMessages();
        if (!BooleanOverrideTypeValidator.canOverrideAsBoolean(field)) {
            this.errorMessages.add(PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_AS_TYPE", (String[])new String[]{BooleanOverrideTypeValidator.getDatatypeName(field), BooleanOverrideTypeValidator.getFieldPath(field), OverrideTypeUtil.getUIStringFromType((DatatypeOverride)overrideType)}));
            return;
        }
        if (this.isRequestSI) {
            this.validateBooleanRequest(field, overrideType.getBooleanRequest());
        } else {
            this.validateBooleanResponse(field, overrideType.getBooleanResponse());
        }
    }

    private void validateBooleanRequest(FieldType field, BooleanRequest request) {
        if (request == null || request.getTrueValueType() == null) {
            this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_TYPE_MISSING", (String[])new String[]{BooleanOverrideTypeValidator.getFieldPath(field)}));
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)request.getTrueValueType())) {
            this.validateSingleValue(field, true, true, request.getTrueValue(), request.getTrueValueIsHex());
        }
        if (request == null || request.getFalseValueType() == null) {
            this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_TYPE_MISSING", (String[])new String[]{BooleanOverrideTypeValidator.getFieldPath(field)}));
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)request.getFalseValueType())) {
            this.validateSingleValue(field, true, false, request.getFalseValue(), request.getFalseValueIsHex());
        }
    }

    private void validateBooleanResponse(FieldType field, BooleanResponse response) {
        OverrideValueType falseValueType;
        OverrideValueType trueValueType = response != null ? response.getTrueValueType() : null;
        OverrideValueType overrideValueType = falseValueType = response != null ? response.getFalseValueType() : null;
        if (trueValueType == null && falseValueType == null) {
            this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_TYPE_MISSING", (String[])new String[]{BooleanOverrideTypeValidator.getFieldPath(field)}));
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)trueValueType)) {
            String trueValue = (String)ListUtilz.getFirstMember((List)response.getTrueValue());
            this.validateSingleValue(field, false, true, trueValue, response.getTrueValueIsHex());
        } else if (OverrideValueType.MULT_VALUES.equals((Object)trueValueType)) {
            this.validateMultipleValues(field, true, response.getTrueValue(), response.getTrueValueIsHex());
        } else if (OverrideValueType.RANGE.equals((Object)trueValueType)) {
            this.validateRangeValues(field, true, response.getTrueValueRangeLow(), response.getTrueValueRangeHigh(), response.getTrueValueIsHex());
        }
        if (falseValueType == null && trueValueType == null) {
            this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TYPE_MISSING", (String[])new String[]{BooleanOverrideTypeValidator.getFieldPath(field)}));
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)falseValueType)) {
            String falseValue = (String)ListUtilz.getFirstMember((List)response.getFalseValue());
            this.validateSingleValue(field, false, true, falseValue, response.getFalseValueIsHex());
        } else if (OverrideValueType.MULT_VALUES.equals((Object)falseValueType)) {
            this.validateMultipleValues(field, true, response.getFalseValue(), response.getFalseValueIsHex());
        } else if (OverrideValueType.RANGE.equals((Object)falseValueType)) {
            this.validateRangeValues(field, false, response.getFalseValueRangeLow(), response.getFalseValueRangeHigh(), response.getFalseValueIsHex());
        }
    }

    private void validateRangeValues(FieldType field, boolean isTrueValue, String lowValue, String highValue, boolean isValueHex) {
        this.validateSingleValue(field, false, isTrueValue, lowValue, isValueHex);
        this.validateSingleValue(field, false, isTrueValue, highValue, isValueHex);
    }

    private void validateMultipleValues(FieldType field, boolean isTrueValue, List<String> values, boolean isValueHex) {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                this.validateSingleValue(field, false, isTrueValue, value, isValueHex);
            }
        }
    }

    private void validateSingleValue(FieldType field, boolean isRequestValue, boolean isTrueValue, String value, boolean isValueHex) {
        if (!isValueHex) {
            this.validateValue(field, isRequestValue, isTrueValue, value);
        } else {
            this.validateHexValue(field, isRequestValue, isTrueValue, value);
        }
    }

    private void validateValue(FieldType field, boolean isRequestValue, boolean isTrueValue, String value) {
        if (!JSONConversionUtil.isInteger((FieldType)field)) {
            if (JSONConversionUtil.isValueTooLong((FieldType)field, (String)value)) {
                if (isRequestValue) {
                    if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_TOO_LONG", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueLengthInCodeUnits((FieldType)field)}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_TOO_LONG", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueLengthInCodeUnits((FieldType)field)}));
                    }
                } else if (isTrueValue) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_TOO_LONG", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueLengthInCodeUnits((FieldType)field)}));
                } else {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TOO_LONG", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueLengthInCodeUnits((FieldType)field)}));
                }
            }
        } else {
            boolean isValueNumeric = false;
            try {
                new BigInteger(value);
                isValueNumeric = true;
            }
            catch (Exception exception) {}
            if (!isValueNumeric) {
                if (isRequestValue) {
                    if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_NOT_NUMERIC", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_NOT_NUMERIC", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                    }
                } else if (isTrueValue) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_NOT_NUMERIC", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                } else {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_NOT_NUMERIC", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                }
            } else {
                boolean isValueTooLarge = false;
                boolean isValueTooSmall = false;
                try {
                    isValueTooLarge = JSONConversionUtil.isValueTooLarge((FieldType)field, (String)value);
                    isValueTooSmall = JSONConversionUtil.isValueTooSmall((FieldType)field, (String)value);
                }
                catch (ValueScaleTooLargeException valueScaleTooLargeException) {
                    isValueTooSmall = true;
                }
                if (isValueTooLarge) {
                    if (isRequestValue) {
                        if (isTrueValue) {
                            this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_TOO_LARGE", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueAsString((FieldType)field)}));
                        } else {
                            this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_TOO_LARGE", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueAsString((FieldType)field)}));
                        }
                    } else if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_TOO_LARGE", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueAsString((FieldType)field)}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TOO_LARGE", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMaxValueAsString((FieldType)field)}));
                    }
                } else if (isValueTooSmall) {
                    if (isRequestValue) {
                        if (isTrueValue) {
                            this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_TOO_SMALL", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMinValueAsString((FieldType)field)}));
                        } else {
                            this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_TOO_SMALL", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMinValueAsString((FieldType)field)}));
                        }
                    } else if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_TOO_SMALL", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMinValueAsString((FieldType)field)}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TOO_SMALL", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field), JSONConversionUtil.getMinValueAsString((FieldType)field)}));
                    }
                }
            }
        }
    }

    private void validateHexValue(FieldType field, boolean isRequestValue, boolean isTrueValue, String value) {
        if (!JSONConversionUtil.isInteger((FieldType)field)) {
            boolean isHexValueTooLong = false;
            boolean isHexValueTooShort = false;
            boolean isHexValueInvalid = false;
            try {
                isHexValueTooLong = JSONConversionUtil.isHexValueTooLong((FieldType)field, (String)value);
                isHexValueTooShort = JSONConversionUtil.isHexValueTooShort((FieldType)field, (String)value);
            }
            catch (InvalidHexValueException | UnbalancedHexValueException throwable) {
                isHexValueInvalid = true;
            }
            if (isHexValueInvalid) {
                if (isRequestValue) {
                    if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_INVALID_HEX", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_INVALID_HEX", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                    }
                } else if (isTrueValue) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_INVALID_HEX", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                } else {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_INVALID_HEX", (String[])new String[]{value, BooleanOverrideTypeValidator.getFieldPath(field)}));
                }
            } else if (isHexValueTooLong) {
                if (isRequestValue) {
                    if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_TOO_LONG_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TOO_LONG_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                    }
                } else if (isTrueValue) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_TOO_LONG_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                } else {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TOO_LONG_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                }
            } else if (isHexValueTooShort) {
                if (isRequestValue) {
                    if (isTrueValue) {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_TRUE_VALUE_TOO_SHORT_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                    } else {
                        this.errorMessages.add(PgmIntXlat.error((String)"REQUEST_FALSE_VALUE_TOO_SHORT_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                    }
                } else if (isTrueValue) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_TRUE_VALUE_TOO_SHORT_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                } else {
                    this.errorMessages.add(PgmIntXlat.error((String)"RESPONSE_FALSE_VALUE_TOO_SHORT_HEX", (Object[])new Object[]{value, BooleanOverrideTypeValidator.getFieldPath(field), field.getBytes()}));
                }
            }
        }
    }

    private void clearMessages() {
        this.errorMessages.clear();
        this.warningMessages.clear();
        this.infoMessages.clear();
    }

    private static String getFieldPath(FieldType field) {
        String fieldPath = "";
        if (field != null && field.getPath() != null) {
            fieldPath = field.getPath();
        }
        return fieldPath;
    }

    private static String getDatatypeName(FieldType field) {
        String datatypeName = "";
        if (field != null && field.getApplicationDatatype() != null) {
            datatypeName = field.getApplicationDatatype().getDatatype().toString();
        }
        return datatypeName;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<String> getInfoMessages() {
        return this.infoMessages;
    }

    public boolean isRequestSI() {
        return this.isRequestSI;
    }

    public void setRequestSI(boolean isRequestSI) {
        this.isRequestSI = isRequestSI;
    }
}

