/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model.utilities;

import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.OverrideValueType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BooleanOverrideTypeUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Map<OverrideValueType, String> ovrTypeToUIStr = new HashMap<OverrideValueType, String>();
    private static final Map<String, OverrideValueType> uiStrToOvrType;
    private static final Map<String, OverrideValueType> strToOvrType;
    private static final List<String> reqUIStrs;
    private static final List<String> respUIStrs;

    static {
        ovrTypeToUIStr.put(OverrideValueType.LOW_VALUES, PgmIntXlat.label((String)"OVT_LOW_VALUES"));
        ovrTypeToUIStr.put(OverrideValueType.HIGH_VALUES, PgmIntXlat.label((String)"OVT_HIGH_VALUES"));
        ovrTypeToUIStr.put(OverrideValueType.MULT_VALUES, PgmIntXlat.label((String)"OVT_MULT_VALUES"));
        ovrTypeToUIStr.put(OverrideValueType.RANGE, PgmIntXlat.label((String)"OVT_RANGE"));
        ovrTypeToUIStr.put(OverrideValueType.SINGLE_VALUE, PgmIntXlat.label((String)"OVT_SINGLE_VALUE"));
        uiStrToOvrType = new HashMap<String, OverrideValueType>();
        uiStrToOvrType.put(PgmIntXlat.label((String)"OVT_LOW_VALUES"), OverrideValueType.LOW_VALUES);
        uiStrToOvrType.put(PgmIntXlat.label((String)"OVT_HIGH_VALUES"), OverrideValueType.HIGH_VALUES);
        uiStrToOvrType.put(PgmIntXlat.label((String)"OVT_MULT_VALUES"), OverrideValueType.MULT_VALUES);
        uiStrToOvrType.put(PgmIntXlat.label((String)"OVT_RANGE"), OverrideValueType.RANGE);
        uiStrToOvrType.put(PgmIntXlat.label((String)"OVT_SINGLE_VALUE"), OverrideValueType.SINGLE_VALUE);
        strToOvrType = new HashMap<String, OverrideValueType>();
        OverrideValueType[] overrideValueTypeArray = OverrideValueType.values();
        int n = overrideValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OverrideValueType overrideType = overrideValueTypeArray[n2];
            strToOvrType.put(overrideType.toString(), overrideType);
            ++n2;
        }
        reqUIStrs = new ArrayList<String>();
        reqUIStrs.add("");
        reqUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.SINGLE_VALUE));
        reqUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.HIGH_VALUES));
        reqUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.LOW_VALUES));
        respUIStrs = new ArrayList<String>();
        respUIStrs.add("");
        respUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.SINGLE_VALUE));
        respUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.MULT_VALUES));
        respUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.RANGE));
        respUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.HIGH_VALUES));
        respUIStrs.add(ovrTypeToUIStr.get(OverrideValueType.LOW_VALUES));
    }

    public static OverrideValueType getTypeFromUIString(String ovrTypeUIStr) {
        OverrideValueType retVal = null;
        if (StringUtils.isNotBlank((CharSequence)ovrTypeUIStr)) {
            retVal = uiStrToOvrType.get(ovrTypeUIStr);
        }
        return retVal;
    }

    public static String getUIStringFromType(OverrideValueType ovrType) {
        String retVal = "";
        if (ovrType != null) {
            retVal = ovrTypeToUIStr.get(ovrType);
        }
        return retVal;
    }

    public static OverrideValueType getTypeFromString(String ovrTypeStr) {
        OverrideValueType retVal = null;
        if (StringUtils.isNotBlank((CharSequence)ovrTypeStr)) {
            retVal = strToOvrType.get(ovrTypeStr);
        }
        return retVal;
    }

    public static List<String> getRequestUIStrings() {
        return reqUIStrs;
    }

    public static List<String> getResponseUIStrings() {
        return respUIStrs;
    }
}

