/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model;

import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;

public class TranTreeParent
extends TranTreeObject {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ArrayList<TranTreeObject> children = new ArrayList();

    public TranTreeParent(String name, TranTreeParent parent) {
        super(name, parent);
    }

    public TranTreeParent(String name, IFolder parent) {
        super(name, parent);
    }

    public void addChild(TranTreeObject child) {
        this.children.add(child);
        child.setTranTreeParent(this);
    }

    public void addChildAfter(TranTreeObject childToAddAfter, TranTreeObject newChild) {
        int indexToAdd = this.children.indexOf(childToAddAfter) + 1;
        this.children.add(indexToAdd, newChild);
    }

    public void addChildBefore(TranTreeObject childToAddBefore, TranTreeObject newChild) {
        int indexToAdd = this.children.indexOf(childToAddBefore);
        this.children.add(indexToAdd, newChild);
    }

    public void removeChild(TranTreeObject child) {
        this.children.remove(child);
        child.setTranTreeParent(null);
    }

    public void removeAllChildren() {
        for (TranTreeObject child : this.children) {
            child.setTranTreeParent(null);
        }
        this.children.clear();
    }

    public void removeChildFromArray(TranTreeObject child) {
        this.children.remove(child);
    }

    public TranTreeObject[] getChildren() {
        return this.children.toArray(new TranTreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }
}

