/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model;

import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.zosconnect.ui.programinterface.controllers.model.IOMessageNode;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TestCaseNode;
import com.ibm.zosconnect.wv.metadata.testcase.FieldValueType;
import com.ibm.zosconnect.wv.metadata.testcase.IoMessagePairType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.Transaction;
import com.ibm.zosconnect.wv.mpm.FieldValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class IOMessagePairNode
extends TestCaseNode {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IoMessagePairType messagePair;
    private IOMessageNode inputMessageNode;
    private IOMessageNode outputMessageNode;
    private Transaction tran;
    private String currentActiveOutputMsg;
    private byte[][] outputBytes;
    public static final int TESTCASE_EDITOR = 3;
    public static final int CANNOT_RUN_YET = 2;
    public static final int NEXT_TO_RUN = 1;
    public static final int ALREADY_RAN = 0;
    private int curr_state;
    private boolean inputMsgExpanded = false;
    private boolean outputMsgExpanded = false;

    public IOMessagePairNode(IoMessagePairType msgPair, String name, TestCaseNode parentNode) {
        super(name, parentNode);
        this.messagePair = msgPair;
        this.curr_state = 3;
    }

    public IoMessagePairType getMessagePair() {
        return this.messagePair;
    }

    public void setState(int newState) {
        this.curr_state = newState;
    }

    public int getState() {
        return this.curr_state;
    }

    public void rePopulateInputMsgFieldValueTypeList() throws UnsupportedTypeConversion, IOException, ConversionException {
        if (this.inputMessageNode != null) {
            List fieldValueTypeList = this.messagePair.getFieldValue();
            fieldValueTypeList.clear();
            List<FieldValue> fieldValueList = this.inputMessageNode.getAllFieldValueList();
            int i = 0;
            while (i < fieldValueList.size()) {
                FieldValue currFieldValue = fieldValueList.get(i);
                FieldValueType newFieldValueType = new FieldValueType();
                newFieldValueType.setFieldName(currFieldValue.getFieldName());
                newFieldValueType.setFieldValue(currFieldValue.getFieldValue());
                fieldValueTypeList.add(newFieldValueType);
                ++i;
            }
        }
    }

    public IOMessageNode getInputMessageNode() {
        return this.inputMessageNode;
    }

    public void setInputMessageNode(IOMessageNode inputMessageNode) {
        this.inputMessageNode = inputMessageNode;
    }

    public IOMessageNode getOutputMessageNode() {
        return this.outputMessageNode;
    }

    public void setOutputMessageNode(IOMessageNode outputMessageNode) {
        this.outputMessageNode = outputMessageNode;
        if (outputMessageNode != null) {
            this.currentActiveOutputMsg = outputMessageNode.getMessageType().getName();
        }
    }

    public boolean isInputMsgExpanded() {
        return this.inputMsgExpanded;
    }

    public boolean isOutputMsgExpanded() {
        return this.outputMsgExpanded;
    }

    public void setInputMsgExpanded(boolean inputMsgExpanded) {
        this.inputMsgExpanded = inputMsgExpanded;
    }

    public void setOutputMsgExpanded(boolean outputMsgExpanded) {
        this.outputMsgExpanded = outputMsgExpanded;
    }

    @Override
    public List<TestCaseNode> getChildren() {
        ArrayList<TestCaseNode> retVal = new ArrayList<TestCaseNode>(2);
        retVal.add(0, this.inputMessageNode);
        retVal.add(1, this.outputMessageNode);
        return retVal;
    }

    public Transaction getTran() {
        return this.tran;
    }

    public BigInteger getTranId() {
        return this.messagePair.getTranId();
    }

    public void setTran(Transaction tran) {
        this.tran = tran;
    }

    public List<String> getOutputMsgNames() {
        List outMsgs = this.tran.getOutputMessage();
        ArrayList<String> retVal = new ArrayList<String>(outMsgs.size());
        int i = 0;
        while (i < outMsgs.size()) {
            retVal.add(((MessageType)outMsgs.get(i)).getName());
            ++i;
        }
        return retVal;
    }

    public String getCurrentActiveOutputMsg() {
        return this.currentActiveOutputMsg;
    }

    public void setCurrentActiveOutputMsg(String currentActiveOutputMsg) {
        this.currentActiveOutputMsg = currentActiveOutputMsg;
    }

    public byte[][] getOutputBytes() {
        return this.outputBytes;
    }

    public void setOutputBytes(byte[][] outputBytes) {
        this.outputBytes = outputBytes;
    }
}

