/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.model;

import com.ibm.zosconnect.ui.programinterface.controllers.model.RedefinesGroup;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeParent;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class FieldModel
extends TranTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FieldType field;
    private RedefinesGroup redefinesGroup;
    private ArrayList<FieldModel> occursDependedUponByFields;
    private ArrayList<FieldModel> redefiningFields;
    private String originalFieldPath;

    public FieldModel(FieldType field, Stack<FieldType> fieldParents, TranTreeParent parentField) {
        super(field.getName(), parentField);
        this.field = field;
        this.originalFieldPath = FieldModel.getOriginalFieldPath(field, fieldParents);
    }

    public FieldType getField() {
        return this.field;
    }

    public List<FieldType> getFieldNested() {
        List<Object> retVal = new ArrayList<FieldType>();
        if (this.field != null) {
            retVal = this.field.getField();
        }
        return retVal;
    }

    public Integer getBytes() {
        Integer retVal = null;
        if (this.field != null) {
            retVal = this.field.getBytes();
        }
        return retVal;
    }

    public static YesnoType getIsDBCSOnly(FieldType field) {
        YesnoType retVal = null;
        if (field != null && field.getMarshaller() != null) {
            retVal = field.getMarshaller().getIsDBCSOnly();
        }
        return retVal;
    }

    public YesnoType getIsDBCSOnly() {
        return FieldModel.getIsDBCSOnly(this.field);
    }

    public static boolean isDBCSOnly(FieldType field) {
        return YesnoType.Y.equals((Object)FieldModel.getIsDBCSOnly(field));
    }

    public boolean isDBCSOnly() {
        return FieldModel.isDBCSOnly(this.field);
    }

    public void setIsDBCSOnly(YesnoType value) {
        if (this.field != null) {
            if (this.field.getMarshaller() == null) {
                this.field.setMarshaller(new MarshallerType());
            }
            this.field.getMarshaller().setIsDBCSOnly(value);
        }
    }

    public static void setIsDBCSOnly(FieldType field, YesnoType value) {
        if (field != null) {
            if (field.getMarshaller() == null) {
                field.setMarshaller(new MarshallerType());
            }
            field.getMarshaller().setIsDBCSOnly(value);
        }
    }

    public String getEncoding() {
        String retVal = null;
        if (this.field != null && this.field.getMarshaller() != null) {
            retVal = this.field.getMarshaller().getEncoding();
        }
        return retVal;
    }

    public static String getEncoding(FieldType field) {
        String retVal = null;
        if (field != null && field.getMarshaller() != null) {
            retVal = field.getMarshaller().getEncoding();
        }
        return retVal;
    }

    public void setEncoding(String value) {
        if (this.field != null) {
            if (this.field.getMarshaller() == null) {
                this.field.setMarshaller(new MarshallerType());
            }
            this.field.getMarshaller().setEncoding(value);
        }
    }

    public static void setEncoding(FieldType field, String value) {
        if (field != null) {
            if (field.getMarshaller() == null) {
                field.setMarshaller(new MarshallerType());
            }
            field.getMarshaller().setEncoding(value);
        }
    }

    public Integer getMaxBytes() {
        Integer retVal = null;
        if (this.field != null) {
            retVal = this.field.getMaxBytes();
        }
        return retVal;
    }

    public String getOriginalName() {
        String retVal = null;
        if (this.field != null) {
            retVal = this.field.getOriginalName() != null ? this.field.getOriginalName() : this.field.getName();
        }
        return retVal;
    }

    public static String getOriginalName(FieldType field) {
        String retVal = null;
        if (field != null) {
            retVal = field.getOriginalName() != null ? field.getOriginalName() : field.getName();
        }
        return retVal;
    }

    public static String getOriginalFieldPath(FieldType field, Stack<FieldType> fieldParents) {
        FieldPath originalFieldPath = new FieldPath();
        int i = 0;
        while (i < fieldParents.size()) {
            originalFieldPath.push(FieldModel.getOriginalName((FieldType)fieldParents.get(i)));
            ++i;
        }
        originalFieldPath.push(FieldModel.getOriginalName(field));
        return originalFieldPath.getValue();
    }

    public String getPath() {
        String retVal = null;
        if (this.field != null) {
            retVal = this.field.getPath();
        }
        return retVal;
    }

    public Integer getStartPos() {
        Integer retVal = null;
        if (this.field != null) {
            retVal = this.field.getStartPos();
        }
        return retVal;
    }

    public static YesnoType getIsWCHAROnly(FieldType field) {
        YesnoType retVal = null;
        if (field != null && field.getMarshaller() != null) {
            retVal = field.getMarshaller().getIsWCHAROnly();
        }
        return retVal;
    }

    public YesnoType getIsWCHAROnly() {
        return FieldModel.getIsWCHAROnly(this.field);
    }

    public static boolean isWCHAROnly(FieldType field) {
        return YesnoType.Y.equals((Object)FieldModel.getIsWCHAROnly(field));
    }

    public boolean isWCHAROnly() {
        return YesnoType.Y.equals((Object)this.getIsWCHAROnly());
    }

    public void setIsWCHAROnly(YesnoType value) {
        if (this.field != null) {
            if (this.field.getMarshaller() == null) {
                this.field.setMarshaller(new MarshallerType());
            }
            this.field.getMarshaller().setIsWCHAROnly(value);
        }
    }

    public static void setIsWCHAROnly(FieldType field, YesnoType value) {
        if (field != null) {
            if (field.getMarshaller() == null) {
                field.setMarshaller(new MarshallerType());
            }
            field.getMarshaller().setIsWCHAROnly(value);
        }
    }

    public boolean isDependedOnField() {
        return this.field != null && this.field.isDependedOn() != null && this.field.isDependedOn() != false;
    }

    public boolean isCounterField() {
        return this.field != null && this.field.isCounter() != null && this.field.isCounter() != false;
    }

    public boolean isArrayField() {
        return this.field != null && this.field.getApplicationDatatype() != null && DatatypeType.ARRAY.equals((Object)this.field.getApplicationDatatype().getDatatype());
    }

    public boolean isSetDependsOn() {
        return this.field != null && this.field.getDependsOn() != null && !this.field.getDependsOn().isEmpty();
    }

    public boolean isSetCounterPath() {
        return this.field != null && this.field.getCounterPath() != null && !this.field.getCounterPath().isEmpty();
    }

    public boolean isUserDefined() {
        return this.field != null && this.field.isUserDefined() != null && this.field.isUserDefined() != false;
    }

    public static boolean isUserDefined(FieldType field) {
        return field != null && field.isUserDefined() != null && field.isUserDefined() != false;
    }

    public static boolean isRedefiningField(FieldType field) {
        return field != null && StringUtils.isNotBlank((CharSequence)field.getRedefines());
    }

    public static boolean isCHARField(FieldType field) {
        return field != null && field.getApplicationDatatype() != null && DatatypeType.CHAR.equals((Object)field.getApplicationDatatype().getDatatype());
    }

    public String getOriginalRedefinesPath() {
        return FieldModel.getOriginalRedefinesPath(this.field, this.getOriginalFieldPath());
    }

    public static String getOriginalRedefinesPath(FieldType redefiningField, String redefiningFieldPath) {
        Object retVal = null;
        if (StringUtils.isNotBlank((CharSequence)redefiningField.getRedefines())) {
            Object redefinedFieldPath = StringUtils.substringBeforeLast((String)redefiningFieldPath, (String)".");
            retVal = redefinedFieldPath = (String)redefinedFieldPath + "." + redefiningField.getRedefines();
        }
        return retVal;
    }

    public void setRedefinesGroup(RedefinesGroup redefinesGroup) {
        this.redefinesGroup = redefinesGroup;
    }

    public RedefinesGroup getRedefinesGroup() {
        return this.redefinesGroup;
    }

    public ArrayList<FieldModel> getOccursDependedUponByFields() {
        return this.occursDependedUponByFields;
    }

    public void setOccursDependedUponByFields(ArrayList<FieldModel> occursDependedUponByFields) {
        this.occursDependedUponByFields = occursDependedUponByFields;
    }

    public ArrayList<FieldModel> getRedefiningFields() {
        return this.redefiningFields;
    }

    public void setRedefiningFields(ArrayList<FieldModel> redefiningFields) {
        this.redefiningFields = redefiningFields;
    }

    public String getOriginalFieldPath() {
        return this.originalFieldPath;
    }

    public void setOriginalFieldPath(String originalFieldPath) {
        this.originalFieldPath = originalFieldPath;
    }

    public TranDataStructureModel getDataStructureNode() {
        TranDataStructureModel dataStructureNode = null;
        TranTreeParent parentObject = this;
        while (parentObject != null && !(parentObject instanceof TranDataStructureModel)) {
            if (!(parentObject.getParent() instanceof TranTreeParent)) continue;
            parentObject = (TranTreeParent)parentObject.getParent();
        }
        if (parentObject instanceof TranDataStructureModel) {
            dataStructureNode = (TranDataStructureModel)parentObject;
        }
        return dataStructureNode;
    }

    public TranSegmentModel getSegmentNode() {
        TranSegmentModel segmentNode = null;
        TranTreeParent parentObject = this;
        while (parentObject != null && !(parentObject instanceof TranSegmentModel)) {
            if (!(parentObject.getParent() instanceof TranTreeParent)) continue;
            parentObject = (TranTreeParent)parentObject.getParent();
        }
        if (parentObject instanceof TranSegmentModel) {
            segmentNode = (TranSegmentModel)parentObject;
        }
        return segmentNode;
    }

    public FieldType getParentField() {
        FieldType parentField = null;
        Object parent = this.getParent();
        if (parent instanceof TranDataStructureModel) {
            parentField = ((TranDataStructureModel)parent).getField();
        } else if (parent instanceof FieldModel) {
            parentField = ((FieldModel)parent).getField();
        }
        return parentField;
    }
}

