/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.exceptions;

import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.UnsupportedTypeException;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Status;

public class UnsupportedPliTypeException
extends UnsupportedTypeException {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PLIClassifier type;
    private FieldType field;

    public UnsupportedPliTypeException() {
    }

    public UnsupportedPliTypeException(FieldType field, PLIClassifier type) {
        this.field = field;
        this.type = type;
    }

    public PLIClassifier getType() {
        return this.type;
    }

    public void setType(PLIClassifier type) {
        this.type = type;
    }

    public FieldType getField() {
        return this.field;
    }

    public void setField(FieldType field) {
        this.field = field;
    }

    @Override
    public Status getStatus() {
        String structName = "";
        String fieldName = "";
        if (this.field != null) {
            structName = StringUtils.substringBefore((String)this.field.getPath(), (String)".");
            fieldName = StringUtils.substringAfterLast((String)this.field.getPath(), (String)".");
        }
        String typeName = "";
        if (this.type != null) {
            typeName = StringUtils.trimToEmpty((String)this.type.getName());
        }
        String statusMsg = PgmIntXlat.getError().getString("IDSD_OMIT_DS_UNSUP_TYPE", (Object[])new String[]{structName, fieldName, typeName});
        return new Status(2, "com.ibm.zosconnect.ui.programinterface.controllers", statusMsg);
    }
}

