/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.RedefinesGroup;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeParent;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class TranEditorSegmentVisitor
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TranSegmentModel segmentModel;
    private Map<FieldType, TranTreeParent> fieldToTreeNode;
    private Map<String, TranTreeParent> fieldPathToFieldModel;
    private boolean isImport;
    private TranEditorController tranEditorController;
    private Map<String, FieldModel> occursDependedOnFields = new HashMap<String, FieldModel>();

    public TranEditorSegmentVisitor(TranSegmentModel segmentModel, boolean isImport, TranEditorController tranEditorController) {
        this.segmentModel = segmentModel;
        this.fieldToTreeNode = new HashMap<FieldType, TranTreeParent>();
        this.fieldPathToFieldModel = new HashMap<String, TranTreeParent>();
        this.isImport = isImport;
        this.tranEditorController = tranEditorController;
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    private void processRedefineExclude(FieldType field, FieldType parentField) {
        String redefines = field.getRedefines();
        if (redefines != null && !redefines.isEmpty()) {
            field.setIncluded(YesnoType.N);
        }
        if (parentField != null && parentField.getIncluded() == YesnoType.N) {
            field.setIncluded(YesnoType.N);
        }
    }

    private void processLeafArrayRedefineExclude(FieldType subField, FieldType field, FieldType parentField) {
        String redefines = field.getRedefines();
        if (redefines != null && !redefines.isEmpty()) {
            field.setIncluded(YesnoType.N);
            subField.setIncluded(YesnoType.N);
            return;
        }
        if (parentField != null && parentField.getIncluded() == YesnoType.N) {
            field.setIncluded(YesnoType.N);
            subField.setIncluded(YesnoType.N);
        }
    }

    private void processRedefines(FieldModel fieldModel, TranTreeObject[] peerFieldModelsSoFar) {
        String redefinedFieldName = fieldModel.getField().getRedefines();
        if (redefinedFieldName != null && !redefinedFieldName.isEmpty()) {
            FieldType redefinedField = null;
            TranTreeObject[] tranTreeObjectArray = peerFieldModelsSoFar;
            int n = peerFieldModelsSoFar.length;
            int n2 = 0;
            while (n2 < n) {
                TranTreeObject tranTreeObject = tranTreeObjectArray[n2];
                FieldModel currFieldModel = (FieldModel)tranTreeObject;
                if (currFieldModel.getOriginalName().equalsIgnoreCase(redefinedFieldName)) {
                    redefinedField = currFieldModel.getField();
                    RedefinesGroup redefinesGroup = currFieldModel.getRedefinesGroup();
                    if (redefinesGroup == null) {
                        redefinesGroup = new RedefinesGroup(currFieldModel);
                        redefinesGroup.addFieldToGroup(currFieldModel);
                        redefinesGroup.addFieldToGroup(fieldModel);
                    } else {
                        redefinesGroup.addFieldToGroup(fieldModel);
                    }
                    ArrayList<FieldModel> redefiningFields = currFieldModel.getRedefiningFields();
                    if (redefiningFields == null) {
                        redefiningFields = new ArrayList();
                        currFieldModel.setRedefiningFields(redefiningFields);
                    }
                    redefiningFields.add(fieldModel);
                }
                ++n2;
            }
            if (redefinedField != null) {
                this.tranEditorController.addToRedefinesMap(this.segmentModel.getName(), redefinedField, fieldModel.getField());
            }
        }
    }

    private void processODO(FieldModel newFieldModel) {
        FieldType fieldType = newFieldModel.getField();
        FieldModel dependedOnFieldModel = this.occursDependedOnFields.get(fieldType.getDependsOnPath());
        if (dependedOnFieldModel != null) {
            ArrayList<FieldModel> dependingFields = dependedOnFieldModel.getOccursDependedUponByFields();
            if (dependingFields == null) {
                dependingFields = new ArrayList();
                dependedOnFieldModel.setOccursDependedUponByFields(dependingFields);
            }
            dependingFields.add(newFieldModel);
        }
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (this.isImport) {
            this.processRedefineExclude(field, fieldParents.peek());
        }
        try {
            FieldType parentFieldType = fieldParents.peek();
            TranTreeParent parentFieldModel = this.fieldToTreeNode.get(parentFieldType);
            FieldModel newFieldModel = new FieldModel(field, fieldParents, parentFieldModel);
            parentFieldModel.addChild(newFieldModel);
            if (field.isDependedOn() != null && field.isDependedOn().booleanValue()) {
                this.occursDependedOnFields.put(field.getPath(), newFieldModel);
                field.setIncluded(YesnoType.N);
            }
            if (field.getDependsOnPath() != null && !field.getDependsOnPath().isEmpty()) {
                this.processODO(newFieldModel);
            }
            this.processRedefines(newFieldModel, parentFieldModel.getChildren());
            this.fieldToTreeNode.put(field, newFieldModel);
            this.fieldPathToFieldModel.put(field.getPath(), newFieldModel);
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType currFieldType = fieldParents.pop();
        FieldType parentFieldType = fieldParents.peek();
        fieldParents.push(currFieldType);
        TranTreeParent parentFieldModel = this.fieldToTreeNode.get(parentFieldType);
        if (this.isImport) {
            field.setIncluded(YesnoType.Y);
            this.processLeafArrayRedefineExclude(field, currFieldType, parentFieldType);
        }
        FieldModel newFieldModel = new FieldModel(currFieldType, fieldParents, parentFieldModel);
        parentFieldModel.addChild(newFieldModel);
        if (currFieldType.getDependsOnPath() != null && !currFieldType.getDependsOnPath().isEmpty()) {
            this.processODO(newFieldModel);
        }
        this.processRedefines(newFieldModel, parentFieldModel.getChildren());
        this.fieldToTreeNode.put(currFieldType, newFieldModel);
        this.fieldPathToFieldModel.put(currFieldType.getPath(), newFieldModel);
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (this.isImport) {
            if (fieldParents.isEmpty()) {
                this.processRedefineExclude(field, null);
            } else {
                this.processRedefineExclude(field, fieldParents.peek());
            }
        }
        if (fieldParents.isEmpty()) {
            TranDataStructureModel newDSModel = new TranDataStructureModel(field, (TranTreeParent)this.segmentModel);
            this.fieldToTreeNode.put(field, newDSModel);
            this.fieldPathToFieldModel.put(field.getPath(), newDSModel);
            this.segmentModel.addChild(newDSModel);
        } else {
            FieldType parentFieldType = fieldParents.peek();
            TranTreeParent parentFieldModel = this.fieldToTreeNode.get(parentFieldType);
            FieldModel newFieldModel = new FieldModel(field, fieldParents, parentFieldModel);
            parentFieldModel.addChild(newFieldModel);
            if (field.getDependsOnPath() != null && !field.getDependsOnPath().isEmpty()) {
                this.processODO(newFieldModel);
            }
            this.processRedefines(newFieldModel, parentFieldModel.getChildren());
            this.fieldToTreeNode.put(field, newFieldModel);
            this.fieldPathToFieldModel.put(field.getPath(), newFieldModel);
        }
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (this.isImport) {
            this.processRedefineExclude(field, fieldParents.peek());
        }
        FieldType parentFieldType = fieldParents.peek();
        TranTreeParent parentFieldModel = this.fieldToTreeNode.get(parentFieldType);
        FieldModel newFieldModel = new FieldModel(field, fieldParents, parentFieldModel);
        parentFieldModel.addChild(newFieldModel);
        if (field.getDependsOnPath() != null && !field.getDependsOnPath().isEmpty()) {
            this.processODO(newFieldModel);
        }
        this.processRedefines(newFieldModel, parentFieldModel.getChildren());
        this.fieldToTreeNode.put(field, newFieldModel);
        this.fieldPathToFieldModel.put(field.getPath(), newFieldModel);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public boolean isExpandArrays() {
        return false;
    }

    public Map<String, TranTreeParent> getFieldPathToFieldModel() {
        return this.fieldPathToFieldModel;
    }
}

