/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerAttributes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.DataStructureSegmentAssociation;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldInfoPreservationVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FindArrayCounterVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.RedefineAsCharController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorSegmentVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorUpdateFieldPathsVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.FoundArrayCounterException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranMessageModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeParent;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.ApplicationDatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.CicsContainerType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.Transaction;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class TranEditorController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String tranName;
    private Message msg;
    private FieldType copiedfield = null;
    private String originalCopiedName;
    private TranTreeParent invisibleRootRequest;
    private TranTreeParent invisibleRootResponse;
    private List<Message> inputMessages;
    private List<Message> outputMessages;
    private Map<String, Message> createdMessages;
    private Map<String, Message> deletedMessages;
    private Map<String, Message> updatedMessages;
    private Map<String, Map<FieldType, ArrayList<FieldType>>> redefinesMap = new HashMap<String, Map<FieldType, ArrayList<FieldType>>>();
    private Map<String, Map<String, TranTreeParent>> segmentNameToFieldPathToFieldModel = new HashMap<String, Map<String, TranTreeParent>>();
    private Map<String, TranTreeParent> fieldPathToFieldModel = new HashMap<String, TranTreeParent>();
    private List<IMarker> siErrorMarkers = new ArrayList<IMarker>();
    private ServiceArchiveConstants.SP_Type spType;
    private ServiceArchiveConstants.SP_Type project_spType;
    private IFile inputFile;

    public TranEditorController(Message msg, String tranName, String projectName, IFile inputFile, ServiceArchiveConstants.SP_Type project_spType, ServiceArchiveConstants.SP_Type spType) throws MessageWalkerException, CoreException, JAXBException {
        this.tranName = tranName;
        this.msg = msg;
        this.inputFile = inputFile;
        this.project_spType = project_spType;
        this.spType = spType;
        this.inputMessages = new ArrayList<Message>();
        this.outputMessages = new ArrayList<Message>();
        if (msg.getDirection().intValue() == 0) {
            this.inputMessages.add(msg);
        } else {
            this.outputMessages.add(msg);
        }
        this.createdMessages = new HashMap<String, Message>();
        this.deletedMessages = new HashMap<String, Message>();
        this.updatedMessages = new HashMap<String, Message>();
        this.refreshMarkers();
        this.populateTranTree();
    }

    public Message getTran() {
        return this.msg;
    }

    public String geMismatchedInputFileWarning() {
        if (this.project_spType == null) {
            return null;
        }
        if (this.spType != this.project_spType) {
            Object[] inserts = new Object[]{"", ""};
            if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                inserts[0] = "CICS CHANNEL";
            } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA) {
                inserts[0] = "CICS COMMAREA";
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                inserts[0] = "IMS";
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS) {
                inserts[0] = "IMS LDS";
            } else if (this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                inserts[0] = "MQ Message";
            }
            if (this.project_spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                inserts[1] = "CICS CHANNEL";
            } else if (this.project_spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA) {
                inserts[1] = "CICS COMMAREA";
            } else if (this.project_spType == ServiceArchiveConstants.SP_Type.IMS) {
                inserts[1] = "IMS";
            } else if (this.project_spType == ServiceArchiveConstants.SP_Type.IMS_LDS) {
                inserts[1] = "IMS LDS";
            } else if (this.project_spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                inserts[1] = "MQ Message";
            }
            return PgmIntXlat.getError().getString("SIE_MISMATCHED_SI_PROJECT", inserts);
        }
        return null;
    }

    private ArrayList<String> checkMultipleRedfinesInclude(FieldType redefinedField, ArrayList<FieldType> redefiningFieldList) {
        int timesIncluded = 0;
        ArrayList<String> includedRedefiningFieldNames = new ArrayList<String>();
        if (redefinedField.getIncluded() == YesnoType.Y) {
            ++timesIncluded;
        }
        for (FieldType currRedefiningField : redefiningFieldList) {
            if (currRedefiningField.getIncluded() != YesnoType.Y) continue;
            ++timesIncluded;
            includedRedefiningFieldNames.add(currRedefiningField.getName());
        }
        if (timesIncluded > 1) {
            return includedRedefiningFieldNames;
        }
        return null;
    }

    public ArrayList<String> validateRedefinesInclude() {
        ArrayList<String> warningMsgs = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>(this.redefinesMap.keySet());
        for (String currSegmentName : keys) {
            Map<FieldType, ArrayList<FieldType>> segmentRedefinesMap = this.redefinesMap.get(currSegmentName);
            ArrayList<FieldType> redefinedFieldsList = new ArrayList<FieldType>(segmentRedefinesMap.keySet());
            for (FieldType currRedefinedField : redefinedFieldsList) {
                Object fieldNames;
                ArrayList<FieldType> redefiningFieldList;
                ArrayList<String> includedRedefiningFieldNames = this.checkMultipleRedfinesInclude(currRedefinedField, redefiningFieldList = segmentRedefinesMap.get(currRedefinedField));
                if (includedRedefiningFieldNames == null) continue;
                if (currRedefinedField.getIncluded() == YesnoType.Y) {
                    fieldNames = currRedefinedField.getName();
                    i = 0;
                    while (i < includedRedefiningFieldNames.size()) {
                        fieldNames = (String)fieldNames + ", " + includedRedefiningFieldNames.get(i);
                        ++i;
                    }
                } else {
                    fieldNames = includedRedefiningFieldNames.get(0);
                    i = 1;
                    while (i < includedRedefiningFieldNames.size()) {
                        fieldNames = (String)fieldNames + ", " + includedRedefiningFieldNames.get(i);
                        ++i;
                    }
                }
                Object[] inserts = new String[]{fieldNames, currSegmentName};
                String msg = PgmIntXlat.getError().getString("RDS_MULTIPLE_REDEFINE_WARNING", inserts);
                warningMsgs.add(msg);
            }
        }
        return warningMsgs;
    }

    public Map<String, Boolean> saveRedefineGroupSelection(FieldModel fieldNode) {
        HashMap<String, Boolean> saveMap = new HashMap<String, Boolean>();
        ArrayList<FieldModel> redefineFieldList = fieldNode.getRedefinesGroup().getRedefinesGroupFields();
        for (FieldModel currFieldModel : redefineFieldList) {
            if (currFieldModel.getField().getIncluded() == YesnoType.Y) {
                saveMap.put(currFieldModel.getName(), new Boolean(true));
                continue;
            }
            saveMap.put(currFieldModel.getName(), new Boolean(false));
        }
        return saveMap;
    }

    public void resetRedefineGroupSelection(Map<String, Boolean> saveMap, FieldModel fieldNode) {
        ArrayList<FieldModel> redefineFieldList = fieldNode.getRedefinesGroup().getRedefinesGroupFields();
        for (FieldModel currFieldModel : redefineFieldList) {
            boolean isIncluded = saveMap.get(currFieldModel.getName());
            if (isIncluded) {
                this.setInclude(currFieldModel, true);
                continue;
            }
            this.setInclude(currFieldModel, false);
        }
    }

    public String validateRedefinesInclude(ArrayList<FieldModel> redefineFieldList) {
        String warningString = null;
        ArrayList<String> fieldsSelected = new ArrayList<String>();
        for (FieldModel currFieldModel : redefineFieldList) {
            if (currFieldModel.getField().getIncluded() != YesnoType.Y) continue;
            fieldsSelected.add(currFieldModel.getName());
        }
        if (fieldsSelected.size() > 1) {
            Object fieldsListString = (String)fieldsSelected.get(0);
            int i = 1;
            while (i < fieldsSelected.size()) {
                fieldsListString = (String)fieldsListString + ", " + (String)fieldsSelected.get(i);
                ++i;
            }
            TranTreeParent parent = (TranTreeParent)redefineFieldList.get(0).getParent();
            TranTreeParent grandparent = (TranTreeParent)parent.getParent();
            Object[] inserts = new String[]{fieldsListString, grandparent.getName()};
            warningString = PgmIntXlat.getError().getString("RDD_MULTIPLE_REDEFINE_WARNING", inserts);
        }
        return warningString;
    }

    protected void addToRedefinesMap(String segmentName, FieldType redefinedField, FieldType redefiningField) {
        ArrayList<Object> redefiningFields;
        Map<FieldType, ArrayList<FieldType>> segmentRedefinesMap = this.redefinesMap.get(segmentName);
        if (segmentRedefinesMap == null) {
            segmentRedefinesMap = new HashMap<FieldType, ArrayList<FieldType>>();
        }
        if ((redefiningFields = segmentRedefinesMap.get(redefinedField)) == null) {
            redefiningFields = new ArrayList();
        }
        redefiningFields.add(redefiningField);
        segmentRedefinesMap.put(redefinedField, redefiningFields);
        this.redefinesMap.put(segmentName, segmentRedefinesMap);
    }

    private void clearSegmentRedefinesMap(String segmentName) {
        Map<FieldType, ArrayList<FieldType>> segmentRedefinesMap = this.redefinesMap.get(segmentName);
        if (segmentRedefinesMap != null) {
            segmentRedefinesMap.clear();
            this.redefinesMap.remove(segmentName);
        }
    }

    private void clearFieldPathToFieldModelMapEntries(String segmentName) {
        Map<String, TranTreeParent> segmentFieldPathToFieldModelMap = this.segmentNameToFieldPathToFieldModel.get(segmentName);
        if (segmentFieldPathToFieldModelMap != null) {
            this.fieldPathToFieldModel.keySet().removeAll(segmentFieldPathToFieldModelMap.keySet());
        }
    }

    public void populateDataStructureAndFieldNodes(TranSegmentModel parent, boolean isImport) throws MessageWalkerException {
        String segmentName = parent.getName();
        parent.removeAllChildren();
        this.clearSegmentRedefinesMap(segmentName);
        this.clearFieldPathToFieldModelMapEntries(segmentName);
        TranEditorSegmentVisitor visitor = new TranEditorSegmentVisitor(parent, isImport, this);
        new MessageWalker().accept((IMessageVisitor)visitor, parent.getSegment());
        Map<String, TranTreeParent> newFieldPathToFieldModel = visitor.getFieldPathToFieldModel();
        this.segmentNameToFieldPathToFieldModel.put(segmentName, newFieldPathToFieldModel);
        this.fieldPathToFieldModel.putAll(newFieldPathToFieldModel);
    }

    public void populateSegmentNodes(List<SegmentType> segments, TranTreeParent parent) throws MessageWalkerException {
        parent.removeAllChildren();
        this.redefinesMap.clear();
        this.segmentNameToFieldPathToFieldModel.clear();
        this.fieldPathToFieldModel.clear();
        int i = 0;
        while (i < segments.size()) {
            SegmentType currSeg = segments.get(i);
            String segName = currSeg.getOriginalName();
            TranSegmentModel currSegNode = new TranSegmentModel(segName, currSeg, parent, this.spType);
            parent.addChild(currSegNode);
            currSegNode.setTranTreeParent(parent);
            this.populateDataStructureAndFieldNodes(currSegNode, false);
            ++i;
        }
    }

    public void populateTranTree() throws MessageWalkerException {
        this.invisibleRootRequest = new TranTreeParent("", null);
        this.invisibleRootResponse = new TranTreeParent("", null);
        this.populateMessages(this.invisibleRootRequest, this.inputMessages);
    }

    private void populateMessages(TranTreeParent parent, List<Message> messages) throws MessageWalkerException {
        int i = 0;
        while (i < messages.size()) {
            Message currMsg = messages.get(i);
            TranMessageModel currMsgNode = new TranMessageModel(currMsg, parent, this.spType);
            parent.addChild(currMsgNode);
            this.populateSegmentNodes(currMsg.getMessage().getSegment(), currMsgNode);
            ++i;
        }
    }

    public long getNextAvailableMessageId() {
        long currId;
        long retVal = 0L;
        for (Message currMessage : this.inputMessages) {
            currId = currMessage.getMessage().getId().longValue();
            if (currId <= retVal) continue;
            retVal = currId;
        }
        for (Message currMessage : this.outputMessages) {
            currId = currMessage.getMessage().getId().longValue();
            if (currId <= retVal) continue;
            retVal = currId;
        }
        return retVal + 1L;
    }

    public boolean isInRedefinesGroup(FieldModel fieldNode) {
        return fieldNode.getRedefinesGroup() != null;
    }

    public static boolean isInputField(FieldModel fieldNode) {
        boolean retVal = false;
        TranSegmentModel segmentNode = TranEditorController.getSegmentNode(fieldNode);
        TranMessageModel msgNode = (TranMessageModel)segmentNode.getParent();
        if (msgNode.getMessageType() == 0) {
            retVal = true;
        }
        return retVal;
    }

    private static TranSegmentModel getSegmentNode(TranTreeObject node) {
        Object parent = node.getParent();
        if (parent instanceof TranSegmentModel) {
            return (TranSegmentModel)parent;
        }
        return TranEditorController.getSegmentNode((TranTreeObject)parent);
    }

    public static boolean isLeafField(FieldModel fieldNode) {
        boolean retVal = true;
        DatatypeType dataType = fieldNode.getField().getApplicationDatatype().getDatatype();
        if (dataType == DatatypeType.ARRAY || dataType == DatatypeType.STRUCT) {
            retVal = false;
        }
        return retVal;
    }

    public void setDefaultValue(FieldModel fieldNode, String defaultValue) {
        fieldNode.getField().setDefaultValue(defaultValue);
    }

    public void setIsHex(FieldModel fieldNode, boolean val) {
        fieldNode.getField().setIsHex(Boolean.valueOf(val));
    }

    private void setParentChainInclude(FieldModel fieldNode) {
        Object parent = fieldNode.getParent();
        while (parent instanceof FieldModel) {
            FieldModel currField = (FieldModel)parent;
            currField.getField().setIncluded(YesnoType.Y);
            parent = currField.getParent();
        }
    }

    private void setChildrenChainInclude(FieldModel fieldNode) {
        TranTreeObject[] children;
        TranTreeObject[] tranTreeObjectArray = children = fieldNode.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String redefines;
            TranTreeObject child = tranTreeObjectArray[n2];
            boolean isODO_Object = false;
            boolean isRedefining = false;
            FieldType currFieldType = ((FieldModel)child).getField();
            Boolean isDependedOn = currFieldType.isDependedOn();
            Boolean isCounter = BooleanUtils.isTrue((Boolean)currFieldType.isCounter());
            if (isDependedOn != null && isDependedOn.booleanValue()) {
                isODO_Object = true;
            }
            if ((redefines = currFieldType.getRedefines()) != null && !redefines.isEmpty()) {
                isRedefining = true;
            }
            if (!(isODO_Object || isRedefining || isCounter.booleanValue())) {
                currFieldType.setIncluded(YesnoType.Y);
                this.setLeafArraySubFieldInclude((FieldModel)child);
                this.setChildrenChainInclude((FieldModel)child);
            }
            ++n2;
        }
    }

    private void setLeafArraySubFieldInclude(FieldModel fieldNode) {
        FieldType fieldType;
        TranTreeObject[] children = fieldNode.getChildren();
        if (children.length == 0 && (fieldType = fieldNode.getField()).getApplicationDatatype().getDatatype() == DatatypeType.ARRAY && fieldType.getField().size() == 1) {
            FieldType subField = (FieldType)fieldType.getField().get(0);
            subField.setIncluded(YesnoType.Y);
        }
    }

    private void setLeafArraySubFieldExclude(FieldModel fieldNode) {
        FieldType fieldType;
        TranTreeObject[] children = fieldNode.getChildren();
        if (children.length == 0 && (fieldType = fieldNode.getField()).getApplicationDatatype().getDatatype() == DatatypeType.ARRAY && fieldType.getField().size() == 1) {
            FieldType subField = (FieldType)fieldType.getField().get(0);
            subField.setIncluded(YesnoType.N);
        }
    }

    private void setChildrenChainExclude(FieldModel fieldNode) {
        TranTreeObject[] childNodes;
        TranTreeObject[] tranTreeObjectArray = childNodes = fieldNode.getChildren();
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            TranTreeObject currNode = tranTreeObjectArray[n2];
            if (currNode instanceof FieldModel) {
                FieldModel currFieldNode = (FieldModel)currNode;
                currFieldNode.getField().setIncluded(YesnoType.N);
                this.setCountedArrayExclude(currFieldNode);
                this.setLeafArraySubFieldExclude(currFieldNode);
                this.setChildrenChainExclude(currFieldNode);
            }
            ++n2;
        }
    }

    private void setParentChainExclude(FieldModel fieldNode) {
        Object parentNode = fieldNode.getParent();
        if (parentNode instanceof FieldModel) {
            FieldType parentField = ((FieldModel)parentNode).getField();
            List childrenFields = parentField.getField();
            boolean anyInclusion = false;
            for (FieldType currField : childrenFields) {
                if (currField.getIncluded() != YesnoType.Y) continue;
                anyInclusion = true;
            }
            if (!anyInclusion) {
                parentField.setIncluded(YesnoType.N);
                this.setCountedArrayExclude((FieldModel)parentNode);
                this.setParentChainExclude((FieldModel)parentNode);
            }
        }
    }

    public void setInclude(FieldModel fieldNode, boolean include) {
        if (include) {
            fieldNode.getField().setIncluded(YesnoType.Y);
            this.setParentChainInclude(fieldNode);
            this.setChildrenChainInclude(fieldNode);
            this.setLeafArraySubFieldInclude(fieldNode);
        } else {
            fieldNode.getField().setIncluded(YesnoType.N);
            this.setCountedArrayExclude(fieldNode);
            this.setLeafArraySubFieldExclude(fieldNode);
            this.setChildrenChainExclude(fieldNode);
            this.setParentChainExclude(fieldNode);
        }
    }

    public YesnoType getInclude(FieldModel fieldNode) {
        return fieldNode.getField().getIncluded();
    }

    private void setCountedArrayExclude(FieldModel fieldNode) {
        if (!fieldNode.isSetCounterPath()) {
            return;
        }
        TranDataStructureModel dataStructureNode = fieldNode.getDataStructureNode();
        FieldType dataStructureField = dataStructureNode.getField();
        FieldType countedArrayField = fieldNode.getField();
        FindArrayCounterVisitor visitor = new FindArrayCounterVisitor(countedArrayField);
        try {
            new MessageWalker().accept((IMessageVisitor)visitor, dataStructureField);
        }
        catch (FoundArrayCounterException foundArrayCounterException) {
            FieldType arrayCounterField = visitor.getArrayCounterField();
            arrayCounterField.setIncluded(YesnoType.N);
            arrayCounterField.setIsCounter(null);
        }
        catch (MessageWalkerException unexpected) {
            ZCeeUILogger.error((Throwable)unexpected);
        }
        countedArrayField.setCounter(null);
        countedArrayField.setCounterPath(null);
        Integer originalMinOccurs = countedArrayField.getOriginalMinOccurs();
        if (originalMinOccurs != null) {
            countedArrayField.setMinOccurs(originalMinOccurs);
            countedArrayField.setOriginalMinOccurs(null);
        }
    }

    private void updateMsgMaps(Message msg) {
        String msgId = msg.getMessage().getId().toString();
        if (this.createdMessages.get(msgId) != null) {
            this.createdMessages.put(msgId, msg);
        } else {
            this.updatedMessages.put(msgId, msg);
        }
    }

    public void editMessageOrChannel(TranMessageModel msgNode, String name, String remarks) {
        msgNode.setName(name);
        Message msg = msgNode.getMessage();
        msg.setMessageName(name);
        msg.getMessage().setName(name);
        msg.getMessage().setRemarks(remarks);
        this.updateMsgMaps(msg);
    }

    public void editDataStructure(TranDataStructureModel dsNode, String name, String remarks) {
        dsNode.setName(name);
        dsNode.getField().setName(name);
        dsNode.getField().setRemarks(remarks);
        TranSegmentModel segNode = (TranSegmentModel)dsNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message msg = msgNode.getMessage();
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dsNode.getField());
        }
        catch (MessageWalkerException e) {
            EclipseLogger.logError(e);
        }
        this.updateMsgMaps(msg);
    }

    public void editField(FieldModel fieldNode, String name, String remarks) {
        fieldNode.setName(name);
        fieldNode.getField().setName(name);
        fieldNode.getField().setRemarks(remarks);
        FieldModel currNode = fieldNode;
        while (!(currNode.getParent() instanceof TranDataStructureModel)) {
            currNode = (FieldModel)currNode.getParent();
        }
        TranDataStructureModel dsNode = (TranDataStructureModel)currNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message msg = msgNode.getMessage();
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dsNode.getField());
        }
        catch (MessageWalkerException e) {
            EclipseLogger.logError(e);
        }
        this.updateMsgMaps(msg);
    }

    public void editField(FieldModel fieldNode, FieldEditorController controller) {
        FieldType fieldType = fieldNode.getField();
        if (TranEditorController.isLeafField(fieldNode)) {
            if (controller.isCodepageChecked()) {
                fieldType.setCodepageConversion(YesnoType.Y);
            } else {
                fieldType.setCodepageConversion(YesnoType.N);
            }
            fieldType.setDefaultValue(controller.getNewFieldValue());
            fieldType.setIsHex(Boolean.valueOf(controller.isHex()));
        }
        if (fieldNode.isArrayField()) {
            this.editField_arrayProperties(fieldNode, controller);
        }
        fieldNode.setName(controller.getNewFieldName());
        fieldType.setName(controller.getNewFieldName());
        fieldType.setRemarks(controller.getNewFieldRemarks());
        fieldType.setDatatypeOverride(controller.getDatatypeOverride());
        FieldModel currNode = fieldNode;
        while (!(currNode.getParent() instanceof TranDataStructureModel)) {
            currNode = (FieldModel)currNode.getParent();
        }
        TranDataStructureModel dsNode = (TranDataStructureModel)currNode.getParent();
        TranSegmentModel segNode = (TranSegmentModel)dsNode.getParent();
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message msg = msgNode.getMessage();
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dsNode.getField());
        }
        catch (MessageWalkerException e) {
            EclipseLogger.logError(e);
        }
        this.updateMsgMaps(msg);
    }

    private void editField_arrayProperties(FieldModel fieldNode, FieldEditorController controller) {
        String newCounterPath;
        FieldType editedArrayField = controller.getFieldType();
        String origCounterPath = controller.getOrigCounterPath();
        if (!StringUtils.equals((CharSequence)origCounterPath, (CharSequence)(newCounterPath = controller.getNewCounterPath()))) {
            FieldType origCounterField = controller.getOrigCounterField();
            if (origCounterField != null) {
                origCounterField.setIsCounter(null);
            }
            editedArrayField.setCounter(null);
            editedArrayField.setCounterPath(null);
            if (editedArrayField.getOriginalMinOccurs() != null) {
                editedArrayField.setMinOccurs(editedArrayField.getOriginalMinOccurs());
            }
            editedArrayField.setOriginalMinOccurs(null);
            if (StringUtils.isNotBlank((CharSequence)newCounterPath)) {
                FieldType newCounterField = controller.getNewCounterField();
                newCounterField.setIsCounter(Boolean.valueOf(true));
                newCounterField.setIncluded(YesnoType.N);
                editedArrayField.setCounter(newCounterField.getName());
                editedArrayField.setCounterPath(newCounterField.getPath());
                editedArrayField.setOriginalMinOccurs(editedArrayField.getMinOccurs());
                editedArrayField.setMinOccurs(controller.getMinimumItems());
                this.setInclude(fieldNode, true);
            }
        } else if (StringUtils.isNotBlank((CharSequence)newCounterPath)) {
            editedArrayField.setMinOccurs(controller.getMinimumItems());
        }
    }

    public void editContainer(TranSegmentModel containerNode, String containerName, String rename, CicsContainerType containerType, YesnoType containerRequired) {
        SegmentType segment = containerNode.getSegment();
        containerNode.setName(containerName);
        segment.setOriginalName(containerName);
        segment.setName(rename);
        segment.setContainerType(containerType);
        segment.setRequired(containerRequired);
        TranMessageModel channelNode = (TranMessageModel)containerNode.getParent();
        Message msg = channelNode.getMessage();
        this.updateMsgMaps(msg);
    }

    public List<TranDataStructureModel> getDataStructureNodes(TranMessageModel msgNode, int segId) {
        TranSegmentModel segNode = (TranSegmentModel)msgNode.getChildren()[segId - 1];
        TranTreeObject[] dsArray = segNode.getChildren();
        ArrayList<TranDataStructureModel> dsNodes = new ArrayList<TranDataStructureModel>();
        int i = 0;
        while (i < dsArray.length) {
            dsNodes.add((TranDataStructureModel)dsArray[i]);
            ++i;
        }
        return dsNodes;
    }

    public List<TranSegmentModel> getSegmentNodes(TranMessageModel msgNode) {
        TranTreeObject[] segArray = msgNode.getChildren();
        ArrayList<TranSegmentModel> segNodes = new ArrayList<TranSegmentModel>();
        int i = 0;
        while (i < segArray.length) {
            segNodes.add((TranSegmentModel)segArray[i]);
            ++i;
        }
        return segNodes;
    }

    public TranMessageModel getMsgOrChannelNode() {
        TranMessageModel retVal = null;
        retVal = (TranMessageModel)this.invisibleRootRequest.getChildren()[0];
        return retVal;
    }

    public TranMessageModel getMsgNode(String msgName, int msgDirection) {
        TranMessageModel retVal = null;
        List<TranMessageModel> msgNodes = this.getMessageNodes(msgDirection);
        for (TranMessageModel msgNode : msgNodes) {
            if (!msgNode.getMessage().getMessage().getName().equals(msgName)) continue;
            retVal = msgNode;
            break;
        }
        return retVal;
    }

    public TranMessageModel getMsgNodeByName(String msgName) {
        TranMessageModel retVal = null;
        List<TranMessageModel> msgNodes = this.getMessageNodes(0);
        for (TranMessageModel msgNode : msgNodes) {
            if (!msgNode.getMessage().getMessage().getName().equals(msgName)) continue;
            retVal = msgNode;
            break;
        }
        if (retVal == null) {
            msgNodes = this.getMessageNodes(1);
            for (TranMessageModel msgNode : msgNodes) {
                if (!msgNode.getMessage().getMessage().getName().equals(msgName)) continue;
                retVal = msgNode;
                break;
            }
        }
        return retVal;
    }

    public List<TranMessageModel> getMessageNodes(int msgDirection) {
        TranTreeObject[] msgs = msgDirection == 0 ? this.invisibleRootRequest.getChildren() : this.invisibleRootResponse.getChildren();
        ArrayList<TranMessageModel> retVal = new ArrayList<TranMessageModel>(msgs.length);
        TranTreeObject[] tranTreeObjectArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            TranTreeObject tranTreeObject = tranTreeObjectArray[n2];
            retVal.add((TranMessageModel)tranTreeObject);
            ++n2;
        }
        return retVal;
    }

    public void removeMessage(TranMessageModel msgNode) {
        int msgType = msgNode.getMessageType();
        List<Message> msgList = null;
        boolean isRequest = false;
        if (msgType == 0) {
            msgList = this.inputMessages;
            isRequest = true;
        } else {
            msgList = this.outputMessages;
        }
        Message msg = msgNode.getMessage();
        msgList.remove(msg);
        msgNode.deleteMessage();
        if (isRequest) {
            this.invisibleRootRequest.removeChild(msgNode);
        } else {
            this.invisibleRootResponse.removeChild(msgNode);
        }
        this.deletedMessages.put(msg.getMessage().getId().toString(), msg);
    }

    public void reorganizeSegmentNumbers(TranMessageModel msgNode) {
        List segmentList = msgNode.getMessage().getMessage().getSegment();
        int i = 0;
        while (i < segmentList.size()) {
            SegmentType currSegType = (SegmentType)segmentList.get(i);
            currSegType.setId(BigInteger.valueOf(i + 1));
            currSegType.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (i + 1));
            currSegType.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (i + 1));
            ++i;
        }
    }

    public int getSegmentsCount() {
        int retVal = 0;
        if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            retVal = ((TranTreeParent)this.invisibleRootRequest.getChildren()[0]).getChildren().length;
        }
        return retVal;
    }

    public void removeSegment(TranSegmentModel segNode) {
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message message = msgNode.getMessage();
        List segmentList = message.getMessage().getSegment();
        segmentList.remove(segNode.getSegment());
        segNode.deleteSegment();
        msgNode.removeChild(segNode);
        this.updateMsgMaps(message);
    }

    public void removeDataStructureListUnderSameSegment(ArrayList<TranDataStructureModel> dsNodeList) throws MessageWalkerException {
        TranDataStructureModel firstDsNode = dsNodeList.get(0);
        TranSegmentModel segNode = (TranSegmentModel)firstDsNode.getParent();
        for (TranDataStructureModel currDsNode : dsNodeList) {
            SegmentType seg = segNode.getSegment();
            List fieldList = seg.getField();
            fieldList.remove(currDsNode.getField());
            currDsNode.deleteField();
            segNode.removeChild(currDsNode);
        }
        this.populateDataStructureAndFieldNodes(segNode, false);
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message msg = msgNode.getMessage();
        this.updateMsgMaps(msg);
    }

    public void removeDataStructure(TranDataStructureModel dsNode) throws MessageWalkerException {
        ArrayList<TranDataStructureModel> dsList = new ArrayList<TranDataStructureModel>();
        dsList.add(dsNode);
        this.removeDataStructureListUnderSameSegment(dsList);
    }

    public boolean canMoveUp(TranTreeObject node) {
        TranTreeObject[] children = ((TranTreeParent)node.getParent()).getChildren();
        int index = -1;
        int i = 0;
        while (i < children.length) {
            if (children[i] == node) {
                index = i;
                break;
            }
            ++i;
        }
        return index > 0;
    }

    public boolean canMoveDown(TranTreeObject node) {
        TranTreeObject[] children = ((TranTreeParent)node.getParent()).getChildren();
        int index = -1;
        int i = 0;
        while (i < children.length) {
            if (children[i] == node) {
                index = i;
                break;
            }
            ++i;
        }
        return index + 1 < children.length;
    }

    public void copyDataStructure(TranDataStructureModel dsNode) {
        this.copiedfield = TranEditorController.cloneFieldType(dsNode.getField());
        this.originalCopiedName = this.copiedfield.getName();
    }

    public void reCopyDsForMultiplePastes() {
        this.copiedfield = TranEditorController.cloneFieldType(this.copiedfield);
        this.copiedfield.setName(this.originalCopiedName);
    }

    public boolean canPaste() {
        return this.copiedfield != null;
    }

    public void setCopiedFieldName(String newName) {
        this.copiedfield.setName(newName);
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), this.copiedfield);
        }
        catch (MessageWalkerException e) {
            EclipseLogger.logError(e);
        }
    }

    public String getCopiedFieldName() {
        return this.copiedfield.getName();
    }

    public Vector<String> getExistingDsNamesForImport(DataStructureSegmentAssociation dssa) {
        Vector<String> retVal = new Vector<String>();
        BigInteger msgId = dssa.messageId;
        TranSegmentModel segmentModel = null;
        List<Message> messageTypes = this.inputMessages;
        for (Message msg : messageTypes) {
            if (!msg.getMessage().getId().equals(msgId)) continue;
            for (SegmentType st : msg.getMessage().getSegment()) {
                segmentModel = this.findSegmentNode(msgId, st.getId());
                if (segmentModel == null) continue;
                TranTreeObject[] dsNodes = segmentModel.getChildren();
                int i = 0;
                while (i < dsNodes.length) {
                    retVal.add(((TranDataStructureModel)dsNodes[i]).getName());
                    ++i;
                }
            }
        }
        return retVal;
    }

    public void preserveFieldInfoAndRemoveDs(DataStructureSegmentAssociation dssa) throws MessageWalkerException {
        BigInteger msgId = dssa.messageId;
        TranSegmentModel segmentModel = null;
        List<Message> messageTypes = this.inputMessages;
        FieldType existingDsTopFieldType = null;
        for (Message msg : messageTypes) {
            if (!msg.getMessage().getId().equals(msgId)) continue;
            block1: for (SegmentType st : msg.getMessage().getSegment()) {
                segmentModel = this.findSegmentNode(msgId, st.getId());
                if (segmentModel == null) continue;
                TranTreeObject[] dsNodes = segmentModel.getChildren();
                int i = 0;
                while (i < dsNodes.length) {
                    TranDataStructureModel currDsModel = (TranDataStructureModel)dsNodes[i];
                    String existingDsName = currDsModel.getField().getOriginalName();
                    if (existingDsName.equals(dssa.dataStructure.getOriginalName()) && dssa.segmentName.equals(((TranSegmentModel)currDsModel.getParent()).getSegment().getOriginalName())) {
                        existingDsTopFieldType = ((TranDataStructureModel)dsNodes[i]).getField();
                        st.getField().remove(existingDsTopFieldType);
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        if (existingDsTopFieldType != null) {
            MessageType tempExistingMsg = new MessageType();
            SegmentType tempExistingSeg = new SegmentType();
            tempExistingSeg.getField().add(existingDsTopFieldType);
            tempExistingMsg.getSegment().add(tempExistingSeg);
            dssa.dataStructure.setName(existingDsTopFieldType.getName());
            dssa.dataStructure.setRemarks(existingDsTopFieldType.getRemarks());
            FieldInfoPreservationVisitor visitor = new FieldInfoPreservationVisitor(existingDsTopFieldType, dssa.dataStructure);
            MessageWalker mw = new MessageWalker();
            mw.accept((IMessageVisitor)visitor, existingDsTopFieldType);
        }
    }

    public void renameDsForPaste(String collidedName, Vector<String> existingDsNames) {
        String startName = PgmIntXlat.getLabel().getString("RND_COPY") + collidedName;
        int i = 2;
        String name = startName;
        while (this.nameCollision(name, existingDsNames)) {
            name = startName + i;
            ++i;
        }
        this.setCopiedFieldName(name);
    }

    public void renameDsForImport(String collidedName, Vector<String> existingDsNames, DataStructureSegmentAssociation dssa) {
        if (this.nameCollision(collidedName, existingDsNames)) {
            String startName = PgmIntXlat.getLabel().getString("RND_COPY") + collidedName;
            int i = 2;
            String name = startName;
            while (this.nameCollision(name, existingDsNames)) {
                name = startName + i;
                ++i;
            }
            dssa.dataStructure.setName(name);
        } else {
            dssa.dataStructure.setName(collidedName);
        }
        try {
            new MessageWalker().accept((IMessageVisitor)new TranEditorUpdateFieldPathsVisitor(), dssa.dataStructure);
        }
        catch (MessageWalkerException e) {
            EclipseLogger.logError(e);
        }
    }

    private boolean nameCollision(String name, Vector<String> existingDsNames) {
        boolean retVal = false;
        Iterator<String> iter = existingDsNames.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public void checkNameCollisionAmongImportDS(String possibleCollideName, Vector<DataStructureSegmentAssociation> importResult, int currPos) {
        Object[] dsArray = importResult.toArray();
        Vector<String> duplicateImportDsNames = null;
        DataStructureSegmentAssociation currDs = (DataStructureSegmentAssociation)dsArray[currPos];
        int i = 0;
        while (i < dsArray.length) {
            if (i != currPos) {
                DataStructureSegmentAssociation compareDs = (DataStructureSegmentAssociation)dsArray[i];
                if (currDs.dataStructure.getName().equalsIgnoreCase(compareDs.dataStructure.getName()) && currDs.messageId.equals(compareDs.messageId)) {
                    FieldType cloneFieldType;
                    String collidingName = compareDs.dataStructure.getName();
                    compareDs.dataStructure = cloneFieldType = TranEditorController.cloneFieldType(compareDs.dataStructure);
                    if (duplicateImportDsNames == null) {
                        duplicateImportDsNames = new Vector<String>();
                    }
                    if (!duplicateImportDsNames.contains(collidingName)) {
                        duplicateImportDsNames.add(collidingName);
                    }
                    Vector<String> allExistingDsNames = this.getExistingDsNamesForImport(compareDs);
                    allExistingDsNames.addAll(duplicateImportDsNames);
                    this.renameDsForImport(possibleCollideName, allExistingDsNames, compareDs);
                    duplicateImportDsNames.add(compareDs.dataStructure.getName());
                    if (compareDs.nameCollision) {
                        compareDs.nameCollision = false;
                    }
                }
            }
            ++i;
        }
    }

    public Vector<String> getExistingDsNamesForPaste(Object node) {
        Vector<String> retVal = new Vector<String>();
        TranTreeParent msgNode = null;
        if (node instanceof TranDataStructureModel) {
            TranSegmentModel segNode = (TranSegmentModel)((TranDataStructureModel)node).getParent();
            msgNode = (TranMessageModel)segNode.getParent();
        } else if (node instanceof TranSegmentModel) {
            msgNode = (TranMessageModel)((TranSegmentModel)node).getParent();
        }
        TranTreeObject[] segNodes = msgNode.getChildren();
        int i = 0;
        while (i < segNodes.length) {
            TranSegmentModel currSegNode = (TranSegmentModel)segNodes[i];
            TranTreeObject[] dsNodes = currSegNode.getChildren();
            int j = 0;
            while (j < dsNodes.length) {
                retVal.add(((TranDataStructureModel)dsNodes[j]).getName());
                ++j;
            }
            ++i;
        }
        return retVal;
    }

    public Vector<String> getExistingFieldNamesUnderParent(TranTreeObject node) {
        Vector<String> retVal = new Vector<String>();
        TranTreeParent parent = (TranTreeParent)node.getParent();
        TranTreeObject[] childrenNodes = parent.getChildren();
        int j = 0;
        while (j < childrenNodes.length) {
            retVal.add(childrenNodes[j].getName());
            ++j;
        }
        return retVal;
    }

    public Vector<String> getAllExistingNamesUnderParent(TranTreeObject node) {
        Vector<String> retVal = new Vector<String>();
        TranTreeParent parent = (TranTreeParent)node.getParent();
        TranTreeObject[] childrenNodes = parent.getChildren();
        int j = 0;
        while (j < childrenNodes.length) {
            retVal.add(childrenNodes[j].getName());
            if (childrenNodes[j] instanceof FieldModel) {
                retVal.add(((FieldModel)childrenNodes[j]).getOriginalName());
            }
            ++j;
        }
        return retVal;
    }

    public Vector<String> getExistingContainerNames(TranMessageModel rootNode) {
        Vector<String> retVal = new Vector<String>();
        TranTreeObject[] childContainers = rootNode.getChildren();
        int i = 0;
        while (i < rootNode.getChildren().length) {
            retVal.add(childContainers[i].getName());
            ++i;
        }
        return retVal;
    }

    public Vector<String> getExistingContainerInterfaceRenames(TranMessageModel rootNode) {
        Vector<String> retVal = new Vector<String>();
        TranTreeObject[] childContainers = rootNode.getChildren();
        int i = 0;
        while (i < rootNode.getChildren().length) {
            TranSegmentModel tsm = (TranSegmentModel)childContainers[i];
            String interfaceRename = tsm.getSegment().getName();
            if (interfaceRename != null && !interfaceRename.isEmpty()) {
                retVal.add(tsm.getSegment().getName());
            }
            ++i;
        }
        return retVal;
    }

    public Vector<String> getExistingFieldNamesUnderThisNode(TranTreeParent parent) {
        Vector<String> retVal = new Vector<String>();
        TranTreeObject[] childrenNodes = parent.getChildren();
        int j = 0;
        while (j < childrenNodes.length) {
            retVal.add(childrenNodes[j].getName());
            ++j;
        }
        return retVal;
    }

    public String checkNameCollisionForPaste(Object selectedNode) {
        String retVal = null;
        if (this.copiedfield != null) {
            String name1 = this.copiedfield.getName();
            TranTreeParent msgNode = null;
            if (selectedNode instanceof TranDataStructureModel) {
                TranSegmentModel segNode = (TranSegmentModel)((TranDataStructureModel)selectedNode).getParent();
                msgNode = (TranMessageModel)segNode.getParent();
            } else if (selectedNode instanceof TranSegmentModel) {
                msgNode = (TranMessageModel)((TranSegmentModel)selectedNode).getParent();
            }
            TranTreeObject[] segNodes = msgNode.getChildren();
            int i = 0;
            while (i < segNodes.length && retVal == null) {
                TranSegmentModel currSegNode = (TranSegmentModel)segNodes[i];
                TranTreeObject[] dsNodes = currSegNode.getChildren();
                int j = 0;
                while (j < dsNodes.length && retVal == null) {
                    String name2 = ((TranDataStructureModel)dsNodes[j]).getName();
                    if (name1.equalsIgnoreCase(name2)) {
                        retVal = name1;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void pasteDataStructure(Object selectedNode) throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        if (this.copiedfield != null) {
            TranMessageModel msgNode = null;
            TranSegmentModel segNode = null;
            if (selectedNode instanceof TranDataStructureModel) {
                TranDataStructureModel dsNode = (TranDataStructureModel)selectedNode;
                segNode = (TranSegmentModel)dsNode.getParent();
                TranDataStructureModel newDsNode = new TranDataStructureModel(this.copiedfield, (TranTreeParent)segNode);
                segNode.addChildAfter(dsNode, newDsNode);
                List fieldTypeList = segNode.getSegment().getField();
                int afterIndex = fieldTypeList.indexOf(dsNode.getField());
                fieldTypeList.add(afterIndex + 1, this.copiedfield);
                this.populateDataStructureAndFieldNodes(segNode, false);
            } else if (selectedNode instanceof TranSegmentModel) {
                segNode = (TranSegmentModel)selectedNode;
                TranDataStructureModel newDsNode = new TranDataStructureModel(this.copiedfield, (TranTreeParent)segNode);
                segNode.addChild(newDsNode);
                List fieldTypeList = segNode.getSegment().getField();
                fieldTypeList.add(this.copiedfield);
                this.populateDataStructureAndFieldNodes(segNode, false);
            }
            if (segNode != null) {
                msgNode = (TranMessageModel)segNode.getParent();
                Message msg = msgNode.getMessage();
                this.updateMsgMaps(msg);
            }
        }
    }

    public void moveUpSegment(TranSegmentModel segNode) {
        SegmentType segToMove;
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message msg = msgNode.getMessage();
        List segmentList = msg.getMessage().getSegment();
        int currentIndex = segmentList.indexOf(segToMove = segNode.getSegment());
        if (currentIndex != 0) {
            SegmentType segAbove = (SegmentType)segmentList.get(currentIndex - 1);
            segmentList.remove(segToMove);
            segToMove.setId(BigInteger.valueOf(currentIndex));
            segAbove.setId(BigInteger.valueOf(currentIndex + 1));
            segmentList.add(currentIndex - 1, segToMove);
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                segToMove.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + currentIndex);
                segToMove.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + currentIndex);
                segAbove.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 1));
                segAbove.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 1));
            }
            TranTreeObject[] segNodeArray = msgNode.getChildren();
            TranTreeObject childToAddBefore = segNodeArray[currentIndex - 1];
            msgNode.removeChildFromArray(segNode);
            msgNode.addChildBefore(childToAddBefore, segNode);
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                segNode.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + currentIndex);
                childToAddBefore.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 1));
            }
            this.updateMsgMaps(msg);
        }
    }

    public void moveDownSegment(TranSegmentModel segNode) {
        TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
        Message msg = msgNode.getMessage();
        List segmentList = msg.getMessage().getSegment();
        int segmentListSize = segmentList.size();
        SegmentType segToMove = segNode.getSegment();
        int currentIndex = segmentList.indexOf(segToMove);
        if (currentIndex != segmentListSize - 1) {
            SegmentType segBelow = (SegmentType)segmentList.get(currentIndex + 1);
            segmentList.remove(segToMove);
            segToMove.setId(BigInteger.valueOf(currentIndex + 2));
            segBelow.setId(BigInteger.valueOf(currentIndex + 1));
            segmentList.add(currentIndex + 1, segToMove);
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                segToMove.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 2));
                segToMove.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 2));
                segBelow.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 1));
                segBelow.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 1));
            }
            TranTreeObject[] segNodeArray = msgNode.getChildren();
            TranTreeObject childToAddAfter = segNodeArray[currentIndex + 1];
            msgNode.removeChildFromArray(segNode);
            msgNode.addChildAfter(childToAddAfter, segNode);
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                segNode.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 2));
                childToAddAfter.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + (currentIndex + 1));
            }
            this.updateMsgMaps(msg);
        }
    }

    public void moveUpDataStructure(TranDataStructureModel dsNode) {
        FieldType fieldToMove;
        TranSegmentModel segNode = (TranSegmentModel)dsNode.getParent();
        SegmentType segment = segNode.getSegment();
        List fieldList = segment.getField();
        int currentIndex = fieldList.indexOf(fieldToMove = dsNode.getField());
        if (currentIndex != 0) {
            fieldList.remove(fieldToMove);
            fieldList.add(currentIndex - 1, fieldToMove);
            TranTreeObject[] dsNodeArray = segNode.getChildren();
            TranTreeObject childToAddBefore = dsNodeArray[currentIndex - 1];
            segNode.removeChildFromArray(dsNode);
            segNode.addChildBefore(childToAddBefore, dsNode);
            TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
            Message msg = msgNode.getMessage();
            this.updateMsgMaps(msg);
        }
    }

    public void moveDownDataStructure(TranDataStructureModel dsNode) {
        TranSegmentModel segNode = (TranSegmentModel)dsNode.getParent();
        SegmentType segment = segNode.getSegment();
        List fieldList = segment.getField();
        int fieldListSize = fieldList.size();
        FieldType fieldToMove = dsNode.getField();
        int currentIndex = fieldList.indexOf(fieldToMove);
        if (currentIndex != fieldListSize - 1) {
            fieldList.remove(fieldToMove);
            fieldList.add(currentIndex + 1, fieldToMove);
            TranTreeObject[] dsNodeArray = segNode.getChildren();
            TranTreeObject childToAddAfter = dsNodeArray[currentIndex + 1];
            segNode.removeChildFromArray(dsNode);
            segNode.addChildAfter(childToAddAfter, dsNode);
            TranMessageModel msgNode = (TranMessageModel)segNode.getParent();
            Message msg = msgNode.getMessage();
            this.updateMsgMaps(msg);
        }
    }

    public static long getNextAvailableSegmentId(MessageType msgType) {
        long retVal = 0L;
        List segments = msgType.getSegment();
        for (SegmentType segmentType : segments) {
            long currId = segmentType.getId().longValue();
            if (currId <= retVal) continue;
            retVal = currId;
        }
        return retVal + 1L;
    }

    public void addSegment(TranMessageModel msgNode) {
        Message msg = msgNode.getMessage();
        List segments = msg.getMessage().getSegment();
        SegmentType newSegment = new SegmentType();
        BigInteger segId = BigInteger.valueOf(TranEditorController.getNextAvailableSegmentId(msg.getMessage()));
        newSegment.setId(segId);
        newSegment.setName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + String.valueOf(segId));
        newSegment.setOriginalName(PgmIntXlat.getLabel().getString("TMME_SEGMENT") + " " + String.valueOf(segId));
        segments.add(newSegment);
        this.updateMsgMaps(msg);
    }

    public void addContainer(String containerName, String rename, CicsContainerType containerType, YesnoType containerRequired) {
        TranMessageModel channelNode = this.getMsgOrChannelNode();
        Message msg = channelNode.getMessage();
        List segments = msg.getMessage().getSegment();
        SegmentType newSegment = new SegmentType();
        newSegment.setOriginalName(containerName);
        newSegment.setName(rename);
        newSegment.setContainerType(containerType);
        newSegment.setRequired(containerRequired);
        BigInteger segId = BigInteger.valueOf(TranEditorController.getNextAvailableSegmentId(msg.getMessage()));
        newSegment.setId(segId);
        segments.add(newSegment);
        this.updateMsgMaps(msg);
    }

    public TranSegmentModel findSegmentNode(BigInteger msgId, BigInteger segId) {
        TranSegmentModel retVal = null;
        TranTreeObject[] msgNodes = null;
        TranTreeParent msgNode = null;
        msgNodes = this.invisibleRootRequest.getChildren();
        int i = 0;
        while (i < msgNodes.length) {
            TranMessageModel currMsgNode = (TranMessageModel)msgNodes[i];
            Message currMsg = currMsgNode.getMessage();
            if (currMsg.getMessage().getId().equals(msgId)) {
                msgNode = currMsgNode;
                break;
            }
            ++i;
        }
        if (msgNode != null) {
            TranTreeObject[] segNodeList = msgNode.getChildren();
            int i2 = 0;
            while (i2 < segNodeList.length) {
                TranSegmentModel currSegNode = (TranSegmentModel)segNodeList[i2];
                if (currSegNode.getSegment().getId().equals(segId)) {
                    retVal = currSegNode;
                    break;
                }
                ++i2;
            }
        }
        return retVal;
    }

    private void clear01LevelRedefine(FieldType dataStructure) {
        dataStructure.setRedefines(null);
    }

    public void addImportedDS(Vector<DataStructureSegmentAssociation> dssaList) throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        HashMap<CallSite, segmentAndDsFolder> populateMap = new HashMap<CallSite, segmentAndDsFolder>();
        int i = 0;
        while (i < dssaList.size()) {
            DataStructureSegmentAssociation dssa = dssaList.get(i);
            FieldType dataStructure = dssa.dataStructure;
            BigInteger segId = dssa.segmentId;
            BigInteger msgId = dssa.messageId;
            SegmentType segmentType = null;
            TranTreeParent segmentModel = null;
            boolean found = false;
            List<Message> msgs = this.inputMessages;
            block1: for (Message msg : msgs) {
                if (found) break;
                if (!msg.getMessage().getId().equals(msgId)) continue;
                for (SegmentType st : msg.getMessage().getSegment()) {
                    if (!st.getId().equals(segId)) continue;
                    segmentType = st;
                    this.clear01LevelRedefine(dataStructure);
                    st.getField().add(dataStructure);
                    segmentModel = this.findSegmentNode(msgId, segId);
                    found = true;
                    this.updateMsgMaps(msg);
                    continue block1;
                }
            }
            if (found) {
                segmentModel.removeAllChildren();
                String key = msgId.toString() + segId.toString();
                segmentAndDsFolder value = (segmentAndDsFolder)populateMap.get(key);
                if (value == null) {
                    segmentAndDsFolder segAndDsFolder = new segmentAndDsFolder(segmentType, (TranSegmentModel)segmentModel);
                    if (dssa.preserveFieldInfo) {
                        segAndDsFolder.preserveFieldInfo = true;
                    }
                    populateMap.put((CallSite)((Object)key), segAndDsFolder);
                }
            }
            ++i;
        }
        if (!populateMap.isEmpty()) {
            Object[] populateList = populateMap.values().toArray();
            int i2 = 0;
            while (i2 < populateList.length) {
                segmentAndDsFolder currItem = (segmentAndDsFolder)populateList[i2];
                boolean treatAsNewImport = true;
                if (currItem.preserveFieldInfo) {
                    treatAsNewImport = false;
                }
                this.populateDataStructureAndFieldNodes(currItem.segmentModel, treatAsNewImport);
                ++i2;
            }
        }
    }

    public static MarshallerType cloneMarshallerType(MarshallerType fromMarshallerType) {
        MarshallerType toMarshallerType = new MarshallerType();
        toMarshallerType.setEncoding(fromMarshallerType.getEncoding());
        toMarshallerType.setIsNullable(fromMarshallerType.getIsNullable());
        toMarshallerType.setIsSigned(fromMarshallerType.getIsSigned());
        toMarshallerType.setIsSignLeading(fromMarshallerType.getIsSignLeading());
        toMarshallerType.setIsSignSeparate(fromMarshallerType.getIsSignSeparate());
        toMarshallerType.setIsDBCSOnly(fromMarshallerType.getIsDBCSOnly());
        toMarshallerType.setIsWCHAROnly(fromMarshallerType.getIsWCHAROnly());
        toMarshallerType.setIsNativeInteger(fromMarshallerType.getIsNativeInteger());
        toMarshallerType.setPattern(fromMarshallerType.getPattern());
        toMarshallerType.setUserTypeConverter(fromMarshallerType.getUserTypeConverter());
        toMarshallerType.setTypeConverter(fromMarshallerType.getTypeConverter());
        return toMarshallerType;
    }

    public static FieldType cloneFieldType(FieldType fromFieldType) {
        ApplicationDatatypeType fromAdt;
        FieldType toFieldType = new FieldType();
        toFieldType.setStartPos(fromFieldType.getStartPos());
        toFieldType.setRelativeStart(fromFieldType.getRelativeStart());
        toFieldType.setStartAfter(fromFieldType.getStartAfter());
        toFieldType.setBytes(fromFieldType.getBytes());
        toFieldType.setMaxBytes(fromFieldType.getMaxBytes());
        toFieldType.setRemarks(fromFieldType.getRemarks());
        MarshallerType marshaller = fromFieldType.getMarshaller();
        if (marshaller != null) {
            toFieldType.setMarshaller(TranEditorController.cloneMarshallerType(marshaller));
        }
        if ((fromAdt = fromFieldType.getApplicationDatatype()) != null) {
            ApplicationDatatypeType toAdt = new ApplicationDatatypeType();
            toAdt.setDatatype(fromAdt.getDatatype());
            toAdt.setPrecision(fromAdt.getPrecision());
            toAdt.setScale(fromAdt.getScale());
            toFieldType.setApplicationDatatype(toAdt);
        }
        Iterator subFieldIter = fromFieldType.getField().iterator();
        List toFieldTypeSubFieldList = toFieldType.getField();
        while (subFieldIter.hasNext()) {
            FieldType currSubField = (FieldType)subFieldIter.next();
            toFieldTypeSubFieldList.add(TranEditorController.cloneFieldType(currSubField));
        }
        toFieldType.setName(fromFieldType.getName());
        toFieldType.setOriginalName(fromFieldType.getOriginalName());
        toFieldType.setPath(fromFieldType.getPath());
        toFieldType.setDependsOn(fromFieldType.getDependsOn());
        toFieldType.setDependedOn(fromFieldType.isDependedOn());
        toFieldType.setDependsOnPath(fromFieldType.getDependsOnPath());
        toFieldType.setRedefines(fromFieldType.getRedefines());
        toFieldType.setMinOccurs(fromFieldType.getMinOccurs());
        toFieldType.setMaxOccurs(fromFieldType.getMaxOccurs());
        toFieldType.setIncluded(fromFieldType.getIncluded());
        toFieldType.setDefaultValue(fromFieldType.getDefaultValue());
        toFieldType.setIsHex(fromFieldType.isIsHex());
        toFieldType.setIsCounter(fromFieldType.isCounter());
        toFieldType.setCounter(fromFieldType.getCounter());
        toFieldType.setCounterPath(fromFieldType.getCounterPath());
        toFieldType.setOriginalMinOccurs(fromFieldType.getOriginalMinOccurs());
        toFieldType.setDatatypeOverride(fromFieldType.getDatatypeOverride());
        return toFieldType;
    }

    public TranTreeParent addRedefineAsCharField(FieldModel redefinedField, String redefiningFieldName) throws MessageWalkerException {
        RedefineAsCharController redefCharCtrl = new RedefineAsCharController(redefinedField.getField());
        String redefiningFieldParentPath = "";
        if (redefinedField.getParent() instanceof FieldModel) {
            redefiningFieldParentPath = ((FieldModel)redefinedField.getParent()).getPath();
        } else if (redefinedField.getParent() instanceof TranTreeObject) {
            redefiningFieldParentPath = ((TranTreeObject)redefinedField.getParent()).getName();
        }
        String redefiningFieldPath = redefiningFieldParentPath + "." + redefiningFieldName;
        FieldType redefiningField = new FieldType();
        redefiningField.setUserDefined(Boolean.valueOf(true));
        redefiningField.setName(redefiningFieldName);
        redefiningField.setOriginalName(redefiningFieldName);
        redefiningField.setPath(redefiningFieldPath);
        redefiningField.setRedefines(redefinedField.getOriginalName());
        redefiningField.setIncluded(YesnoType.Y);
        redefiningField.setStartPos(redefinedField.getStartPos());
        redefiningField.setBytes(redefinedField.getBytes());
        redefiningField.setMaxBytes(redefinedField.getMaxBytes());
        ApplicationDatatypeType datatypeType = new ApplicationDatatypeType();
        datatypeType.setDatatype(DatatypeType.CHAR);
        redefiningField.setApplicationDatatype(datatypeType);
        MarshallerType marshallerType = new MarshallerType();
        marshallerType.setEncoding(redefCharCtrl.getEncoding());
        marshallerType.setIsDBCSOnly(redefCharCtrl.getIsDBCSOnly());
        redefiningField.setMarshaller(marshallerType);
        FieldType redefinedFieldParent = redefinedField.getParentField();
        int redefinedFieldIndex = ListUtilz.indexOf((List)redefinedFieldParent.getField(), (Object)redefinedField.getField());
        redefinedFieldParent.getField().add(redefinedFieldIndex + 1, redefiningField);
        this.populateDataStructureAndFieldNodes(redefinedField.getSegmentNode(), false);
        return this.fieldPathToFieldModel.get(redefiningFieldPath);
    }

    public TranTreeParent removeRedefineAsCharField(FieldModel redefiningField) throws MessageWalkerException {
        FieldModel redefinedField = redefiningField.getRedefinesGroup().getRedefinedField();
        FieldType parentField = redefiningField.getParentField();
        parentField.getField().remove(redefiningField.getField());
        this.populateDataStructureAndFieldNodes(redefinedField.getSegmentNode(), false);
        return this.fieldPathToFieldModel.get(redefinedField.getPath());
    }

    public void doSave(String projectName, String fileName) throws JAXBException, CoreException {
        if (this.project_spType != null) {
            for (Message currMsg : this.inputMessages) {
                ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsg(projectName, currMsg, fileName);
            }
        } else {
            for (Message currMsg : this.inputMessages) {
                ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsgUnknownProjectType(projectName, currMsg, fileName, this.inputFile);
            }
        }
        this.createdMessages.clear();
        this.deletedMessages.clear();
        this.updatedMessages.clear();
    }

    public void doSaveMessageFiles(String projectName, Transaction tran) throws JAXBException, CoreException {
        ProjectTreeFileHelper.marshallProgramMessages(projectName, tran);
        this.createdMessages.clear();
        this.deletedMessages.clear();
        this.updatedMessages.clear();
    }

    public boolean haveBitContainerInInterface() {
        TranMessageModel channel = (TranMessageModel)this.invisibleRootRequest.getChildren()[0];
        TranTreeObject[] containers = channel.getChildren();
        int i = 0;
        while (i < containers.length) {
            TranSegmentModel currContainer = (TranSegmentModel)containers[i];
            if (currContainer.getSegment().getContainerType() == CicsContainerType.BIT) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TranTreeParent getInvisibleRootRequest() {
        return this.invisibleRootRequest;
    }

    public TranTreeParent getInvisibleRootResponse() {
        return this.invisibleRootResponse;
    }

    public String getTranName() {
        return this.tranName;
    }

    public List<Message> getInputMessages() {
        return this.inputMessages;
    }

    public List<Message> getOutputMessages() {
        return this.outputMessages;
    }

    public Map<String, TranTreeParent> getFieldPathToFieldModel() {
        return this.fieldPathToFieldModel;
    }

    public IFile getInputFile() {
        return this.inputFile;
    }

    public void refreshMarkers() {
        this.siErrorMarkers.clear();
        String markerType = ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM.toString();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.inputFile.findMarkers(markerType, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.exists() && TranEditorController.getSeverity(marker).equals(2)) {
                    this.siErrorMarkers.add(marker);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    public boolean hasErrorMarkers(FieldType fieldType) {
        for (IMarker marker : this.siErrorMarkers) {
            if (!marker.exists() || !TranEditorController.getSeverity(marker).equals(2) || !TranEditorController.getFieldPath(marker).equals(fieldType.getPath())) continue;
            return true;
        }
        return false;
    }

    public List<IMarker> getErrorMarkers(FieldType fieldType) {
        ArrayList<IMarker> errorMarkers = new ArrayList<IMarker>();
        for (IMarker marker : this.siErrorMarkers) {
            if (!marker.exists() || !TranEditorController.getSeverity(marker).equals(2) || !TranEditorController.getFieldPath(marker).equals(fieldType.getPath())) continue;
            errorMarkers.add(marker);
        }
        return errorMarkers;
    }

    public static Integer getSeverity(IMarker marker) {
        return marker.getAttribute("severity", -1);
    }

    public static String getFieldPath(IMarker marker) {
        return marker.getAttribute(ServiceProjectMarkerAttributes.FIELD_PATH.toString(), "");
    }

    class segmentAndDsFolder {
        SegmentType segType;
        TranSegmentModel segmentModel;
        public boolean preserveFieldInfo;

        segmentAndDsFolder(SegmentType segType, TranSegmentModel segmentModel) {
            this.segType = segType;
            this.segmentModel = segmentModel;
            this.preserveFieldInfo = false;
        }
    }
}

