/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.CannotRedefineAsCharException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.transaction.messages.NumericFieldType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

public class RedefineAsCharController
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Set<String> errorMessages = new HashSet<String>();
    private Set<String> warningMessages = new HashSet<String>();
    private Set<String> infoMessages = new HashSet<String>();
    private FieldType fieldToRedefine;
    private FieldType prevLeafField;
    private FieldType currLeafField;
    private boolean currLeafFieldIsUnicode;
    private boolean prevLeafFieldIsUnicode;
    private boolean currLeafFieldIsDBCS;
    private boolean prevLeafFieldIsDBCS;
    private boolean canRedefineAsChar;

    public RedefineAsCharController(FieldType fieldToRedefine) {
        this.fieldToRedefine = fieldToRedefine;
        this.initialize();
    }

    private RedefineAsCharController() {
    }

    public void initialize() {
        MessageWalker walker = new MessageWalker();
        try {
            this.canRedefineAsChar = false;
            walker.accept((IMessageVisitor)this, this.fieldToRedefine);
            this.canRedefineAsChar = true;
        }
        catch (CannotRedefineAsCharException cannotRedefineAsCharException) {
        }
        catch (MessageWalkerException e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (field == this.fieldToRedefine && redefines) {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_ALREADY_REDEFINES", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine)}));
            throw new CannotRedefineAsCharException();
        }
        if (field != this.fieldToRedefine && redefines) {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_NESTED_RDEF", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(field)}));
            throw new CannotRedefineAsCharException();
        }
        return state;
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.currLeafField = field;
        if (this.fieldToRedefine == this.currLeafField) {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_COMPOSITE_ONLY", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine)}));
            throw new CannotRedefineAsCharException();
        }
        if (redefines) {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_NESTED_RDEF", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField)}));
            throw new CannotRedefineAsCharException();
        }
        NumericFieldType numericField = new NumericFieldType(this.currLeafField);
        if (numericField.isNumeric()) {
            if (!numericField.isZonedDecimal()) {
                this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_NOT_ZONED_DECIMAL", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField)}));
                throw new CannotRedefineAsCharException();
            }
            if (numericField.isSigned() && !numericField.isSignSeparate()) {
                this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_ZONED_DECIMAL_NOT_SIGN_SEPERATE", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField)}));
                throw new CannotRedefineAsCharException();
            }
            this.currLeafFieldIsUnicode = FieldModel.isWCHAROnly(this.currLeafField);
            if (this.prevLeafField != null) {
                if (this.currLeafFieldIsUnicode && !this.prevLeafFieldIsUnicode) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_PREV_NOT_UNICODE", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField), RedefineAsCharController.getFieldPath(this.prevLeafField)}));
                    throw new CannotRedefineAsCharException();
                }
                if (!this.currLeafFieldIsUnicode && this.prevLeafFieldIsUnicode) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_NEXT_NOT_UNICODE", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField), RedefineAsCharController.getFieldPath(this.prevLeafField)}));
                    throw new CannotRedefineAsCharException();
                }
            }
        } else {
            this.currLeafFieldIsUnicode = StringUtils.startsWithIgnoreCase((CharSequence)FieldModel.getEncoding(this.currLeafField), (CharSequence)"UTF-");
            if (this.prevLeafField != null) {
                if (this.currLeafFieldIsUnicode && !this.prevLeafFieldIsUnicode) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_PREV_NOT_UNICODE", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField), RedefineAsCharController.getFieldPath(this.prevLeafField)}));
                    throw new CannotRedefineAsCharException();
                }
                if (!this.currLeafFieldIsUnicode && this.prevLeafFieldIsUnicode) {
                    this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_NEXT_NOT_UNICODE", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField), RedefineAsCharController.getFieldPath(this.prevLeafField)}));
                    throw new CannotRedefineAsCharException();
                }
            }
        }
        this.currLeafFieldIsDBCS = FieldModel.isDBCSOnly(this.currLeafField);
        if (this.prevLeafField != null) {
            if (this.currLeafFieldIsDBCS && !this.prevLeafFieldIsDBCS) {
                this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_PREV_NOT_DBCS", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField), RedefineAsCharController.getFieldPath(this.prevLeafField)}));
                throw new CannotRedefineAsCharException();
            }
            if (!this.currLeafFieldIsDBCS && this.prevLeafFieldIsDBCS) {
                this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_NEXT_NOT_DBCS", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(this.currLeafField), RedefineAsCharController.getFieldPath(this.prevLeafField)}));
                throw new CannotRedefineAsCharException();
            }
        }
        this.prevLeafField = this.currLeafField;
        this.prevLeafFieldIsUnicode = this.currLeafFieldIsUnicode;
        this.prevLeafFieldIsDBCS = this.currLeafFieldIsDBCS;
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType actualField = fieldParents.peek();
        if (actualField != this.fieldToRedefine) {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_CONTAINS_ARRAY", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(actualField)}));
        } else {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_IS_ARRAY", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine)}));
        }
        throw new CannotRedefineAsCharException();
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (field != this.fieldToRedefine) {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_CONTAINS_ARRAY", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine), RedefineAsCharController.getFieldPath(field)}));
        } else {
            this.errorMessages.add(PgmIntXlat.error((String)"RDEFAS_CHAR_IS_ARRAY", (String[])new String[]{RedefineAsCharController.getFieldPath(this.fieldToRedefine)}));
        }
        throw new CannotRedefineAsCharException();
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public boolean isExpandArrays() {
        return false;
    }

    public FieldType getFieldToRedefine() {
        return this.fieldToRedefine;
    }

    public String getEncoding() {
        return FieldModel.getEncoding(this.currLeafField);
    }

    public YesnoType getIsDBCSOnly() {
        return FieldModel.getIsDBCSOnly(this.currLeafField);
    }

    public boolean canRedefineAsChar(boolean logErrors) {
        if (logErrors && ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
            for (String errorMessage : this.errorMessages) {
                ZCeeUILogger.info((String)errorMessage, (Object[])new Object[0]);
            }
        }
        return this.canRedefineAsChar;
    }

    private static String getFieldPath(FieldType field) {
        String fieldPath = "";
        if (field != null && field.getPath() != null) {
            fieldPath = field.getPath();
        }
        return fieldPath;
    }

    public Set<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Set<String> getWarningMessages() {
        return this.warningMessages;
    }

    public Set<String> getInfoMessages() {
        return this.infoMessages;
    }
}

