/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class OriginalFieldPathToFieldVisitor
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, FieldType> fieldPathToField = new LinkedHashMap<String, FieldType>();
    private Map<String, FieldType> fieldPathToParentField = new HashMap<String, FieldType>();
    private Map<String, List<String>> fieldPathToRedefiningFieldPaths = new HashMap<String, List<String>>();
    private Map<FieldType, String> fieldToFieldPath = new HashMap<FieldType, String>();
    private Map<FieldType, FieldType> fieldToArraySubField = new HashMap<FieldType, FieldType>();

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    private void processField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines) throws MessageWalkerException {
        String originalFieldPath = FieldModel.getOriginalFieldPath(field, fieldParents);
        this.fieldPathToField.put(originalFieldPath, field);
        if (!fieldParents.isEmpty()) {
            this.fieldPathToParentField.put(originalFieldPath, fieldParents.peek());
        }
        if (redefines) {
            String redefinedFieldPath = FieldModel.getOriginalRedefinesPath(field, originalFieldPath);
            this.addRedefiningField(redefinedFieldPath, originalFieldPath);
        }
        this.fieldToFieldPath.put(field, originalFieldPath);
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.processField(field, fieldPath, fieldParents, redefines);
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType arrayField = fieldParents.peek();
        FieldType arraySubField = field;
        this.processField(arrayField, fieldPath, fieldParents, redefines);
        this.fieldToArraySubField.put(arrayField, arraySubField);
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.processField(field, fieldPath, fieldParents, redefines);
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.processField(field, fieldPath, fieldParents, redefines);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public boolean isExpandArrays() {
        return false;
    }

    public Map<String, FieldType> getFieldPathToField() {
        return this.fieldPathToField;
    }

    public FieldType getFieldFromFieldPath(String fieldPath) {
        return this.fieldPathToField.get(fieldPath);
    }

    public FieldType getParentFieldFromFieldPath(String fieldPath) {
        return this.fieldPathToParentField.get(fieldPath);
    }

    public List<String> getRedefiningFieldPathsFromFieldPath(String fieldPath) {
        return this.fieldPathToRedefiningFieldPaths.get(fieldPath);
    }

    public String getFieldPathFromField(FieldType field) {
        return this.fieldToFieldPath.get(field);
    }

    public FieldType getArraySubFieldFromField(FieldType field) {
        return this.fieldToArraySubField.get(field);
    }

    public int getRedefiningFieldCount(String fieldPath) {
        int retVal = 0;
        List<String> redefiningFieldPaths = this.fieldPathToRedefiningFieldPaths.get(fieldPath);
        if (redefiningFieldPaths != null) {
            retVal = redefiningFieldPaths.size();
        }
        return retVal;
    }

    private void addRedefiningField(String redefinedFieldPath, String redefiningFieldPath) {
        List<String> redefiningFieldPaths = this.fieldPathToRedefiningFieldPaths.get(redefinedFieldPath);
        if (redefiningFieldPaths == null) {
            redefiningFieldPaths = new ArrayList<String>();
            this.fieldPathToRedefiningFieldPaths.put(redefinedFieldPath, redefiningFieldPaths);
        }
        redefiningFieldPaths.add(redefiningFieldPath);
    }

    public void addRedefiningField(FieldType redefinedField, String redefinedFieldPath, FieldType redefinedFieldParent, FieldType redefiningField, String redefiningFieldPath, FieldType redefiningFieldParent) {
        this.fieldPathToParentField.put(redefiningFieldPath, redefiningFieldParent);
        this.fieldPathToField.put(redefiningFieldPath, redefiningField);
        this.fieldToFieldPath.put(redefiningField, redefiningFieldPath);
        List<String> redefiningFieldPaths = this.fieldPathToRedefiningFieldPaths.get(redefinedFieldPath);
        if (redefiningFieldPaths == null) {
            redefiningFieldPaths = new ArrayList<String>();
            this.fieldPathToRedefiningFieldPaths.put(redefinedFieldPath, redefiningFieldPaths);
        }
        redefiningFieldPaths.add(redefiningFieldPath);
        int redefinedFieldIndex = redefinedFieldParent.getField().indexOf(redefinedField);
        int redefiningFieldCount = this.getRedefiningFieldCount(redefinedFieldPath);
        int redefiningFieldIndex = redefinedFieldIndex + redefiningFieldCount;
        redefinedFieldParent.getField().add(redefiningFieldIndex, redefiningField);
    }
}

