/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.wv.metadata.message.overlay.InterfaceFieldType;
import com.ibm.zosconnect.wv.metadata.message.overlay.MessageInterfaceType;
import com.ibm.zosconnect.wv.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.zosconnect.wv.metadata.message.overlay.YesnoType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.Stack;

public class ModelToInterfaceVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private InterfaceFieldType currParentField;
    private Stack<InterfaceFieldType> parentFieldStack = new Stack();
    private MessageInterfaceType msgInterface;
    private ServiceInterfaceSegmentType currSegment;
    private String tranCode;

    public ModelToInterfaceVisitor(MessageInterfaceType msgInterface, String tranCode) {
        this.msgInterface = msgInterface;
        this.tranCode = tranCode;
    }

    public boolean isExpandArrays() {
        return false;
    }

    public Object startOfMessageType(MessageType message, Object state) {
        this.parentFieldStack.clear();
        return state;
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        this.currSegment = new ServiceInterfaceSegmentType();
        this.msgInterface.getSegment().add(this.currSegment);
        return state;
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) {
        InterfaceFieldType newInterfaceField = new InterfaceFieldType();
        newInterfaceField.setIncluded(YesnoType.Y);
        newInterfaceField.setAssociatedFieldType(field);
        newInterfaceField.setfieldName(field.getName());
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            newInterfaceField.setDefaultValue(defaultValue);
        }
        this.currParentField.getField().add(newInterfaceField);
        Integer startPos = field.getStartPos();
        Integer fieldLength = field.getBytes();
        if (startPos != null && fieldLength != null && fieldLength == 2 && (startPos == 1 || startPos == 3)) {
            newInterfaceField.setIncluded(YesnoType.N);
        }
        if (startPos != null && startPos == 5 && fieldLength != null && fieldLength == 8) {
            newInterfaceField.setDefaultValue(this.tranCode);
            newInterfaceField.setIncluded(YesnoType.N);
        }
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        InterfaceFieldType newInterfaceField = new InterfaceFieldType();
        newInterfaceField.setIncluded(YesnoType.Y);
        newInterfaceField.setAssociatedFieldType(fieldParents.peek());
        newInterfaceField.setfieldName(field.getName());
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            newInterfaceField.setDefaultValue(defaultValue);
        }
        this.currParentField.getField().add(newInterfaceField);
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        InterfaceFieldType newInterfaceField = new InterfaceFieldType();
        newInterfaceField.setIncluded(YesnoType.Y);
        newInterfaceField.setAssociatedFieldType(field);
        newInterfaceField.setfieldName(field.getName());
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            newInterfaceField.setDefaultValue(defaultValue);
        }
        if (this.currParentField != null) {
            this.currParentField.getField().add(newInterfaceField);
        }
        if (this.parentFieldStack.size() == 0) {
            this.currSegment.getInterfaceField().add(newInterfaceField);
        }
        this.currParentField = newInterfaceField;
        this.parentFieldStack.push(newInterfaceField);
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        InterfaceFieldType newInterfaceField = new InterfaceFieldType();
        newInterfaceField.setIncluded(YesnoType.Y);
        newInterfaceField.setAssociatedFieldType(field);
        newInterfaceField.setfieldName(field.getName());
        String defaultValue = field.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            newInterfaceField.setDefaultValue(defaultValue);
        }
        if (this.currParentField != null) {
            this.currParentField.getField().add(newInterfaceField);
        }
        if (this.parentFieldStack.size() == 0) {
            this.currSegment.getInterfaceField().add(newInterfaceField);
        }
        this.currParentField = newInterfaceField;
        this.parentFieldStack.push(newInterfaceField);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentFieldStack.pop();
        this.currParentField = !this.parentFieldStack.isEmpty() ? this.parentFieldStack.peek() : null;
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.parentFieldStack.pop();
        this.currParentField = !this.parentFieldStack.isEmpty() ? this.parentFieldStack.peek() : null;
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        this.currParentField = null;
        return state;
    }

    public int getVariableArrayOccurrenceCount(FieldType dynArrayField) {
        return 1;
    }

    public int getCountedArrayOccurrenceCount(FieldType arg0) throws MessageWalkerException {
        return 1;
    }
}

