/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FindCountedArrayVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.OriginalFieldPathToFieldVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.RedefineAsCharController;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.FoundCountedArrayException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.BooleanOverrideTypeValidator;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanRequest;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanResponse;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class FieldInfoPreservationVisitor
extends JSONConversionVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FieldType oldStruct;
    private final FieldType newStruct;
    private OriginalFieldPathToFieldVisitor oldStructVisitor;
    private OriginalFieldPathToFieldVisitor newStructVisitor;
    private List<FieldType> newArrayCounters;

    public FieldInfoPreservationVisitor(FieldType oldStruct, FieldType newStruct) {
        this.oldStruct = oldStruct;
        this.newStruct = newStruct;
        this.newArrayCounters = new ArrayList<FieldType>();
        this.visitStructs();
    }

    private void visitStructs() {
        try {
            this.oldStructVisitor = new OriginalFieldPathToFieldVisitor();
            new MessageWalker().accept((IMessageVisitor)this.oldStructVisitor, this.oldStruct);
        }
        catch (MessageWalkerException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        try {
            this.newStructVisitor = new OriginalFieldPathToFieldVisitor();
            new MessageWalker().accept((IMessageVisitor)this.newStructVisitor, this.newStruct);
        }
        catch (MessageWalkerException e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    public boolean isExpandArrays() {
        return false;
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field);
        return state;
    }

    private void doFieldInfoPreservation(FieldType oldField) {
        FieldType newField;
        String oldFieldPath = this.oldStructVisitor.getFieldPathFromField(oldField);
        if (FieldModel.isUserDefined(oldField) && FieldModel.isRedefiningField(oldField)) {
            String oldRedefinedFieldPath = FieldModel.getOriginalRedefinesPath(oldField, oldFieldPath);
            FieldType oldRedefinedFieldParent = this.oldStructVisitor.getParentFieldFromFieldPath(oldRedefinedFieldPath);
            FieldType newRedefinedField = this.newStructVisitor.getFieldFromFieldPath(oldRedefinedFieldPath);
            if (newRedefinedField != null) {
                String newRedefinedFieldPath = this.newStructVisitor.getFieldPathFromField(newRedefinedField);
                FieldType newRedefinedFieldParent = this.newStructVisitor.getParentFieldFromFieldPath(newRedefinedFieldPath);
                if (newRedefinedField != null && newRedefinedFieldParent != null) {
                    this.doFieldPreservation_userRedefiningField(oldField, oldFieldPath, oldRedefinedFieldParent, newRedefinedField, newRedefinedFieldPath, newRedefinedFieldParent);
                }
            }
        }
        if ((newField = this.newStructVisitor.getFieldPathToField().get(oldFieldPath)) != null) {
            this.doFieldPreservation_common(oldField, oldFieldPath, newField);
            this.doFieldPreservation_datatypeOverride(oldField, oldFieldPath, newField);
            this.doFieldPreservation_arrayCounters(oldField, oldFieldPath, newField);
        }
    }

    private void doFieldPreservation_userRedefiningField(FieldType oldRedefiningField, String oldRedefiningFieldPath, FieldType oldRedefinedFieldParent, FieldType newRedefinedField, String newRedefinedFieldPath, FieldType newRedefinedFieldParent) {
        if (FieldModel.isCHARField(oldRedefiningField)) {
            this.doFieldPreservation_userRedefiningField_CHAR(oldRedefiningField, oldRedefiningFieldPath, oldRedefinedFieldParent, newRedefinedField, newRedefinedFieldPath, newRedefinedFieldParent);
        }
    }

    private void doFieldPreservation_userRedefiningField_CHAR(FieldType oldRedefiningField, String oldRedefiningFieldPath, FieldType oldRedefinedFieldParent, FieldType newRedefinedField, String newRedefinedFieldPath, FieldType newRedefinedFieldParent) {
        RedefineAsCharController rdefAsChar = new RedefineAsCharController(newRedefinedField);
        if (rdefAsChar.canRedefineAsChar(true)) {
            oldRedefiningField.setStartPos(newRedefinedField.getStartPos());
            oldRedefiningField.setBytes(newRedefinedField.getBytes());
            oldRedefiningField.setMaxBytes(newRedefinedField.getMaxBytes());
            FieldModel.setEncoding(oldRedefiningField, rdefAsChar.getEncoding());
            FieldModel.setIsDBCSOnly(oldRedefiningField, rdefAsChar.getIsDBCSOnly());
            this.newStructVisitor.addRedefiningField(newRedefinedField, newRedefinedFieldPath, newRedefinedFieldParent, oldRedefiningField, oldRedefiningFieldPath, oldRedefinedFieldParent);
        }
    }

    private void doFieldPreservation_common(FieldType oldField, String oldFieldPath, FieldType newField) {
        FieldType newSubField;
        newField.setName(oldField.getName());
        newField.setRemarks(oldField.getRemarks());
        newField.setIncluded(oldField.getIncluded());
        newField.setPath(oldField.getPath());
        if (!MessageWalker.isArray((FieldType)newField) && !MessageWalker.isCompositeField((FieldType)newField)) {
            newField.setDefaultValue(oldField.getDefaultValue());
            newField.setCodepageConversion(oldField.getCodepageConversion());
            newField.setIsHex(oldField.isIsHex());
        }
        if (MessageWalker.isVariableLengthArray((FieldType)newField) && MessageWalker.isVariableLengthArray((FieldType)oldField)) {
            newField.setDependsOnPath(oldField.getDependsOnPath());
        }
        if ((newSubField = this.newStructVisitor.getArraySubFieldFromField(newField)) != null) {
            newSubField.setIncluded(oldField.getIncluded());
        }
    }

    private void doFieldPreservation_datatypeOverride(FieldType oldField, String oldFieldPath, FieldType newField) {
        DatatypeOverride overrideType = oldField.getDatatypeOverride();
        newField.setDatatypeOverride(overrideType);
        if (overrideType instanceof BooleanOverrideType) {
            this.doFieldPreservation_booleanOverrideType(oldField, oldFieldPath, newField, (BooleanOverrideType)overrideType);
        }
    }

    private void doFieldPreservation_booleanOverrideType(FieldType oldField, String oldFieldPath, FieldType newField, BooleanOverrideType overrideType) {
        BooleanRequest booleanRequest = overrideType.getBooleanRequest();
        BooleanResponse booleanResponse = overrideType.getBooleanResponse();
        if (JSONConversionUtil.isNumeric((FieldType)newField) || !BooleanOverrideTypeValidator.canOverrideAsBoolean(newField)) {
            if (booleanRequest != null) {
                booleanRequest.setTrueValueIsHex(false);
                booleanRequest.setFalseValueIsHex(false);
            }
            if (booleanResponse != null) {
                booleanResponse.setTrueValueIsHex(false);
                booleanResponse.setFalseValueIsHex(false);
            }
        }
    }

    private void doFieldPreservation_arrayCounters(FieldType oldField, String oldFieldPath, FieldType newField) {
        newField.setIsCounter(oldField.isCounter());
        if (MessageWalker.isArray((FieldType)oldField) && MessageWalker.isArray((FieldType)newField) && StringUtils.isNotBlank((CharSequence)oldField.getCounterPath())) {
            newField.setCounter(oldField.getCounter());
            newField.setCounterPath(oldField.getCounterPath());
            newField.setOriginalMinOccurs(newField.getMinOccurs());
            newField.setMinOccurs(oldField.getMinOccurs());
        }
        if (BooleanUtils.isTrue((Boolean)newField.isCounter())) {
            this.newArrayCounters.add(newField);
        }
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType arrayParentField = fieldParents.peek();
        this.doFieldInfoPreservation(arrayParentField);
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field);
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.doFieldInfoPreservation(field);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (FieldInfoPreservationVisitor.isTopLevelField(field)) {
            this.postProcessArrayCountersInMergedStructure();
        }
        return state;
    }

    private void postProcessArrayCountersInMergedStructure() {
        for (FieldType newArrayCounter : this.newArrayCounters) {
            FindCountedArrayVisitor visitor = new FindCountedArrayVisitor(newArrayCounter);
            try {
                new MessageWalker().accept((IMessageVisitor)visitor, this.newStruct);
                newArrayCounter.setIsCounter(null);
            }
            catch (FoundCountedArrayException foundCountedArrayException) {
            }
            catch (Exception unexpected) {
                ZCeeUILogger.error((Throwable)unexpected);
            }
        }
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public int getVariableArrayOccurrenceCount(FieldType dynArrayField) {
        int retVal = -1;
        return retVal;
    }

    public int getCountedArrayOccurrenceCount(FieldType arrayField) throws MessageWalkerException {
        return 0;
    }

    private static boolean isTopLevelField(FieldType field) {
        return field != null && field.getName() != null && field.getName().equals(field.getPath());
    }
}

