/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfMonth;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeHexLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeMonthOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYearOfCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParseResult;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternToken;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.InvalidValueException;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.ApplicationDatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DateComponentType;
import com.ibm.zosconnect.wv.metadata.transaction.DateComponentTypeType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.PatternDateType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.transaction.messages.NumericFieldType;
import com.ibm.zosconnect.wv.transaction.messages.exceptions.InvalidHexValueException;
import com.ibm.zosconnect.wv.transaction.messages.exceptions.UnbalancedHexValueException;
import com.ibm.zosconnect.wv.transaction.messages.exceptions.ValueScaleTooLargeException;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

public class FieldEditorController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FieldType fieldType;
    private String origFieldValue;
    private String origFieldRemarks;
    private String newFieldValue;
    private String newFieldName;
    private String newFieldRemarks;
    private String encoding;
    private boolean isHex;
    private boolean isCodepageChecked;
    private String origCounterPath;
    private String newCounterPath;
    private FieldType origCounterField;
    private FieldType newCounterField;
    private Integer minimumItems;
    private boolean isCounter;
    private DatatypeOverride datatypeOverride;

    public FieldEditorController(FieldType fieldType, String origValue, String origRemarks, String encoding) {
        this.fieldType = fieldType;
        this.origFieldValue = origValue;
        this.origFieldRemarks = origRemarks;
        this.encoding = encoding;
        this.datatypeOverride = fieldType.getDatatypeOverride();
    }

    public int getByteSize() {
        return this.fieldType.getBytes();
    }

    public void validateValue(String value) throws InvalidValueException {
        DatatypeType dataType = this.fieldType.getApplicationDatatype().getDatatype();
        Integer size = this.fieldType.getBytes();
        if (dataType != null && !value.isEmpty()) {
            if (dataType == DatatypeType.CHAR) {
                if (JSONConversionUtil.isValueTooLong((FieldType)this.fieldType, (String)value)) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_LONG", (String[])new String[]{String.valueOf(size)}));
                }
            } else {
                if (dataType == DatatypeType.FLOAT) {
                    try {
                        Float.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_FLOAT_NAN"));
                    }
                }
                if (dataType == DatatypeType.DOUBLE) {
                    try {
                        Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_DOUBLE_NAN"));
                    }
                }
                try {
                    if (JSONConversionUtil.isValueTooLarge((FieldType)this.fieldType, (String)value)) {
                        BigInteger maximumValue = new BigInteger(JSONConversionUtil.getMaxValueAsString((FieldType)this.fieldType));
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_LARGE", (String[])new String[]{String.valueOf(maximumValue)}));
                    }
                    if (JSONConversionUtil.isValueTooSmall((FieldType)this.fieldType, (String)value)) {
                        BigInteger minimumValue = new BigInteger(JSONConversionUtil.getMinValueAsString((FieldType)this.fieldType));
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_SMALL", (String[])new String[]{String.valueOf(minimumValue)}));
                    }
                }
                catch (ValueScaleTooLargeException valueScaleTooLargeException) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_SCALE_TOO_LARGE"));
                }
            }
        }
    }

    public void validateHexValue(String value) throws InvalidValueException {
        Integer size = this.fieldType.getBytes();
        DatatypeType dataType = this.fieldType.getApplicationDatatype().getDatatype();
        if (dataType != null) {
            try {
                int hexSize = size * 2;
                if (JSONConversionUtil.isHexValueTooLong((FieldType)this.fieldType, (String)value)) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_LONG", (Object[])new Object[]{hexSize}));
                }
                if (JSONConversionUtil.isHexValueTooShort((FieldType)this.fieldType, (String)value)) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_SHORT", (Object[])new Object[]{hexSize}));
                }
            }
            catch (InvalidHexValueException invalidHexValueException) {
                throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_CHAR"));
            }
            catch (UnbalancedHexValueException unbalancedHexValueException) {
                int hexSize = size * 2;
                if (value.length() < hexSize) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_SHORT", (Object[])new Object[]{hexSize}));
                }
                throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_LONG", (Object[])new Object[]{hexSize}));
            }
        }
    }

    public void validateDateOverrideValue(DateTimePatternParseResult result) throws InvalidValueException {
        DatatypeType dataType = this.fieldType.getApplicationDatatype().getDatatype();
        List<DateTimePatternToken> tokenList = result.getTokens();
        Iterator<DateTimePatternToken> it = tokenList.iterator();
        String unBoxedPattern = "";
        String unBoxedHexLiteralPattern = "";
        while (it.hasNext()) {
            DateTimePatternToken currToken = it.next();
            String tokenText = currToken.getText();
            if (currToken instanceof DateTimeHexLiteral) {
                if (dataType != DatatypeType.CHAR) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_LITERAL_NUMERIC_FIELD"));
                }
                unBoxedHexLiteralPattern = unBoxedHexLiteralPattern.concat(((DateTimeHexLiteral)currToken).getLiteral());
                if (!FieldEditorController.isWideCharField(this.fieldType) || ((DateTimeHexLiteral)currToken).getLiteral().length() % 4 == 0) continue;
                throw new InvalidValueException(PgmIntXlat.error((String)"DT_UNICODE_HEX_LITERAL_ENCODING_UNIT_ERROR"));
            }
            if (currToken instanceof DateTimeLiteral) {
                String unBoxedLiteral = ((DateTimeLiteral)currToken).getLiteral();
                if (dataType != DatatypeType.CHAR) {
                    try {
                        new BigInteger(unBoxedLiteral);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_LITERAL_NOT_INT", (String[])new String[]{unBoxedLiteral}));
                    }
                }
                unBoxedPattern = unBoxedPattern.concat(unBoxedLiteral);
                continue;
            }
            unBoxedPattern = unBoxedPattern.concat(tokenText);
        }
        if (dataType != null) {
            int patternLen = unBoxedPattern.length();
            if (dataType == DatatypeType.CHAR) {
                BigInteger maxSize;
                if (FieldEditorController.isWideCharField(this.fieldType)) {
                    if (!unBoxedHexLiteralPattern.isEmpty()) {
                        patternLen += unBoxedHexLiteralPattern.length() / 4;
                    }
                } else if (!unBoxedHexLiteralPattern.isEmpty()) {
                    patternLen += unBoxedHexLiteralPattern.length() / 2;
                }
                if ((maxSize = JSONConversionUtil.getMaxValueLengthInCodeUnits((FieldType)this.fieldType)).compareTo(BigInteger.valueOf(patternLen)) < 0) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"DT_EXCEEDS_CHARS", (Object[])new Object[]{maxSize}));
                }
            } else {
                NumericFieldType numericField = new NumericFieldType(this.fieldType);
                if (unBoxedPattern.length() > numericField.getPrecision()) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"DT_EXCEEDS_DIGITS", (Object[])new Object[]{numericField.getPrecision()}));
                }
            }
        }
    }

    public String getPatternText(PatternDateType patternDate) {
        String retVal = "";
        for (DateComponentType currComponent : patternDate.getDateComponent()) {
            DateComponentTypeType currType = currComponent.getType();
            switch (currType) {
                case Century: {
                    retVal = retVal.concat(new DateTimeCentury().getText());
                    break;
                }
                case DayOfMonth: {
                    retVal = retVal.concat(new DateTimeDayOfMonth().getText());
                    break;
                }
                case DayOfYear: {
                    retVal = retVal.concat(new DateTimeDayOfYear().getText());
                    break;
                }
                case MonthOfYear: {
                    retVal = retVal.concat(new DateTimeMonthOfYear().getText());
                    break;
                }
                case Year: {
                    retVal = retVal.concat(new DateTimeYear().getText());
                    break;
                }
                case YearOfCentury: {
                    retVal = retVal.concat(new DateTimeYearOfCentury().getText());
                    break;
                }
                case HexLiteral: {
                    retVal = retVal.concat("%'" + currComponent.getValue() + "'");
                    break;
                }
                case Literal: {
                    retVal = retVal.concat("'" + currComponent.getValue() + "'");
                    break;
                }
            }
        }
        return retVal;
    }

    public void validateBooleanOverrideValue(String value) throws InvalidValueException {
        DatatypeType dataType = this.fieldType.getApplicationDatatype().getDatatype();
        Integer size = this.fieldType.getBytes();
        if (dataType != null) {
            if (dataType == DatatypeType.CHAR) {
                if (JSONConversionUtil.isValueTooLong((FieldType)this.fieldType, (String)value)) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_LONG", (Object[])new Object[]{size}));
                }
            } else {
                try {
                    new BigInteger(value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_NOT_INT"));
                }
                try {
                    if (JSONConversionUtil.isValueTooLarge((FieldType)this.fieldType, (String)value)) {
                        String maximumValue = JSONConversionUtil.getMaxValueAsString((FieldType)this.fieldType);
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_LARGE", (String[])new String[]{maximumValue}));
                    }
                    if (JSONConversionUtil.isValueTooSmall((FieldType)this.fieldType, (String)value)) {
                        String minimumValue = JSONConversionUtil.getMinValueAsString((FieldType)this.fieldType);
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_SMALL", (String[])new String[]{minimumValue}));
                    }
                }
                catch (ValueScaleTooLargeException valueScaleTooLargeException) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_NOT_INT"));
                }
            }
        }
    }

    public void validateBooleanOverrideHexValue(String value) throws InvalidValueException {
        Integer size = this.fieldType.getBytes();
        DatatypeType dataType = this.fieldType.getApplicationDatatype().getDatatype();
        if (dataType != null) {
            try {
                if (dataType == DatatypeType.CHAR) {
                    int hexSize = size * 2;
                    if (JSONConversionUtil.isHexValueTooLong((FieldType)this.fieldType, (String)value)) {
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_LONG", (Object[])new Object[]{hexSize}));
                    }
                    if (JSONConversionUtil.isHexValueTooShort((FieldType)this.fieldType, (String)value)) {
                        throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_SHORT", (Object[])new Object[]{hexSize}));
                    }
                }
            }
            catch (InvalidHexValueException invalidHexValueException) {
                throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_CHAR"));
            }
            catch (UnbalancedHexValueException unbalancedHexValueException) {
                int hexSize = size * 2;
                if (value.length() < hexSize) {
                    throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_SHORT", (Object[])new Object[]{hexSize}));
                }
                throw new InvalidValueException(PgmIntXlat.error((String)"EF_ERROR_HEX_LONG", (Object[])new Object[]{hexSize}));
            }
        }
    }

    public String getFieldName() {
        String fieldName = null;
        if (this.fieldType != null) {
            fieldName = this.fieldType.getName();
        }
        return fieldName;
    }

    public ApplicationDatatypeType getApplicationDatatype() {
        ApplicationDatatypeType appDataType = null;
        if (this.fieldType != null && this.fieldType.getApplicationDatatype() != null) {
            appDataType = this.fieldType.getApplicationDatatype();
        }
        return appDataType;
    }

    public String getDataType() {
        String dataType = null;
        if (this.fieldType != null && this.fieldType.getApplicationDatatype() != null && this.fieldType.getApplicationDatatype().getDatatype() != null) {
            dataType = this.fieldType.getApplicationDatatype().getDatatype().name();
        }
        return dataType;
    }

    public boolean isArrayField() {
        return this.fieldType != null && this.fieldType.getApplicationDatatype() != null && DatatypeType.ARRAY.equals((Object)this.fieldType.getApplicationDatatype().getDatatype());
    }

    public boolean isDatatype(DatatypeType datatype) {
        return this.fieldType != null && this.fieldType.getApplicationDatatype() != null && datatype.equals((Object)this.fieldType.getApplicationDatatype().getDatatype());
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public String getOrigFieldValue() {
        return this.origFieldValue;
    }

    public void setOrigFieldValue(String origFieldValue) {
        this.origFieldValue = origFieldValue;
    }

    public String getOrigFieldRemarks() {
        return this.origFieldRemarks;
    }

    public void setOrigFieldRemarks(String origFieldRemarks) {
        this.origFieldRemarks = origFieldRemarks;
    }

    public String getNewFieldValue() {
        return this.newFieldValue;
    }

    public void setNewFieldValue(String newFieldValue) {
        this.newFieldValue = newFieldValue;
    }

    public String getNewFieldName() {
        return this.newFieldName;
    }

    public void setNewFieldName(String newFieldName) {
        this.newFieldName = newFieldName;
    }

    public String getNewFieldRemarks() {
        return this.newFieldRemarks;
    }

    public void setNewFieldRemarks(String newFieldRemarks) {
        this.newFieldRemarks = newFieldRemarks;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isHex() {
        return this.isHex;
    }

    public void setHex(boolean isHex) {
        this.isHex = isHex;
    }

    public boolean isCodepageChecked() {
        return this.isCodepageChecked;
    }

    public void setCodepageChecked(boolean isCodepageChecked) {
        this.isCodepageChecked = isCodepageChecked;
    }

    public FieldType getOrigCounterField() {
        return this.origCounterField;
    }

    public void setOrigCounterField(FieldType origCounterField) {
        this.origCounterField = origCounterField;
    }

    public FieldType getNewCounterField() {
        return this.newCounterField;
    }

    public void setNewCounterField(FieldType newCounterField) {
        this.newCounterField = newCounterField;
    }

    public Integer getMinimumItems() {
        return this.minimumItems;
    }

    public void setMinimumItems(Integer minimumItems) {
        this.minimumItems = minimumItems;
    }

    public boolean isCounter() {
        return this.isCounter;
    }

    public void setCounter(boolean isCounter) {
        this.isCounter = isCounter;
    }

    public String getOrigCounterPath() {
        return this.origCounterPath;
    }

    public void setOrigCounterPath(String origCounterPath) {
        this.origCounterPath = origCounterPath;
    }

    public String getNewCounterPath() {
        return this.newCounterPath;
    }

    public void setNewCounterPath(String newCounterPath) {
        this.newCounterPath = newCounterPath;
    }

    public DatatypeOverride getDatatypeOverride() {
        return this.datatypeOverride;
    }

    public void setDatatypeOverride(DatatypeOverride datatypeOverride) {
        this.datatypeOverride = datatypeOverride;
    }

    public String getFieldPath() {
        String fieldPath = "";
        if (this.fieldType != null && this.fieldType.getPath() != null) {
            fieldPath = this.fieldType.getPath();
        }
        return fieldPath;
    }

    public boolean isNativeCharField() {
        return FieldEditorController.isNativeCharField(this.fieldType);
    }

    public static boolean isNativeCharField(FieldType field) {
        MarshallerType marshaller;
        if (field == null || field.getApplicationDatatype() == null || field.getApplicationDatatype().getDatatype() == null) {
            return false;
        }
        boolean retVal = false;
        ApplicationDatatypeType appDatatype = field.getApplicationDatatype();
        DatatypeType datatype = appDatatype.getDatatype();
        if (DatatypeType.CHAR.equals((Object)datatype)) {
            if (field.getMarshaller() == null) {
                retVal = true;
            } else {
                MarshallerType marshaller2 = field.getMarshaller();
                if (marshaller2.getEncoding() == null && !YesnoType.Y.equals((Object)marshaller2.getIsDBCSOnly())) {
                    retVal = true;
                }
            }
        } else if (DatatypeType.DECIMAL.equals((Object)datatype) && field.getMarshaller() != null && (marshaller = field.getMarshaller()).getEncoding() == null && !YesnoType.Y.equals((Object)marshaller.getIsDBCSOnly())) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isWideCharField() {
        return FieldEditorController.isWideCharField(this.fieldType);
    }

    public static boolean isWideCharField(FieldType field) {
        MarshallerType marshaller;
        if (field == null || field.getApplicationDatatype() == null || field.getApplicationDatatype().getDatatype() == null) {
            return false;
        }
        boolean retVal = false;
        ApplicationDatatypeType appDatatype = field.getApplicationDatatype();
        DatatypeType datatype = appDatatype.getDatatype();
        if (DatatypeType.CHAR.equals((Object)datatype) && field.getMarshaller() != null && "UTF-16BE".equals((marshaller = field.getMarshaller()).getEncoding())) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isDBCSOnlyCharField() {
        return FieldEditorController.isDBCSOnlyCharField(this.fieldType);
    }

    public static boolean isDBCSOnlyCharField(FieldType field) {
        MarshallerType marshaller;
        if (field == null || field.getApplicationDatatype() == null || field.getApplicationDatatype().getDatatype() == null) {
            return false;
        }
        boolean retVal = false;
        ApplicationDatatypeType appDatatype = field.getApplicationDatatype();
        DatatypeType datatype = appDatatype.getDatatype();
        if (DatatypeType.CHAR.equals((Object)datatype) && field.getMarshaller() != null && YesnoType.Y.equals((Object)(marshaller = field.getMarshaller()).getIsDBCSOnly())) {
            retVal = true;
        }
        return retVal;
    }

    public int getEncodingUnitSize() {
        int retVal = -1;
        if (this.isWideCharField() || this.isDBCSOnlyCharField()) {
            retVal = 2;
        } else if (this.isNativeCharField()) {
            retVal = 1;
        }
        return retVal;
    }
}

