/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.InterfaceToUIVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.JSONCharacterEscapes;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.ModelToInterfaceVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.model.GwTreeObject;
import com.ibm.zosconnect.ui.programinterface.controllers.model.GwTreeParent;
import com.ibm.zosconnect.ui.programinterface.controllers.model.InterfaceFieldNode;
import com.ibm.zosconnect.ui.programinterface.controllers.model.MessageNode;
import com.ibm.zosconnect.ui.programinterface.controllers.model.SegmentNode;
import com.ibm.zosconnect.ui.programinterface.controllers.model.ServiceNode;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.wv.gateway.rest.models.GatewayMetadataInterface;
import com.ibm.zosconnect.wv.gateway.rest.models.GatewayService;
import com.ibm.zosconnect.wv.metadata.message.overlay.MessageInterfaceType;
import com.ibm.zosconnect.wv.metadata.message.overlay.ServiceInterface;
import com.ibm.zosconnect.wv.metadata.message.overlay.ServiceInterfaceSegmentType;
import com.ibm.zosconnect.wv.metadata.message.overlay.YesnoType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONSchemaVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;

public class EditServiceController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TRIM_OUTPUT_LEADING_WHITESPACE = "TRIM_OUTPUT_LEADING_WHITESPACE";
    public static final String TRIM_OUTPUT_TRAILING_WHITESPACE = "TRIM_OUTPUT_TRAILING_WHITESPACE";
    public static final String ESCAPE_CONTROL_CHARACTERS = "ESCAPE_CONTROL_CHARACTERS";
    public static final String INITIALIZE_INPUT_FIELDS = "INITIALIZE_INPUT_FIELD";
    public static final String OMIT_FIELDS_BY_VALUE = "OMIT_FIELDS_BY_VALUE";
    public static final String OMIT_FIELDS_BY_VALUE_BYTE = "OMIT_FIELDS_BY_VALUE_BYTE";
    public static final String OMIT_EMPTY_FIELDS = "OMIT_EMPTY_FIELDS";
    public static final String ENFORCE_MIN_ARRAY_OCCURENCE = "ENFORCE_MIN_ARRAY_OCCURENCE";
    public static final String CONVERSION_TYPE_NONE = "NONE";
    public static final String CONVERSION_TYPE_IN = "IN";
    public static final String CONVERSION_TYPE_OUT = "OUT";
    public static final String CONVERSION_TYPE_INOUT = "INOUT";
    private GatewayService service;
    private InterfaceToUIVisitor inputUiVisitor;
    private List<InterfaceToUIVisitor> outputUiVisitors = new ArrayList<InterfaceToUIVisitor>();
    private boolean editingExisting;
    private boolean edited = false;
    private boolean messageEdited = false;
    private String projectName;
    private List<String> allPgmInterfaces = null;
    private List<String> allRequestDataStructures = null;
    private List<String> allResponseDataStructures = null;
    private HashMap<String, GatewayMetadataInterface> prevInterfaces = new HashMap();
    private ServiceNode invisibleRootRequest;
    private ServiceNode invisibleRootResponse;

    public EditServiceController(String serviceName) {
        this.projectName = serviceName;
    }

    public void updateMsgListsForSelectedPgmName() throws CoreException, JAXBException {
        String selectedPgmInterface = this.service.getResourceName();
        ArrayList<String> projectNames = ProjectTreeFileHelper.getProjectList(new String[]{"com.ibm.ims.zcee.transaction.nature"});
        int i = 0;
        while (i < projectNames.size()) {
            String currProjectName = (String)projectNames.get(i);
            this.allPgmInterfaces = ProjectTreeFileHelper.getzCEEProgramInterfaceNames(currProjectName);
            int j = 0;
            while (j < this.allPgmInterfaces.size()) {
                String currPgmInterface = this.allPgmInterfaces.get(j);
                if (currPgmInterface.equals(selectedPgmInterface)) {
                    this.allRequestDataStructures = ProjectTreeFileHelper.getzCEEDataStructureNames(currProjectName, selectedPgmInterface, 0);
                    this.allResponseDataStructures = ProjectTreeFileHelper.getzCEEDataStructureNames(currProjectName, selectedPgmInterface, 1);
                }
                ++j;
            }
            ++i;
        }
    }

    public GatewayService getGwService() {
        return this.service;
    }

    public ServiceNode getInvisibleRootRequest() {
        return this.invisibleRootRequest;
    }

    public ServiceNode getInvisibleRootResponse() {
        return this.invisibleRootResponse;
    }

    public static boolean isInputField(InterfaceFieldNode fieldNode) {
        boolean retVal = false;
        SegmentNode segmentNode = EditServiceController.getSegmentNode(fieldNode);
        MessageNode msgNode = (MessageNode)segmentNode.getParent();
        if (msgNode.getMsgDirection() == 0) {
            retVal = true;
        }
        return retVal;
    }

    private static SegmentNode getSegmentNode(GwTreeObject node) {
        GwTreeParent parent = node.getParent();
        if (parent instanceof SegmentNode) {
            return (SegmentNode)parent;
        }
        return EditServiceController.getSegmentNode(parent);
    }

    public static boolean isLeafField(InterfaceFieldNode fieldNode) {
        boolean retVal = true;
        DatatypeType dataType = fieldNode.getInterfaceField().getAssociatedFieldType().getApplicationDatatype().getDatatype();
        if (dataType == DatatypeType.ARRAY || dataType == DatatypeType.STRUCT) {
            retVal = false;
        }
        return retVal;
    }

    public void populateInputInterface() throws MessageWalkerException, JAXBException, CoreException {
        String tranCode = this.service.getResourceName();
        GatewayMetadataInterface inputInterface = this.service.getServiceInputInterface();
        if (inputInterface == null) {
            return;
        }
        String msgName = inputInterface.getMetadataName();
        if (tranCode != null && !tranCode.isEmpty() && msgName != null && !msgName.isEmpty()) {
            this.invisibleRootRequest.removeChildren();
            MessageWalker mw = new MessageWalker();
            this.inputUiVisitor = new InterfaceToUIVisitor(this.service.getServiceInputInterface().getServiceInterface().getInterface());
            Message msg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg(this.projectName, msgName);
            mw.accept((IMessageVisitor)this.inputUiVisitor, msg.getMessage());
            this.populateIoMessageNodes(this.invisibleRootRequest, 0);
        }
    }

    public void populateOutputInterface() throws MessageWalkerException, JAXBException, CoreException {
        String tranCode = this.service.getResourceName();
        List interfaces = this.service.getServiceOutputInterface();
        if (interfaces == null || interfaces.size() <= 0) {
            return;
        }
        String msgName = ((GatewayMetadataInterface)interfaces.get(0)).getMetadataName();
        if (tranCode != null && !tranCode.isEmpty() && msgName != null && !msgName.isEmpty()) {
            this.invisibleRootResponse.removeChildren();
            MessageWalker mw = new MessageWalker();
            this.outputUiVisitors.clear();
            this.outputUiVisitors.add(0, new InterfaceToUIVisitor(((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getServiceInterface().getInterface()));
            String outputMsgName = ((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getMetadataName();
            Message msg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg(this.projectName, outputMsgName);
            mw.accept((IMessageVisitor)this.outputUiVisitors.get(0), msg.getMessage());
            this.populateIoMessageNodes(this.invisibleRootResponse, 1);
        }
    }

    public void setDefaultValue(InterfaceFieldNode interfaceField, String defaultValue) {
        this.edited = true;
        interfaceField.getInterfaceField().setDefaultValue(defaultValue);
    }

    public void setIncluded(InterfaceFieldNode interfaceField, YesnoType included) {
        this.edited = true;
        interfaceField.getInterfaceField().setIncluded(included);
    }

    public void populateIoMessageNodes(ServiceNode parent, int msgDirection) {
        if (msgDirection == 0) {
            MessageNode inputMsgNode = new MessageNode(this.service.getServiceInputInterface().getMetadataName(), parent, this.service.getServiceInputInterface().getServiceInterface().getInterface(), 0);
            parent.addChild(inputMsgNode);
            this.populateSegmentNodes(inputMsgNode);
        } else {
            MessageNode outputMsgNode = new MessageNode(((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getMetadataName(), parent, ((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getServiceInterface().getInterface(), 1);
            parent.addChild(outputMsgNode);
            this.populateSegmentNodes(outputMsgNode);
        }
    }

    public void populateSegmentNodes(MessageNode parent) {
        List segmentList = parent.getMsgInterface().getSegment();
        int i = 0;
        while (i < segmentList.size()) {
            ServiceInterfaceSegmentType currSegment = (ServiceInterfaceSegmentType)segmentList.get(i);
            SegmentNode segmentNode = new SegmentNode("Segment " + (i + 1), parent, currSegment);
            parent.addChild(segmentNode);
            this.populateDataStructureAndFieldNodes(segmentNode, i);
            ++i;
        }
    }

    public void populateDataStructureAndFieldNodes(SegmentNode parent, int segmentIx) {
        List<InterfaceFieldNode> fieldList = null;
        MessageNode msgNode = (MessageNode)parent.getParent();
        fieldList = msgNode.getMsgDirection() == 0 ? this.inputUiVisitor.getInterfaceFieldNodes(segmentIx) : this.outputUiVisitors.get(0).getInterfaceFieldNodes(segmentIx);
        int i = 0;
        while (i < fieldList.size()) {
            InterfaceFieldNode currField = fieldList.get(i);
            parent.addChild(currField);
            ++i;
        }
    }

    public void createNewProfile(IPreferenceStore store) {
        this.editingExisting = false;
        this.service = new GatewayService();
        this.initMobileDataConversionOptions(this.service, store);
        GatewayMetadataInterface inputMdi = new GatewayMetadataInterface();
        MessageInterfaceType inputMsgInterface = new MessageInterfaceType();
        ServiceInterface inputServiceInterface = new ServiceInterface();
        inputServiceInterface.setInterface(inputMsgInterface);
        inputMdi.setServiceInterface(inputServiceInterface);
        this.service.setServiceInputInterface(inputMdi);
        GatewayMetadataInterface outputMdi = new GatewayMetadataInterface();
        MessageInterfaceType outputMsgInterface = new MessageInterfaceType();
        ServiceInterface outputServiceInterface = new ServiceInterface();
        outputServiceInterface.setInterface(outputMsgInterface);
        outputMdi.setServiceInterface(outputServiceInterface);
        this.service.getServiceOutputInterface().add(outputMdi);
    }

    private void initMobileDataConversionOptions(GatewayService gwService, IPreferenceStore store) {
        if (store == null) {
            gwService.setTrimOutputTrailingWhitespace(Boolean.valueOf(true));
            gwService.setTrimOutputLeadingWhitespace(Boolean.valueOf(false));
            gwService.setInitializeInputFields(Boolean.valueOf(false));
            gwService.setEnforceMinArrayOccurrence(Boolean.valueOf(false));
            gwService.setEscapeOutputControlCharacters(Boolean.valueOf(false));
            gwService.setOmitOutputFieldsByValue(Boolean.valueOf(false));
            gwService.setOmitOutputFieldsByValueByte("00");
            gwService.setOmitOutputEmptyTags(Boolean.valueOf(false));
        } else {
            gwService.setTrimOutputTrailingWhitespace(Boolean.valueOf(store.getBoolean(TRIM_OUTPUT_TRAILING_WHITESPACE)));
            gwService.setTrimOutputLeadingWhitespace(Boolean.valueOf(store.getBoolean(TRIM_OUTPUT_LEADING_WHITESPACE)));
            gwService.setInitializeInputFields(Boolean.valueOf(store.getBoolean(INITIALIZE_INPUT_FIELDS)));
            gwService.setEnforceMinArrayOccurrence(Boolean.valueOf(store.getBoolean(ENFORCE_MIN_ARRAY_OCCURENCE)));
            gwService.setEscapeOutputControlCharacters(Boolean.valueOf(store.getBoolean(ESCAPE_CONTROL_CHARACTERS)));
            gwService.setOmitOutputFieldsByValue(Boolean.valueOf(store.getBoolean(OMIT_FIELDS_BY_VALUE)));
            gwService.setOmitOutputFieldsByValueByte(store.getString(OMIT_FIELDS_BY_VALUE_BYTE));
            gwService.setOmitOutputEmptyTags(Boolean.valueOf(store.getBoolean(OMIT_EMPTY_FIELDS)));
        }
    }

    public boolean editingExisting() {
        return this.editingExisting;
    }

    public void generateBinServiceArtifact(String requestDS, String responseDS) throws JAXBException, CoreException, MessageWalkerException, IOException {
        this.service = new GatewayService();
        this.service.setServiceName(this.projectName);
        if (requestDS != null && !requestDS.isEmpty()) {
            this.createInitialInterface(0, requestDS);
        }
        if (responseDS != null && !responseDS.isEmpty()) {
            this.createInitialInterface(1, responseDS);
        }
        this.doSave();
        MessageWalker messageWalker = new MessageWalker();
        MessageInterfaceType inputInterface = this.service.getServiceInputInterface().getServiceInterface().getInterface();
        JSONSchemaVisitor schemaVisitor = new JSONSchemaVisitor(inputInterface);
        Message requestMsg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg(this.projectName, requestDS);
        MessageType inputMessageType = requestMsg.getMessage();
        messageWalker.accept((IMessageVisitor)schemaVisitor, inputMessageType);
        HashMap inputJsonSchemaMap = schemaVisitor.getHashMap();
        String inputJsonSchemaStr = EditServiceController.convertToJson(inputJsonSchemaMap, true);
        MessageInterfaceType outputInterface = ((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getServiceInterface().getInterface();
        JSONSchemaVisitor responseSchemaVisitor = new JSONSchemaVisitor(outputInterface);
        Message respMsg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg(this.projectName, responseDS);
        MessageType outputMessageType = respMsg.getMessage();
        messageWalker.accept((IMessageVisitor)responseSchemaVisitor, outputMessageType);
        HashMap responseJsonSchemaMap = responseSchemaVisitor.getHashMap();
        String outputJsonSchemaStr = EditServiceController.convertToJson(responseJsonSchemaMap, true);
        ProjectTreeFileHelper.marshallzCEESchemas(this.projectName, inputJsonSchemaStr, outputJsonSchemaStr);
    }

    public static String convertToJson(HashMap<String, Object> nvMap, boolean pretty) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.WRAP_EXCEPTIONS);
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectMapper.enable(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JsonNode resultNode = (JsonNode)objectMapper.convertValue(nvMap, JsonNode.class);
        MappingJsonFactory factory = new MappingJsonFactory();
        factory.setCharacterEscapes((CharacterEscapes)new JSONCharacterEscapes());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        JsonGenerator generator = factory.createGenerator((OutputStream)bytes, JsonEncoding.UTF8);
        if (pretty) {
            generator.useDefaultPrettyPrinter().writeTree((TreeNode)resultNode);
        } else {
            generator.writeTree((TreeNode)resultNode);
        }
        return new String(bytes.toByteArray(), Charset.forName("UTF-8"));
    }

    public void createInitialInterface(int msgDirection, String msgName) throws MessageWalkerException, JAXBException, CoreException {
        String pgmName = this.service.getResourceName();
        if (msgDirection == 0) {
            Message gwMsg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg(this.projectName, msgName);
            MessageType inputMessageType = gwMsg.getMessage();
            GatewayMetadataInterface inputMdi = new GatewayMetadataInterface();
            inputMdi.setMetadataName(msgName);
            MessageInterfaceType inputMsgInterface = new MessageInterfaceType();
            ServiceInterface inputServiceInterface = new ServiceInterface();
            inputServiceInterface.setInterface(inputMsgInterface);
            inputMdi.setServiceInterface(inputServiceInterface);
            this.service.setServiceInputInterface(inputMdi);
            MessageInterfaceType msgInterfaceType = this.service.getServiceInputInterface().getServiceInterface().getInterface();
            MessageWalker messageWalker = new MessageWalker();
            String tranCode = this.service.getTrancodeOverride();
            if (tranCode == null || tranCode.isEmpty()) {
                tranCode = pgmName;
            }
            ModelToInterfaceVisitor visitor = new ModelToInterfaceVisitor(msgInterfaceType, tranCode);
            messageWalker.accept((IMessageVisitor)visitor, inputMessageType);
        } else {
            Message gwMsg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg(this.projectName, msgName);
            GatewayMetadataInterface outputMdi = new GatewayMetadataInterface();
            outputMdi.setMetadataName(msgName);
            MessageInterfaceType outputMsgInterface = new MessageInterfaceType();
            ServiceInterface outputServiceInterface = new ServiceInterface();
            outputServiceInterface.setInterface(outputMsgInterface);
            outputMdi.setServiceInterface(outputServiceInterface);
            this.service.getServiceOutputInterface().add(outputMdi);
            MessageInterfaceType msgInterfaceType = ((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getServiceInterface().getInterface();
            MessageWalker messageWalker = new MessageWalker();
            String tranCode = this.service.getTrancodeOverride();
            if (tranCode == null || tranCode.isEmpty()) {
                tranCode = pgmName;
            }
            ModelToInterfaceVisitor visitor = new ModelToInterfaceVisitor(msgInterfaceType, tranCode);
            messageWalker.accept((IMessageVisitor)visitor, gwMsg.getMessage());
        }
    }

    public void setInputMessageName(String name) throws MessageWalkerException, JAXBException, CoreException {
        this.edited = true;
        this.messageEdited = true;
        String interfaceKey = this.service.getResourceName() + "." + name;
        GatewayMetadataInterface inputMdi = this.prevInterfaces.get(interfaceKey);
        if (inputMdi == null) {
            this.createInitialInterface(0, name);
        } else {
            this.service.setServiceInputInterface(inputMdi);
        }
    }

    public void setOutputMessageName(String name) throws MessageWalkerException, JAXBException, CoreException {
        this.edited = true;
        this.messageEdited = true;
        String interfaceKey = this.service.getResourceName() + "." + name;
        GatewayMetadataInterface outputMdi = this.prevInterfaces.get(interfaceKey);
        if (outputMdi == null) {
            this.createInitialInterface(1, name);
        } else {
            this.service.getServiceOutputInterface().add(outputMdi);
        }
    }

    public void clearInterface(int msgDirection) {
        GatewayMetadataInterface metadataInterface = null;
        if (msgDirection == 0) {
            metadataInterface = this.service.getServiceInputInterface();
            this.service.setServiceInputInterface(null);
            this.invisibleRootRequest = new ServiceNode("", null);
        } else {
            List intList = this.service.getServiceOutputInterface();
            if (intList != null && intList.size() > 0) {
                metadataInterface = (GatewayMetadataInterface)intList.get(0);
                intList.remove(0);
            }
            this.invisibleRootResponse = new ServiceNode("", null);
        }
        if (metadataInterface != null) {
            String interfaceKey = this.service.getResourceName() + "." + metadataInterface.getMetadataName();
            this.prevInterfaces.put(interfaceKey, metadataInterface);
        }
    }

    public String getInputMessageName() {
        return this.service.getServiceInputInterface().getMetadataName();
    }

    public String getOutputMessageName() {
        return ((GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0)).getMetadataName();
    }

    public String getModifiedBy() {
        return this.service.getModifiedBy();
    }

    public void setModifiedBy(String modifiedBy) {
        this.edited = true;
        this.service.setModifiedBy(modifiedBy);
    }

    public String getModifiedTime() {
        String retVal = null;
        Timestamp timeStamp = this.service.getModifiedTime();
        if (timeStamp != null) {
            retVal = timeStamp.toString();
        }
        return retVal;
    }

    public void setModifiedTime(String modifiedTime) {
        this.edited = true;
        this.service.setModifiedTime(Timestamp.valueOf(modifiedTime));
    }

    public String getServiceType() {
        return this.service.getServiceType();
    }

    public String getResourceType() {
        return this.service.getResourceType();
    }

    public String getResourceName() {
        return this.service.getResourceName();
    }

    public String getDatastoreOverride() {
        return this.service.getDatastoreOverride();
    }

    public String getTrancodeOverride() {
        return this.service.getTrancodeOverride();
    }

    public int getVersion() {
        int retVal = 0;
        if (this.service.getVersion() != null) {
            retVal = this.service.getVersion();
        }
        return retVal;
    }

    public void setVersion(String version) {
        this.edited = true;
        this.service.setVersion(Integer.valueOf(version));
    }

    public String getServiceName() {
        return this.service.getServiceName();
    }

    public String getServicePropertyName() {
        return this.service.getServicePropertyName();
    }

    public String getServiceConnectionName() {
        String retVal = null;
        List conns = this.service.getServiceConnections();
        if (conns != null && !conns.isEmpty()) {
            retVal = (String)conns.get(0);
        }
        return retVal;
    }

    public List<String> getServiceConnections() {
        return this.service.getServiceConnections();
    }

    public void moveConnUp(String connName) {
        int currIdx;
        this.edited = true;
        List connNameList = this.service.getServiceConnections();
        if (connNameList != null && (currIdx = connNameList.indexOf(connName)) != 0) {
            connNameList.remove(connName);
            connNameList.add(currIdx - 1, connName);
            this.service.setServiceConnections(connNameList);
        }
    }

    public void moveConnDown(String connName) {
        this.edited = true;
        List connNameList = this.service.getServiceConnections();
        if (connNameList != null) {
            int size = connNameList.size();
            int currIdx = connNameList.indexOf(connName);
            if (currIdx != size - 1) {
                connNameList.remove(connName);
                connNameList.add(currIdx + 1, connName);
                this.service.setServiceConnections(connNameList);
            }
        }
    }

    public void addConnection(String connName) {
        this.edited = true;
        this.service.getServiceConnections().add(connName);
    }

    public void setEditedTrue() {
        this.edited = true;
    }

    public void clearConnection() {
        this.edited = true;
        this.service.getServiceConnections().clear();
    }

    public void deleteConnection(String connName) {
        this.edited = true;
        this.service.getServiceConnections().remove(connName);
    }

    public void setServiceName(String serviceName) {
        this.edited = true;
        this.service.setServiceName(serviceName);
    }

    public void setServicePropertyName(String servicePropertyName) {
        this.edited = true;
        this.service.setServicePropertyName(servicePropertyName);
    }

    public void setServiceType(String serviceType) {
        this.edited = true;
        this.service.setServiceType(serviceType);
    }

    public void setResourceType(String resourceType) {
        this.edited = true;
        this.service.setResourceType(resourceType);
    }

    public void setResourceName(String resourceName) {
        this.edited = true;
        this.service.setResourceName(resourceName);
    }

    public void setTrancodeOverride(String tranCodeOverride) {
        this.edited = true;
        this.service.setTrancodeOverride(tranCodeOverride);
    }

    public void setComments(String comments) {
        this.edited = true;
        this.service.setComments(comments);
    }

    public String getComments() {
        return this.service.getComments();
    }

    public Integer getConversionType() {
        return this.service.getConversionType();
    }

    public void setConversionType(String conversionType) {
        this.edited = true;
        Integer type = conversionType.equalsIgnoreCase(CONVERSION_TYPE_IN) ? Integer.valueOf(1) : (conversionType.equalsIgnoreCase(CONVERSION_TYPE_OUT) ? Integer.valueOf(2) : (conversionType.equalsIgnoreCase(CONVERSION_TYPE_INOUT) ? Integer.valueOf(3) : Integer.valueOf(0)));
        this.service.setConversionType(type);
    }

    public Integer getDataProtocol() {
        return this.service.getDataProtocol();
    }

    public void setDataProtocol(Integer dataProtocol) {
        this.edited = true;
        this.service.setDataProtocol(dataProtocol);
    }

    public void setDatastoreOverride(String datastoreOverride) {
        this.edited = true;
        this.service.setDatastoreOverride(datastoreOverride);
    }

    public void setStatus(String statusStr) {
        this.edited = true;
        Integer status = statusStr.equalsIgnoreCase("ENABLED") ? Integer.valueOf(1) : Integer.valueOf(2);
        this.service.setStatus(status);
    }

    public String toString() {
        return this.service.toString();
    }

    public boolean canFinish() {
        boolean retVal = true;
        if (!this.edited) {
            retVal = false;
        } else {
            GatewayMetadataInterface inputInterface;
            String propertiesProfName;
            String serviceName = this.service.getServiceName();
            if (serviceName == null || serviceName.isEmpty()) {
                retVal = false;
            }
            if ((propertiesProfName = this.service.getServicePropertyName()) == null || propertiesProfName.isEmpty()) {
                retVal = false;
            }
            if (this.service.getServiceConnections().size() == 0) {
                retVal = false;
            }
            if ((inputInterface = this.service.getServiceInputInterface()) == null) {
                retVal = false;
            } else {
                String inputMsgName = inputInterface.getMetadataName();
                if (inputMsgName == null || inputMsgName.isEmpty()) {
                    retVal = false;
                }
            }
            GatewayMetadataInterface outputInterface = (GatewayMetadataInterface)this.service.getServiceOutputInterface().get(0);
            if (outputInterface == null) {
                retVal = false;
            } else {
                String outputMsgName = outputInterface.getMetadataName();
                if (outputMsgName == null || outputMsgName.isEmpty()) {
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    public boolean isMessageEdited() {
        return this.messageEdited;
    }

    public void resetMessageEdited() {
        this.messageEdited = false;
    }

    public boolean isServiceEdited() {
        return this.edited;
    }

    public void doSave() throws JAXBException, CoreException {
        ProjectTreeFileHelper.marshallzCEEService(this.service);
    }

    public String getSelectedTrancode() {
        return this.service.getResourceName();
    }

    public String getSelectedInputMsgName() {
        String retVal = null;
        GatewayMetadataInterface inputInterface = this.service.getServiceInputInterface();
        if (inputInterface != null) {
            retVal = inputInterface.getMetadataName();
        }
        return retVal;
    }

    public String getSelectedOutputMsgName() {
        String retVal = null;
        List outputInterface = this.service.getServiceOutputInterface();
        if (outputInterface != null && outputInterface.size() > 0) {
            retVal = ((GatewayMetadataInterface)outputInterface.get(0)).getMetadataName();
        }
        return retVal;
    }

    public List<String> getRequestDataStructuresForSelectedPgmInterface() {
        return this.allRequestDataStructures;
    }

    public List<String> getResponseDataStructuresForSelectedPgmInterface() {
        return this.allResponseDataStructures;
    }

    public List<String> getAllPgmInterfaces() {
        return this.allPgmInterfaces;
    }

    public boolean pgmNameExists(String pgmName) {
        boolean retVal = false;
        int i = 0;
        while (i < this.allPgmInterfaces.size()) {
            if (pgmName.trim().equals(this.allPgmInterfaces.get(i).trim())) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }
}

