/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.BooleanOverrideTypeValidator;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.DateOverrideTypeValidator;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DateOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class CheckDatatypeOverridesVisitor
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<FieldType, List<String>> fieldErrorMessages;
    private Map<FieldType, List<String>> fieldWarningMessages;
    private Map<FieldType, List<String>> fieldInfoMessages;
    private BooleanOverrideTypeValidator booleanValidator;
    private DateOverrideTypeValidator dateValidator;
    private boolean isRequestSI;

    public CheckDatatypeOverridesVisitor(boolean isRequestSI) {
        this.isRequestSI = isRequestSI;
        this.fieldErrorMessages = new HashMap<FieldType, List<String>>();
        this.fieldWarningMessages = new HashMap<FieldType, List<String>>();
        this.fieldInfoMessages = new HashMap<FieldType, List<String>>();
        this.booleanValidator = new BooleanOverrideTypeValidator(isRequestSI);
        this.dateValidator = new DateOverrideTypeValidator();
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (CheckDatatypeOverridesVisitor.hasDatatypeOverride(field)) {
            this.validateLeafFieldDatatypeOverride(field);
        }
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        field = fieldParents.peek();
        if (CheckDatatypeOverridesVisitor.hasDatatypeOverride(field)) {
            this.validateLeafArrayFieldDatatypeOverride(field);
        }
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (CheckDatatypeOverridesVisitor.hasDatatypeOverride(field)) {
            this.validateCompositeFieldDatatypeOverride(field);
        }
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (CheckDatatypeOverridesVisitor.hasDatatypeOverride(field)) {
            this.validateCompositeArrayFieldDatatypeOverride(field);
        }
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public boolean isExpandArrays() {
        return false;
    }

    private void validateLeafFieldDatatypeOverride(FieldType field) {
        DatatypeOverride overrideType = field.getDatatypeOverride();
        if (overrideType instanceof BooleanOverrideType) {
            this.booleanValidator.validate(field);
            this.addErrorMessages(field, this.booleanValidator.getErrorMessages());
        } else if (overrideType instanceof DateOverrideType) {
            this.dateValidator.validate(field);
            this.addErrorMessages(field, this.dateValidator.getErrorMessages());
        }
    }

    private void validateLeafArrayFieldDatatypeOverride(FieldType field) {
        this.addErrorMessage(field, PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_NON_LEAF", (String[])new String[]{CheckDatatypeOverridesVisitor.getFieldPath(field)}));
    }

    private void validateCompositeFieldDatatypeOverride(FieldType field) {
        this.addErrorMessage(field, PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_NON_LEAF", (String[])new String[]{CheckDatatypeOverridesVisitor.getFieldPath(field)}));
    }

    private void validateCompositeArrayFieldDatatypeOverride(FieldType field) {
        this.addErrorMessage(field, PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_NON_LEAF", (String[])new String[]{CheckDatatypeOverridesVisitor.getFieldPath(field)}));
    }

    private static boolean hasDatatypeOverride(FieldType field) {
        boolean hasDatatypeOverride = false;
        if (field != null && field.getDatatypeOverride() != null) {
            hasDatatypeOverride = true;
        }
        return hasDatatypeOverride;
    }

    private static String getFieldPath(FieldType field) {
        String fieldPath = "";
        if (field != null && field.getPath() != null) {
            fieldPath = field.getPath();
        }
        return fieldPath;
    }

    private void addErrorMessage(FieldType field, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        List<String> errorMessages = this.fieldErrorMessages.get(field);
        if (errorMessages == null) {
            errorMessages = new ArrayList<String>();
            this.fieldErrorMessages.put(field, errorMessages);
        }
        errorMessages.add(message);
    }

    private void addErrorMessages(FieldType field, List<String> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        List<String> errorMessages = this.fieldErrorMessages.get(field);
        if (errorMessages == null) {
            errorMessages = new ArrayList<String>();
            this.fieldErrorMessages.put(field, errorMessages);
        }
        errorMessages.addAll(messages);
    }

    public Map<FieldType, List<String>> getFieldErrorMessages() {
        return this.fieldErrorMessages;
    }

    public Map<FieldType, List<String>> getFieldWarningMessages() {
        return this.fieldWarningMessages;
    }

    public Map<FieldType, List<String>> getFieldInfoMessages() {
        return this.fieldInfoMessages;
    }

    public boolean isRequestSI() {
        return this.isRequestSI;
    }

    public void setRequestSI(boolean isRequestSI) {
        this.isRequestSI = isRequestSI;
    }
}

