/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class CheckArrayCountersVisitor
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<FieldType, List<String>> fieldErrorMessages = new HashMap<FieldType, List<String>>();
    private Map<FieldType, List<String>> fieldWarningMessages = new HashMap<FieldType, List<String>>();
    private Map<FieldType, List<String>> fieldInfoMessages = new HashMap<FieldType, List<String>>();
    private List<FieldType> allFields = new ArrayList<FieldType>();
    private List<FieldType> countedArrayFields = new ArrayList<FieldType>();
    private Stack<FieldType> compositeArrayFieldStack = new Stack();
    private Stack<String> compositeRedefinesFieldStack = new Stack();
    private LinkedHashMap<String, FieldType> fieldPathToField = new LinkedHashMap();
    private LinkedHashMap<FieldType, FieldType> fieldToRedefinesCompositeField = new LinkedHashMap();
    private LinkedHashMap<FieldType, FieldType> odoObjectToSubjectField = new LinkedHashMap();
    private LinkedHashMap<FieldType, List<FieldType>> fieldToParentArrayFields = new LinkedHashMap();

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType odoObjectField;
        String dependsOnPath;
        field = fieldParents.peek();
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        if ((dependsOnPath = field.getDependsOnPath()) != null && !dependsOnPath.isEmpty() && (odoObjectField = this.fieldPathToField.get(dependsOnPath)) != null) {
            this.odoObjectToSubjectField.put(odoObjectField, field);
        }
        if (StringUtils.isNotBlank((CharSequence)field.getCounterPath())) {
            this.countedArrayFields.add(field);
        }
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (redefines && !CheckArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.push(field.getPath());
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType odoObjectField;
        String dependsOnPath;
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (redefines && !CheckArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.push(field.getPath());
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        if ((dependsOnPath = field.getDependsOnPath()) != null && !dependsOnPath.isEmpty() && (odoObjectField = this.fieldPathToField.get(dependsOnPath)) != null) {
            this.odoObjectToSubjectField.put(odoObjectField, field);
        }
        this.compositeArrayFieldStack.push(field);
        if (StringUtils.isNotBlank((CharSequence)field.getCounterPath())) {
            this.countedArrayFields.add(field);
        }
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines && !CheckArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.pop();
        }
        if (CheckArrayCountersVisitor.isTopLevelField(field)) {
            this.validateCountedArrayFields();
        }
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines && !CheckArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.pop();
        }
        this.compositeArrayFieldStack.pop();
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public boolean isExpandArrays() {
        return false;
    }

    private void validateCountedArrayFields() {
        for (FieldType countedArray : this.countedArrayFields) {
            FieldType arrayRedefinesComposite;
            FieldType counterRedefinesComposite;
            int arrayPosition;
            int counterPosition;
            FieldType arrayCounter = null;
            String counterPath = countedArray.getCounterPath();
            arrayCounter = this.fieldPathToField.get(counterPath);
            if (arrayCounter == null) {
                this.addErrorMessage(countedArray, PgmIntXlat.error((String)"COUNTER_DOES_NOT_EXIST", (String[])new String[]{counterPath, CheckArrayCountersVisitor.getFieldPath(countedArray)}));
            }
            if (arrayCounter == null) continue;
            if (MessageWalker.isArray((FieldType)arrayCounter) || MessageWalker.isLeafArrayField((FieldType)arrayCounter) || MessageWalker.isCompositeField((FieldType)arrayCounter)) {
                this.addErrorMessage(countedArray, PgmIntXlat.error((String)"COUNTER_NOT_LEAF_FIELD", (String[])new String[]{CheckArrayCountersVisitor.getFieldPath(arrayCounter), CheckArrayCountersVisitor.getFieldPath(countedArray)}));
                continue;
            }
            if (!JSONConversionUtil.isInteger((FieldType)arrayCounter)) {
                this.addErrorMessage(countedArray, PgmIntXlat.error((String)"COUNTER_NOT_AN_INTEGER", (String[])new String[]{CheckArrayCountersVisitor.getFieldPath(arrayCounter), CheckArrayCountersVisitor.getFieldPath(countedArray)}));
            }
            if ((counterPosition = this.allFields.indexOf(arrayCounter)) > (arrayPosition = this.allFields.indexOf(countedArray))) {
                this.addErrorMessage(countedArray, PgmIntXlat.error((String)"COUNTER_NOT_LOCATED_BEFORE", (String[])new String[]{CheckArrayCountersVisitor.getFieldPath(arrayCounter), CheckArrayCountersVisitor.getFieldPath(countedArray)}));
            }
            List<FieldType> counterParentArrays = this.fieldToParentArrayFields.get(arrayCounter);
            List<FieldType> arrayParentArrays = this.fieldToParentArrayFields.get(countedArray);
            if (counterParentArrays != null && arrayParentArrays == null || counterParentArrays == null && arrayParentArrays != null || counterParentArrays != null && arrayParentArrays != null && !counterParentArrays.equals(arrayParentArrays)) {
                this.addErrorMessage(countedArray, PgmIntXlat.error((String)"COUNTER_DIFFERENT_PARENT_ARRAYS", (String[])new String[]{CheckArrayCountersVisitor.getFieldPath(arrayCounter), CheckArrayCountersVisitor.getFieldPath(countedArray)}));
            }
            if ((counterRedefinesComposite = this.fieldToRedefinesCompositeField.get(arrayCounter)) == (arrayRedefinesComposite = this.fieldToRedefinesCompositeField.get(countedArray))) continue;
            this.addErrorMessage(countedArray, PgmIntXlat.error((String)"COUNTER_DIFFERENT_PARENT_REDEFINES", (String[])new String[]{CheckArrayCountersVisitor.getFieldPath(arrayCounter), CheckArrayCountersVisitor.getFieldPath(countedArray)}));
        }
    }

    private static String getFieldPath(FieldType field) {
        String fieldPath = "";
        if (field != null && field.getPath() != null) {
            fieldPath = field.getPath();
        }
        return fieldPath;
    }

    private static Boolean isTrue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    private static boolean isTopLevelField(FieldType field) {
        return field != null && field.getName() != null && field.getName().equals(field.getPath());
    }

    private void addErrorMessage(FieldType field, String message) {
        List<String> errorMessages = this.fieldErrorMessages.get(field);
        if (errorMessages == null) {
            errorMessages = new ArrayList<String>();
            this.fieldErrorMessages.put(field, errorMessages);
        }
        errorMessages.add(message);
    }

    public Map<FieldType, List<String>> getFieldErrorMessages() {
        return this.fieldErrorMessages;
    }

    public Map<FieldType, List<String>> getFieldWarningMessages() {
        return this.fieldWarningMessages;
    }

    public Map<FieldType, List<String>> getFieldInfoMessages() {
        return this.fieldInfoMessages;
    }
}

