/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.editor;

import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class CandidateArrayCountersVisitor
implements IMessageVisitor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FieldType selectedArrayField;
    private List<FieldType> allFields;
    private List<FieldType> candidateCounterFields;
    private Stack<FieldType> compositeArrayFieldStack;
    private Stack<String> compositeRedefinesFieldStack;
    private LinkedHashMap<String, FieldType> fieldPathToField;
    private LinkedHashMap<FieldType, FieldType> fieldToRedefinesCompositeField;
    private LinkedHashMap<FieldType, FieldType> existingCounterToArrayField;
    private LinkedHashMap<FieldType, FieldType> odoObjectToSubjectField;
    private LinkedHashMap<FieldType, List<FieldType>> fieldToParentArrayFields;
    private LinkedHashMap<FieldType, List<String>> errorMessages;

    public CandidateArrayCountersVisitor(FieldType selectedArrayField) {
        this.selectedArrayField = selectedArrayField;
        this.allFields = new ArrayList<FieldType>();
        this.candidateCounterFields = new ArrayList<FieldType>();
        this.compositeArrayFieldStack = new Stack();
        this.compositeRedefinesFieldStack = new Stack();
        this.fieldPathToField = new LinkedHashMap();
        this.fieldToRedefinesCompositeField = new LinkedHashMap();
        this.existingCounterToArrayField = new LinkedHashMap();
        this.odoObjectToSubjectField = new LinkedHashMap();
        this.fieldToParentArrayFields = new LinkedHashMap();
        this.errorMessages = new LinkedHashMap();
    }

    public Object startOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object startOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        throw new MessageWalkerException((Throwable)new IllegalStateException("Expected a FieldType for an 01 level data structure"));
    }

    public Object leafField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        this.candidateCounterFields.add(field);
        return state;
    }

    public Object leafArrayField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType counterField;
        String counterPath;
        FieldType odoObjectField;
        String dependsOnPath;
        field = fieldParents.peek();
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        if ((dependsOnPath = field.getDependsOnPath()) != null && !dependsOnPath.isEmpty() && (odoObjectField = this.fieldPathToField.get(dependsOnPath)) != null) {
            this.odoObjectToSubjectField.put(odoObjectField, field);
        }
        if ((counterPath = field.getCounterPath()) != null && !counterPath.isEmpty() && (counterField = this.fieldPathToField.get(counterPath)) != null) {
            this.existingCounterToArrayField.put(counterField, field);
        }
        return state;
    }

    public Object startOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (redefines && !CandidateArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.push(field.getPath());
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        return state;
    }

    public Object startOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        FieldType counterField;
        String counterPath;
        FieldType odoObjectField;
        String dependsOnPath;
        this.allFields.add(field);
        this.fieldPathToField.put(field.getPath(), field);
        if (!this.compositeRedefinesFieldStack.isEmpty()) {
            String redefinesCompositePath = this.compositeRedefinesFieldStack.peek();
            this.fieldToRedefinesCompositeField.put(field, this.fieldPathToField.get(redefinesCompositePath));
        }
        if (redefines && !CandidateArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.push(field.getPath());
        }
        if (!this.compositeArrayFieldStack.isEmpty()) {
            this.fieldToParentArrayFields.put(field, new ArrayList<FieldType>(this.compositeArrayFieldStack));
        }
        if ((dependsOnPath = field.getDependsOnPath()) != null && !dependsOnPath.isEmpty() && (odoObjectField = this.fieldPathToField.get(dependsOnPath)) != null) {
            this.odoObjectToSubjectField.put(odoObjectField, field);
        }
        if ((counterPath = field.getCounterPath()) != null && !counterPath.isEmpty() && (counterField = this.fieldPathToField.get(counterPath)) != null) {
            this.existingCounterToArrayField.put(counterField, field);
        }
        this.compositeArrayFieldStack.push(field);
        return state;
    }

    public Object endOfCompositeField(FieldType field, FieldPath fieldPath, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines && !CandidateArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.pop();
        }
        if (CandidateArrayCountersVisitor.isTopLevelField(field)) {
            this.filterCandidateCounterFields();
        }
        return state;
    }

    public Object endOfCompositeArrayField(FieldType field, FieldPath fieldPath, int index, int upperbound, Stack<FieldType> fieldParents, boolean redefines, Object state) throws MessageWalkerException {
        if (redefines && !CandidateArrayCountersVisitor.isTopLevelField(field)) {
            this.compositeRedefinesFieldStack.pop();
        }
        this.compositeArrayFieldStack.pop();
        return state;
    }

    public Object endOfSegmentType(SegmentType segment, Object state) throws MessageWalkerException {
        return state;
    }

    public Object endOfMessageType(MessageType message, Object state) throws MessageWalkerException {
        return state;
    }

    public boolean isExpandArrays() {
        return false;
    }

    private void filterCandidateCounterFields() {
        ArrayList<FieldType> invalidCandidates = new ArrayList<FieldType>();
        for (FieldType candidateCounter : this.candidateCounterFields) {
            FieldType arrayRedefinesComposite;
            FieldType counterRedefinesComposite;
            int arrayPosition;
            int counterPosition;
            DatatypeOverride overrideType;
            FieldType countedArray;
            boolean invalid = false;
            ArrayList<String> messages = new ArrayList<String>();
            if (CandidateArrayCountersVisitor.isTrue(candidateCounter.isCounter()).booleanValue() && (countedArray = this.existingCounterToArrayField.get(candidateCounter)) != null && !StringUtils.equals((CharSequence)countedArray.getPath(), (CharSequence)this.selectedArrayField.getPath())) {
                invalid = true;
                messages.add(PgmIntXlat.error((String)"FIELD_ALREADY_COUNTER", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter), CandidateArrayCountersVisitor.getFieldPath(countedArray)}));
            }
            if (CandidateArrayCountersVisitor.isTrue(candidateCounter.isDependedOn()).booleanValue()) {
                invalid = true;
                FieldType odoSubject = this.odoObjectToSubjectField.get(candidateCounter);
                messages.add(PgmIntXlat.error((String)"FIELD_ALREADY_DEPENDED_ON", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter), CandidateArrayCountersVisitor.getFieldPath(odoSubject)}));
            }
            if ((overrideType = candidateCounter.getDatatypeOverride()) != null) {
                invalid = true;
                messages.add(PgmIntXlat.error((String)"FIELD_ALREADY_OVERRIDDEN_AS_TYPE", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter), OverrideTypeUtil.getUIStringFromType(overrideType)}));
            }
            if (!JSONConversionUtil.isInteger((FieldType)candidateCounter)) {
                invalid = true;
                messages.add(PgmIntXlat.error((String)"FIELD_NOT_AN_INTEGER", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter)}));
            }
            if ((counterPosition = this.allFields.indexOf(candidateCounter)) > (arrayPosition = this.allFields.indexOf(this.selectedArrayField))) {
                invalid = true;
                messages.add(PgmIntXlat.error((String)"FIELD_NOT_LOCATED_BEFORE", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter), CandidateArrayCountersVisitor.getFieldPath(this.selectedArrayField)}));
            }
            List<FieldType> counterParentArrays = this.fieldToParentArrayFields.get(candidateCounter);
            List<FieldType> arrayParentArrays = this.fieldToParentArrayFields.get(this.selectedArrayField);
            if (counterParentArrays != null && arrayParentArrays == null || counterParentArrays == null && arrayParentArrays != null || counterParentArrays != null && arrayParentArrays != null && !counterParentArrays.equals(arrayParentArrays)) {
                invalid = true;
                messages.add(PgmIntXlat.error((String)"FIELD_DIFFERENT_PARENT_ARRAYS", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter), CandidateArrayCountersVisitor.getFieldPath(this.selectedArrayField)}));
            }
            if ((counterRedefinesComposite = this.fieldToRedefinesCompositeField.get(candidateCounter)) != (arrayRedefinesComposite = this.fieldToRedefinesCompositeField.get(this.selectedArrayField))) {
                invalid = true;
                messages.add(PgmIntXlat.error((String)"FIELD_DIFFERENT_PARENT_REDEFINES", (String[])new String[]{CandidateArrayCountersVisitor.getFieldPath(candidateCounter), CandidateArrayCountersVisitor.getFieldPath(this.selectedArrayField)}));
            }
            if (!invalid) continue;
            invalidCandidates.add(candidateCounter);
            this.errorMessages.put(candidateCounter, messages);
        }
        this.candidateCounterFields.removeAll(invalidCandidates);
    }

    private static String getFieldPath(FieldType field) {
        String fieldPath = "";
        if (field != null && field.getPath() != null) {
            fieldPath = field.getPath();
        }
        return fieldPath;
    }

    private static Boolean isTrue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    private static boolean isTopLevelField(FieldType field) {
        return field != null && field.getName() != null && field.getName().equals(field.getPath());
    }

    public List<FieldType> getCandidateCounterFields() {
        return this.candidateCounterFields;
    }

    public String[] getCandidateCounterFieldPaths(boolean includeBlankPath) {
        List<FieldType> counterFields = this.getCandidateCounterFields();
        int counterFieldPathCount = counterFields.size() + (includeBlankPath ? 1 : 0);
        String[] counterFieldPaths = new String[counterFieldPathCount];
        int counterFieldPathIndex = 0;
        if (includeBlankPath) {
            counterFieldPaths[0] = "";
            ++counterFieldPathIndex;
        }
        for (FieldType counterField : counterFields) {
            counterFieldPaths[counterFieldPathIndex] = counterField.getPath();
            ++counterFieldPathIndex;
        }
        return counterFieldPaths;
    }

    public LinkedHashMap<FieldType, List<String>> getErrorMessages() {
        return this.errorMessages;
    }

    public FieldType getSelectedArrayField() {
        return this.selectedArrayField;
    }

    public List<FieldType> getAllFields() {
        return this.allFields;
    }

    public LinkedHashMap<FieldType, FieldType> getExistingCounterToArrayField() {
        return this.existingCounterToArrayField;
    }

    public Map<FieldType, FieldType> getFieldToRedefinesCompositeField() {
        return this.fieldToRedefinesCompositeField;
    }

    public LinkedHashMap<FieldType, FieldType> getOdoObjectToSubjectField() {
        return this.odoObjectToSubjectField;
    }

    public LinkedHashMap<FieldType, List<FieldType>> getFieldToParentArrayFields() {
        return this.fieldToParentArrayFields;
    }

    public LinkedHashMap<String, FieldType> getFieldPathToField() {
        return this.fieldPathToField;
    }

    public FieldType getFieldFromPath(String fieldPath) {
        return this.fieldPathToField.get(fieldPath);
    }
}

