/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser;

import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfMonth;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeHexLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeMonthOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYearOfCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParseResult;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParserConstants;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternProposal;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DateTimeProposalGenerator
implements DateTimePatternParserConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final List<String> PrefixLiterals = Arrays.asList("CC".substring(0, 1), "CC".substring(0, 1).toLowerCase(), "dd".substring(0, 1), "DDD".substring(0, 1), "MM".substring(0, 1), "MM".substring(0, 1).toLowerCase(), "yyyy".substring(0, 1), "YY".substring(0, 1));
    private DateTimePatternParseResult parseResult;
    private int currentColumn;
    private DateTimePatternToken prevToken;
    private DateTimePatternToken currToken;
    private DateTimePatternToken nextToken;

    private DateTimeProposalGenerator() {
    }

    public DateTimeProposalGenerator(DateTimePatternParseResult parseResult, int currentColumn) {
        this.parseResult = parseResult;
        this.currentColumn = currentColumn;
    }

    public List<DateTimePatternProposal> generatePatternProposals() {
        ArrayList<DateTimePatternProposal> proposals = new ArrayList<DateTimePatternProposal>();
        List<DateTimePatternToken> parseTokens = this.parseResult.getTokens();
        this.prevToken = null;
        this.currToken = null;
        this.nextToken = null;
        int parseTokenCount = parseTokens.size();
        int currTokenIndex = -1;
        int nextTokenIndex = -1;
        int parseTokenIndex = 0;
        while (parseTokenIndex < parseTokenCount && (this.currToken == null || this.nextToken == null)) {
            DateTimePatternToken parseToken = parseTokens.get(parseTokenIndex);
            if (this.currToken == null && parseToken.beginColumn < this.currentColumn && parseToken.endColumn >= this.currentColumn) {
                currTokenIndex = parseTokenIndex;
                this.currToken = parseToken;
            } else if (this.nextToken == null && parseToken.beginColumn >= this.currentColumn) {
                nextTokenIndex = parseTokenIndex;
                this.nextToken = parseToken;
            }
            ++parseTokenIndex;
        }
        if (currTokenIndex > 0) {
            this.prevToken = parseTokens.get(currTokenIndex - 1);
        } else if (nextTokenIndex > 0) {
            this.prevToken = parseTokens.get(nextTokenIndex - 1);
        } else if (parseTokenCount > 0) {
            this.prevToken = parseTokens.get(parseTokenCount - 1);
        }
        if (DateTimeProposalGenerator.isQuotedOrHexLiteral(this.currToken)) {
            return proposals;
        }
        StringBuilder literalPrefixBld = null;
        String literalPrefix = "";
        String firstLiteral = null;
        int parseTokenIndex2 = parseTokens.indexOf(this.prevToken);
        while (parseTokenIndex2 >= 0 && DateTimeProposalGenerator.isPlainPrefixLiteral(parseTokens.get(parseTokenIndex2))) {
            String literalText = parseTokens.get(parseTokenIndex2).getText();
            if (literalPrefixBld == null) {
                literalPrefixBld = new StringBuilder();
                literalPrefixBld.append(literalText);
                firstLiteral = literalText;
            } else if (literalText.equalsIgnoreCase(firstLiteral)) {
                literalPrefixBld.insert(0, literalText);
            }
            --parseTokenIndex2;
        }
        if (literalPrefixBld != null) {
            literalPrefix = literalPrefixBld.toString();
        }
        this.checkAddYear(literalPrefix, proposals);
        this.checkAddMonthOfYear(literalPrefix, proposals);
        this.checkAddDayOfMonth(literalPrefix, proposals);
        this.checkAddDayOfYear(literalPrefix, proposals);
        this.checkAddCentury(literalPrefix, proposals);
        this.checkAddYearOfCentury(literalPrefix, proposals);
        return proposals;
    }

    private void checkAddCentury(String literalPrefix, List<DateTimePatternProposal> proposals) {
        if (!this.parseResult.hasTokenType(DateTimeCentury.class) && !this.parseResult.hasTokenType(DateTimeYear.class) && (StringUtils.isBlank((CharSequence)literalPrefix) || StringUtils.startsWithIgnoreCase((CharSequence)"CC", (CharSequence)literalPrefix))) {
            DateTimeCentury newToken = new DateTimeCentury();
            String newPattern = null;
            newPattern = literalPrefix != null && !literalPrefix.isEmpty() ? DateTimeProposalGenerator.replaceLiteralInPattern(literalPrefix, this.currentColumn, this.parseResult.getPatternText(), newToken) : DateTimeProposalGenerator.insertIntoPattern(this.currentColumn, this.parseResult.getPatternText(), newToken);
            int cursorPosition = DateTimeProposalGenerator.computeCursorPosition(this.currentColumn, literalPrefix, newToken);
            proposals.add(new DateTimePatternProposal(newToken, newPattern, cursorPosition));
        }
    }

    private void checkAddDayOfMonth(String literalPrefix, List<DateTimePatternProposal> proposals) {
        if (!this.parseResult.hasTokenType(DateTimeDayOfMonth.class) && !this.parseResult.hasTokenType(DateTimeDayOfYear.class) && (StringUtils.isBlank((CharSequence)literalPrefix) || StringUtils.startsWithIgnoreCase((CharSequence)"dd", (CharSequence)literalPrefix))) {
            DateTimeDayOfMonth newToken = new DateTimeDayOfMonth();
            String newPattern = null;
            newPattern = literalPrefix != null && !literalPrefix.isEmpty() ? DateTimeProposalGenerator.replaceLiteralInPattern(literalPrefix, this.currentColumn, this.parseResult.getPatternText(), newToken) : DateTimeProposalGenerator.insertIntoPattern(this.currentColumn, this.parseResult.getPatternText(), newToken);
            int cursorPosition = DateTimeProposalGenerator.computeCursorPosition(this.currentColumn, literalPrefix, newToken);
            proposals.add(new DateTimePatternProposal(newToken, newPattern, cursorPosition));
        }
    }

    private void checkAddDayOfYear(String literalPrefix, List<DateTimePatternProposal> proposals) {
        if (!(this.parseResult.hasTokenType(DateTimeDayOfYear.class) || this.parseResult.hasTokenType(DateTimeMonthOfYear.class) || this.parseResult.hasTokenType(DateTimeDayOfMonth.class) || !StringUtils.isBlank((CharSequence)literalPrefix) && !StringUtils.startsWithIgnoreCase((CharSequence)"DDD", (CharSequence)literalPrefix))) {
            DateTimeDayOfYear newToken = new DateTimeDayOfYear();
            String newPattern = null;
            newPattern = literalPrefix != null && !literalPrefix.isEmpty() ? DateTimeProposalGenerator.replaceLiteralInPattern(literalPrefix, this.currentColumn, this.parseResult.getPatternText(), newToken) : DateTimeProposalGenerator.insertIntoPattern(this.currentColumn, this.parseResult.getPatternText(), newToken);
            int cursorPosition = DateTimeProposalGenerator.computeCursorPosition(this.currentColumn, literalPrefix, newToken);
            proposals.add(new DateTimePatternProposal(newToken, newPattern, cursorPosition));
        }
    }

    private void checkAddMonthOfYear(String literalPrefix, List<DateTimePatternProposal> proposals) {
        if (!this.parseResult.hasTokenType(DateTimeMonthOfYear.class) && !this.parseResult.hasTokenType(DateTimeDayOfYear.class) && (StringUtils.isBlank((CharSequence)literalPrefix) || StringUtils.startsWithIgnoreCase((CharSequence)"MM", (CharSequence)literalPrefix))) {
            DateTimeMonthOfYear newToken = new DateTimeMonthOfYear();
            String newPattern = null;
            newPattern = literalPrefix != null && !literalPrefix.isEmpty() ? DateTimeProposalGenerator.replaceLiteralInPattern(literalPrefix, this.currentColumn, this.parseResult.getPatternText(), newToken) : DateTimeProposalGenerator.insertIntoPattern(this.currentColumn, this.parseResult.getPatternText(), newToken);
            int cursorPosition = DateTimeProposalGenerator.computeCursorPosition(this.currentColumn, literalPrefix, newToken);
            proposals.add(new DateTimePatternProposal(newToken, newPattern, cursorPosition));
        }
    }

    private void checkAddYear(String literalPrefix, List<DateTimePatternProposal> proposals) {
        if (!(this.parseResult.hasTokenType(DateTimeYear.class) || this.parseResult.hasTokenType(DateTimeCentury.class) || this.parseResult.hasTokenType(DateTimeYearOfCentury.class) || !StringUtils.isBlank((CharSequence)literalPrefix) && !StringUtils.startsWithIgnoreCase((CharSequence)"yyyy", (CharSequence)literalPrefix))) {
            DateTimeYear newToken = new DateTimeYear();
            String newPattern = null;
            newPattern = literalPrefix != null && !literalPrefix.isEmpty() ? DateTimeProposalGenerator.replaceLiteralInPattern(literalPrefix, this.currentColumn, this.parseResult.getPatternText(), newToken) : DateTimeProposalGenerator.insertIntoPattern(this.currentColumn, this.parseResult.getPatternText(), newToken);
            int cursorPosition = DateTimeProposalGenerator.computeCursorPosition(this.currentColumn, literalPrefix, newToken);
            proposals.add(new DateTimePatternProposal(newToken, newPattern, cursorPosition));
        }
    }

    private void checkAddYearOfCentury(String literalPrefix, List<DateTimePatternProposal> proposals) {
        if (!this.parseResult.hasTokenType(DateTimeYearOfCentury.class) && !this.parseResult.hasTokenType(DateTimeYear.class) && (StringUtils.isBlank((CharSequence)literalPrefix) || StringUtils.startsWithIgnoreCase((CharSequence)"YY", (CharSequence)literalPrefix))) {
            DateTimeYearOfCentury newToken = new DateTimeYearOfCentury();
            String newPattern = null;
            newPattern = literalPrefix != null && !literalPrefix.isEmpty() ? DateTimeProposalGenerator.replaceLiteralInPattern(literalPrefix, this.currentColumn, this.parseResult.getPatternText(), newToken) : DateTimeProposalGenerator.insertIntoPattern(this.currentColumn, this.parseResult.getPatternText(), newToken);
            int cursorPosition = DateTimeProposalGenerator.computeCursorPosition(this.currentColumn, literalPrefix, newToken);
            proposals.add(new DateTimePatternProposal(newToken, newPattern, cursorPosition));
        }
    }

    private static String replaceLiteralInPattern(String literal, int column, String pattern, DateTimePatternToken token) {
        String p1 = StringUtils.substring((String)pattern, (int)0, (int)(column - literal.length() - 1));
        String p2 = StringUtils.substring((String)pattern, (int)(column - 1));
        String p3 = p1 + token.getText() + p2;
        return p3;
    }

    private static String insertIntoPattern(int column, String pattern, DateTimePatternToken token) {
        String p1 = StringUtils.substring((String)pattern, (int)0, (int)(column - 1));
        String p2 = StringUtils.substring((String)pattern, (int)(column - 1));
        String p3 = p1 + token.getText() + p2;
        return p3;
    }

    private static boolean isPlainPrefixLiteral(DateTimePatternToken token) {
        boolean retVal = false;
        if (token instanceof DateTimeLiteral && !((DateTimeLiteral)token).isQuoted() && !((DateTimeLiteral)token).isEscaped() && PrefixLiterals.contains(token.getText())) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isQuotedOrHexLiteral(DateTimePatternToken token) {
        boolean retVal = false;
        if (token instanceof DateTimeLiteral && ((DateTimeLiteral)token).isQuoted()) {
            retVal = true;
        } else if (token instanceof DateTimeHexLiteral) {
            retVal = true;
        }
        return retVal;
    }

    private static int computeCursorPosition(int currentColumn, String literalPrefix, DateTimePatternToken token) {
        int retVal = Math.max(0, currentColumn - 1);
        if (token != null && token.getText() != null) {
            retVal += token.getText().length();
        }
        if (literalPrefix != null) {
            retVal -= literalPrefix.length();
        }
        return retVal;
    }
}

