/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser;

import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfMonth;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeHexLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeMonthOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYearOfCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParseResult;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParserMode;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternToken;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.cc.DateTimePatternParserCC;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.cc.DateTimePatternParserCCConstants;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.cc.Token;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.DateTimePatternParserException;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class DateTimePatternParser
implements DateTimePatternParserCCConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PatternCharsetName = "UTF-16BE";
    private static final Pattern HEX_PATTERN = Pattern.compile("[A-Fa-f0-9]+");
    private DateTimePatternParserMode mode;

    private DateTimePatternParser() {
    }

    public DateTimePatternParser(DateTimePatternParserMode mode) {
        this.mode = mode;
    }

    public DateTimePatternParseResult parse(String patternText) throws DateTimePatternParserException {
        if (patternText == null) {
            patternText = "";
        }
        DateTimePatternParseResult parseResult = new DateTimePatternParseResult(patternText);
        ByteArrayInputStream parserCCInputStream = null;
        try {
            try {
                parserCCInputStream = new ByteArrayInputStream(patternText.getBytes(Charset.forName(PatternCharsetName)));
                DateTimePatternParserCC parserCC = new DateTimePatternParserCC(parserCCInputStream, PatternCharsetName);
                Token tokenCC = parserCC.getNextToken();
                while (tokenCC != null && tokenCC.kind != 0) {
                    parseResult.getTokens().add((DateTimePatternToken)tokenCC);
                    tokenCC = parserCC.getNextToken();
                }
                for (DateTimePatternToken token : parseResult.getTokens()) {
                    if (token instanceof DateTimeCentury) {
                        this.validateToken((DateTimeCentury)token, parseResult);
                        continue;
                    }
                    if (token instanceof DateTimeDayOfMonth) {
                        this.validateToken((DateTimeDayOfMonth)token, parseResult);
                        continue;
                    }
                    if (token instanceof DateTimeDayOfYear) {
                        this.validateToken((DateTimeDayOfYear)token, parseResult);
                        continue;
                    }
                    if (token instanceof DateTimeLiteral) {
                        this.validateToken((DateTimeLiteral)token, parseResult);
                        continue;
                    }
                    if (token instanceof DateTimeHexLiteral) {
                        this.validateToken((DateTimeHexLiteral)token, parseResult);
                        continue;
                    }
                    if (token instanceof DateTimeMonthOfYear) {
                        this.validateToken((DateTimeMonthOfYear)token, parseResult);
                        continue;
                    }
                    if (token instanceof DateTimeYear) {
                        this.validateToken((DateTimeYear)token, parseResult);
                        continue;
                    }
                    if (!(token instanceof DateTimeYearOfCentury)) continue;
                    this.validateToken((DateTimeYearOfCentury)token, parseResult);
                }
                if (DateTimePatternParserMode.DATE.equals((Object)this.mode)) {
                    this.validateDate(parseResult);
                }
            }
            catch (Throwable e) {
                throw new DateTimePatternParserException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(parserCCInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)parserCCInputStream);
        return parseResult;
    }

    public void validateToken(DateTimeCentury token, DateTimePatternParseResult parseResult) {
        if (parseResult.getCountTokenType(DateTimeCentury.class) > 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_MULT_CENTURY_OF_ERA"), token);
        }
        if (!parseResult.hasTokenType(DateTimeYearOfCentury.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_REQD_CENTURY_NO_YEAR_OF_ERA"), token);
        }
    }

    public void validateToken(DateTimeDayOfMonth token, DateTimePatternParseResult parseResult) {
        if (parseResult.getCountTokenType(DateTimeDayOfMonth.class) > 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_MULT_DAY_OF_MONTH"), token);
        }
        if (parseResult.hasTokenType(DateTimeDayOfYear.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_DAY_OF_MONTH_AND_DAY_OF_YEAR"), token);
        }
    }

    public void validateToken(DateTimeDayOfYear token, DateTimePatternParseResult parseResult) {
        if (parseResult.getCountTokenType(DateTimeDayOfYear.class) > 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_MULT_DAY_OF_YEAR"), token);
        }
        if (parseResult.hasTokenType(DateTimeDayOfMonth.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_DAY_OF_MONTH_AND_DAY_OF_YEAR"), token);
        }
        if (parseResult.hasTokenType(DateTimeMonthOfYear.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_MONTH_OF_YEAR_AND_DAY_OF_YEAR"), token);
        }
    }

    public void validateToken(DateTimeLiteral token, DateTimePatternParseResult parseResult) {
        String literal = token.getLiteral();
        if (literal == null || literal.isEmpty()) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_LTRL_EMPTY", (Object[])new Object[]{token.getBeginColumn()}), token);
        }
    }

    public void validateToken(DateTimeHexLiteral token, DateTimePatternParseResult parseResult) {
        String literal = token.getLiteral();
        if (literal == null || literal.isEmpty() || literal.length() == 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_LTRL_HEX_EMPTY", (Object[])new Object[]{token.getBeginColumn()}), token);
        } else {
            if (!HEX_PATTERN.matcher(literal).matches()) {
                parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_LTRL_HEX_INVALID_CHAR", (Object[])new Object[]{token.getBeginColumn()}), token);
            }
            if (literal.length() % 2 > 0) {
                parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_LTRL_HEX_ODD_LENGTH", (Object[])new Object[]{token.getBeginColumn()}), token);
            }
        }
    }

    public void validateToken(DateTimeMonthOfYear token, DateTimePatternParseResult parseResult) {
        if (parseResult.getCountTokenType(DateTimeMonthOfYear.class) > 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_MULT_MONTH_OF_YEAR"), token);
        }
        if (parseResult.hasTokenType(DateTimeDayOfYear.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_MONTH_OF_YEAR_AND_DAY_OF_YEAR"), token);
        }
    }

    public void validateToken(DateTimeYear token, DateTimePatternParseResult parseResult) {
        if (parseResult.getCountTokenType(DateTimeYear.class) > 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_MULT_YEAR"), token);
        }
        if (parseResult.hasTokenType(DateTimeYearOfCentury.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_YEAR_AND_YEAR_OF_ERA"), token);
        }
        if (parseResult.hasTokenType(DateTimeCentury.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_YEAR_AND_CENTURY_OF_ERA"), token);
        }
    }

    public void validateToken(DateTimeYearOfCentury token, DateTimePatternParseResult parseResult) {
        if (parseResult.getCountTokenType(DateTimeYearOfCentury.class) > 1) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_MULT_YEAR_OF_ERA"), token);
        }
        if (!parseResult.hasTokenType(DateTimeCentury.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_REQD_YEAR_OF_ERA_NO_CENTURY"), token);
        }
        if (parseResult.hasTokenType(DateTimeYear.class)) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_BOTH_YEAR_AND_CENTURY_OF_ERA"), token);
        }
    }

    public void validateDate(DateTimePatternParseResult parseResult) {
        boolean year = false;
        boolean month = false;
        boolean day = false;
        if (parseResult.hasTokenType(DateTimeYear.class)) {
            year = true;
        } else if (parseResult.hasTokenType(DateTimeCentury.class) && parseResult.hasTokenType(DateTimeYearOfCentury.class)) {
            year = true;
        }
        if (parseResult.hasTokenType(DateTimeMonthOfYear.class) || parseResult.hasTokenType(DateTimeDayOfYear.class)) {
            month = true;
        }
        if (parseResult.hasTokenType(DateTimeDayOfMonth.class) || parseResult.hasTokenType(DateTimeDayOfYear.class)) {
            day = true;
        }
        if (!year) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_REQD_PTRN_4YEAR"));
        }
        if (!month) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_REQD_PTRN_2MONTH"));
        }
        if (!day) {
            parseResult.addErrorUnique(PgmIntXlat.error((String)"DT_REQD_PTRN_2DAY"));
        }
    }

    public DateTimePatternParserMode getMode() {
        return this.mode;
    }
}

