/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser;

import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParseError;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DateTimePatternParseResult {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final List<DateTimePatternToken> tokens = new ArrayList<DateTimePatternToken>();
    private final List<DateTimePatternParseError> errors = new ArrayList<DateTimePatternParseError>();
    private final Set<DateTimePatternToken> errorTokens = new HashSet<DateTimePatternToken>();
    private String patternText;
    private final List<String> errorMessages = new ArrayList<String>();

    public DateTimePatternParseResult() {
    }

    public DateTimePatternParseResult(String patternText) {
        this();
        this.patternText = patternText;
    }

    public List<DateTimePatternToken> getTokens() {
        return this.tokens;
    }

    public void addErrorUnique(String errorMessage) {
        if (!this.errorMessages.contains(errorMessage)) {
            this.errorMessages.add(errorMessage);
            this.errors.add(new DateTimePatternParseError(errorMessage));
        }
    }

    public void addErrorUnique(String errorMessage, DateTimePatternToken token) {
        if (!this.errorMessages.contains(errorMessage)) {
            this.errorMessages.add(errorMessage);
            this.errors.add(new DateTimePatternParseError(errorMessage, token));
        }
        this.errorTokens.add(token);
    }

    public List<DateTimePatternParseError> getErrors() {
        return this.errors;
    }

    public String getPatternText() {
        return this.patternText;
    }

    public void setPatternText(String patternText) {
        this.patternText = patternText;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public DateTimePatternParseError getFirstError() {
        return this.hasErrors() ? this.errors.get(0) : null;
    }

    public boolean hasTokenType(Class<? extends DateTimePatternToken> tokenType) {
        boolean retVal = false;
        for (DateTimePatternToken token : this.tokens) {
            if (token.getClass() != tokenType) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public int getCountTokenType(Class<? extends DateTimePatternToken> tokenType) {
        int retVal = 0;
        for (DateTimePatternToken token : this.tokens) {
            if (token.getClass() != tokenType) continue;
            ++retVal;
        }
        return retVal;
    }

    public Set<DateTimePatternToken> getErrorTokens() {
        return this.errorTokens;
    }
}

