/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.controllers.datastructure;

import com.ibm.ccl.pli.BaseValues;
import com.ibm.ccl.pli.LengthType;
import com.ibm.ccl.pli.PLIClassifier;
import com.ibm.ccl.pli.PLIComposedType;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.ccl.pli.PLISimpleType;
import com.ibm.ccl.pli.StringTypeValues;
import com.ibm.ccl.pli.impl.PLIArrayImpl;
import com.ibm.ccl.pli.impl.PLICodedStringTypeImpl;
import com.ibm.ccl.pli.impl.PLIFixedBoundArrayImpl;
import com.ibm.ccl.pli.impl.PLIFixedLboundArrayImpl;
import com.ibm.ccl.pli.impl.PLIFloatTypeImpl;
import com.ibm.ccl.pli.impl.PLIIntegerTypeImpl;
import com.ibm.ccl.pli.impl.PLIPackedTypeImpl;
import com.ibm.ccl.pli.impl.PLIPictureTypeImpl;
import com.ibm.ccl.pli.impl.PLIVariableBoundArrayImpl;
import com.ibm.etools.cobol.COBOLAlphaNumericType;
import com.ibm.etools.cobol.COBOLAlphabeticType;
import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLFixedLengthArray;
import com.ibm.etools.cobol.COBOLNationalExternalFloatType;
import com.ibm.etools.cobol.COBOLNationalNumericType;
import com.ibm.etools.cobol.COBOLNumericType;
import com.ibm.etools.cobol.COBOLRedefiningElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLUsageValues;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.etools.cobol.impl.COBOLNumericEditedTypeImpl;
import com.ibm.etools.cobol.impl.COBOLNumericTypeImpl;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.DBDConstants;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.InformationException;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.TranDataStructureController;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.ImportParseException;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.UnsupportedCobolTypeException;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.UnsupportedPliTypeException;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.UnsupportedTypeException;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.UnsupportedTypesException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ModelException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.Utility;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.AlignmentType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.FieldPath;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class TranDataStructureParser {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TranDataStructureParser.class.getName());
    SegmentType seg;
    Vector<InformationException> informationExceptionList;
    TranDataStructureController controller;
    HashMap<String, FieldType> fieldPathToFieldType;
    List<String> dependsOnFieldPaths;
    UnsupportedTypesException unsupportedTypesException;

    public TranDataStructureParser(TranDataStructureController controller) {
        this.controller = controller;
        this.fieldPathToFieldType = new HashMap();
        this.dependsOnFieldPaths = new ArrayList<String>();
    }

    public ArrayList<FieldType> parseCobolCopyBookModel(Resource res) throws ImportParseException, ModelException {
        ArrayList<FieldType> segments = new ArrayList<FieldType>();
        this.fieldPathToFieldType.clear();
        this.dependsOnFieldPaths.clear();
        int totalStructs = 0;
        for (EObject refObject : res.getContents()) {
            if (!(refObject instanceof COBOLElement)) continue;
            COBOLElement element = (COBOLElement)refObject;
            try {
                ++totalStructs;
                FieldType field = this.parseElementModel(element, false);
                segments.add(field);
                this.fieldPathToFieldType.put(this.fieldPathOf(element), field);
            }
            catch (UnsupportedTypeException e) {
                if (this.unsupportedTypesException == null) {
                    this.unsupportedTypesException = new UnsupportedTypesException();
                }
                this.unsupportedTypesException.add(e);
                ZCeeUILogger.error((Throwable)e);
            }
        }
        if (this.unsupportedTypesException != null) {
            this.unsupportedTypesException.setTotalStructs(totalStructs);
        } else if (segments.size() == 0) {
            ImportParseException e = new ImportParseException(PgmIntXlat.getError().getString("IDSW_ERR_APP_01"));
            logger.throwing(this.getClass().getName(), "", e);
            throw e;
        }
        for (String fieldPath : this.dependsOnFieldPaths) {
            FieldType fieldType = this.fieldPathToFieldType.get(fieldPath);
            if (fieldType == null) continue;
            fieldType.setDependedOn(Boolean.TRUE);
        }
        return segments;
    }

    public ArrayList<FieldType> parsePliIncludeModel(Resource res) throws ImportParseException, ModelException {
        ArrayList<FieldType> segments = new ArrayList<FieldType>();
        this.fieldPathToFieldType.clear();
        this.dependsOnFieldPaths.clear();
        int totalStructs = 0;
        for (EObject refObject : res.getContents()) {
            PLIElement element;
            PLIClassifier classifier;
            if (!(refObject instanceof PLIElement) || !((classifier = (element = (PLIElement)refObject).getSharedType()) instanceof PLIComposedType)) continue;
            try {
                ++totalStructs;
                FieldType field = this.parseElementModel(element, false);
                this.controller.preconditionTopLevelFieldStartInfo(field.getField());
                segments.add(field);
                this.fieldPathToFieldType.put(this.fieldPathOf(element), field);
            }
            catch (UnsupportedTypeException e) {
                if (this.unsupportedTypesException == null) {
                    this.unsupportedTypesException = new UnsupportedTypesException();
                }
                this.unsupportedTypesException.add(e);
                ZCeeUILogger.error((Throwable)e);
            }
        }
        if (this.unsupportedTypesException != null) {
            this.unsupportedTypesException.setTotalStructs(totalStructs);
        } else if (segments.size() == 0) {
            ImportParseException e = new ImportParseException(PgmIntXlat.getError().getString("IDSW_ERR_APP_01"));
            logger.throwing(this.getClass().getName(), "", e);
            throw e;
        }
        for (String fieldPath : this.dependsOnFieldPaths) {
            FieldType fieldType = this.fieldPathToFieldType.get(fieldPath);
            if (fieldType == null) continue;
            fieldType.setDependedOn(Boolean.TRUE);
        }
        return segments;
    }

    private String replaceHyphens(String value) {
        Object retVal = value;
        if (retVal != null && !((String)retVal).isEmpty()) {
            retVal = ((String)retVal).replace('-', '_');
        }
        if (Utility.hasReservedSQLKeywords((String)retVal)) {
            retVal = (String)retVal + "1";
        }
        retVal = ((String)retVal).toUpperCase();
        return retVal;
    }

    private FieldType parseElementModel(COBOLElement element, boolean thisIsUnderArray) throws ImportParseException, ModelException {
        COBOLClassifier classifier;
        COBOLElement redefines;
        String redefinedName;
        FieldType field = new FieldType();
        field.setIncluded(YesnoType.Y);
        this.fieldPathToFieldType.put(this.fieldPathOf(element), field);
        field.setName(this.replaceHyphens(element.getName()));
        field.setOriginalName(field.getName());
        field.setPath(this.fieldPathOf(element));
        this.parseTDBaseModel(field, element.getInstanceTDBase());
        if (thisIsUnderArray) {
            field.setStartPos(null);
        }
        boolean thisFieldIsAnArray = false;
        COBOLFixedLengthArray array = element.getArray();
        if (array != null) {
            thisFieldIsAnArray = true;
            this.controller.setAppDatatype(field, DBDConstants.ARRAY);
            int maxUpper = array.getMaxUpper();
            if (array instanceof COBOLVariableLengthArray) {
                COBOLVariableLengthArray varArray = (COBOLVariableLengthArray)array;
                this.controller.setMinOccurs(field, varArray.getMinUpper());
                COBOLElement dependingOn = varArray.getDependingOn();
                this.controller.setDependsOn(field, this.replaceHyphens(dependingOn.getName()));
                this.controller.setDependsOnPath(field, this.fieldPathOf(dependingOn));
                this.dependsOnFieldPaths.add(this.fieldPathOf(dependingOn));
            } else {
                this.controller.setMinOccurs(field, maxUpper);
            }
            this.controller.setMaxOccurs(field, maxUpper);
        }
        if (element instanceof COBOLRedefiningElement && (redefinedName = (redefines = ((COBOLRedefiningElement)element).getRedefines()).getName()) != null && !redefinedName.isEmpty()) {
            field.setRedefines(this.replaceHyphens(redefinedName));
        }
        if ((classifier = element.getSharedType()) instanceof COBOLSimpleType && array != null) {
            FieldType subField = new FieldType();
            field.setIncluded(YesnoType.Y);
            subField.setName(field.getName() + "_SUB");
            Integer maxOccurs = field.getMaxOccurs();
            Integer arrayLength = field.getBytes();
            if (arrayLength != null && maxOccurs != null) {
                subField.setBytes(Integer.valueOf(arrayLength / maxOccurs));
            } else {
                String pictureString = ((COBOLSimpleType)classifier).getPictureString();
                subField.setBytes(Integer.valueOf(this.getFieldLength(pictureString, ((COBOLSimpleType)classifier).getUsage())));
            }
            field.getField().add(subField);
            this.parseSimpleModel(subField, (COBOLSimpleType)classifier);
        } else if (classifier instanceof COBOLSimpleType) {
            this.parseSimpleModel(field, (COBOLSimpleType)classifier);
        } else if (classifier instanceof COBOLComposedType) {
            if (this.controller.getAppDatatype(field) != DBDConstants.ARRAY) {
                this.controller.setAppDatatype(field, DBDConstants.STRUCT);
            }
            this.parseComposedModel(field, (COBOLComposedType)classifier, thisIsUnderArray || thisFieldIsAnArray);
        } else {
            throw new RuntimeException("COBOLClassifier " + String.valueOf(classifier) + " not of known type");
        }
        logger.finer("Parsing complete for field: " + field.getName());
        return field;
    }

    private int getFieldLength(String pictureString, COBOLUsageValues usageValue) throws ImportParseException {
        int retVal = -1;
        if (pictureString != null) {
            if (pictureString.indexOf(88) >= 0 || pictureString.indexOf(120) >= 0 || pictureString.indexOf(65) >= 0 || pictureString.indexOf(97) >= 0 || pictureString.indexOf(71) >= 0 || pictureString.indexOf(103) >= 0) {
                retVal = this.getAlphaNumericPictureStringLength(pictureString);
            } else {
                retVal = this.getComputationalPictureStringLength(pictureString);
                if (usageValue.getValue() == 0) {
                    if (retVal >= 1 && retVal <= 4) {
                        retVal = 2;
                    } else if (retVal >= 5 && retVal <= 9) {
                        retVal = 4;
                    } else if (retVal >= 10 && retVal <= 18) {
                        retVal = 8;
                    }
                } else if (usageValue.getValue() == 8) {
                    retVal = (retVal + 2) / 2;
                }
            }
        } else {
            if (usageValue.getValue() == 4) {
                return 4;
            }
            if (usageValue.getValue() == 2) {
                return 8;
            }
        }
        return retVal;
    }

    private FieldType parseElementModel(PLIElement element, boolean thisIsUnderArray) throws ImportParseException, ModelException {
        PLIClassifier classifier;
        FieldType field = new FieldType();
        field.setIncluded(YesnoType.Y);
        this.fieldPathToFieldType.put(this.fieldPathOf(element), field);
        field.setName(element.getName().toUpperCase());
        field.setOriginalName(field.getName());
        field.setPath(this.fieldPathOf(element));
        this.parseTDBaseModel(field, element.getInstanceTDBase());
        if (thisIsUnderArray) {
            field.setStartPos(null);
        }
        boolean thisFieldIsAnArray = false;
        EList elist = element.getArray();
        if (elist.size() > 0) {
            thisFieldIsAnArray = true;
            Object currArray = elist.get(0);
            if (currArray instanceof PLIArrayImpl) {
                this.controller.setAppDatatype(field, DBDConstants.ARRAY);
                if (currArray instanceof PLIFixedBoundArrayImpl) {
                    Integer lBound = ((PLIFixedBoundArrayImpl)currArray).getLBound();
                    Integer uBound = ((PLIFixedBoundArrayImpl)currArray).getUBound();
                    if (lBound < 1) {
                        int addAmount = 1 - lBound;
                        int numElements = uBound + addAmount;
                        field.setMinOccurs(Integer.valueOf(numElements));
                        field.setMaxOccurs(Integer.valueOf(numElements));
                    } else if (lBound > 1) {
                        int subAmount = lBound - 1;
                        int numElements = uBound - subAmount;
                        field.setMinOccurs(Integer.valueOf(numElements));
                        field.setMaxOccurs(Integer.valueOf(numElements));
                    } else {
                        field.setMinOccurs(uBound);
                        field.setMaxOccurs(uBound);
                    }
                } else if (currArray instanceof PLIFixedLboundArrayImpl) {
                    referredTo = ((PLIFixedLboundArrayImpl)currArray).getReferredTo();
                    field.setDependsOn(this.replaceHyphens(referredTo.getName()));
                    field.setDependsOnPath(this.fieldPathOf(referredTo));
                    this.dependsOnFieldPaths.add(this.fieldPathOf(referredTo));
                    field.setMinOccurs(Integer.valueOf(0));
                    field.setMaxOccurs(Integer.valueOf(0));
                } else if (currArray instanceof PLIVariableBoundArrayImpl) {
                    referredTo = ((PLIVariableBoundArrayImpl)currArray).getReferredTo();
                    field.setDependsOn(this.replaceHyphens(referredTo.getName()));
                    field.setDependsOnPath(this.fieldPathOf(referredTo));
                    this.dependsOnFieldPaths.add(this.fieldPathOf(referredTo));
                    field.setMinOccurs(Integer.valueOf(0));
                    field.setMaxOccurs(Integer.valueOf(0));
                }
            }
        }
        if ((classifier = element.getSharedType()) instanceof PLISimpleType && thisFieldIsAnArray) {
            FieldType subField = new FieldType();
            field.setIncluded(YesnoType.Y);
            subField.setName(field.getName() + "_SUB");
            if (field.getMaxOccurs() == 0) {
                subField.setBytes(field.getBytes());
            } else {
                subField.setBytes(Integer.valueOf(field.getBytes() / field.getMaxOccurs()));
            }
            field.getField().add(subField);
            this.parseSimpleModel(subField, (PLISimpleType)classifier, element);
        } else if (classifier instanceof PLISimpleType) {
            this.parseSimpleModel(field, (PLISimpleType)classifier, element);
        } else if (classifier instanceof PLIComposedType) {
            if (this.controller.getAppDatatype(field) != DBDConstants.ARRAY) {
                this.controller.setAppDatatype(field, DBDConstants.STRUCT);
            }
            this.parseComposedModel(field, (PLIComposedType)classifier, thisIsUnderArray || thisFieldIsAnArray);
        } else {
            throw new RuntimeException("PLIClassifier not of known type");
        }
        logger.finer("Parsing complete for field: " + field.getName());
        return field;
    }

    private void parseTDBaseModel(FieldType field, InstanceTDBase base) throws ImportParseException {
        String length = base.getSize();
        String contentLength = base.getContentSize();
        String startByte = base.getOffset();
        int lengthInt = 0;
        int startInt = 0;
        int contentLengthInt = 0;
        boolean lengthNotInt = false;
        boolean contentLengthNotInt = false;
        boolean startNotInt = false;
        try {
            startInt = Integer.parseInt(startByte);
        }
        catch (NumberFormatException numberFormatException) {
            startNotInt = true;
        }
        try {
            lengthInt = Integer.parseInt(length);
        }
        catch (NumberFormatException numberFormatException) {
            lengthNotInt = true;
        }
        try {
            contentLengthInt = Integer.parseInt(contentLength);
        }
        catch (NumberFormatException numberFormatException) {
            contentLengthNotInt = true;
        }
        if (base.getAttributeInBit().booleanValue()) {
            int mod = startInt % 8;
            startInt /= 8;
            if (mod > 0) {
                ++startInt;
            }
            mod = lengthInt % 8;
            lengthInt /= 8;
            if (mod > 0) {
                ++lengthInt;
            }
            mod = contentLengthInt % 8;
            contentLengthInt /= 8;
            if (mod > 0) {
                ++contentLengthInt;
            }
        }
        if (!startNotInt) {
            field.setStartPos(Integer.valueOf(startInt + 1));
        }
        if (!lengthNotInt) {
            field.setBytes(Integer.valueOf(lengthInt));
        } else {
            field.setBytes(Integer.valueOf(0));
        }
        if (!contentLengthNotInt) {
            field.setMaxBytes(Integer.valueOf(contentLengthInt));
        } else {
            field.setMaxBytes(Integer.valueOf(0));
        }
    }

    private void parseComposedModel(FieldType field, COBOLComposedType composed, boolean childFieldsUnderArray) throws ImportParseException, ModelException {
        Iterator iter = composed.getElement().iterator();
        while (iter.hasNext()) {
            MarshallerType subFieldMarshaller;
            FieldType subField = this.parseElementModel((COBOLElement)iter.next(), childFieldsUnderArray);
            if (!MessageWalker.isCompositeField((FieldType)subField) && (subFieldMarshaller = subField.getMarshaller()) != null && subFieldMarshaller.getAlignment() != null) {
                MarshallerType fieldMarshaller = field.getMarshaller();
                if (fieldMarshaller == null) {
                    fieldMarshaller = new MarshallerType();
                    fieldMarshaller.setAlignment(AlignmentType.NATURAL);
                    field.setMarshaller(fieldMarshaller);
                }
                AlignmentType fieldAlignment = fieldMarshaller.getAlignment();
                AlignmentType subFieldAlignment = subFieldMarshaller.getAlignment();
                int fieldBoundary = TranDataStructureParser.alignmentTypeToInt(fieldAlignment);
                int subFieldBoundary = TranDataStructureParser.alignmentTypeToInt(subFieldAlignment);
                if (subFieldBoundary > fieldBoundary) {
                    fieldMarshaller.setAlignment(subFieldAlignment);
                }
            }
            field.getField().add(subField);
        }
    }

    public static int alignmentTypeToInt(AlignmentType type) {
        switch (type) {
            case HALFWORD: {
                return 2;
            }
            case FULLWORD: {
                return 4;
            }
            case DOUBLEWORD: {
                return 8;
            }
        }
        return 1;
    }

    private void parseComposedModel(FieldType field, PLIComposedType composed, boolean childFieldsUnderArray) throws ImportParseException, ModelException {
        FieldType currField = null;
        FieldType prevField = null;
        Boolean isUnion = composed.getUnion();
        Iterator iter = composed.getElements().iterator();
        while (iter.hasNext()) {
            MarshallerType subFieldMarshaller;
            currField = this.parseElementModel((PLIElement)iter.next(), childFieldsUnderArray);
            if (!MessageWalker.isCompositeField((FieldType)currField) && (subFieldMarshaller = currField.getMarshaller()) != null && subFieldMarshaller.getAlignment() != null) {
                MarshallerType fieldMarshaller = field.getMarshaller();
                if (fieldMarshaller == null) {
                    fieldMarshaller = new MarshallerType();
                    fieldMarshaller.setAlignment(AlignmentType.NATURAL);
                    field.setMarshaller(fieldMarshaller);
                }
                AlignmentType fieldAlignment = fieldMarshaller.getAlignment();
                AlignmentType subFieldAlignment = subFieldMarshaller.getAlignment();
                int fieldBoundary = TranDataStructureParser.alignmentTypeToInt(fieldAlignment);
                int subFieldBoundary = TranDataStructureParser.alignmentTypeToInt(subFieldAlignment);
                if (subFieldBoundary > fieldBoundary) {
                    fieldMarshaller.setAlignment(subFieldAlignment);
                }
            }
            field.getField().add(currField);
            if (!isUnion.booleanValue()) continue;
            if (prevField != null) {
                currField.setRedefines(this.replaceHyphens(prevField.getName()));
            }
            prevField = currField;
        }
    }

    private void parseSimpleModel(FieldType field, PLISimpleType simple, PLIElement element) throws ImportParseException {
        if (simple instanceof PLICodedStringTypeImpl) {
            StringTypeValues type = ((PLICodedStringTypeImpl)simple).getType();
            LengthType varying = ((PLICodedStringTypeImpl)simple).getVarying();
            if (type.getValue() == 1 || type.getValue() == 3 || type.getValue() == 2) {
                this.controller.setAppDatatype(field, DBDConstants.CHAR);
                if (type.getValue() == 2) {
                    this.controller.setEncoding(field, "UTF-16BE");
                } else if (type.getValue() == 3) {
                    this.controller.setIsDBCSOnly(field, "Y");
                }
                if (simple.isAligned() && (varying == LengthType.VARYING_BIG_ENDIAN_LITERAL || varying == LengthType.VARYING_LITTLE_ENDIAN_LITERAL)) {
                    this.controller.setAlignment(field, AlignmentType.HALFWORD);
                } else {
                    this.controller.setAlignment(field, AlignmentType.NATURAL);
                }
            } else if (type.getValue() == 0) {
                this.controller.setAppDatatype(field, DBDConstants.BIT);
                if (simple.isAligned()) {
                    if (varying == LengthType.VARYING_BIG_ENDIAN_LITERAL || varying == LengthType.VARYING_LITTLE_ENDIAN_LITERAL) {
                        this.controller.setAlignment(field, AlignmentType.HALFWORD);
                    } else {
                        this.controller.setAlignment(field, AlignmentType.NATURAL);
                    }
                } else {
                    this.controller.setAlignment(field, AlignmentType.NATURAL);
                }
            }
        } else if (simple instanceof PLIPictureTypeImpl) {
            PLIPictureTypeImpl pictureType = (PLIPictureTypeImpl)simple;
            String pictureString = pictureType.getPictureString().toUpperCase();
            if (StringUtils.containsOnly((CharSequence)pictureString, (String)"SV0123456789()")) {
                this.controller.setAppDatatype(field, DBDConstants.DECIMAL);
                DBDConstants fieldType = DBDConstants.ZONEDDECIMAL;
                this.controller.setPhysicalDataType(field, fieldType);
                boolean isSignLeading = StringUtils.startsWith((CharSequence)pictureString, (CharSequence)"S");
                boolean isSignTrailing = StringUtils.endsWith((CharSequence)pictureString, (CharSequence)"S");
                boolean isSigned = isSignLeading | isSignTrailing;
                if (isSigned) {
                    this.controller.setIsSigned(field, "Y");
                    this.controller.setSignSeparate(field, "Y");
                } else {
                    this.controller.setIsSigned(field, "N");
                    this.controller.setSignSeparate(field, "N");
                }
                if (isSignLeading) {
                    this.controller.setSignLeading(field, "Y");
                } else {
                    this.controller.setSignLeading(field, "N");
                }
                this.controller.setPrecision(field, pictureType.getPrecision().toString());
                this.controller.setScale(field, pictureType.getScale().toString());
            } else {
                this.controller.setAppDatatype(field, DBDConstants.CHAR);
            }
        } else if (simple instanceof PLIPackedTypeImpl) {
            this.controller.setAppDatatype(field, DBDConstants.DECIMAL);
            this.controller.setPrecision(field, ((PLIPackedTypeImpl)simple).getPrecision().toString());
            this.controller.setScale(field, ((PLIPackedTypeImpl)simple).getScale().toString());
            this.controller.setPhysicalDataType(field, DBDConstants.PACKEDDECIMAL);
            this.controller.setIsSigned(field, "YES");
        } else if (simple instanceof PLIIntegerTypeImpl) {
            Integer scale = ((PLIIntegerTypeImpl)simple).getScale();
            Integer precision = ((PLIIntegerTypeImpl)simple).getPrecision();
            boolean signed = ((PLIIntegerTypeImpl)simple).isSigned();
            if (scale != 0) {
                Object[] inserts = new Object[]{element.getName()};
                ImportParseException e = new ImportParseException(PgmIntXlat.getError().getString("IDSW_ERR_APP_01", inserts));
                logger.throwing(this.getClass().getName(), "", e);
                EclipseLogger.logError(e);
                throw e;
            }
            this.controller.setIsNativeInteger(field, "Y");
            this.controller.setPrecision(field, String.valueOf(precision));
            int bytes = field.getBytes();
            if (bytes == 1) {
                if (!signed) {
                    this.controller.setAppDatatype(field, DBDConstants.UBYTE);
                } else {
                    this.controller.setAppDatatype(field, DBDConstants.BYTE);
                }
                this.controller.setAlignment(field, AlignmentType.NATURAL);
            } else if (bytes == 2) {
                if (!signed) {
                    this.controller.setAppDatatype(field, DBDConstants.USHORT);
                } else {
                    this.controller.setAppDatatype(field, DBDConstants.SHORT);
                }
                if (simple.isAligned()) {
                    this.controller.setAlignment(field, AlignmentType.HALFWORD);
                } else {
                    this.controller.setAlignment(field, AlignmentType.NATURAL);
                }
            } else if (bytes == 4) {
                if (!signed) {
                    this.controller.setAppDatatype(field, DBDConstants.UINT);
                } else {
                    this.controller.setAppDatatype(field, DBDConstants.INT);
                }
                if (simple.isAligned()) {
                    this.controller.setAlignment(field, AlignmentType.FULLWORD);
                } else {
                    this.controller.setAlignment(field, AlignmentType.NATURAL);
                }
            } else if (bytes == 8) {
                if (!signed) {
                    this.controller.setAppDatatype(field, DBDConstants.ULONG);
                } else {
                    this.controller.setAppDatatype(field, DBDConstants.LONG);
                }
                if (simple.isAligned()) {
                    this.controller.setAlignment(field, AlignmentType.FULLWORD);
                } else {
                    this.controller.setAlignment(field, AlignmentType.NATURAL);
                }
            }
        } else if (simple instanceof PLIFloatTypeImpl) {
            PLIFloatTypeImpl floatType = (PLIFloatTypeImpl)simple;
            BaseValues bv = floatType.getBase();
            if (bv == BaseValues.BINARY_LITERAL) {
                int p = floatType.getPrecision();
                if (1 <= p && p <= 21) {
                    this.controller.setAppDatatype(field, DBDConstants.FLOAT);
                    if (simple.isAligned()) {
                        this.controller.setAlignment(field, AlignmentType.FULLWORD);
                    } else {
                        this.controller.setAlignment(field, AlignmentType.NATURAL);
                    }
                } else {
                    this.controller.setAppDatatype(field, DBDConstants.DOUBLE);
                    if (simple.isAligned()) {
                        this.controller.setAlignment(field, AlignmentType.DOUBLEWORD);
                    } else {
                        this.controller.setAlignment(field, AlignmentType.NATURAL);
                    }
                }
            } else {
                int p = floatType.getPrecision();
                if (1 <= p && p <= 6) {
                    this.controller.setAppDatatype(field, DBDConstants.FLOAT);
                    if (simple.isAligned()) {
                        this.controller.setAlignment(field, AlignmentType.FULLWORD);
                    } else {
                        this.controller.setAlignment(field, AlignmentType.NATURAL);
                    }
                } else {
                    this.controller.setAppDatatype(field, DBDConstants.DOUBLE);
                    if (simple.isAligned()) {
                        this.controller.setAlignment(field, AlignmentType.DOUBLEWORD);
                    } else {
                        this.controller.setAlignment(field, AlignmentType.NATURAL);
                    }
                }
            }
        } else {
            throw new UnsupportedPliTypeException(field, (PLIClassifier)simple);
        }
    }

    private void parseSimpleModel(FieldType field, COBOLSimpleType simple) throws ImportParseException {
        int fieldLength = field.getBytes();
        String qualifier = simple.getPictureString();
        int usageInt = simple.getUsage().getValue();
        boolean isSYNC = false;
        if (simple.getSynchronized() != null) {
            isSYNC = simple.getSynchronized();
        }
        switch (usageInt) {
            case 0: {
                if (!(simple instanceof COBOLNumericTypeImpl)) break;
                COBOLNumericTypeImpl numType = (COBOLNumericTypeImpl)simple;
                int scale = numType.getScale();
                boolean signed = numType.getSigned();
                int precision = numType.getPrecision();
                String isCOMP5 = "N";
                if (numType.getUsage().getValue() == 0 && numType.getTrunc().getValue() == 2) {
                    isCOMP5 = "Y";
                }
                if (scale > 0) {
                    this.controller.setAppDatatype(field, DBDConstants.DECIMAL);
                    this.controller.setPrecision(field, Integer.toString(precision));
                    this.controller.setScale(field, Integer.toString(scale));
                    this.controller.setPhysicalDataType(field, DBDConstants.BINARY);
                    String isSigned = signed ? "Y" : "N";
                    this.controller.setIsSigned(field, isSigned);
                    this.controller.setIsNativeInteger(field, isCOMP5);
                    AlignmentType alignType = !isSYNC ? AlignmentType.NATURAL : (precision <= 9 ? AlignmentType.FULLWORD : (precision <= 18 ? AlignmentType.DOUBLEWORD : AlignmentType.NATURAL));
                    this.controller.setAlignment(field, alignType);
                    break;
                }
                if (!isCOMP5.equals("Y")) {
                    this.controller.setPrecision(field, Integer.toString(precision));
                }
                if (precision <= 4) {
                    DBDConstants fieldType = !signed ? DBDConstants.USHORT : DBDConstants.SHORT;
                    this.controller.setAppDatatype(field, fieldType);
                    this.controller.setIsNativeInteger(field, isCOMP5);
                    AlignmentType alignType = !isSYNC ? AlignmentType.NATURAL : AlignmentType.HALFWORD;
                    this.controller.setAlignment(field, alignType);
                    if (fieldLength == 2) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                    logger.throwing(this.getClass().getName(), "", ipe);
                    EclipseLogger.logError(ipe);
                    throw ipe;
                }
                if (precision <= 9) {
                    DBDConstants fieldType = !signed ? DBDConstants.UINT : DBDConstants.INT;
                    this.controller.setAppDatatype(field, fieldType);
                    this.controller.setIsNativeInteger(field, isCOMP5);
                    AlignmentType alignType = !isSYNC ? AlignmentType.NATURAL : AlignmentType.FULLWORD;
                    this.controller.setAlignment(field, alignType);
                    if (fieldLength == 4) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                    logger.throwing(this.getClass().getName(), "", ipe);
                    EclipseLogger.logError(ipe);
                    throw ipe;
                }
                if (precision <= 18) {
                    DBDConstants fieldType = !signed ? DBDConstants.ULONG : DBDConstants.LONG;
                    this.controller.setAppDatatype(field, fieldType);
                    this.controller.setIsNativeInteger(field, isCOMP5);
                    AlignmentType alignType = !isSYNC ? AlignmentType.NATURAL : AlignmentType.FULLWORD;
                    this.controller.setAlignment(field, alignType);
                    if (fieldLength == 8) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                    logger.throwing(this.getClass().getName(), "", ipe);
                    EclipseLogger.logError(ipe);
                    throw ipe;
                }
                ImportParseException ipe = new ImportParseException("Binary numbers of length over 18 digits not supported");
                logger.throwing(this.getClass().getName(), "", ipe);
                EclipseLogger.logError(ipe);
                throw ipe;
            }
            case 3: {
                if (simple instanceof COBOLAlphaNumericType || simple instanceof COBOLAlphabeticType) {
                    DBDConstants fieldType = DBDConstants.CHAR;
                    this.controller.setAppDatatype(field, fieldType);
                    if (fieldLength == this.getAlphaNumericPictureStringLength(qualifier)) break;
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                    logger.throwing(this.getClass().getName(), "", ipe);
                    EclipseLogger.logError(ipe);
                    throw ipe;
                }
                if (simple instanceof COBOLNumericType) {
                    this.controller.setAppDatatype(field, DBDConstants.DECIMAL);
                    DBDConstants fieldType = DBDConstants.ZONEDDECIMAL;
                    this.controller.setPhysicalDataType(field, fieldType);
                    COBOLNumericType numericType = (COBOLNumericType)simple;
                    int picStrLength = this.getNumericPictureStringLength(qualifier);
                    if (numericType.getSigned().booleanValue() && numericType.getSignSeparate().booleanValue()) {
                        ++picStrLength;
                    }
                    String isSigned = numericType.getSigned() != false ? "Y" : "N";
                    this.controller.setIsSigned(field, isSigned);
                    String isSignLeading = numericType.getSignLeading() != false ? "Y" : "N";
                    this.controller.setSignLeading(field, isSignLeading);
                    String isSignSeparate = numericType.getSignSeparate() != false ? "Y" : "N";
                    this.controller.setSignSeparate(field, isSignSeparate);
                    this.controller.setIsWCHAROnly(field, "N");
                    if (fieldLength != picStrLength) {
                        ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                        logger.throwing(this.getClass().getName(), "", ipe);
                        throw ipe;
                    }
                    this.controller.setZoneddecimalSubparms(field, qualifier);
                    break;
                }
                if (simple instanceof COBOLNumericEditedTypeImpl) {
                    DBDConstants fieldType = DBDConstants.CHAR;
                    this.controller.setAppDatatype(field, fieldType);
                    break;
                }
                throw new UnsupportedCobolTypeException(field, (COBOLClassifier)simple);
            }
            case 4: {
                DBDConstants fieldType = DBDConstants.FLOAT;
                this.controller.setAppDatatype(field, fieldType);
                AlignmentType alignType = !isSYNC ? AlignmentType.NATURAL : AlignmentType.FULLWORD;
                this.controller.setAlignment(field, alignType);
                if (fieldLength == 4) break;
                ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                logger.throwing(this.getClass().getName(), "", ipe);
                EclipseLogger.logError(ipe);
                throw ipe;
            }
            case 2: {
                DBDConstants fieldType = DBDConstants.DOUBLE;
                this.controller.setAppDatatype(field, fieldType);
                AlignmentType alignType = !isSYNC ? AlignmentType.NATURAL : AlignmentType.DOUBLEWORD;
                this.controller.setAlignment(field, alignType);
                if (fieldLength == 8) break;
                ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + ".");
                logger.throwing(this.getClass().getName(), "", ipe);
                EclipseLogger.logError(ipe);
                throw ipe;
            }
            case 8: {
                this.controller.setAppDatatype(field, DBDConstants.DECIMAL);
                DBDConstants fieldType = DBDConstants.PACKEDDECIMAL;
                this.controller.setPhysicalDataType(field, fieldType);
                if (fieldLength != (this.getNumericPictureStringLength(qualifier) + 2) / 2) {
                    ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                    logger.throwing(this.getClass().getName(), "", ipe);
                    EclipseLogger.logError(ipe);
                    throw ipe;
                }
                this.controller.setPackeddecimalSubparms(field, qualifier);
                break;
            }
            case 1: {
                DBDConstants fieldType = DBDConstants.CHAR;
                this.controller.setAppDatatype(field, fieldType);
                this.controller.setIsDBCSOnly(field, "Y");
                if (fieldLength == this.getAlphaNumericPictureStringLength(qualifier)) break;
                ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                logger.throwing(this.getClass().getName(), "", ipe);
                EclipseLogger.logError(ipe);
                throw ipe;
            }
            case 6: {
                if (simple instanceof COBOLNationalExternalFloatType) {
                    throw new UnsupportedCobolTypeException(field, (COBOLClassifier)simple);
                }
                if (simple instanceof COBOLNationalNumericType) {
                    this.controller.setAppDatatype(field, DBDConstants.DECIMAL);
                    DBDConstants fieldType = DBDConstants.ZONEDDECIMAL;
                    this.controller.setPhysicalDataType(field, fieldType);
                    COBOLNumericType numericType = (COBOLNumericType)simple;
                    int picStrLength = this.getNumericPictureStringLength(qualifier);
                    if (numericType.getSigned().booleanValue() && numericType.getSignSeparate().booleanValue()) {
                        ++picStrLength;
                    }
                    String isSigned = numericType.getSigned() != false ? "Y" : "N";
                    this.controller.setIsSigned(field, isSigned);
                    String isSignLeading = numericType.getSignLeading() != false ? "Y" : "N";
                    this.controller.setSignLeading(field, isSignLeading);
                    String isSignSeparate = numericType.getSignSeparate() != false ? "Y" : "N";
                    this.controller.setSignSeparate(field, isSignSeparate);
                    this.controller.setIsWCHAROnly(field, "Y");
                    this.controller.setEncoding(field, "UTF-16BE");
                    if (fieldLength / 2 != picStrLength) {
                        ImportParseException ipe = new ImportParseException("Length of " + fieldLength + " does not match type " + String.valueOf((Object)fieldType) + " with type qualifier " + qualifier + ".");
                        logger.throwing(this.getClass().getName(), "", ipe);
                        EclipseLogger.logError(ipe);
                        throw ipe;
                    }
                    this.controller.setZoneddecimalSubparms(field, qualifier);
                    break;
                }
                DBDConstants fieldType = DBDConstants.CHAR;
                this.controller.setAppDatatype(field, fieldType);
                this.controller.setEncoding(field, "UTF-16BE");
                break;
            }
            default: {
                throw new UnsupportedCobolTypeException(field, (COBOLClassifier)simple);
            }
        }
    }

    private int getComputationalPictureStringLength(String pictureString) throws ImportParseException {
        int length = 0;
        int i = 0;
        while (i < pictureString.length()) {
            char charVal = pictureString.charAt(i);
            switch (charVal) {
                case '9': {
                    ++length;
                    break;
                }
                case '(': {
                    int starting = i++;
                    while (pictureString.charAt(i) != ')') {
                        ++i;
                    }
                    if (pictureString.charAt(starting - 1) == '9') {
                        length += Integer.parseInt(pictureString.substring(starting + 1, i)) - 1;
                        break;
                    }
                    throw new ImportParseException("Computational Picture String not of 9's");
                }
            }
            ++i;
        }
        return length;
    }

    private int getAlphaNumericPictureStringLength(String pictureString) throws ImportParseException {
        int length = 0;
        boolean isWideChar = false;
        int i = 0;
        while (i < pictureString.length()) {
            char charVal = pictureString.charAt(i);
            switch (charVal) {
                case 'A': 
                case 'X': 
                case 'a': 
                case 'x': {
                    ++length;
                    break;
                }
                case 'G': 
                case 'N': 
                case 'g': 
                case 'n': {
                    ++length;
                    isWideChar = true;
                    break;
                }
                case '(': {
                    int starting = i++;
                    while (pictureString.charAt(i) != ')') {
                        ++i;
                    }
                    length += Integer.parseInt(pictureString.substring(starting + 1, i)) - 1;
                    break;
                }
                default: {
                    throw new ImportParseException("Unsupported Picture String character: " + pictureString.charAt(i));
                }
            }
            ++i;
        }
        return isWideChar ? length * 2 : length;
    }

    private int getNumericPictureStringLength(String pictureString) throws ImportParseException {
        int length = 0;
        int i = 0;
        while (i < pictureString.length()) {
            switch (pictureString.charAt(i)) {
                case '.': 
                case '9': 
                case 'Z': 
                case 'z': {
                    ++length;
                }
                case 'P': 
                case 'S': 
                case 'V': 
                case 'p': 
                case 's': 
                case 'v': {
                    break;
                }
                case '(': {
                    int starting = i++;
                    while (pictureString.charAt(i) != ')') {
                        ++i;
                    }
                    if (pictureString.charAt(starting - 1) == '9') {
                        length += Integer.parseInt(pictureString.substring(starting + 1, i)) - 1;
                        break;
                    }
                    throw new ImportParseException("Invalid Picture String");
                }
                default: {
                    throw new ImportParseException("Unsupported Picture String character: " + pictureString.charAt(i));
                }
            }
            ++i;
        }
        return length;
    }

    private String getFixedDecimalPictureString(int precision, int scale) {
        Object picture = "";
        if (scale == 0) {
            int i = 0;
            while (i < precision) {
                picture = (String)picture + "9";
                ++i;
            }
        } else {
            int i = 0;
            while (i < precision - scale) {
                picture = (String)picture + "9";
                ++i;
            }
            picture = (String)picture + "V.";
            i = 0;
            while (i < scale) {
                picture = (String)picture + "9";
                ++i;
            }
        }
        return picture;
    }

    private String getFloatPictureString(int base, int precision) {
        Object picture = "";
        picture = base == 0 ? "BINARY" : "DECIMAL";
        picture = (String)picture + Integer.toString(precision);
        return picture;
    }

    private void informationExceptionHandling(FieldType field, String message) {
        String fieldName = field.getName();
        if (this.informationExceptionList == null) {
            this.informationExceptionList = new Vector();
            InformationException e = new InformationException(PgmIntXlat.getError().getString(message), fieldName);
            this.informationExceptionList.add(e);
        } else {
            Iterator<InformationException> iter = this.informationExceptionList.iterator();
            boolean found = false;
            while (iter.hasNext() && !found) {
                InformationException currException = iter.next();
                if (!currException.getMessage().equals(PgmIntXlat.getError().getString(message))) continue;
                found = true;
                currException.addToResourceList(fieldName);
            }
            if (!found) {
                InformationException e = new InformationException(PgmIntXlat.getError().getString(message), fieldName);
                this.informationExceptionList.add(e);
            }
        }
    }

    public Vector<InformationException> getInformationExceptionList() {
        return this.informationExceptionList;
    }

    public String fieldPathOf(COBOLElement element) {
        FieldPath fieldPath = new FieldPath();
        ArrayList<String> fieldNames = new ArrayList<String>();
        COBOLElement element1 = element;
        COBOLElement element2 = null;
        fieldNames.add(this.replaceHyphens(element.getName()));
        while (element1.getGroup() != null) {
            element2 = (COBOLElement)element1.getGroup().getTypedElement().get(0);
            fieldNames.add(this.replaceHyphens(element2.getName()));
            element1 = element2;
        }
        Collections.reverse(fieldNames);
        for (String fieldName : fieldNames) {
            fieldPath.push(fieldName);
        }
        return fieldPath.getValue();
    }

    public String fieldPathOf(PLIElement element) {
        FieldPath fieldPath = new FieldPath();
        ArrayList<String> fieldNames = new ArrayList<String>();
        PLIElement element1 = element;
        PLIElement element2 = null;
        fieldNames.add(this.replaceHyphens(element.getName()));
        while (element1.getGroup() != null) {
            element2 = (PLIElement)element1.getGroup().getTypedElement().get(0);
            fieldNames.add(element2.getName().toUpperCase());
            element1 = element2;
        }
        Collections.reverse(fieldNames);
        for (String fieldName : fieldNames) {
            fieldPath.push(fieldName);
        }
        return fieldPath.getValue();
    }

    public UnsupportedTypesException getUnsupportedTypesException() {
        return this.unsupportedTypesException;
    }
}

